/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.bugreport.model;

import be.iminds.ilabt.jfed.bugreport.model.BugReportBuilder;
import be.iminds.ilabt.jfed.bugreport.model.ConnectivityTestResult;
import be.iminds.ilabt.jfed.bugreport.model.LogLine;
import be.iminds.ilabt.jfed.bugreport.model.Slice;
import be.iminds.ilabt.jfed.bugreport.model.StitchingJobReport;
import be.iminds.ilabt.jfed.json.util.JsonGeniUrnDeserializer;
import be.iminds.ilabt.jfed.json.util.JsonGeniUrnSerializer;
import be.iminds.ilabt.jfed.json.util.JsonInstantRFC3339Deserializer;
import be.iminds.ilabt.jfed.json.util.JsonInstantRFC3339Serializer;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.net.URI;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"@context"})
@JsonLdObjectsMetaData.JsonLdObjectInfo(pathName="bugreport", builderClass=BugReportBuilder.class, uriType=JsonLdObjectsMetaData.UriType.ID_BASED, idType=JsonLdObjectsMetaData.IdType.PRIMARY)
public class BugReport
extends PrimaryIdObject<Integer> {
    private static final Logger LOG = LoggerFactory.getLogger(BugReport.class);
    private final Instant commitTime;
    private final String description;
    private final String environment;
    private final String version;
    private final String reporterUrn;
    private final String loggedInUserInfo;
    private final String mail;
    private final String preferences;
    private final List<Integer> apiCallDetailIds;
    private final List<URI> apiCallDetailUris;
    private final List<ConnectivityTestResult> connectivityTestResults;
    private final List<LogLine> logLines;
    private final List<Slice> slices;
    private final String screenshot;
    private final List<StitchingJobReport> stitchingJobReports;
    private final ReportType reportType;
    private final ReportTarget reportTarget;
    private final List<GeniUrn> relatedTestbeds;
    private final String subject;
    private final Boolean postOnPublicList;

    @JsonCreator
    public BugReport(@JsonProperty(value="id") Integer id, @JsonProperty(value="@id") URI uri, @JsonProperty(value="commitTime") Instant commitTime, @JsonProperty(value="description") String description, @JsonProperty(value="environment") String environment, @JsonProperty(value="version") String version, @JsonProperty(value="reporterUrn") String reporterUrn, @JsonProperty(value="loggedInUserInfo") String loggedInUserInfo, @JsonProperty(value="mail") String mail, @JsonProperty(value="preferences") String preferences, @JsonProperty(value="apiCallDetailIds") List<Integer> apiCallDetailIds, @JsonProperty(value="apiCallDetailUris") List<URI> apiCallDetailUris, @JsonProperty(value="connectivityTestResults") List<ConnectivityTestResult> connectivityTestResults, @JsonProperty(value="logLines") List<LogLine> logLines, @JsonProperty(value="slices") List<Slice> slices, @JsonProperty(value="screenshot") String screenshot, @JsonProperty(value="stitchingJobReports") List<StitchingJobReport> stitchingJobReports, @JsonProperty(value="reportType") ReportType reportType, @JsonProperty(value="reportTarget") ReportTarget reportTarget, @JsonProperty(value="relatedTestbeds") List<GeniUrn> relatedTestbeds, @JsonProperty(value="subject") String subject, @JsonProperty(value="postOnPublicList") Boolean postOnPublicList) {
        this(id, uri, commitTime, description, environment, version, reporterUrn, loggedInUserInfo, mail, preferences, apiCallDetailIds, apiCallDetailUris, connectivityTestResults, logLines, slices, screenshot, stitchingJobReports, reportType, reportTarget, relatedTestbeds, subject, postOnPublicList, JsonLdObjectsMetaData.mustSerializeAsEmbeddedObjectForJacksonConstructor());
    }

    public BugReport(Integer id, URI uri, Instant commitTime, String description, String environment, String version, String reporterUrn, String loggedInUserInfo, String mail, String preferences, List<Integer> apiCallDetailIds, List<URI> apiCallDetailUris, List<ConnectivityTestResult> connectivityTestResults, List<LogLine> logLines, List<Slice> slices, String screenshot, List<StitchingJobReport> stitchingJobReports, ReportType reportType, ReportTarget reportTarget, List<GeniUrn> relatedTestbeds, String subject, Boolean postOnPublicList, boolean serializeInfo_SerializeAsEmbeddedObject) {
        super((Object)id, uri, serializeInfo_SerializeAsEmbeddedObject);
        this.commitTime = commitTime;
        this.description = description;
        this.environment = environment;
        this.version = version;
        this.reporterUrn = reporterUrn;
        this.loggedInUserInfo = loggedInUserInfo;
        this.mail = mail;
        this.preferences = preferences;
        this.apiCallDetailIds = apiCallDetailIds;
        this.apiCallDetailUris = apiCallDetailUris;
        this.connectivityTestResults = connectivityTestResults;
        this.logLines = logLines;
        this.slices = slices;
        this.screenshot = screenshot;
        this.stitchingJobReports = stitchingJobReports;
        this.reportType = reportType;
        this.reportTarget = reportTarget;
        this.relatedTestbeds = relatedTestbeds;
        this.subject = subject;
        this.postOnPublicList = postOnPublicList;
    }

    @JsonProperty
    @JsonSerialize(using=JsonInstantRFC3339Serializer.class)
    @JsonDeserialize(using=JsonInstantRFC3339Deserializer.class)
    public Instant getCommitTime() {
        return this.commitTime;
    }

    @JsonProperty
    public String getDescription() {
        return this.description;
    }

    @JsonProperty
    public String getEnvironment() {
        return this.environment;
    }

    @JsonProperty
    public String getVersion() {
        return this.version;
    }

    @JsonProperty
    public String getReporterUrn() {
        return this.reporterUrn;
    }

    @JsonProperty
    public String getLoggedInUserInfo() {
        return this.loggedInUserInfo;
    }

    @JsonProperty
    public String getMail() {
        return this.mail;
    }

    @JsonProperty
    public String getPreferences() {
        return this.preferences;
    }

    @JsonProperty
    public List<Integer> getApiCallDetailIds() {
        return this.apiCallDetailIds;
    }

    @JsonProperty
    public List<URI> getApiCallDetailUris() {
        return this.apiCallDetailUris;
    }

    @JsonProperty
    public List<ConnectivityTestResult> getConnectivityTestResults() {
        return this.connectivityTestResults;
    }

    @JsonProperty
    public List<LogLine> getLogLines() {
        return this.logLines;
    }

    @JsonProperty
    public List<Slice> getSlices() {
        return this.slices;
    }

    @JsonProperty
    public String getScreenshot() {
        return this.screenshot;
    }

    @JsonProperty
    public List<StitchingJobReport> getStitchingJobReports() {
        return this.stitchingJobReports;
    }

    @JsonProperty
    @JsonSerialize(contentUsing=JsonGeniUrnSerializer.class)
    @JsonDeserialize(contentUsing=JsonGeniUrnDeserializer.class)
    public List<GeniUrn> getRelatedTestbeds() {
        return this.relatedTestbeds;
    }

    @JsonProperty
    @Nullable
    public ReportType getReportType() {
        return this.reportType;
    }

    @JsonIgnore
    @Nonnull
    public ReportType getReportTypeOrDefault() {
        return this.reportType == null ? ReportType.OTHER : this.reportType;
    }

    @JsonProperty
    @Nullable
    public ReportTarget getReportTarget() {
        return this.reportTarget;
    }

    @JsonIgnore
    @Nonnull
    public ReportTarget getReportTargetOrDefault() {
        return this.reportTarget == null ? ReportTarget.OTHER : this.reportTarget;
    }

    @JsonProperty
    public String getSubject() {
        return this.subject;
    }

    @JsonProperty
    public Boolean getPostOnPublicList() {
        return this.postOnPublicList;
    }

    @JsonIgnore
    public boolean getPostOnPublicListOrDefault() {
        return Objects.equals(this.postOnPublicList, Boolean.TRUE);
    }

    public String toString() {
        return this.getAsJsonString();
    }

    @JsonIgnore
    public String getAsJsonString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting " + ((Object)((Object)this)).getClass().getName() + " to JSON", (Throwable)e);
            return "Exception converting Testbed " + ((Object)((Object)this)).getClass().getName() + " to JSON: " + e.getMessage();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BugReport)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BugReport bugReport = (BugReport)((Object)o);
        if (this.commitTime != null ? !this.commitTime.equals(bugReport.commitTime) : bugReport.commitTime != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(bugReport.description) : bugReport.description != null) {
            return false;
        }
        if (this.environment != null ? !this.environment.equals(bugReport.environment) : bugReport.environment != null) {
            return false;
        }
        if (this.version != null ? !this.version.equals(bugReport.version) : bugReport.version != null) {
            return false;
        }
        if (this.reporterUrn != null ? !this.reporterUrn.equals(bugReport.reporterUrn) : bugReport.reporterUrn != null) {
            return false;
        }
        if (this.loggedInUserInfo != null ? !this.loggedInUserInfo.equals(bugReport.loggedInUserInfo) : bugReport.loggedInUserInfo != null) {
            return false;
        }
        if (this.mail != null ? !this.mail.equals(bugReport.mail) : bugReport.mail != null) {
            return false;
        }
        if (this.preferences != null ? !this.preferences.equals(bugReport.preferences) : bugReport.preferences != null) {
            return false;
        }
        if (this.apiCallDetailIds != null ? !this.apiCallDetailIds.equals(bugReport.apiCallDetailIds) : bugReport.apiCallDetailIds != null) {
            return false;
        }
        if (this.apiCallDetailUris != null ? !this.apiCallDetailUris.equals(bugReport.apiCallDetailUris) : bugReport.apiCallDetailUris != null) {
            return false;
        }
        if (this.connectivityTestResults != null ? !this.connectivityTestResults.equals(bugReport.connectivityTestResults) : bugReport.connectivityTestResults != null) {
            return false;
        }
        if (this.logLines != null ? !this.logLines.equals(bugReport.logLines) : bugReport.logLines != null) {
            return false;
        }
        if (this.slices != null ? !this.slices.equals(bugReport.slices) : bugReport.slices != null) {
            return false;
        }
        if (this.screenshot != null ? !this.screenshot.equals(bugReport.screenshot) : bugReport.screenshot != null) {
            return false;
        }
        if (this.stitchingJobReports != null ? !this.stitchingJobReports.equals(bugReport.stitchingJobReports) : bugReport.stitchingJobReports != null) {
            return false;
        }
        if (this.reportType != bugReport.reportType) {
            return false;
        }
        if (this.reportTarget != bugReport.reportTarget) {
            return false;
        }
        if (this.relatedTestbeds != null ? !this.relatedTestbeds.equals(bugReport.relatedTestbeds) : bugReport.relatedTestbeds != null) {
            return false;
        }
        if (this.subject != null ? !this.subject.equals(bugReport.subject) : bugReport.subject != null) {
            return false;
        }
        return this.postOnPublicList != null ? this.postOnPublicList.equals(bugReport.postOnPublicList) : bugReport.postOnPublicList == null;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.commitTime != null ? this.commitTime.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.reporterUrn != null ? this.reporterUrn.hashCode() : 0);
        result = 31 * result + (this.loggedInUserInfo != null ? this.loggedInUserInfo.hashCode() : 0);
        result = 31 * result + (this.mail != null ? this.mail.hashCode() : 0);
        result = 31 * result + (this.preferences != null ? this.preferences.hashCode() : 0);
        result = 31 * result + (this.apiCallDetailIds != null ? this.apiCallDetailIds.hashCode() : 0);
        result = 31 * result + (this.apiCallDetailUris != null ? this.apiCallDetailUris.hashCode() : 0);
        result = 31 * result + (this.connectivityTestResults != null ? this.connectivityTestResults.hashCode() : 0);
        result = 31 * result + (this.logLines != null ? this.logLines.hashCode() : 0);
        result = 31 * result + (this.slices != null ? this.slices.hashCode() : 0);
        result = 31 * result + (this.screenshot != null ? this.screenshot.hashCode() : 0);
        result = 31 * result + (this.stitchingJobReports != null ? this.stitchingJobReports.hashCode() : 0);
        result = 31 * result + (this.reportType != null ? this.reportType.hashCode() : 0);
        result = 31 * result + (this.reportTarget != null ? this.reportTarget.hashCode() : 0);
        result = 31 * result + (this.relatedTestbeds != null ? this.relatedTestbeds.hashCode() : 0);
        result = 31 * result + (this.subject != null ? this.subject.hashCode() : 0);
        result = 31 * result + (this.postOnPublicList != null ? this.postOnPublicList.hashCode() : 0);
        return result;
    }

    public static enum ReportType {
        QUESTION("Question"),
        FEATURE("jFed Feature Request"),
        BUG("Bug Report"),
        CONNECTIVITY("Connectivity Issue"),
        UNCAUGHT_EXCEPTION("Uncaught Exception"),
        OTHER("Generic Feedback");

        private final String hrn;

        private ReportType(String hrn) {
            this.hrn = hrn;
        }

        public String getHrn() {
            return this.hrn;
        }
    }

    public static enum ReportTarget {
        JFED("jFed"),
        TESTBED("Testbed(s)"),
        OTHER("Both/Neither/Unknown/Other");

        private final String hrn;

        private ReportTarget(String hrn) {
            this.hrn = hrn;
        }

        public String getHrn() {
            return this.hrn;
        }
    }
}

