/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.bugreport.model;

import be.iminds.ilabt.jfed.bugreport.model.BugReport;
import be.iminds.ilabt.jfed.bugreport.model.ConnectivityTestResult;
import be.iminds.ilabt.jfed.bugreport.model.LogLine;
import be.iminds.ilabt.jfed.bugreport.model.Slice;
import be.iminds.ilabt.jfed.bugreport.model.StitchingJobReport;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObjectBuilder;
import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;

@JsonLdObjectsMetaData.JsonLdObjectBuilderInfo(objectClass=BugReport.class)
public class BugReportBuilder
extends PrimaryIdObjectBuilder<Integer, BugReport, BugReportBuilder> {
    private Instant commitTime;
    private String description;
    private String environment;
    private String version;
    private String reporterUrn;
    private String loggedInUserInfo;
    private String mail;
    private String preferences;
    private List<Integer> apiCallDetailIds;
    private List<URI> apiCallDetailUris;
    private List<ConnectivityTestResult> connectivityTestResults;
    private List<LogLine> logLines;
    private List<Slice> slices;
    private String screenshot;
    private List<StitchingJobReport> stitchingJobReports;
    private BugReport.ReportType reportType;
    private BugReport.ReportTarget reportTarget;
    private List<GeniUrn> relatedTestbeds;
    private String subject;
    private Boolean postOnPublicList;

    public BugReportBuilder() {
    }

    public BugReportBuilder(@Nonnull BugReport orig) {
        super((PrimaryIdObject)orig);
        this.commitTime = orig.getCommitTime();
        this.description = orig.getDescription();
        this.environment = orig.getEnvironment();
        this.version = orig.getVersion();
        this.reporterUrn = orig.getReporterUrn();
        this.loggedInUserInfo = orig.getLoggedInUserInfo();
        this.mail = orig.getMail();
        this.preferences = orig.getPreferences();
        this.apiCallDetailIds = orig.getApiCallDetailIds();
        this.apiCallDetailUris = orig.getApiCallDetailUris();
        this.connectivityTestResults = orig.getConnectivityTestResults();
        this.logLines = orig.getLogLines();
        this.slices = orig.getSlices();
        this.screenshot = orig.getScreenshot();
        this.stitchingJobReports = orig.getStitchingJobReports();
        this.reportType = orig.getReportType();
        this.reportTarget = orig.getReportTarget();
        this.relatedTestbeds = orig.getRelatedTestbeds();
        this.subject = orig.getSubject();
        this.postOnPublicList = orig.getPostOnPublicList();
    }

    public BugReportBuilder setCommitTime(Instant commitTime) {
        this.commitTime = commitTime;
        return this;
    }

    public BugReportBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public BugReportBuilder setEnvironment(String environment) {
        this.environment = environment;
        return this;
    }

    public BugReportBuilder setVersion(String version) {
        this.version = version;
        return this;
    }

    public BugReportBuilder setReporterUrn(String reporterUrn) {
        this.reporterUrn = reporterUrn;
        return this;
    }

    public BugReportBuilder setLoggedInUserInfo(String loggedInUserInfo) {
        this.loggedInUserInfo = loggedInUserInfo;
        return this;
    }

    public BugReportBuilder setMail(String mail) {
        this.mail = mail;
        return this;
    }

    public BugReportBuilder setPreferences(String preferences) {
        this.preferences = preferences;
        return this;
    }

    public BugReportBuilder setApiCallDetailIds(List<Integer> apiCallDetailIds) {
        this.apiCallDetailIds = apiCallDetailIds;
        return this;
    }

    public BugReportBuilder setApiCallDetailUris(List<URI> apiCallDetailUris) {
        this.apiCallDetailUris = apiCallDetailUris;
        return this;
    }

    public BugReportBuilder addApiCallDetailId(@Nonnull Integer apiCallDetailId) {
        if (this.apiCallDetailIds == null) {
            this.apiCallDetailIds = new ArrayList<Integer>();
        }
        this.apiCallDetailIds.add(apiCallDetailId);
        return this;
    }

    public BugReportBuilder addApiCallDetailUri(@Nonnull URI apiCallDetailUri) {
        if (this.apiCallDetailUris == null) {
            this.apiCallDetailUris = new ArrayList<URI>();
        }
        this.apiCallDetailUris.add(apiCallDetailUri);
        return this;
    }

    public BugReportBuilder addApiCallDetail(@Nonnull Integer apiCallDetailId, @Nonnull URI apiCallDetailUri) {
        this.addApiCallDetailId(apiCallDetailId);
        this.addApiCallDetailUri(apiCallDetailUri);
        return this;
    }

    public BugReportBuilder setConnectivityTestResults(List<ConnectivityTestResult> connectivityTestResults) {
        this.connectivityTestResults = connectivityTestResults;
        return this;
    }

    public BugReportBuilder addConnectivityTestResults(@Nonnull ConnectivityTestResult connectivityTestResult) {
        if (this.connectivityTestResults == null) {
            this.connectivityTestResults = new ArrayList<ConnectivityTestResult>();
        }
        this.connectivityTestResults.add(connectivityTestResult);
        return this;
    }

    public BugReportBuilder setLogLines(List<LogLine> logLines) {
        this.logLines = logLines;
        return this;
    }

    public BugReportBuilder addLogLine(@Nonnull LogLine logLine) {
        if (this.logLines == null) {
            this.logLines = new ArrayList<LogLine>();
        }
        this.logLines.add(logLine);
        return this;
    }

    public BugReportBuilder setSlices(List<Slice> slices) {
        this.slices = slices;
        return this;
    }

    public BugReportBuilder addSlice(@Nonnull Slice slice) {
        if (this.slices == null) {
            this.slices = new ArrayList<Slice>();
        }
        this.slices.add(slice);
        return this;
    }

    public BugReportBuilder setScreenshot(String screenshot) {
        this.screenshot = screenshot;
        return this;
    }

    public BugReportBuilder setStitchingJobReports(List<StitchingJobReport> stitchingJobReports) {
        this.stitchingJobReports = stitchingJobReports;
        return this;
    }

    public BugReportBuilder addStitchingJobReport(@Nonnull StitchingJobReport stitchingJobReport) {
        if (this.stitchingJobReports == null) {
            this.stitchingJobReports = new ArrayList<StitchingJobReport>();
        }
        this.stitchingJobReports.add(stitchingJobReport);
        return this;
    }

    public BugReportBuilder setReportType(BugReport.ReportType reportType) {
        this.reportType = reportType;
        return this;
    }

    public BugReportBuilder setReportTarget(BugReport.ReportTarget reportTarget) {
        this.reportTarget = reportTarget;
        return this;
    }

    public BugReportBuilder setRelatedTestbeds(List<GeniUrn> relatedTestbeds) {
        this.relatedTestbeds = relatedTestbeds;
        return this;
    }

    public BugReportBuilder addRelatedTestbed(@Nonnull GeniUrn relatedTestbed) {
        if (this.relatedTestbeds == null) {
            this.relatedTestbeds = new ArrayList<GeniUrn>();
        }
        this.relatedTestbeds.add(relatedTestbed);
        return this;
    }

    public BugReportBuilder setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public BugReportBuilder setPostOnPublicList(Boolean postOnPublicList) {
        this.postOnPublicList = postOnPublicList;
        return this;
    }

    public BugReport create() {
        return new BugReport((Integer)this.id, this.uri, this.commitTime, this.description, this.environment, this.version, this.reporterUrn, this.loggedInUserInfo, this.mail, this.preferences, this.apiCallDetailIds, this.apiCallDetailUris, this.connectivityTestResults, this.logLines, this.slices, this.screenshot, this.stitchingJobReports, this.reportType, this.reportTarget, this.relatedTestbeds, this.subject, this.postOnPublicList, this.mustSerializeAsEmbeddedObjectForNonMinimizedCreate());
    }

    public BugReport createMinimized(JsonLdObjectsMetaData.Minimization minimization) {
        return new BugReport(minimization.includeId() ? (Integer)this.id : null, minimization.includeId() ? this.uri : null, !minimization.includeOtherProperties() ? null : this.commitTime, !minimization.includeOtherProperties() ? null : this.description, !minimization.includeOtherProperties() ? null : this.environment, !minimization.includeOtherProperties() ? null : this.version, !minimization.includeOtherProperties() ? null : this.reporterUrn, !minimization.includeOtherProperties() ? null : this.loggedInUserInfo, !minimization.includeOtherProperties() ? null : this.mail, !minimization.includeOtherProperties() ? null : this.preferences, !minimization.includeOtherProperties() ? null : this.apiCallDetailIds, !minimization.includeOtherProperties() ? null : this.apiCallDetailUris, !minimization.includeOtherProperties() ? null : this.connectivityTestResults, !minimization.includeOtherProperties() ? null : this.logLines, !minimization.includeOtherProperties() ? null : this.slices, !minimization.includeOtherProperties() ? null : this.screenshot, !minimization.includeOtherProperties() ? null : this.stitchingJobReports, !minimization.includeOtherProperties() ? null : this.reportType, !minimization.includeOtherProperties() ? null : this.reportTarget, !minimization.includeOtherProperties() ? null : this.relatedTestbeds, !minimization.includeOtherProperties() ? null : this.subject, !minimization.includeOtherProperties() ? null : this.postOnPublicList, minimization.serializeAsEmbeddedObject());
    }

    public static List<BugReport> minimize(JsonLdObjectsMetaData.Minimization minimization, Collection<BugReport> in) {
        if (in == null) {
            return null;
        }
        ArrayList<BugReport> res = new ArrayList<BugReport>();
        for (BugReport tb : in) {
            res.add(new BugReportBuilder(tb).createMinimized(minimization));
        }
        return res;
    }

    public static List<BugReport> minimizeBuilders(JsonLdObjectsMetaData.Minimization minimization, Collection<BugReportBuilder> in) {
        if (in == null) {
            return null;
        }
        ArrayList<BugReport> res = new ArrayList<BugReport>();
        for (BugReportBuilder tbb : in) {
            res.add(tbb.createMinimized(minimization));
        }
        return res;
    }

    public static BugReport minimize(JsonLdObjectsMetaData.Minimization minimization, BugReport in) {
        if (in == null) {
            return null;
        }
        return new BugReportBuilder(in).createMinimized(minimization);
    }

    public static BugReport minimize(JsonLdObjectsMetaData.Minimization minimization, BugReportBuilder in) {
        if (in == null) {
            return null;
        }
        return in.createMinimized(minimization);
    }

    public Instant getCommitTime() {
        return this.commitTime;
    }

    public String getDescription() {
        return this.description;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getVersion() {
        return this.version;
    }

    public String getReporterUrn() {
        return this.reporterUrn;
    }

    public String getLoggedInUserInfo() {
        return this.loggedInUserInfo;
    }

    public String getMail() {
        return this.mail;
    }

    public String getPreferences() {
        return this.preferences;
    }

    public List<Integer> getApiCallDetailIds() {
        return this.apiCallDetailIds;
    }

    public List<URI> getApiCallDetailUris() {
        return this.apiCallDetailUris;
    }

    public List<ConnectivityTestResult> getConnectivityTestResults() {
        return this.connectivityTestResults;
    }

    public List<LogLine> getLogLines() {
        return this.logLines;
    }

    public List<Slice> getSlices() {
        return this.slices;
    }

    public String getScreenshot() {
        return this.screenshot;
    }

    public List<StitchingJobReport> getStitchingJobReports() {
        return this.stitchingJobReports;
    }

    public BugReport.ReportType getReportType() {
        return this.reportType;
    }

    public BugReport.ReportTarget getReportTarget() {
        return this.reportTarget;
    }

    public List<GeniUrn> getRelatedTestbeds() {
        return this.relatedTestbeds;
    }

    public String getSubject() {
        return this.subject;
    }

    public Boolean getPostOnPublicList() {
        return this.postOnPublicList;
    }
}

