/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.bugreport.model;

import be.iminds.ilabt.jfed.bugreport.model.Slice;
import be.iminds.ilabt.jfed.bugreport.model.Sliver;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class SliceBuilder {
    private String sliceUrn;
    private String status;
    private Instant expirationDate;
    private List<Sliver> slivers;

    public SliceBuilder() {
    }

    public SliceBuilder(Slice orig) {
        this.sliceUrn = orig.getSliceUrn();
        this.status = orig.getStatus();
        this.expirationDate = orig.getExpirationDate();
        this.slivers = orig.getSlivers();
    }

    public SliceBuilder setSliceUrn(String sliceUrn) {
        this.sliceUrn = sliceUrn;
        return this;
    }

    public SliceBuilder setStatus(String status) {
        this.status = status;
        return this;
    }

    public SliceBuilder setExpirationDate(Instant expirationDate) {
        this.expirationDate = expirationDate;
        return this;
    }

    public SliceBuilder setSlivers(List<Sliver> slivers) {
        this.slivers = slivers;
        return this;
    }

    public SliceBuilder addSliver(@Nonnull Sliver sliver) {
        if (this.slivers == null) {
            this.slivers = new ArrayList<Sliver>();
        }
        this.slivers.add(sliver);
        return this;
    }

    public Slice create() {
        return new Slice(this.sliceUrn, this.status, this.expirationDate, this.slivers);
    }
}

