/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.rrd.base;

import be.iminds.ilabt.jfed.fedmon.rrd.base.RrdConfig;
import be.iminds.ilabt.jfed.fedmon.rrd.base.RrdManager;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Frequency;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Graph;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinitionBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceStatistics;
import be.iminds.ilabt.jfed.json.util.JsonTimeStampRFC3339Deserializer;
import be.iminds.ilabt.jfed.json.util.JsonTimeStampRFC3339Serializer;
import be.iminds.ilabt.util.jsonld.JsonLdObjectLinkSerializer;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.NotFoundException;
import org.rrd4j.ConsolFun;
import org.rrd4j.DsType;
import org.rrd4j.core.ArcDef;
import org.rrd4j.core.DsDef;
import org.rrd4j.core.FetchData;
import org.rrd4j.core.FetchRequest;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.Sample;
import org.rrd4j.core.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TestInstanceRrd {
    private static final Logger LOG = LoggerFactory.getLogger(TestInstanceRrd.class);
    protected static final int IMG_WIDTH = 500;
    protected static final int IMG_HEIGHT = 300;
    protected static final String FILE_FORMAT = "png";
    protected final TestInstance testInstance;
    protected final Frequency testInstanceFrequency;
    protected final TestDefinition testDefinition;
    protected final RrdConfig rrdConfig;
    protected final String name;
    protected final RrdDef rrdDef;
    protected final String dsBaseName;
    protected final File rrdFile;
    private boolean disableInsertDebug = false;
    private RrdDb insertRrdDb = null;

    private File getRealRrdFile() {
        String filename = this.dsBaseName + ".rrd";
        return new File(RrdManager.getBaseRrdDir(this.rrdConfig), filename);
    }

    public TestInstanceRrd(TestInstance testInstance, Frequency testInstanceFrequency, TestDefinition testDefinition, RrdConfig rrdConfig, String name) {
        this(testInstance, testInstanceFrequency, testDefinition, rrdConfig, name, null);
    }

    public TestInstanceRrd(TestInstance testInstance, Frequency testInstanceFrequency, TestDefinition testDefinition, RrdConfig rrdConfig, String name, File altRrdFile) {
        this.testInstance = testInstance;
        this.testInstanceFrequency = testInstanceFrequency;
        this.testDefinition = testDefinition;
        this.rrdConfig = rrdConfig;
        this.name = name;
        this.dsBaseName = name + "-" + testInstance.getId();
        this.rrdFile = altRrdFile == null ? this.getRealRrdFile() : altRrdFile;
        this.rrdDef = this.createDef();
    }

    protected String getStringParam(String paramName) {
        String res = this.testInstance.getStringParameterOrDefault(paramName, this.testDefinition);
        if (res == null) {
            throw new RuntimeException("There is no \"" + paramName + "\" parameter found in either testinstance or testdefinition! (it should have at least been in testdefinition). ti=" + this.testInstance.getId() + " td=" + (String)this.testDefinition.getId());
        }
        return res;
    }

    protected String makeDsName(String dsSubName) {
        if (dsSubName != null) {
            assert (!dsSubName.contains(this.dsBaseName)) : "dsSubName=" + dsSubName + " dsBaseName=" + this.dsBaseName;
            return dsSubName + "-" + this.dsBaseName;
        }
        return this.dsBaseName;
    }

    protected RrdDef createDef() {
        String[] rraStrings;
        String[] dsStrings;
        String ds = this.getDsLine();
        String rra = this.getRraLine();
        String step = this.getStepLine();
        long now = System.currentTimeMillis() / 1000L;
        long startTime = now - 31622400L;
        long stepS = RrdManager.rrdTimeToS(step);
        assert (this.rrdFile != null);
        RrdDef rrdDef = new RrdDef(this.rrdFile.getAbsolutePath(), startTime, stepS);
        rrdDef.setVersion(2);
        for (String dsString : dsStrings = ds.split(" ")) {
            double max;
            double min;
            long heartbeat;
            DsType dsType;
            String dsSubName;
            String[] dsParts = dsString.split(":");
            if (dsParts.length != 6 || !dsParts[0].equals("DS")) {
                throw new RuntimeException("Invalid RRD DS line: \"" + dsString + "\" (parsed into " + dsParts.length + " parts: " + Arrays.asList(dsParts) + "). Full DS line: " + ds);
            }
            try {
                dsSubName = dsParts[1];
                dsType = DsType.valueOf((String)dsParts[2]);
                heartbeat = this.makeHeartBeat(stepS, dsParts[3]);
                min = dsParts[4].equals("U") ? Double.NaN : Double.parseDouble(dsParts[4]);
                max = dsParts[5].equals("U") ? Double.NaN : Double.parseDouble(dsParts[5]);
            }
            catch (Throwable e) {
                throw new RuntimeException("Error processing RRD DS line: \"" + ds + "\" (parsed into " + dsParts.length + " parts: " + Arrays.asList(dsParts) + ")", e);
            }
            String dsName = this.makeDsName(dsStrings.length > 1 ? dsSubName : null);
            LOG.debug("dsname=" + dsName + " dsBaseName=" + this.dsBaseName + " dsSubName=" + dsSubName + " dsCount=" + dsStrings.length);
            LOG.debug("rrdDef.addDatasource(" + dsName + ", " + dsType + ", " + heartbeat + ", " + min + ", " + max + ");");
            rrdDef.addDatasource(dsName, dsType, heartbeat, min, max);
        }
        for (String rraString : rraStrings = rra.split(" ")) {
            long rows;
            long steps;
            double xff;
            ConsolFun cf;
            String[] rraParts = rraString.split(":");
            if (rraParts.length != 5 || !rraParts[0].equals("RRA")) {
                throw new RuntimeException("Invalid RRD RRA line: \"" + rraString + "\" (parsed into " + rraParts.length + " parts: " + Arrays.asList(rraParts) + "). Full rrd_rra: " + rra);
            }
            try {
                cf = ConsolFun.valueOf((String)rraParts[1]);
                xff = Double.parseDouble(rraParts[2]);
                if (RrdManager.isLong(rraParts[3])) {
                    steps = Long.parseLong(rraParts[3]);
                } else {
                    long rraStepS = RrdManager.rrdTimeToS(rraParts[3]);
                    steps = rraStepS / stepS;
                }
                if (RrdManager.isLong(rraParts[4])) {
                    rows = Long.parseLong(rraParts[4]);
                } else {
                    long rraRowS = RrdManager.rrdTimeToS(rraParts[4]);
                    rows = rraRowS / (steps * stepS);
                }
            }
            catch (Throwable e) {
                throw new RuntimeException("Error processing RRD RRA line: \"" + rraString + "\" (parsed into " + rraParts.length + " parts: " + Arrays.asList(rraParts) + ") Full rrd_rra: " + rra, e);
            }
            LOG.debug("rrdDef.addArchive(" + cf + ", " + xff + ", " + steps + ", " + rows + ");");
            rrdDef.addArchive(cf, xff, (int)steps, (int)rows);
        }
        return rrdDef;
    }

    protected long makeHeartBeat(long step, String hb) {
        if (hb.trim().equalsIgnoreCase("<rrd.heartbeat>")) {
            long res = step;
            res += this.testDefinition.getMaxTestDurationMs() / 1000L;
            return res += 60L;
        }
        long res = RrdManager.rrdTimeToS(hb);
        return res;
    }

    protected String getDsLine() {
        return this.getStringParam("rrd_ds");
    }

    protected String getStepLine() {
        return this.getStringParam("rrd_step");
    }

    protected String getRraLine() {
        return this.getStringParam("rrd_rra");
    }

    public void create() throws IOException {
        RrdDef rrdDef = this.createDef();
        LOG.info("Estimated " + this.rrdFile.getAbsolutePath() + " size: " + rrdDef.getEstimatedSize());
        RrdDb rrdDb = new RrdDb(rrdDef);
        LOG.debug("RRD file " + this.rrdFile.getAbsolutePath() + " created.");
        if (!rrdDb.getRrdDef().equals((Object)rrdDef)) {
            throw new RuntimeException("Invalid RRD file created. This is a serious bug, bailing out");
        }
        LOG.debug("RRD file structure OK");
        rrdDb.close();
    }

    public File getRrdFile() {
        return this.rrdFile;
    }

    protected abstract List<Val> getValues(@Nonnull Result var1);

    protected boolean wasTestInPlannedMaintenance(@Nonnull Result result) {
        return result.getBooleanSubResult("inMaintenanceDuringTest", Boolean.valueOf(false)) != false || result.getBooleanSubResult("isInMaintenanceNow", Boolean.valueOf(false)) != false;
    }

    public void setDisableInsertDebug(boolean disableInsertDebug) {
        this.disableInsertDebug = disableInsertDebug;
    }

    public abstract TestInstanceStatistics.RrdStatistics getTestStatistics();

    public abstract TestInstanceStatistics.Summation getSummation();

    public int insert(Result result) throws IOException {
        boolean debugHack;
        int tid = this.testInstance != null && this.testInstance.getId() != null ? (Integer)this.testInstance.getId() : -1;
        boolean bl = debugHack = tid == 7 || tid == 135;
        if (this.insertRrdDb == null) {
            this.insertRrdDb = new RrdDb(this.rrdFile.getAbsolutePath());
        }
        long timestamp = result.getCreated().getTime() / 1000L;
        if (debugHack) {
            LOG.info("debugHack " + tid + " Starting insert on RDD with times:\n" + this.insertRrdDb.getLastUpdateTime() + " -> last update time\n" + this.insertRrdDb.getRrdDef().getStartTime() + " -> start time\n" + timestamp + " -> current sample time");
        }
        Sample sample = this.insertRrdDb.createSample(timestamp);
        List<Val> vals = this.getValues(result);
        if (debugHack) {
            LOG.info("debugHack " + tid + " TestInstanceRrd.insert vals=" + vals);
        }
        for (Val val : vals) {
            String dsName = this.makeDsName(val.dsSubName);
            if (!this.disableInsertDebug) {
                LOG.debug("Will insert " + timestamp + ":" + val.value + " into DS " + dsName + " with dsSubName=" + val.dsSubName);
            }
            if (debugHack) {
                LOG.info("debugHack " + tid + " Will insert " + timestamp + ":" + val.value + " into DS " + dsName + " with dsSubName=" + val.dsSubName);
            }
            sample.setValue(dsName, val.value.doubleValue());
        }
        if (!this.disableInsertDebug) {
            LOG.debug("Inserting all values");
        }
        if (!vals.isEmpty()) {
            sample.update();
        } else {
            LOG.debug("No values found to insert @ " + timestamp);
        }
        if (!this.disableInsertDebug) {
            LOG.debug("Inserting: done");
        }
        return vals.size();
    }

    protected static Color colorByNr(int nr) {
        switch (nr) {
            case 0: {
                return Color.BLUE;
            }
            case 1: {
                return Color.GREEN;
            }
            case 2: {
                return Color.CYAN;
            }
            case 3: {
                return Color.MAGENTA;
            }
            case 4: {
                return Color.YELLOW;
            }
            case 5: {
                return Color.RED;
            }
        }
        return Color.GRAY;
    }

    protected static Color brighterColorByNr(int nr) {
        switch (nr) {
            case 0: {
                return new Color(100, 100, 255);
            }
            case 1: {
                return new Color(100, 255, 100);
            }
            case 2: {
                new Color(100, 255, 255);
            }
            case 3: {
                new Color(255, 100, 255);
            }
            case 4: {
                new Color(255, 255, 100);
            }
            case 5: {
                new Color(255, 100, 100);
            }
        }
        return Color.GRAY.brighter();
    }

    protected static Color darkerColorByNr(int nr) {
        switch (nr) {
            case 0: {
                return Color.BLUE.darker();
            }
            case 1: {
                return Color.GREEN.darker();
            }
            case 2: {
                return Color.CYAN.darker();
            }
            case 3: {
                return Color.MAGENTA.darker();
            }
            case 4: {
                return Color.YELLOW.darker();
            }
            case 5: {
                return Color.RED.darker();
            }
        }
        return Color.GRAY.darker();
    }

    public String getType() {
        return this.name;
    }

    public abstract File makeGraph(GraphInfo var1) throws IOException;

    public abstract List<GraphInfo> getGraphInfo();

    protected static String underScoreToCamelCase(String in) {
        Object out = "";
        boolean prevWasUnderscore = false;
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (c == '_') {
                prevWasUnderscore = true;
                continue;
            }
            out = prevWasUnderscore ? (String)out + Character.toUpperCase(c) : (String)out + c;
            prevWasUnderscore = false;
        }
        return out;
    }

    protected static String dsNameSimplify(String in) {
        String[] parts = in.split("-");
        String res = TestInstanceRrd.underScoreToCamelCase(parts[0]);
        if (res.matches("^tota[A-Z].*")) {
            res = res.replaceFirst("tota", "total");
        }
        if (res.matches(".*Oflw$")) {
            res = res.replaceFirst("Oflw$", "Openflow");
        }
        return res;
    }

    public List<DsDef> dsDefNamesToDsDef(String ... names) {
        ArrayList<DsDef> res = new ArrayList<DsDef>();
        for (String name : names) {
            for (DsDef dsDef : this.rrdDef.getDsDefs()) {
                if (!dsDef.getDsName().startsWith(name)) continue;
                res.add(dsDef);
            }
        }
        assert (names.length == res.size()) : "names.length=" + names.length + " res.size()=" + res.size() + " allDsNames=" + Arrays.asList(this.rrdDef.getDsDefs()).stream().map(DsDef::getDsName).collect(Collectors.toList());
        return res;
    }

    @Nonnull
    public abstract List<RawDataInfo> getRawDataInfo(String var1);

    @Nonnull
    public List<RawData> fetchRawData(RawDataInfo rawDataInfo) {
        ArrayList<RawData> res = new ArrayList<RawData>();
        try {
            RrdDb rrdDb = new RrdDb(this.rrdFile.getAbsolutePath(), true);
            FetchRequest fetchRequest = rrdDb.createFetchRequest(rawDataInfo.getArcDef().getConsolFun(), rawDataInfo.getFromSeconds(), rawDataInfo.getToSeconds());
            LOG.debug("fetchRawData({})", (Object)rawDataInfo);
            FetchData data = fetchRequest.fetchData();
            int colCount = data.getColumnCount();
            int rowCount = data.getRowCount();
            long stepSeconds = data.getStep();
            LOG.debug("data.getRowCount=" + rowCount);
            LOG.debug("data.getColumnCount=" + colCount);
            LOG.debug("data.getStep=" + stepSeconds);
            double[][] values = data.getValues();
            long[] timestamps = data.getTimestamps();
            String[] dsNames = data.getDsNames();
            boolean[] needed = new boolean[dsNames.length];
            List modDsNames = Arrays.asList(dsNames).stream().map(TestInstanceRrd::dsNameSimplify).collect(Collectors.toList());
            for (int dsIndex = 0; dsIndex < colCount; ++dsIndex) {
                String modDsName = (String)modDsNames.get(dsIndex);
                needed[dsIndex] = rawDataInfo.getMetrics().contains(modDsName);
            }
            LOG.debug("dsNames=" + Arrays.asList(dsNames));
            LOG.debug("modDsNames=" + modDsNames);
            LOG.debug("needed=" + Arrays.asList(new boolean[][]{needed}));
            for (int i = 0; i < rowCount; ++i) {
                long from = timestamps[i];
                long to = from + stepSeconds;
                boolean hasNonNull = false;
                HashMap<String, Double> rdv = new HashMap<String, Double>();
                for (int dsIndex = 0; dsIndex < colCount; ++dsIndex) {
                    if (!needed[dsIndex]) continue;
                    double v = values[dsIndex][i];
                    if (Double.isInfinite(v) || Double.isNaN(v)) {
                        rdv.put((String)modDsNames.get(dsIndex), null);
                        continue;
                    }
                    rdv.put((String)modDsNames.get(dsIndex), v);
                    hasNonNull = true;
                }
                this.postProcessRawValues(rdv, hasNonNull);
                if (!hasNonNull) continue;
                RawData rawData = new RawData(new Timestamp(from * 1000L), new Timestamp(to * 1000L), rdv);
                res.add(rawData);
            }
        }
        catch (FileNotFoundException e) {
            throw new NotFoundException("RRD Database file not found");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to fetch raw data", e);
        }
        return res;
    }

    protected void postProcessRawValues(Map<String, Double> values, boolean hasNonNull) {
    }

    public Date getRrdStartTime() {
        return new Date(this.rrdDef.getStartTime() * 1000L);
    }

    public List<GraphInfo> updateAllGraphs() throws IOException {
        LOG.debug("Rendering graphs");
        long startTime = System.currentTimeMillis();
        String ds = this.getDsLine();
        String[] dsParts = ds.split(":");
        if (dsParts.length != 6 || !dsParts[0].equals("DS")) {
            throw new RuntimeException("Invalid RRD DS line: \"" + ds + "\" (parsed into " + dsParts.length + " parts: " + Arrays.asList(dsParts) + ")");
        }
        List<GraphInfo> res = this.getGraphInfo();
        for (GraphInfo g : res) {
            File tmpGraphFile = this.makeGraph(g);
            tmpGraphFile.deleteOnExit();
        }
        long stopTime = System.currentTimeMillis();
        LOG.debug("Rendered graph(s) in " + (stopTime - startTime) + " ms");
        return res;
    }

    public void copyToRealFile() throws IOException {
        File cur = this.rrdFile;
        File orig = this.getRealRrdFile();
        File bck = new File(orig.getParent(), orig.getName() + ".bck");
        LOG.debug("Will copy " + cur.getAbsolutePath() + " to " + orig.getAbsolutePath() + " (while making sure there is a backup)");
        if (orig.exists()) {
            LOG.debug("cp " + orig.getAbsolutePath() + " " + bck.getAbsolutePath());
            Files.copy(orig.toPath(), bck.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        LOG.debug("cp " + cur.getAbsolutePath() + " " + orig.getAbsolutePath());
        Files.copy(cur.toPath(), orig.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public boolean isEnabled() {
        Boolean res = this.testInstance.getBooleanParameterOrDefault("rrd_enabled", this.testDefinition);
        if (res == null) {
            LOG.warn("There is no \"rrd_enabled\" parameter found in either testinstance or testdefinition! (will fall back to false)");
            return false;
        }
        return res;
    }

    public boolean exists() {
        try {
            return this.rrdFile.exists() && Files.size(this.rrdFile.toPath()) > 0L;
        }
        catch (IOException e) {
            LOG.error("Exception fetching file size of " + this.rrdFile.getAbsolutePath() + ". Will assume file does not exist!");
            return false;
        }
    }

    public double summarizeRawData(ConsolFun consolFun, long fromSec, long toSec, SummaryOp summaryOp, String dsSimpleName) {
        double res = 0.0;
        try {
            RrdDb rrdDb = new RrdDb(this.rrdFile.getAbsolutePath(), true);
            FetchRequest fetchRequest = rrdDb.createFetchRequest(consolFun, fromSec, toSec);
            LOG.debug("summarizeRawData({} {} {} {} {})", new Object[]{consolFun, fromSec, toSec, summaryOp, dsSimpleName});
            FetchData data = fetchRequest.fetchData();
            int colCount = data.getColumnCount();
            int rowCount = data.getRowCount();
            long stepSeconds = data.getStep();
            LOG.debug("data.getRowCount=" + rowCount);
            LOG.debug("data.getColumnCount=" + colCount);
            LOG.debug("data.getStep=" + stepSeconds);
            double[][] values = data.getValues();
            long[] timestamps = data.getTimestamps();
            String[] dsNames = data.getDsNames();
            List modDsNames = Arrays.asList(dsNames).stream().map(TestInstanceRrd::dsNameSimplify).collect(Collectors.toList());
            LOG.debug("dsNames=" + Arrays.asList(dsNames));
            LOG.debug("modDsNames=" + modDsNames);
            int neededDsIndex = modDsNames.indexOf(dsSimpleName);
            assert (neededDsIndex >= 0);
            block7: for (int i = 0; i < rowCount; ++i) {
                long from = timestamps[i];
                double v = values[neededDsIndex][i];
                if (Double.isInfinite(v) || Double.isNaN(v)) continue;
                switch (summaryOp) {
                    case TOTAL: {
                        if (v != 0.0) {
                            LOG.debug("for " + from + "      adding=" + v);
                        }
                        res += v;
                        continue block7;
                    }
                    case MAX: {
                        if (!(res < v)) continue block7;
                        res = v;
                        continue block7;
                    }
                    default: {
                        throw new RuntimeException("summaryOp " + summaryOp + " is not implemented");
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new NotFoundException("RRD Database file not found");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to fetch raw data", e);
        }
        return res;
    }

    protected class Val {
        protected String dsSubName;
        protected Double value;

        public Val(Double value) {
            this.dsSubName = null;
            this.value = value;
        }

        public Val(String dsSubName, Double value) {
            this.dsSubName = dsSubName;
            this.value = value;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class RawDataInfo {
        private final List<DsDef> dsDefs;
        private final ArcDef arcDef;
        private final RrdDef rrdDef;
        private final String id;
        private final String periodDescription;
        private final String stepDescription;
        private final Long stepSeconds;
        private final Long periodSeconds;
        private final long fromSeconds;
        private final long toSeconds;
        private final Timestamp from;
        private final Timestamp to;
        private final TestInstanceRrd testInstanceRrd;
        private final TestInstance testInstance;
        private final TestDefinition testDefinition;
        private final List<String> metrics;
        private final String consolidationFunction;
        private final URI dataUri;
        private final URI uri;

        public RawDataInfo(@Nonnull TestInstanceRrd testInstanceRrd, @Nonnull TestInstance testInstance, @Nonnull TestDefinition testDefinition, @Nonnull RrdDef rrdDef, @Nonnull List<DsDef> dsDefs, @Nonnull ArcDef arcDef, @Nonnull String baseUri) {
            this.testInstanceRrd = testInstanceRrd;
            try {
                this.testInstance = testInstance.getUri() == null ? ((TestInstanceBuilder)new TestInstanceBuilder(testInstance).setUri(new URI(baseUri + "testinstance/" + testInstance.getId()))).create() : testInstance;
                this.testDefinition = testDefinition.getUri() == null ? ((TestDefinitionBuilder)new TestDefinitionBuilder(testDefinition).setUri(new URI(baseUri + "testdefinition/" + (String)testDefinition.getId()))).create() : testDefinition;
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Unexpected failure, this should never occur!", e);
            }
            assert (!dsDefs.isEmpty());
            this.dsDefs = dsDefs;
            this.arcDef = arcDef;
            this.rrdDef = rrdDef;
            this.stepSeconds = (long)arcDef.getSteps() * rrdDef.getStep();
            long nowSeconds = Util.normalize((long)(System.currentTimeMillis() / 1000L), (long)this.stepSeconds) + this.stepSeconds;
            this.to = new Timestamp(nowSeconds * 1000L);
            this.toSeconds = nowSeconds;
            this.fromSeconds = nowSeconds - (long)arcDef.getRows() * this.stepSeconds;
            this.from = new Timestamp(this.fromSeconds * 1000L);
            this.stepDescription = RrdManager.makeTimePretty(this.stepSeconds);
            this.periodSeconds = (long)(arcDef.getRows() * arcDef.getSteps()) * rrdDef.getStep();
            this.periodDescription = RrdManager.makeTimePretty(this.periodSeconds);
            this.consolidationFunction = arcDef.getConsolFun().toString();
            this.metrics = dsDefs.stream().map(DsDef::getDsName).map(TestInstanceRrd::dsNameSimplify).collect(Collectors.toList());
            this.id = testInstance.getId() + "-" + this.periodDescription.replaceAll(" ", "") + "-" + this.consolidationFunction;
            try {
                this.uri = new URI(baseUri + "rrd/" + this.id);
                this.dataUri = new URI(baseUri + "rrd/" + this.id + "/data");
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Unexpected failure, this should never occur!", e);
            }
        }

        @JsonIgnore
        public List<DsDef> getDsDefs() {
            return this.dsDefs;
        }

        @JsonIgnore
        public ArcDef getArcDef() {
            return this.arcDef;
        }

        @JsonIgnore
        public RrdDef getRrdDef() {
            return this.rrdDef;
        }

        @JsonProperty
        public String getId() {
            return this.id;
        }

        @JsonProperty
        public String getPeriodDescription() {
            return this.periodDescription;
        }

        @JsonProperty
        public String getStepDescription() {
            return this.stepDescription;
        }

        @JsonProperty
        public Long getStepSeconds() {
            return this.stepSeconds;
        }

        @JsonProperty
        public Long getPeriodSeconds() {
            return this.periodSeconds;
        }

        @JsonProperty
        @JsonSerialize(using=JsonTimeStampRFC3339Serializer.class)
        @JsonDeserialize(using=JsonTimeStampRFC3339Deserializer.class)
        public Timestamp getFrom() {
            return this.from;
        }

        @JsonProperty
        @JsonSerialize(using=JsonTimeStampRFC3339Serializer.class)
        @JsonDeserialize(using=JsonTimeStampRFC3339Deserializer.class)
        public Timestamp getTo() {
            return this.to;
        }

        @JsonIgnore
        public long getFromSeconds() {
            return this.fromSeconds;
        }

        @JsonIgnore
        public long getToSeconds() {
            return this.toSeconds;
        }

        @JsonProperty
        @JsonSerialize(using=JsonLdObjectLinkSerializer.NeverEmbedParentLinkSerializer.class)
        public TestInstance getTestInstance() {
            return this.testInstance;
        }

        @JsonProperty
        @JsonSerialize(using=JsonLdObjectLinkSerializer.NeverEmbedParentLinkSerializer.class)
        public TestDefinition getTestDefinition() {
            return this.testDefinition;
        }

        @JsonProperty
        public List<String> getMetrics() {
            return this.metrics;
        }

        @JsonProperty
        public String getConsolidationFunction() {
            return this.consolidationFunction;
        }

        @JsonProperty(value="data")
        public URI getDataUri() {
            return this.dataUri;
        }

        @JsonProperty(value="@id")
        public URI getUri() {
            return this.uri;
        }

        @JsonIgnore
        @Nonnull
        public List<RawData> fetchRawData() {
            return this.testInstanceRrd.fetchRawData(this);
        }

        public String toString() {
            ObjectMapper mapper = new ObjectMapper();
            try {
                return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
            }
            catch (JsonProcessingException e) {
                LOG.error("Exception converting RawDataInfo " + this.getId() + " to JSON", (Throwable)e);
                return "Exception converting RawDataInfo " + this.getId() + " to JSON: " + e.getMessage();
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class RawData {
        private final Timestamp from;
        private final Timestamp to;
        private final Map<String, Double> values;

        public RawData(Timestamp from, Timestamp to, Map<String, Double> values) {
            this.from = from;
            this.to = to;
            this.values = values;
        }

        @JsonProperty
        @JsonSerialize(using=JsonTimeStampRFC3339Serializer.class)
        @JsonDeserialize(using=JsonTimeStampRFC3339Deserializer.class)
        public Timestamp getFrom() {
            return this.from;
        }

        @JsonProperty
        @JsonSerialize(using=JsonTimeStampRFC3339Serializer.class)
        @JsonDeserialize(using=JsonTimeStampRFC3339Deserializer.class)
        public Timestamp getTo() {
            return this.to;
        }

        @JsonAnyGetter
        public Map<String, Double> getValues() {
            return this.values;
        }
    }

    public static class GraphInfo {
        private final DsDef dsDef;
        private final ArcDef arcDef;
        private final RrdDef rrdDef;
        private final Graph graph;

        public GraphInfo(@Nonnull String baseName, @Nullable String subType, long periodInSeconds, String description, TestInstance testInstance, TestDefinition testDefinition, long graphStartTime, long graphEndTime, RrdDef rrdDef, DsDef dsDef, ArcDef arcDef) {
            this.graph = new Graph(subType == null ? testInstance.getId() + "-" + baseName + "-" + RrdManager.makeTimePretty(periodInSeconds) : testInstance.getId() + "-" + baseName + "-" + subType + "-" + RrdManager.makeTimePretty(periodInSeconds), baseName, subType, RrdManager.makeTimePretty(periodInSeconds), description, Long.valueOf(periodInSeconds), testInstance, testDefinition, new Timestamp(graphStartTime * 1000L), new Timestamp(graphEndTime * 1000L), new Timestamp((graphEndTime + RrdManager.periodAndStepToExpireS(rrdDef.getStep(), (long)(arcDef.getSteps() * arcDef.getRows()) * rrdDef.getStep())) * 1000L), null, null, true);
            assert (baseName != null);
            assert (periodInSeconds > 0L);
            assert (!baseName.trim().isEmpty());
            assert (subType == null || !subType.trim().isEmpty());
            this.dsDef = dsDef;
            this.arcDef = arcDef;
            this.rrdDef = rrdDef;
        }

        public RrdDef getRrdDef() {
            return this.rrdDef;
        }

        public DsDef getDsDef() {
            return this.dsDef;
        }

        public ArcDef getArcDef() {
            return this.arcDef;
        }

        public long getExpireS() {
            return this.getExpire().getTime() / 1000L;
        }

        public Graph getGraph() {
            return this.graph;
        }

        public String getId() {
            return (String)this.graph.getId();
        }

        public URI getUri() {
            return this.graph.getUri();
        }

        public String getClassName() {
            return this.graph.getClassName();
        }

        public boolean getSerializeAsEmbeddedObject() {
            return this.graph.getSerializeAsEmbeddedObject();
        }

        public String getGraphDefinitionId() {
            return this.graph.getGraphDefinitionId();
        }

        public String getDescription() {
            return this.graph.getDescription();
        }

        public String getSubType() {
            return this.graph.getSubType();
        }

        public String getPeriodString() {
            return this.graph.getPeriodString();
        }

        public Long getPeriodInSeconds() {
            return this.graph.getPeriodInSeconds();
        }

        public TestInstance getTestInstance() {
            return this.graph.getTestInstance();
        }

        public TestDefinition getTestDefinition() {
            return this.graph.getTestDefinition();
        }

        public Integer getTestInstanceId() {
            return this.graph.getTestInstanceId();
        }

        public String getTestDefinitionId() {
            return this.graph.getTestDefinitionId();
        }

        public Date getGraphStartTime() {
            return this.graph.getGraphStartTime();
        }

        public long getGraphStartTimeInSecondsSinceEpoch() {
            return this.graph.getGraphStartTimeInSecondsSinceEpoch();
        }

        public long getGraphEndTimeInSecondsSinceEpoch() {
            return this.graph.getGraphEndTimeInSecondsSinceEpoch();
        }

        public Date getGraphEndTime() {
            return this.graph.getGraphEndTime();
        }

        public Date getExpire() {
            return this.graph.getExpire();
        }

        public long getExpireInSecondsSinceEpoch() {
            return this.graph.getExpireInSecondsSinceEpoch();
        }

        public URI getImageUri() {
            return this.graph.getImageUri();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof GraphInfo)) {
                return false;
            }
            GraphInfo graphInfo = (GraphInfo)o;
            if (this.dsDef != null ? !this.dsDef.equals((Object)graphInfo.dsDef) : graphInfo.dsDef != null) {
                return false;
            }
            if (this.arcDef != null ? !this.arcDef.equals((Object)graphInfo.arcDef) : graphInfo.arcDef != null) {
                return false;
            }
            if (this.rrdDef != null ? !this.rrdDef.equals((Object)graphInfo.rrdDef) : graphInfo.rrdDef != null) {
                return false;
            }
            return this.graph != null ? this.graph.equals((Object)graphInfo.graph) : graphInfo.graph == null;
        }

        public int hashCode() {
            int result = this.dsDef != null ? this.dsDef.hashCode() : 0;
            result = 31 * result + (this.arcDef != null ? this.arcDef.hashCode() : 0);
            result = 31 * result + (this.rrdDef != null ? this.rrdDef.hashCode() : 0);
            result = 31 * result + (this.graph != null ? this.graph.hashCode() : 0);
            return result;
        }

        public String toString() {
            ObjectMapper mapper = new ObjectMapper();
            try {
                return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
            }
            catch (JsonProcessingException e) {
                LOG.error("Exception converting Testbed " + this.getId() + " to JSON", (Throwable)e);
                return "Exception converting Testbed " + this.getId() + " to JSON: " + e.getMessage();
            }
        }
    }

    public static enum SummaryOp {
        TOTAL,
        MAX;

    }
}

