/*
 * Decompiled with CFR 0.152.
 */
package org.rendersnake.ext.servlet;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.rendersnake.internal.ContextMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionAttributesMap
implements ContextMap {
    private HttpServletRequest request;
    private HttpSession session;

    public SessionAttributesMap(HttpServletRequest request) {
        this.request = request;
    }

    private HttpSession getSession(boolean createIfAbsent) {
        if (this.session != null) {
            return this.session;
        }
        this.session = this.request.getSession(createIfAbsent);
        return this.session;
    }

    @Override
    public SessionAttributesMap withBoolean(String key, Boolean trueOrFalse) {
        this.getSession(true).setAttribute(key, trueOrFalse);
        return this;
    }

    @Override
    public Boolean getBoolean(String key, Boolean ... optional) {
        HttpSession currentSession = this.getSession(false);
        Object value = null;
        if (currentSession != null) {
            value = currentSession.getAttribute(key);
        }
        if (value == null) {
            return optional == null || optional.length == 0 ? null : optional[0];
        }
        return (Boolean)value;
    }

    @Override
    public Long getLong(String key, Long ... optional) {
        HttpSession currentSession = this.getSession(false);
        Object value = null;
        if (currentSession != null) {
            value = currentSession.getAttribute(key);
        }
        if (value == null) {
            return optional == null || optional.length == 0 ? null : optional[0];
        }
        return (Long)value;
    }

    @Override
    public SessionAttributesMap withLong(String key, Long aLong) {
        this.getSession(true).setAttribute(key, aLong);
        return this;
    }

    @Override
    public Float getFloat(String key, Float ... optional) {
        HttpSession currentSession = this.getSession(false);
        Object value = null;
        if (currentSession != null) {
            value = currentSession.getAttribute(key);
        }
        if (value == null) {
            return optional == null || optional.length == 0 ? null : optional[0];
        }
        return (Float)value;
    }

    @Override
    public SessionAttributesMap withFloat(String key, Float aFloat) {
        this.getSession(true).setAttribute(key, aFloat);
        return this;
    }

    @Override
    public SessionAttributesMap withInteger(String key, Integer anInteger) {
        this.getSession(true).setAttribute(key, anInteger);
        return this;
    }

    @Override
    public Integer getInteger(String key, Integer ... optional) {
        HttpSession currentSession = this.getSession(false);
        Object value = null;
        if (currentSession != null) {
            value = currentSession.getAttribute(key);
        }
        if (value == null) {
            return optional == null || optional.length == 0 ? null : optional[0];
        }
        return (Integer)value;
    }

    @Override
    public Object getObject(String key, Object ... optional) {
        HttpSession currentSession = this.getSession(false);
        Object value = null;
        if (currentSession != null) {
            value = currentSession.getAttribute(key);
        }
        if (value == null) {
            return optional == null || optional.length == 0 ? null : optional[0];
        }
        return value;
    }

    @Override
    public SessionAttributesMap withObject(String key, Object value) {
        this.getSession(true).setAttribute(key, value);
        return this;
    }

    @Override
    public SessionAttributesMap withString(String key, String value) {
        this.getSession(true).setAttribute(key, value);
        return this;
    }

    @Override
    public String getString(String key, String ... optional) {
        HttpSession currentSession = this.getSession(false);
        Object value = null;
        if (currentSession != null) {
            value = currentSession.getAttribute(key);
        }
        if (value == null) {
            return optional == null || optional.length == 0 ? null : optional[0];
        }
        return (String)value;
    }

    @Override
    public Object clear(String key) {
        HttpSession currentSession = this.getSession(false);
        if (currentSession == null) {
            return null;
        }
        Object last = currentSession.getAttribute(key);
        currentSession.removeAttribute(key);
        return last;
    }

    @Override
    public Map<Object, Object> toMap() {
        HttpSession currentSession = this.getSession(false);
        if (currentSession == null) {
            return null;
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        Enumeration<String> enumy = currentSession.getAttributeNames();
        while (enumy.hasMoreElements()) {
            String key = enumy.nextElement();
            map.put(key, currentSession.getAttribute(key));
        }
        return map;
    }
}

