/*
 * Decompiled with CFR 0.152.
 */
package org.rendersnake.ext.spring;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.rendersnake.HtmlCanvas;
import org.rendersnake.PageContext;
import org.rendersnake.ext.servlet.RequestHeadersMap;
import org.rendersnake.ext.servlet.RequestParametersMap;
import org.rendersnake.ext.servlet.SessionAttributesMap;
import org.rendersnake.ext.spring.HtmlCanvasFactory;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebArgumentResolver;
import org.springframework.web.context.request.NativeWebRequest;

public class HtmlCanvasArgumentResolver
implements WebArgumentResolver {
    public Object resolveArgument(MethodParameter methodParameter, NativeWebRequest webRequest) throws Exception {
        if (methodParameter.getParameterType() != HtmlCanvas.class) {
            return UNRESOLVED;
        }
        HttpServletRequest request = (HttpServletRequest)webRequest.getNativeRequest();
        HttpServletResponse response = (HttpServletResponse)webRequest.getNativeResponse();
        response.setContentType("text/html");
        HtmlCanvas canvas = HtmlCanvasFactory.createCanvas(request, response, response.getWriter());
        HtmlCanvasArgumentResolver.setupPageContext(request, canvas.getPageContext());
        return canvas;
    }

    static void setupPageContext(HttpServletRequest request, PageContext context) {
        String q = request.getQueryString();
        context.withObject("http.request.path", request.getPathTranslated());
        context.withObject("http.request.uri.query", request.getRequestURI() + (q == null ? "" : "?" + q));
        context.withObject("http.session", new SessionAttributesMap(request));
        context.withObject("http.request.parameters", new RequestParametersMap(request));
        context.withObject("http.request.headers", new RequestHeadersMap(request));
    }
}

