/*
 * Decompiled with CFR 0.152.
 */
package org.rendersnake.internal;

import java.io.IOException;
import java.io.Writer;

public class WriteBuffer
extends Writer {
    private char[] buffer;
    private int begin = 0;
    private int end = -1;

    public WriteBuffer() {
        this(64);
    }

    public WriteBuffer(int initialCapacity) {
        this.buffer = new char[initialCapacity];
    }

    public void reset() {
        this.begin = 0;
        this.end = -1;
    }

    public WriteBuffer append(char ch) {
        if (this.begin == this.buffer.length) {
            this.grow();
        }
        this.buffer[this.begin] = ch;
        ++this.begin;
        ++this.end;
        return this;
    }

    public void append(String s) {
        int l = s.length();
        while (this.begin + l > this.buffer.length) {
            this.grow();
        }
        s.getChars(0, l, this.buffer, this.begin);
        this.begin += l;
        this.end += l;
    }

    public void append(int integer) {
        this.append(String.valueOf(integer));
    }

    public String toString() {
        if (this.end == -1) {
            return "";
        }
        return new String(this.buffer, 0, this.end + 1);
    }

    private void grow() {
        char[] newbuffer = new char[this.buffer.length * 2];
        System.arraycopy(this.buffer, 0, newbuffer, 0, this.buffer.length);
        this.buffer = newbuffer;
    }

    public int length() {
        return this.end + 1;
    }

    public void writeCharsOn(Writer writer) throws IOException {
        writer.write(this.buffer, 0, this.end + 1);
    }

    public void close() throws IOException {
    }

    public void flush() throws IOException {
    }

    public void write(char[] charArray, int from, int to) throws IOException {
        for (int i = from; i < to; ++i) {
            this.append(charArray[i]);
        }
    }
}

