/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.bugreport.jira;

import be.iminds.ilabt.jfed.bugreport.jira.JiraClient;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class JiraClientTest {
    private String getPassword() {
        try {
            return IOUtils.fileToString((String)"/home/wim/tmp/jira.pass").trim();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read password", e);
        }
    }

    private JiraClient getJiraClient() {
        return new JiraClient("https://ibcn-jira.intec.ugent.be", "wvdemeer", this.getPassword());
    }

    @Test
    public void testJiraSearch() throws JiraClient.JiraException {
        JiraClient jiraClient = this.getJiraClient();
        List issueKeys = jiraClient.getIssueKeysMatchingSummarySearch("FEDIBBTDEV", Collections.singletonList("Jira REST API java client"), true);
        System.out.println("Found issues: " + issueKeys);
        MatcherAssert.assertThat((Object)issueKeys, (Matcher)Matchers.is((Matcher)Matchers.equalTo(Collections.singletonList("FEDIBBTDEV-2728"))));
    }

    @Test
    public void testJiraDescription() throws JiraClient.JiraException {
        JiraClient jiraClient = this.getJiraClient();
        String description = jiraClient.getIssueDescription("FEDIBBTDEV-2728");
        System.out.println("Found description: " + description);
        MatcherAssert.assertThat((Object)description, (Matcher)Matchers.containsString((String)"This is a test of the Jira REST API java client."));
    }

    @Test
    public void testAddComment() throws JiraClient.JiraException {
        JiraClient jiraClient = this.getJiraClient();
        jiraClient.addComment("FEDIBBTDEV-2728", "This is just a test comment. Ignore it.");
    }

    @Test
    public void testCreateIssue() throws JiraClient.JiraException {
        JiraClient jiraClient = this.getJiraClient();
        String issueKey = jiraClient.createIssue("FEDIBBTDEV", "This is a test issue. Ignore it.", "This is the description of the test message.", "Task", Collections.singletonList("wvdemeer_todo"), Collections.singletonList("jFed FedMon"), "wvdemeer", "Release_R5.7.0", Collections.singletonList("FEDIBBTDEV-2728"));
        System.out.println("Created issue: " + issueKey);
        MatcherAssert.assertThat((Object)issueKey, (Matcher)Matchers.containsString((String)"FEDIBBTDEV"));
    }
}

