/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.math.BigDecimal;
import java.net.URI;
import java.net.URL;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.skife.jdbi.v2.ResultColumnMapperFactory;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultColumnMapper;
import org.skife.jdbi.v2.util.BigDecimalColumnMapper;
import org.skife.jdbi.v2.util.BooleanColumnMapper;
import org.skife.jdbi.v2.util.ByteArrayColumnMapper;
import org.skife.jdbi.v2.util.ByteColumnMapper;
import org.skife.jdbi.v2.util.CharColumnMapper;
import org.skife.jdbi.v2.util.DoubleColumnMapper;
import org.skife.jdbi.v2.util.EnumColumnMapper;
import org.skife.jdbi.v2.util.FloatColumnMapper;
import org.skife.jdbi.v2.util.IntegerColumnMapper;
import org.skife.jdbi.v2.util.LongColumnMapper;
import org.skife.jdbi.v2.util.ShortColumnMapper;
import org.skife.jdbi.v2.util.StringColumnMapper;
import org.skife.jdbi.v2.util.TimestampColumnMapper;
import org.skife.jdbi.v2.util.URIColumnMapper;
import org.skife.jdbi.v2.util.URLColumnMapper;

public class PrimitivesColumnMapperFactory
implements ResultColumnMapperFactory {
    private static final Map<Class, ResultColumnMapper> mappers = new HashMap<Class, ResultColumnMapper>();

    @Override
    public boolean accepts(Class type, StatementContext ctx) {
        return type.isEnum() || mappers.containsKey(type);
    }

    @Override
    public ResultColumnMapper columnMapperFor(Class type, StatementContext ctx) {
        if (type.isEnum()) {
            return EnumColumnMapper.byName(type);
        }
        return mappers.get(type);
    }

    static {
        mappers.put(Boolean.TYPE, BooleanColumnMapper.PRIMITIVE);
        mappers.put(Byte.TYPE, ByteColumnMapper.PRIMITIVE);
        mappers.put(Character.TYPE, CharColumnMapper.PRIMITIVE);
        mappers.put(Short.TYPE, ShortColumnMapper.PRIMITIVE);
        mappers.put(Integer.TYPE, IntegerColumnMapper.PRIMITIVE);
        mappers.put(Long.TYPE, LongColumnMapper.PRIMITIVE);
        mappers.put(Float.TYPE, FloatColumnMapper.PRIMITIVE);
        mappers.put(Double.TYPE, DoubleColumnMapper.PRIMITIVE);
        mappers.put(Boolean.class, BooleanColumnMapper.WRAPPER);
        mappers.put(Byte.class, ByteColumnMapper.WRAPPER);
        mappers.put(Character.class, CharColumnMapper.WRAPPER);
        mappers.put(Short.class, ShortColumnMapper.WRAPPER);
        mappers.put(Integer.class, IntegerColumnMapper.WRAPPER);
        mappers.put(Long.class, LongColumnMapper.WRAPPER);
        mappers.put(Float.class, FloatColumnMapper.WRAPPER);
        mappers.put(Double.class, DoubleColumnMapper.WRAPPER);
        mappers.put(BigDecimal.class, BigDecimalColumnMapper.INSTANCE);
        mappers.put(String.class, StringColumnMapper.INSTANCE);
        mappers.put(byte[].class, ByteArrayColumnMapper.INSTANCE);
        mappers.put(Timestamp.class, TimestampColumnMapper.INSTANCE);
        mappers.put(URL.class, URLColumnMapper.INSTANCE);
        mappers.put(URI.class, URIColumnMapper.INSTANCE);
    }
}

