/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.util;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultColumnMapper;

public enum ShortColumnMapper implements ResultColumnMapper<Short>
{
    PRIMITIVE(false),
    WRAPPER(true);

    private final boolean nullable;

    private ShortColumnMapper(boolean nullable) {
        this.nullable = nullable;
    }

    @Override
    public Short mapColumn(ResultSet r, int columnNumber, StatementContext ctx) throws SQLException {
        short value = r.getShort(columnNumber);
        return this.nullable && r.wasNull() ? null : Short.valueOf(value);
    }

    @Override
    public Short mapColumn(ResultSet r, String columnLabel, StatementContext ctx) throws SQLException {
        short value = r.getShort(columnLabel);
        return this.nullable && r.wasNull() ? null : Short.valueOf(value);
    }
}

