/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.test.inmemory;

import java.net.URI;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.test.DeploymentContext;
import org.glassfish.jersey.test.inmemory.InMemoryConnector;
import org.glassfish.jersey.test.spi.TestContainer;
import org.glassfish.jersey.test.spi.TestContainerFactory;

public class InMemoryTestContainerFactory
implements TestContainerFactory {
    public TestContainer create(URI baseUri, DeploymentContext context) throws IllegalArgumentException {
        return new InMemoryTestContainer(baseUri, context);
    }

    private static class InMemoryTestContainer
    implements TestContainer {
        private final URI baseUri;
        private final ApplicationHandler appHandler;
        private final AtomicBoolean started = new AtomicBoolean(false);
        private static final Logger LOGGER = Logger.getLogger(InMemoryTestContainer.class.getName());

        private InMemoryTestContainer(URI baseUri, DeploymentContext context) {
            this.baseUri = UriBuilder.fromUri((URI)baseUri).path(context.getContextPath()).build(new Object[0]);
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Creating InMemoryTestContainer configured at the base URI " + this.baseUri);
            }
            this.appHandler = new ApplicationHandler((Application)context.getResourceConfig());
        }

        public ClientConfig getClientConfig() {
            return new ClientConfig().connectorProvider((ConnectorProvider)new InMemoryConnector.Provider(this.baseUri, this.appHandler));
        }

        public URI getBaseUri() {
            return this.baseUri;
        }

        public void start() {
            if (this.started.compareAndSet(false, true)) {
                LOGGER.log(Level.FINE, "Starting InMemoryContainer...");
            } else {
                LOGGER.log(Level.WARNING, "Ignoring start request - InMemoryTestContainer is already started.");
            }
        }

        public void stop() {
            if (this.started.compareAndSet(true, false)) {
                LOGGER.log(Level.FINE, "Stopping InMemoryContainer...");
            } else {
                LOGGER.log(Level.WARNING, "Ignoring stop request - InMemoryTestContainer is already stopped.");
            }
        }
    }
}

