/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.FedmonFullObjectLinkDeserializers;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.GraphBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.json.util.JsonTimeStampRFC3339Deserializer;
import be.iminds.ilabt.jfed.json.util.JsonTimeStampRFC3339Serializer;
import be.iminds.ilabt.util.jsonld.JsonLdObjectLinkSerializer;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.net.URI;
import java.sql.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"@context"})
@JsonLdObjectsMetaData.JsonLdObjectInfo(pathName="graph", builderClass=GraphBuilder.class, uriType=JsonLdObjectsMetaData.UriType.ID_BASED, idType=JsonLdObjectsMetaData.IdType.PRIMARY)
public class Graph
extends PrimaryIdObject<String> {
    private static final Logger LOG = LoggerFactory.getLogger(Graph.class);
    private final String graphDefinitionId;
    private final String subType;
    private final String periodString;
    private final String description;
    private final Long periodInSeconds;
    private final TestInstance testInstance;
    private final TestDefinition testDefinition;
    private final Timestamp graphStartTime;
    private final Timestamp graphEndTime;
    private final Timestamp expire;
    private final URI imageUri;

    @JsonCreator
    public Graph(@JsonProperty(value="id") String id, @JsonProperty(value="graphDefinitionId") String graphDefinitionId, @JsonProperty(value="subType") String subType, @JsonProperty(value="periodString") String periodString, @JsonProperty(value="description") String description, @JsonProperty(value="periodInSeconds") Long periodInSeconds, @JsonProperty(value="testInstance") TestInstance testInstance, @JsonProperty(value="testDefinition") TestDefinition testDefinition, @JsonProperty(value="graphStartTime") Timestamp graphStartTime, @JsonProperty(value="graphEndTime") Timestamp graphEndTime, @JsonProperty(value="expire") Timestamp expire, @JsonProperty(value="image") URI imageUri, @JsonProperty(value="@id") URI uri) {
        this(id, graphDefinitionId, subType, periodString, description, periodInSeconds, testInstance, testDefinition, graphStartTime, graphEndTime, expire, imageUri, uri, JsonLdObjectsMetaData.mustSerializeAsEmbeddedObjectForJacksonConstructor());
    }

    public Graph(String id, String graphDefinitionId, String subType, String periodString, String description, Long periodInSeconds, TestInstance testInstance, TestDefinition testDefinition, Timestamp graphStartTime, Timestamp graphEndTime, Timestamp expire, URI imageUri, URI uri, boolean serializeInfo_SerializeAsEmbeddedObject) {
        super((Object)id, uri, serializeInfo_SerializeAsEmbeddedObject);
        this.graphDefinitionId = graphDefinitionId;
        this.subType = subType;
        this.periodString = periodString;
        this.description = description;
        this.periodInSeconds = periodInSeconds;
        this.testInstance = testInstance;
        this.testDefinition = testDefinition;
        this.graphStartTime = graphStartTime;
        this.graphEndTime = graphEndTime;
        this.expire = expire;
        this.imageUri = imageUri;
    }

    @JsonProperty
    public String getGraphDefinitionId() {
        return this.graphDefinitionId;
    }

    @JsonProperty
    public String getDescription() {
        return this.description;
    }

    @JsonProperty
    public String getSubType() {
        return this.subType;
    }

    @JsonProperty
    public String getPeriodString() {
        return this.periodString;
    }

    @JsonProperty
    public Long getPeriodInSeconds() {
        return this.periodInSeconds;
    }

    @JsonProperty
    @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.TestInstanceDeserializer.class)
    @JsonSerialize(using=JsonLdObjectLinkSerializer.ParentLinkSerializer.class)
    public TestInstance getTestInstance() {
        return this.testInstance;
    }

    @JsonProperty
    @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.TestDefinitionDeserializer.class)
    @JsonSerialize(using=JsonLdObjectLinkSerializer.ParentLinkSerializer.class)
    public TestDefinition getTestDefinition() {
        return this.testDefinition;
    }

    @JsonIgnore
    public Integer getTestInstanceId() {
        return this.testInstance == null ? null : (Integer)this.testInstance.getId();
    }

    @JsonIgnore
    public String getTestDefinitionId() {
        return this.testDefinition == null ? null : (String)this.testDefinition.getId();
    }

    @JsonProperty
    @JsonSerialize(using=JsonTimeStampRFC3339Serializer.class)
    @JsonDeserialize(using=JsonTimeStampRFC3339Deserializer.class)
    public Timestamp getGraphStartTime() {
        return this.graphStartTime;
    }

    @JsonIgnore
    public long getGraphStartTimeInSecondsSinceEpoch() {
        return this.graphStartTime.getTime() / 1000L;
    }

    @JsonIgnore
    public long getGraphEndTimeInSecondsSinceEpoch() {
        return this.graphEndTime.getTime() / 1000L;
    }

    @JsonProperty
    @JsonSerialize(using=JsonTimeStampRFC3339Serializer.class)
    @JsonDeserialize(using=JsonTimeStampRFC3339Deserializer.class)
    public Timestamp getGraphEndTime() {
        return this.graphEndTime;
    }

    @JsonProperty
    @JsonSerialize(using=JsonTimeStampRFC3339Serializer.class)
    @JsonDeserialize(using=JsonTimeStampRFC3339Deserializer.class)
    public Timestamp getExpire() {
        return this.expire;
    }

    @JsonIgnore
    public long getExpireInSecondsSinceEpoch() {
        return this.expire.getTime() / 1000L;
    }

    @JsonProperty(value="image")
    public URI getImageUri() {
        return this.imageUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Graph)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Graph graph = (Graph)((Object)o);
        if (this.periodInSeconds != null ? !this.periodInSeconds.equals(graph.periodInSeconds) : graph.periodInSeconds != null) {
            return false;
        }
        if (this.graphDefinitionId != null ? !this.graphDefinitionId.equals(graph.graphDefinitionId) : graph.graphDefinitionId != null) {
            return false;
        }
        if (this.subType != null ? !this.subType.equals(graph.subType) : graph.subType != null) {
            return false;
        }
        if (this.periodString != null ? !this.periodString.equals(graph.periodString) : graph.periodString != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(graph.description) : graph.description != null) {
            return false;
        }
        if (this.testInstance != null ? !this.testInstance.equals((Object)graph.testInstance) : graph.testInstance != null) {
            return false;
        }
        if (this.testDefinition != null ? !this.testDefinition.equals((Object)graph.testDefinition) : graph.testDefinition != null) {
            return false;
        }
        if (this.graphStartTime != null ? !this.graphStartTime.equals(graph.graphStartTime) : graph.graphStartTime != null) {
            return false;
        }
        if (this.graphEndTime != null ? !this.graphEndTime.equals(graph.graphEndTime) : graph.graphEndTime != null) {
            return false;
        }
        if (this.expire != null ? !this.expire.equals(graph.expire) : graph.expire != null) {
            return false;
        }
        return this.imageUri != null ? this.imageUri.equals(graph.imageUri) : graph.imageUri == null;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.graphDefinitionId != null ? this.graphDefinitionId.hashCode() : 0);
        result = 31 * result + (this.subType != null ? this.subType.hashCode() : 0);
        result = 31 * result + (this.periodInSeconds != null ? this.periodInSeconds.hashCode() : 0);
        result = 31 * result + (this.periodString != null ? this.periodString.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.testInstance != null ? this.testInstance.hashCode() : 0);
        result = 31 * result + (this.testDefinition != null ? this.testDefinition.hashCode() : 0);
        result = 31 * result + (this.graphStartTime != null ? this.graphStartTime.hashCode() : 0);
        result = 31 * result + (this.graphEndTime != null ? this.graphEndTime.hashCode() : 0);
        result = 31 * result + (this.expire != null ? this.expire.hashCode() : 0);
        result = 31 * result + (this.imageUri != null ? this.imageUri.hashCode() : 0);
        return result;
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)GraphBuilder.minimize(JsonLdObjectsMetaData.Minimization.FULL_WITH_MINIMAL_LINK_IDS, this));
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting Testbed " + (String)this.getId() + " to JSON", (Throwable)e);
            return "Exception converting Testbed " + (String)this.getId() + " to JSON: " + e.getMessage();
        }
    }
}

