/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.FedmonFullObjectLinkDeserializers;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Task;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceStatisticsBuilder;
import be.iminds.ilabt.jfed.json.util.JsonTimeStampRFC3339Deserializer;
import be.iminds.ilabt.jfed.json.util.JsonTimeStampRFC3339Serializer;
import be.iminds.ilabt.util.jsonld.JsonLdObjectLinkSerializer;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.BasicLdObject;
import be.iminds.ilabt.util.jsonld.impl.ForeignIdObject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.net.URI;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"@context"})
@JsonLdObjectsMetaData.JsonLdObjectInfo(pathName="testinstancestatistics", builderClass=TestInstanceStatisticsBuilder.class, uriType=JsonLdObjectsMetaData.UriType.ID_BASED, idType=JsonLdObjectsMetaData.IdType.FOREIGN)
public class TestInstanceStatistics
extends ForeignIdObject {
    private static final Logger LOG = LoggerFactory.getLogger(TestInstanceStatistics.class);
    private final TestInstance testInstance;
    private final Timestamp nextRun;
    private final Timestamp lastRun;
    private final Map<String, LastResultInfo> lastResultInfoByFilter;
    private final Task activeTask;
    private final RrdStatistics rrdStatistics;
    private final Summation summation;

    @JsonCreator
    TestInstanceStatistics(@JsonProperty(value="testInstance") TestInstance testInstance, @JsonProperty(value="nextRun") Timestamp nextRun, @JsonProperty(value="lastRun") Timestamp lastRun, @JsonProperty(value="lastResults") Collection<LastResultInfo> lastResultInfoList, @JsonProperty(value="activeTask") Task activeTask, @JsonProperty(value="rrdStatistics") RrdStatistics rrdStatistics, @JsonProperty(value="summation") Summation summation, @JsonProperty(value="@id") URI uri) {
        super(uri, JsonLdObjectsMetaData.mustSerializeAsEmbeddedObjectForJacksonConstructor());
        HashMap<String, LastResultInfo> lastResultInfoByFilter;
        this.testInstance = testInstance;
        this.nextRun = nextRun;
        this.lastRun = lastRun;
        this.activeTask = activeTask;
        this.rrdStatistics = rrdStatistics;
        this.summation = summation;
        assert (testInstance == null || testInstance.getId() != null) : "testInstance == null -> " + (testInstance == null) + "   <->   testInstance.getId() ->" + testInstance.getId();
        assert (activeTask == null || activeTask.getId() != null) : "activeTask == null -> " + (activeTask == null) + "   <->   activeTask.getId() ->" + activeTask.getId();
        HashMap<String, LastResultInfo> hashMap = lastResultInfoByFilter = lastResultInfoList == null ? null : new HashMap<String, LastResultInfo>();
        if (lastResultInfoList != null) {
            for (LastResultInfo lastResultInfo : lastResultInfoList) {
                assert (lastResultInfo != null);
                lastResultInfoByFilter.put(lastResultInfo.getFilter(), lastResultInfo);
            }
        }
        this.lastResultInfoByFilter = lastResultInfoByFilter;
    }

    @JsonProperty
    @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.TestInstanceDeserializer.class)
    @JsonSerialize(using=JsonLdObjectLinkSerializer.NeverEmbedParentLinkSerializer.class)
    TestInstance getTestInstance() {
        assert (this.testInstance == null || this.testInstance.getId() != null) : "testInstance == null -> " + (this.testInstance == null) + "   <->   testInstance.getId() ->" + this.testInstance.getId();
        return this.testInstance;
    }

    @JsonIgnore
    public Integer getTestInstanceId() {
        return this.testInstance == null ? null : (Integer)this.testInstance.getId();
    }

    @JsonIgnore
    public URI getTestInstanceUri() {
        return this.testInstance == null ? null : this.testInstance.getUri();
    }

    @JsonSerialize(using=JsonTimeStampRFC3339Serializer.class)
    @JsonDeserialize(using=JsonTimeStampRFC3339Deserializer.class)
    @JsonProperty
    public Timestamp getNextRun() {
        return this.nextRun;
    }

    @JsonSerialize(using=JsonTimeStampRFC3339Serializer.class)
    @JsonDeserialize(using=JsonTimeStampRFC3339Deserializer.class)
    @JsonProperty
    public Timestamp getLastRun() {
        return this.lastRun;
    }

    @JsonProperty
    public RrdStatistics getRrdStatistics() {
        return this.rrdStatistics;
    }

    @JsonProperty
    public Summation getSummation() {
        return this.summation;
    }

    @JsonProperty(value="lastResults")
    public Collection<LastResultInfo> getLastResultInfos() {
        return this.lastResultInfoByFilter == null ? null : this.lastResultInfoByFilter.values();
    }

    @JsonIgnore
    public Map<String, LastResultInfo> getLastResultInfoByFilter() {
        return this.lastResultInfoByFilter;
    }

    @JsonIgnore
    public LastResultInfo getLastResultInfo(String filter) {
        return this.lastResultInfoByFilter == null ? null : this.lastResultInfoByFilter.get(filter);
    }

    @JsonIgnore
    public Long getLastResultId(String filter) {
        if (this.lastResultInfoByFilter == null) {
            return null;
        }
        LastResultInfo info = this.lastResultInfoByFilter.get(filter);
        if (info == null) {
            return null;
        }
        return info.getResultId();
    }

    @JsonIgnore
    public LastResultInfo getLastResultInfo() {
        return this.getLastResultInfo("any");
    }

    @JsonIgnore
    public Long getLastResultId() {
        return this.getLastResultId("any");
    }

    @JsonIgnore
    public LastResultInfo getLastResultExcludingCancelledInfo() {
        return this.getLastResultInfo("anyButCancelled");
    }

    @JsonIgnore
    public Long getLastResultExcludingCancelledId() {
        return this.getLastResultId("anyButCancelled");
    }

    @JsonIgnore
    public Long getActiveTaskId() {
        return this.activeTask == null ? null : (Long)this.activeTask.getId();
    }

    @JsonIgnore
    public URI getActiveTaskUri() {
        return this.activeTask == null ? null : this.activeTask.getUri();
    }

    @JsonProperty
    @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.TaskDeserializer.class)
    @JsonSerialize(using=JsonLdObjectLinkSerializer.NeverEmbedChildLinkSerializer.class)
    Task getActiveTask() {
        assert (this.activeTask == null || this.activeTask.getId() != null) : "activeTask == null -> " + (this.activeTask == null) + "   <->   activeTask.getId() ->" + this.activeTask.getId();
        return this.activeTask;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TestInstanceStatistics)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TestInstanceStatistics that = (TestInstanceStatistics)((Object)o);
        return Objects.equals((Object)this.testInstance, (Object)that.testInstance) && Objects.equals(this.nextRun, that.nextRun) && Objects.equals(this.lastRun, that.lastRun) && Objects.equals(this.lastResultInfoByFilter, that.lastResultInfoByFilter) && Objects.equals((Object)this.activeTask, (Object)that.activeTask) && Objects.equals((Object)this.rrdStatistics, (Object)that.rrdStatistics) && Objects.equals((Object)this.summation, (Object)that.summation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.testInstance, this.nextRun, this.lastRun, this.lastResultInfoByFilter, this.activeTask, this.rrdStatistics, this.summation});
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting TestInstanceStatistics " + this.getTestInstanceId() + " to JSON", (Throwable)e);
            return "Exception converting TestInstanceStatistics " + this.getTestInstanceId() + " to JSON: " + e.getMessage();
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(value={"@context"})
    @JsonLdObjectsMetaData.JsonLdObjectInfo(pathName="rrdStatistics", builderClass=TestInstanceStatisticsBuilder.RrdStatisticsBuilder.class, idType=JsonLdObjectsMetaData.IdType.NONE, uriType=JsonLdObjectsMetaData.UriType.NONE)
    public static class RrdStatistics
    extends BasicLdObject {
        private static final Logger LOG = LoggerFactory.getLogger(RrdStatistics.class);
        private final String metric;
        private final String unit;
        private final double monthTotal;
        private final double weekTotal;
        private final double dayTotal;

        @JsonCreator
        public RrdStatistics(@JsonProperty(value="metric") String metric, @JsonProperty(value="unit") String unit, @JsonProperty(value="monthTotal") double monthTotal, @JsonProperty(value="weekTotal") double weekTotal, @JsonProperty(value="dayTotal") double dayTotal) {
            this.metric = metric;
            this.unit = unit;
            this.monthTotal = monthTotal;
            this.weekTotal = weekTotal;
            this.dayTotal = dayTotal;
        }

        @JsonProperty
        public String getMetric() {
            return this.metric;
        }

        @JsonProperty
        public String getUnit() {
            return this.unit;
        }

        @JsonProperty
        public double getMonthTotal() {
            return this.monthTotal;
        }

        @JsonProperty
        public double getWeekTotal() {
            return this.weekTotal;
        }

        @JsonProperty
        public double getDayTotal() {
            return this.dayTotal;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            RrdStatistics that = (RrdStatistics)((Object)o);
            if (Double.compare(that.dayTotal, this.dayTotal) != 0) {
                return false;
            }
            if (Double.compare(that.monthTotal, this.monthTotal) != 0) {
                return false;
            }
            if (Double.compare(that.weekTotal, this.weekTotal) != 0) {
                return false;
            }
            if (this.metric != null ? !this.metric.equals(that.metric) : that.metric != null) {
                return false;
            }
            return !(this.unit != null ? !this.unit.equals(that.unit) : that.unit != null);
        }

        public int hashCode() {
            int result = this.metric != null ? this.metric.hashCode() : 0;
            result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
            long temp = Double.doubleToLongBits(this.monthTotal);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.weekTotal);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.dayTotal);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public String toString() {
            ObjectMapper mapper = new ObjectMapper();
            try {
                return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
            }
            catch (JsonProcessingException e) {
                LOG.error("Exception converting RrdStatistics to JSON", (Throwable)e);
                return "Exception converting RrdStatistics to JSON: " + e.getMessage();
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(value={"@context"})
    @JsonLdObjectsMetaData.JsonLdObjectInfo(pathName="summation", builderClass=TestInstanceStatisticsBuilder.SummationBuilder.class, idType=JsonLdObjectsMetaData.IdType.NONE, uriType=JsonLdObjectsMetaData.UriType.NONE)
    public static class Summation
    extends BasicLdObject {
        private final String unit;
        private final SummationDetail year;
        private final SummationDetail month;
        private final SummationDetail week;
        private final SummationDetail day;

        @JsonCreator
        public Summation(@JsonProperty(value="unit") String unit, @JsonProperty(value="year") SummationDetail year, @JsonProperty(value="month") SummationDetail month, @JsonProperty(value="week") SummationDetail week, @JsonProperty(value="day") SummationDetail day) {
            this.unit = unit;
            this.year = year;
            this.month = month;
            this.week = week;
            this.day = day;
        }

        @JsonProperty
        public String getUnit() {
            return this.unit;
        }

        @JsonProperty
        public SummationDetail getYear() {
            return this.year;
        }

        @JsonProperty
        public SummationDetail getMonth() {
            return this.month;
        }

        @JsonProperty
        public SummationDetail getWeek() {
            return this.week;
        }

        @JsonProperty
        public SummationDetail getDay() {
            return this.day;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Summation)) {
                return false;
            }
            Summation summation = (Summation)((Object)o);
            return Objects.equals(this.unit, summation.unit) && Objects.equals(this.year, summation.year) && Objects.equals(this.month, summation.month) && Objects.equals(this.week, summation.week) && Objects.equals(this.day, summation.day);
        }

        public int hashCode() {
            return Objects.hash(this.unit, this.year, this.month, this.week, this.day);
        }

        public String toString() {
            ObjectMapper mapper = new ObjectMapper();
            try {
                return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
            }
            catch (JsonProcessingException e) {
                LOG.error("Exception converting " + ((Object)((Object)this)).getClass().getSimpleName() + " to JSON", (Throwable)e);
                return "Exception converting " + ((Object)((Object)this)).getClass().getSimpleName() + " to JSON: " + e.getMessage();
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(value={"@context"})
    @JsonLdObjectsMetaData.JsonLdObjectInfo(pathName="lastResultInfo", builderClass=TestInstanceStatisticsBuilder.LastResultInfoBuilder.class, idType=JsonLdObjectsMetaData.IdType.NONE, uriType=JsonLdObjectsMetaData.UriType.NONE)
    public static class LastResultInfo
    extends BasicLdObject {
        private final String filter;
        private final Timestamp date;
        private final Result result;

        @JsonCreator
        public LastResultInfo(@JsonProperty(value="filter") String filter, @JsonProperty(value="date") Timestamp date, @JsonProperty(value="result") Result result) {
            this.filter = filter;
            this.date = date;
            this.result = result;
            assert (result == null || result.getId() != null);
        }

        @JsonProperty
        public String getFilter() {
            return this.filter;
        }

        @JsonProperty
        @JsonSerialize(using=JsonTimeStampRFC3339Serializer.class)
        @JsonDeserialize(using=JsonTimeStampRFC3339Deserializer.class)
        public Timestamp getDate() {
            return this.date;
        }

        @JsonProperty
        @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.ResultDeserializer.class)
        @JsonSerialize(using=JsonLdObjectLinkSerializer.NeverEmbedChildLinkSerializer.class)
        Result getResult() {
            assert (this.result == null || this.result.getId() != null);
            return this.result;
        }

        @JsonIgnore
        public Long getResultId() {
            return this.result == null ? null : (Long)this.result.getId();
        }

        @JsonIgnore
        public URI getResultUri() {
            return this.result == null ? null : this.result.getUri();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            LastResultInfo that = (LastResultInfo)((Object)o);
            if (this.date != null ? !this.date.equals(that.date) : that.date != null) {
                return false;
            }
            if (this.filter != null ? !this.filter.equals(that.filter) : that.filter != null) {
                return false;
            }
            if (this.result != null) {
                if (that.result == null) {
                    return false;
                }
                if (this.result.getId() == null) {
                    if (that.result.getId() != null) {
                        return false;
                    }
                } else {
                    if (that.result.getId() == null) {
                        return false;
                    }
                    if (!((Long)this.result.getId()).equals(that.result.getId())) {
                        return false;
                    }
                }
            } else if (that.result != null) {
                return false;
            }
            return true;
        }

        public int hashCode() {
            int result1 = this.filter != null ? this.filter.hashCode() : 0;
            result1 = 31 * result1 + (this.date != null ? this.date.hashCode() : 0);
            if (this.result != null && this.result.getId() != null) {
                result1 = 31 * result1 + ((Long)this.result.getId()).hashCode();
            }
            return result1;
        }

        public String toString() {
            ObjectMapper mapper = new ObjectMapper();
            try {
                return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
            }
            catch (JsonProcessingException e) {
                LOG.error("Exception converting LastResultInfo to JSON", (Throwable)e);
                return "Exception converting LastResultInfo to JSON: " + e.getMessage();
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(value={"@context"})
    public static class SummationDetail {
        private final double success;
        private final double warning;
        private final double failure;
        private final double total;
        private final double successPercent;
        private final double nonFailurePercent;

        @JsonCreator
        public SummationDetail(@JsonProperty(value="success") double success, @JsonProperty(value="warning") double warning, @JsonProperty(value="failure") double failure, @JsonProperty(value="total") double total, @JsonProperty(value="successPercent") double successPercent, @JsonProperty(value="nonFailurePercent") double nonFailurePercent) {
            this.success = success;
            this.warning = warning;
            this.failure = failure;
            this.total = total;
            this.successPercent = successPercent;
            this.nonFailurePercent = nonFailurePercent;
        }

        public SummationDetail(double success, double warning, double failure, double total) {
            this.success = success;
            this.warning = warning;
            this.failure = failure;
            this.total = total;
            if (total != 0.0) {
                this.successPercent = success * 100.0 / total;
                this.nonFailurePercent = (total - failure) * 100.0 / total;
            } else {
                this.successPercent = 0.0;
                this.nonFailurePercent = 0.0;
            }
        }

        @JsonProperty
        public double getSuccess() {
            return this.success;
        }

        @JsonProperty
        public double getWarning() {
            return this.warning;
        }

        @JsonProperty
        public double getFailure() {
            return this.failure;
        }

        @JsonProperty
        public double getTotal() {
            return this.total;
        }

        @JsonProperty
        public double getSuccessPercent() {
            return this.successPercent;
        }

        @JsonProperty
        public double getNonFailurePercent() {
            return this.nonFailurePercent;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SummationDetail)) {
                return false;
            }
            SummationDetail that = (SummationDetail)o;
            return Double.compare(that.success, this.success) == 0 && Double.compare(that.warning, this.warning) == 0 && Double.compare(that.failure, this.failure) == 0 && Double.compare(that.total, this.total) == 0 && Double.compare(that.successPercent, this.successPercent) == 0 && Double.compare(that.nonFailurePercent, this.nonFailurePercent) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.success, this.warning, this.failure, this.total, this.successPercent, this.nonFailurePercent);
        }

        public String toString() {
            ObjectMapper mapper = new ObjectMapper();
            try {
                return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
            }
            catch (JsonProcessingException e) {
                LOG.error("Exception converting " + this.getClass().getSimpleName() + " to JSON", (Throwable)e);
                return "Exception converting " + this.getClass().getSimpleName() + " to JSON: " + e.getMessage();
            }
        }
    }
}

