/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.VersionNumbers;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"@context"})
public class VersionInfo {
    private static final Logger LOG = LoggerFactory.getLogger(VersionInfo.class);
    private final String jFed;
    private final String java;
    private final String javaVendor;
    private final String javaSpec;
    private final String os;
    private final String arch;

    @JsonCreator
    VersionInfo(@JsonProperty(value="jFed") String jFed, @JsonProperty(value="java") String java, @JsonProperty(value="javaVendor") String javaVendor, @JsonProperty(value="javaSpec") String javaSpec, @JsonProperty(value="os") String os, @JsonProperty(value="arch") String arch) {
        this.jFed = jFed;
        this.java = java;
        this.javaVendor = javaVendor;
        this.javaSpec = javaSpec;
        this.os = os;
        this.arch = arch;
    }

    @JsonProperty
    public String getjFed() {
        return this.jFed;
    }

    @JsonIgnore
    public VersionNumbers getjFedVersionNumbers() {
        if (this.jFed == null) {
            return null;
        }
        int firstSpace = this.jFed.indexOf(32);
        String jFedFirstPart = firstSpace < 0 ? this.jFed : this.jFed.substring(0, firstSpace);
        return new VersionNumbers(jFedFirstPart);
    }

    @JsonProperty
    public String getJava() {
        return this.java;
    }

    @JsonProperty
    public String getJavaVendor() {
        return this.javaVendor;
    }

    @JsonProperty
    public String getJavaSpec() {
        return this.javaSpec;
    }

    @JsonProperty
    public String getOs() {
        return this.os;
    }

    @JsonProperty
    public String getArch() {
        return this.arch;
    }

    @JsonProperty(value="@type")
    public String getClassName() {
        return this.getClass().getSimpleName();
    }

    @JsonProperty(value="@type")
    private void setClassName(String className) {
        if (!this.getClass().getSimpleName().equals(className)) {
            throw new IllegalArgumentException("@type must be " + this.getClass().getSimpleName());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionInfo that = (VersionInfo)o;
        if (this.arch != null ? !this.arch.equals(that.arch) : that.arch != null) {
            return false;
        }
        if (this.jFed != null ? !this.jFed.equals(that.jFed) : that.jFed != null) {
            return false;
        }
        if (this.java != null ? !this.java.equals(that.java) : that.java != null) {
            return false;
        }
        if (this.javaVendor != null ? !this.javaVendor.equals(that.javaVendor) : that.javaVendor != null) {
            return false;
        }
        if (this.javaSpec != null ? !this.javaSpec.equals(that.javaSpec) : that.javaSpec != null) {
            return false;
        }
        return !(this.os != null ? !this.os.equals(that.os) : that.os != null);
    }

    public int hashCode() {
        int result = this.jFed != null ? this.jFed.hashCode() : 0;
        result = 31 * result + (this.java != null ? this.java.hashCode() : 0);
        result = 31 * result + (this.javaVendor != null ? this.javaVendor.hashCode() : 0);
        result = 31 * result + (this.javaSpec != null ? this.javaSpec.hashCode() : 0);
        result = 31 * result + (this.os != null ? this.os.hashCode() : 0);
        result = 31 * result + (this.arch != null ? this.arch.hashCode() : 0);
        return result;
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting VersionInfo to JSON", (Throwable)e);
            return "Exception converting VersionInfo to JSON: " + e.getMessage();
        }
    }
}

