/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.git;

import be.iminds.ilabt.jfed.git.GitAuthPreferences;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SingleUserPassGitAuthPreferences
implements GitAuthPreferences {
    @Nonnull
    private final String username;
    @Nullable
    private final String password;

    public SingleUserPassGitAuthPreferences(@Nonnull String username, @Nullable String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    @Nonnull
    public List<GitAuthPreferences.GitAuthMethod> getGitAuthMethodAvailable(String repoUrl) {
        return Collections.singletonList(GitAuthPreferences.GitAuthMethod.USER_PASS);
    }

    @Override
    public boolean hasAuth(String repoUrl) {
        return GitAuthPreferences.getRepoUrlGitAuthMethod(repoUrl).contains((Object)GitAuthPreferences.GitAuthMethod.USER_PASS);
    }

    @Override
    @Nullable
    public GitAuthPreferences.GitAuth getGitAuth(String repoUrl, GitAuthPreferences.GitAuthMethod ... allowedMethods) {
        for (GitAuthPreferences.GitAuthMethod allowedMethod : allowedMethods) {
            if (allowedMethod != GitAuthPreferences.GitAuthMethod.USER_PASS) continue;
            return this.getGitAuthUserPass(repoUrl);
        }
        return null;
    }

    @Override
    @Nullable
    public GitAuthPreferences.GitAuthSsh getGitAuthSsh(String repoUrl) {
        return null;
    }

    @Override
    @Nullable
    public GitAuthPreferences.GitAuthUserPass getGitAuthUserPass(String repoUrl) {
        return new GitAuthPreferences.GitAuthUserPass(repoUrl, this.username, this.password);
    }
}

