/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api;

import be.iminds.ilabt.jfed.lowlevel.api.AbstractGeniAggregateManager;
import be.iminds.ilabt.jfed.lowlevel.api.AggregateManager2;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.AggregateManagerWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethod;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethodParameter;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethodParameterType;
import be.iminds.ilabt.jfed.lowlevel.lib.BadReplyGeniException;
import be.iminds.ilabt.jfed.lowlevel.lib.RetrySettings;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtoGeniAMExtensions
extends AbstractGeniAggregateManager {
    private static final Logger LOG = LoggerFactory.getLogger(ProtoGeniAMExtensions.class);

    public ProtoGeniAMExtensions(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull RetrySettings retrySettings, @Nonnull JFedPreferences jFedPreferences) {
        super(logger, retrySettings, new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, 2), jFedPreferences);
    }

    public ProtoGeniAMExtensions(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull JFedPreferences jFedPreferences) {
        this(logger, jFedPreferences.getRetrySettings(), jFedPreferences);
    }

    public static String getApiName() {
        return "ProtoGeni Aggregate Manager API Extensions";
    }

    @Override
    @Nonnull
    public String getName() {
        return ProtoGeniAMExtensions.getApiName();
    }

    @Override
    @Nonnull
    public AbstractGeniAggregateManager.AggregateManagerReply<? extends AbstractGeniAggregateManager.AbstractVersionInfo> getVersion(@Nonnull SfaConnection con) throws JFedException {
        throw new RuntimeException("not implemented here");
    }

    @ApiMethod(order=1, hint="ListImages call")
    @Nonnull
    public AbstractGeniAggregateManager.AggregateManagerReply<List<ImageInfo>> listImages(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", hint="mandatory list of credentials. this must include a valid user credential.") @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="userUrn", hint="user to list images for", parameterType=ApiMethodParameterType.USER_URN) @Nonnull String userUrn, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = ProtoGeniAMExtensions.makeMethodParameters("credentialList", credentialList, "userUrn", userUrn, "extraOptions", extraOptions);
        Objects.requireNonNull(credentialList, "Illegal argument: credentialList is not allowed to be null");
        Objects.requireNonNull(userUrn, "Illegal argument: userUrn is not allowed to be null");
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add(userUrn);
        args.add(AggregateManager2.createCredentialsList(credentialList));
        args.add(ProtoGeniAMExtensions.createOptionsMap(extraOptions));
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, "listImages", "ListImages", args, resultValueObject -> {
            List<Map> v = ProtoGeniAMExtensions.apiSpecifiesListOfT(Map.class, resultValueObject);
            ArrayList<ImageInfo> listImageResult = new ArrayList<ImageInfo>();
            for (Map ht : v) {
                Map<String, String> htss = ProtoGeniAMExtensions.apiSpecifiesMapStringToString(ht);
                ImageInfo imageInfo = new ImageInfo(htss);
                listImageResult.add(imageInfo);
            }
            return listImageResult;
        });
    }

    @ApiMethod(order=2, hint="DeleteImage call")
    @Nonnull
    public AbstractGeniAggregateManager.AggregateManagerReply<Boolean> deleteImage(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", hint="mandatory list of credentials. this must include a valid user credential.") @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="imageUrn", hint="image URN to delete", parameterType=ApiMethodParameterType.URN) @Nonnull String imageUrn, @ApiMethodParameter(name="creatorUrn", required=false, hint="Optional: creator user URN, needed if image not owned by calling user", parameterType=ApiMethodParameterType.USER_URN) @Nullable String creatorUrn, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = ProtoGeniAMExtensions.makeMethodParameters("credentialList", credentialList, "imageUrn", imageUrn, "creatorUrn", creatorUrn, "extraOptions", extraOptions);
        Objects.requireNonNull(credentialList, "Illegal argument: credentialList is not allowed to be null");
        Objects.requireNonNull(imageUrn, "Illegal argument: imageUrn is not allowed to be null");
        List<String> credentialsList = AggregateManager2.createCredentialsList(credentialList);
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (creatorUrn != null) {
            options.put("creator_urn", creatorUrn);
        }
        if (extraOptions != null) {
            options.putAll(extraOptions);
        }
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add(imageUrn);
        args.add(credentialsList);
        args.add(options);
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, "deleteImage", "DeleteImage", args, BOOLEAN_REPLY_CONVERTER);
    }

    @ApiMethod(order=3, hint="CreateImage call")
    @Nonnull
    public AbstractGeniAggregateManager.AggregateManagerReply<ImageInfo> createImage(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", hint="mandatory list of credentials.") @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="sliceUrn", hint="slice URN", parameterType=ApiMethodParameterType.SLICE_URN) @Nonnull String sliceUrn, @ApiMethodParameter(name="imageName", hint="image name", parameterType=ApiMethodParameterType.STRING) @Nonnull String imageName, @ApiMethodParameter(name="sliverUrn", hint="sliver URN (= URN of node)", parameterType=ApiMethodParameterType.URN) @Nonnull String sliverUrn, @ApiMethodParameter(name="global", required=false, hint="optional: global flag (if global is true, the image is public, otherwise, it is private)", parameterType=ApiMethodParameterType.BOOLEAN) @Nullable Boolean global, @ApiMethodParameter(name="updatePrepare", required=false, hint="optional: update_prepare flag (if true, the prepare -M option is used for image creation, which will cause system users to be saved in the image, default is false)", parameterType=ApiMethodParameterType.BOOLEAN, guiDefault="false") @Nullable Boolean updatePrepare, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = ProtoGeniAMExtensions.makeMethodParameters("credentialList", credentialList, "sliceUrn", sliceUrn, "imageName", imageName, "sliverUrn", sliverUrn, "global", global, "updatePrepare", updatePrepare, "extraOptions", extraOptions);
        Objects.requireNonNull(credentialList, "Illegal argument: credentialList is not allowed to be null");
        Objects.requireNonNull(sliceUrn, "Illegal argument: sliceUrn is not allowed to be null");
        Objects.requireNonNull(imageName, "Illegal argument: imageName is not allowed to be null");
        Objects.requireNonNull(sliverUrn, "Illegal argument: sliverUrn is not allowed to be null");
        List<String> credentialsList = AggregateManager2.createCredentialsList(credentialList);
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (global != null) {
            options.put("global", global);
        }
        if (updatePrepare != null) {
            options.put("update_prepare", updatePrepare);
        }
        if (extraOptions != null) {
            options.putAll(extraOptions);
        }
        ArrayList<Object> args = new ArrayList<Object>(5);
        args.add(sliceUrn);
        args.add(imageName);
        args.add(sliverUrn);
        args.add(credentialsList);
        args.add(options);
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, "createImage", "CreateImage", args, resultValueObject -> {
            List<String> v = ProtoGeniAMExtensions.apiSpecifiesListOfString(resultValueObject);
            if (v.size() < 2) {
                throw new BadReplyGeniException("returned array does not have exactly 2 items: " + v);
            }
            if (v.size() > 2) {
                LOG.warn("returned array of CreateImage does not have exactly 2 items. It has {}. Will try to continue anyway.", (Object)v.size());
            }
            return new ImageInfo(v.get(0), v.get(1));
        });
    }

    public static class ImageInfo
    implements AggregateManagerWrapper.ImageInfo {
        private final String urn;
        private final String url;

        public ImageInfo(String urn, String url) {
            this.urn = urn;
            this.url = url;
        }

        public ImageInfo(Map<String, String> ht) {
            this.urn = ht.get("urn");
            this.url = ht.get("url");
        }

        @Override
        public String getUrn() {
            return this.urn;
        }

        @Override
        public String getUrl() {
            return this.url;
        }

        public String toString() {
            return "ImageInfo{urn='" + this.urn + "', url='" + this.url + "'}";
        }
    }
}

