/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api.user_spec;

import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UserSpec {
    @Nullable
    protected final String urn;
    @Nonnull
    protected final List<String> sshKey;

    public UserSpec(@Nullable String urn, @Nullable Collection<String> sshKeys) {
        if (urn != null && !GeniUrn.valid((String)urn)) {
            throw new IllegalArgumentException("not a valid URN");
        }
        this.urn = urn;
        this.sshKey = sshKeys != null ? new ArrayList<String>(sshKeys) : Collections.emptyList();
        this.validateSshKeys();
    }

    public UserSpec(@Nullable GeniUrn urn, @Nullable Collection<String> sshKeys) {
        this.urn = urn == null ? null : urn.toString();
        this.sshKey = sshKeys != null ? new ArrayList<String>(sshKeys) : Collections.emptyList();
        this.validateSshKeys();
    }

    public UserSpec(@Nullable String urn, @Nullable String sshKey) {
        if (urn != null && !GeniUrn.valid((String)urn)) {
            throw new IllegalArgumentException("not a valid URN");
        }
        this.urn = urn;
        this.sshKey = new ArrayList<String>();
        if (sshKey != null) {
            this.sshKey.add(sshKey);
        }
        this.validateSshKeys();
    }

    public UserSpec(@Nullable GeniUrn urn, @Nullable String sshKey) {
        this.urn = urn == null ? null : urn.toString();
        this.sshKey = new ArrayList<String>();
        if (sshKey != null) {
            this.sshKey.add(sshKey);
        }
        this.validateSshKeys();
    }

    private void validateSshKeys() {
        for (String k : this.sshKey) {
            if (k.startsWith("ssh-")) continue;
            throw new RuntimeException("Problem with key, doesn't start with \"ssh-\": \"" + k + "\"");
        }
    }

    public UserSpec(UserSpec orig) {
        if (orig.urn != null && !GeniUrn.valid((String)orig.urn)) {
            throw new IllegalArgumentException("not a valid URN");
        }
        this.urn = orig.urn;
        this.sshKey = new ArrayList<String>(orig.sshKey);
        this.validateSshKeys();
    }

    public UserSpec(String urn) {
        this(urn, new ArrayList<String>());
        if (urn != null && !GeniUrn.valid((String)urn)) {
            throw new IllegalArgumentException("not a valid URN");
        }
    }

    @Nullable
    public String getUrn() {
        return this.urn;
    }

    @Nonnull
    public List<String> getSshKey() {
        return this.sshKey;
    }

    public String toString() {
        return "UserSpec{urn='" + this.urn + "', sshKey=" + this.sshKey + "}";
    }

    public Map getAsMap() {
        HashMap<String, Object> res = new HashMap<String, Object>();
        assert (this.urn != null);
        res.put("urn", this.urn);
        res.put("keys", this.sshKey);
        return res;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserSpec userSpec = (UserSpec)o;
        if (!Objects.equals(this.sshKey, userSpec.sshKey)) {
            return false;
        }
        return !(this.urn != null ? !Objects.equals(this.urn, userSpec.urn) : userSpec.urn != null);
    }

    public int hashCode() {
        int result = this.urn != null ? this.urn.hashCode() : 0;
        result = 31 * result + this.sshKey.hashCode();
        return result;
    }
}

