/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.credential;

import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.credential.AbacCredential;
import be.iminds.ilabt.jfed.lowlevel.credential.SfaCredential;
import be.iminds.ilabt.jfed.lowlevel.lib.BadReplyGeniException;
import be.iminds.ilabt.jfed.lowlevel.lib.CredentialException;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.util.library.JFedTrustStore;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import java.io.IOException;
import java.io.StringReader;
import java.security.Key;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.apache.xml.security.Init;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.keys.storage.StorageResolverSpi;
import org.apache.xml.security.keys.storage.implementations.KeyStoreResolver;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.utils.ElementProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class AnyCredential {
    private static final Logger LOG = LoggerFactory.getLogger(AnyCredential.class);
    protected String name;
    @Nonnull
    protected final String credentialXml;
    protected Document xmlDoc;
    protected final String type;
    protected final String version;

    protected AnyCredential(String name, @Nonnull String credentialXml, String type, String version) {
        Objects.requireNonNull(credentialXml, "AnyCredential credentialXml may not be null");
        this.name = name;
        this.credentialXml = credentialXml;
        this.type = type;
        this.version = version;
    }

    public static AnyCredential createSfa2(String name, String credentialXml) throws CredentialException {
        return new SfaCredential(name, credentialXml, "geni_sfa", "2");
    }

    public static AnyCredential createAutoDetect(String name, String credentialXml) throws CredentialException {
        String type = null;
        String version = null;
        XMLStreamReader streamReader = null;
        try {
            XMLInputFactory xif = XMLInputFactory.newFactory();
            StreamSource xml = new StreamSource(new StringReader(credentialXml));
            streamReader = xif.createXMLStreamReader(xml);
            boolean withinType = false;
            boolean withinAbac = false;
            boolean withinAbacVersion = false;
            block14: while (streamReader.hasNext()) {
                streamReader.next();
                switch (streamReader.getEventType()) {
                    case 1: {
                        if (Objects.equals(streamReader.getName().getLocalPart(), "type")) {
                            withinType = true;
                        }
                        if (Objects.equals(streamReader.getName().getLocalPart(), "abac")) {
                            withinAbac = true;
                        }
                        if (!withinAbac || !Objects.equals(streamReader.getName().getLocalPart(), "version")) continue block14;
                        withinAbacVersion = true;
                        continue block14;
                    }
                    case 2: {
                        if (Objects.equals(streamReader.getName().getLocalPart(), "abac")) {
                            withinType = false;
                        }
                        if (Objects.equals(streamReader.getName().getLocalPart(), "type")) {
                            withinAbac = false;
                        }
                        if (!Objects.equals(streamReader.getName().getLocalPart(), "version")) continue block14;
                        withinAbacVersion = false;
                        continue block14;
                    }
                    case 4: {
                        String typeText;
                        if (withinType && (typeText = streamReader.getText()) != null) {
                            if (Objects.equals(typeText.trim().toLowerCase(), "abac")) {
                                type = "geni_abac";
                            }
                            if (typeText.trim().toLowerCase().equals("sfa") || typeText.trim().toLowerCase().equals("privilege")) {
                                type = "sfa";
                                version = "3";
                            }
                        }
                        if (!withinAbacVersion || (typeText = streamReader.getText()) == null) continue block14;
                        type = "geni_abac";
                        version = "1";
                        continue block14;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new CredentialException("Exception while parsing credential XML", e);
        }
        finally {
            if (streamReader != null) {
                try {
                    streamReader.close();
                }
                catch (XMLStreamException e) {
                    LOG.error("Exception closing streamReader is ignored", (Throwable)e);
                }
            }
        }
        if (type == null || version == null) {
            throw new CredentialException("Could not auto detect credential type.");
        }
        if (type.equals("geni_abac") || type.equals("geni_abac")) {
            return new AbacCredential(name, credentialXml, type, version);
        }
        if (type.equals("sfa") || type.equals("geni_sfa")) {
            return new SfaCredential(name, credentialXml, type, version);
        }
        throw new CredentialException("Unsupported credential type: \"" + type + "\" (version=\"" + version + "\")");
    }

    public static AnyCredential create(String name, String credentialXml, String type, String version) throws CredentialException {
        if (type.equalsIgnoreCase("sfa") || type.equalsIgnoreCase("geni_sfa")) {
            return new SfaCredential(name, credentialXml, type, version);
        }
        if (type.equalsIgnoreCase("abac") || type.equalsIgnoreCase("geni_abac")) {
            return new AbacCredential(name, credentialXml, type, version);
        }
        return new AnyCredential(name, credentialXml, type, version);
    }

    public static AnyCredential createFromV3Map(String credName, Map ht) throws BadReplyGeniException, CredentialException {
        Object geniTypeO = ht.get("geni_type");
        Object geniVersionO = ht.get("geni_version");
        Object genivalueO = ht.get("geni_value");
        if (geniTypeO == null || geniVersionO == null || genivalueO == null) {
            throw new BadReplyGeniException("The API specified a List of Maps sepcifying credentials. These must contain the keys geni_type, geni_version and geni_value. At least one of these is missing. Map content: " + ht);
        }
        if (!(geniTypeO instanceof String)) {
            throw new BadReplyGeniException("The API specified a credential, but the geni_type field of the Map is of type " + geniTypeO.getClass().getName() + " instead of String. value=" + geniTypeO);
        }
        if (!(geniVersionO instanceof Integer) && !(geniVersionO instanceof String)) {
            throw new BadReplyGeniException("The API specified a credential, but the geni_version field of the Map is of type " + geniVersionO.getClass().getName() + " instead of String with Integer. value=" + geniVersionO);
        }
        if (!(genivalueO instanceof String)) {
            throw new BadReplyGeniException("The API specified a credential, but the geni_value field of the Map is of type " + genivalueO.getClass().getName() + " instead of String. value=" + genivalueO);
        }
        return AnyCredential.create(credName, (String)genivalueO, (String)geniTypeO, geniVersionO.toString());
    }

    @Nonnull
    public static AnyCredential toSingleCredential(@Nonnull List<AnyCredential> credentialList) throws JFedException {
        if (credentialList.isEmpty()) {
            throw new JFedException("Requested a single credential, but none were provided");
        }
        if (credentialList.size() > 1) {
            LOG.warn("requested toSingleCredential, but {} credentials in list", (Object)credentialList.size());
        }
        return credentialList.get(0);
    }

    public static Date getExpireTime(List<AnyCredential> credentials) {
        for (AnyCredential cred : credentials) {
            SfaCredential sfaCred;
            if (!(cred instanceof SfaCredential) || (sfaCred = (SfaCredential)cred).getExpiresDate() == null) continue;
            return sfaCred.getExpiresDate();
        }
        return null;
    }

    @Nonnull
    public String getCredentialXml() {
        return this.credentialXml;
    }

    public String getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public Map getGeniV3Map() {
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("geni_type", this.type);
        res.put("geni_version", this.version);
        res.put("geni_value", this.credentialXml);
        return res;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getExpires() {
        return null;
    }

    public Date getExpiresDate() {
        return null;
    }

    public Boolean isTargetSubAuthority() {
        return null;
    }

    public String toString() {
        return this.credentialXml;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnyCredential that = (AnyCredential)o;
        if (!Objects.equals(this.credentialXml, that.credentialXml)) {
            return false;
        }
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.credentialXml.hashCode();
        return result;
    }

    public List<AnyCredential> toCredentialList() {
        return Collections.singletonList(this);
    }

    protected void initDoc() throws CredentialException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            this.xmlDoc = dbf.newDocumentBuilder().parse(new InputSource(new StringReader(this.credentialXml)));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new CredentialException("Error parsing credential XML: " + e.getMessage(), e);
        }
        Element rootEl = this.xmlDoc.getDocumentElement();
        NodeList credentialNl = rootEl.getElementsByTagName("credential");
        LOG.trace("Need to mark " + credentialNl.getLength() + " <credential> xml:id attributes as xml IDs");
        for (int j = 0; j < credentialNl.getLength(); ++j) {
            Node n = credentialNl.item(j);
            if (n.getNodeType() != 1) continue;
            Element credentialEl = (Element)n;
            NamedNodeMap l = credentialEl.getAttributes();
            for (int i = 0; i < l.getLength(); ++i) {
                Attr a = (Attr)l.item(i);
                if (Objects.equals(a.getName(), "xml:id")) {
                    LOG.trace("Marking <credential> Attribute as id: " + a);
                    credentialEl.setIdAttributeNode(a, true);
                    continue;
                }
                LOG.trace("<credential> Attribute is not id: '" + a.getNamespaceURI() + "' : '" + a.getName() + "' -> " + a);
            }
        }
    }

    public boolean check(TestbedInfoSource testbedInfoSource) throws CredentialException {
        JFedTrustStore jFedTrustStore = new JFedTrustStore();
        return this.check(jFedTrustStore.getTrustStore());
    }

    public boolean check(KeyStore trustStore) throws CredentialException {
        if (this.xmlDoc == null) {
            this.initDoc();
        }
        assert (this.xmlDoc != null);
        NodeList signatureNodeList = this.xmlDoc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (signatureNodeList.getLength() == 0) {
            throw new CredentialException("Cannot find any Signature element: not a valid credential.");
        }
        LOG.debug("There are " + signatureNodeList.getLength() + " <signature> elements in <Signature> that need to be checked.");
        try {
            for (int i = 0; i < signatureNodeList.getLength(); ++i) {
                Element sigElement = (Element)signatureNodeList.item(i);
                LOG.debug("Checking <signature> with apache santurio library");
                Init.init();
                ElementProxy.setDefaultPrefix((String)"http://www.w3.org/2000/09/xmldsig#", (String)"");
                XMLSignature signature = new XMLSignature(sigElement, null);
                KeyInfo ki = signature.getKeyInfo();
                ki.addStorageResolver(new StorageResolver((StorageResolverSpi)new KeyStoreResolver(trustStore)));
                X509Certificate cert = signature.getKeyInfo().getX509Certificate();
                if (cert != null) {
                    boolean check = signature.checkSignatureValue(cert);
                    LOG.debug("X509Certificate Check: " + check);
                    if (check) continue;
                    return false;
                }
                PublicKey pk = signature.getKeyInfo().getPublicKey();
                if (pk != null) {
                    boolean check = signature.checkSignatureValue((Key)pk);
                    LOG.debug("PublicKey Check: " + check);
                    if (check) continue;
                    return false;
                }
                LOG.debug("Could not find Certificate or PublicKey");
                return false;
            }
        }
        catch (Exception e) {
            LOG.error("Error during checkSignedCredential", (Throwable)e);
            return false;
        }
        return true;
    }

    public List<X509Certificate> getSignerCertificates() throws CredentialException {
        ArrayList<X509Certificate> res = new ArrayList<X509Certificate>();
        if (this.xmlDoc == null) {
            this.initDoc();
        }
        assert (this.xmlDoc != null);
        NodeList signatureNodeList = this.xmlDoc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (signatureNodeList.getLength() == 0) {
            throw new CredentialException("Cannot find any Signature element: not a valid credential.");
        }
        LOG.debug("There are " + signatureNodeList.getLength() + " <signature> elements in <Signature>");
        try {
            for (int i = 0; i < signatureNodeList.getLength(); ++i) {
                X509Certificate x509Certificate;
                Element xdElement;
                NodeList cert;
                Element nlElement;
                NodeList xd;
                Element sigElement = (Element)signatureNodeList.item(i);
                NodeList nl = sigElement.getElementsByTagName("KeyInfo");
                if (nl == null || nl.getLength() == 0 || !(nl.item(0) instanceof Element) || (xd = (nlElement = (Element)nl.item(0)).getElementsByTagName("X509Data")) == null || xd.getLength() == 0 || !(xd.item(0) instanceof Element) || (cert = (xdElement = (Element)xd.item(0)).getElementsByTagName("X509Certificate")) == null || cert.getLength() == 0 || !(cert.item(0) instanceof Element)) continue;
                Element certElement = (Element)cert.item(0);
                Object certPem = certElement.getTextContent().trim();
                if (!((String)certPem).startsWith("-----BEGIN CERTIFICATE-----")) {
                    certPem = "-----BEGIN CERTIFICATE-----\n" + (String)certPem + "\n-----END CERTIFICATE-----\n";
                }
                if ((x509Certificate = KeyUtil.pemToX509Certificate((String)certPem)) == null) continue;
                res.add(x509Certificate);
            }
        }
        catch (Exception e) {
            LOG.error("Error searching signer certificates", (Throwable)e);
        }
        return res;
    }

    public boolean isSpeaksFor() {
        return false;
    }
}

