/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.lib;

import be.iminds.ilabt.jfed.lowlevel.connection.GeniResponseCode;
import be.iminds.ilabt.jfed.lowlevel.connection.UnknownResponseCodeException;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum SCSResponseCode implements GeniResponseCode
{
    SCSRESPONSE_SUCCESS(0, "Success"),
    SCSRESPONSE_UNKNOWN1(1, "Unknown error code"),
    SCSRESPONSE_UNKNOWN2(2, "Unknown error code"),
    SCSRESPONSE_UNKNOWN3(3, "Unknown error code"),
    SCSRESPONSE_UNKNOWN4(4, "Unknown error code"),
    SCSRESPONSE_UNKNOWN5(5, "Unknown error code"),
    SCSRESPONSE_UNKNOWN6(6, "Unknown error code"),
    SCSRESPONSE_UNKNOWN7(7, "Unknown error code"),
    SCSRESPONSE_UNKNOWN8(8, "Unknown error code"),
    SCSRESPONSE_UNKNOWN9(9, "Unknown error code"),
    SCSRESPONSE_UNKNOWN10(10, "Unknown error code"),
    SCSRESPONSE_UNKNOWN11(11, "Unknown error code"),
    SCSRESPONSE_UNKNOWN12(12, "Unknown error code"),
    SCSRESPONSE_UNKNOWN13(13, "Unknown error code"),
    SCSRESPONSE_UNKNOWN14(14, "Unknown error code"),
    SCSRESPONSE_UNKNOWN15(15, "Unknown error code"),
    SCSRESPONSE_UNKNOWN16(16, "Unknown error code"),
    SCSRESPONSE_UNKNOWN17(17, "Unknown error code"),
    SCSRESPONSE_UNKNOWN24(24, "Unknown error code"),
    SERVERBUSY(-32001, "Server is (temporarily) too busy; try again later"),
    INTERNAL_NONGENI_ERROR(50, "Internal error in client application"),
    SERVER_REPLY_ERROR(51, "The client could not parse the server's reply. Either the server sent something strange, or this is a bug in the client");

    private final int code;
    private final String description;
    private static final Map<Integer, SCSResponseCode> RESPONSE_CODE_BY_CODE;

    private SCSResponseCode(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public boolean isSuccess() {
        return this.code == 0;
    }

    public boolean isBusy() {
        return this.code == 14 || this.code == -32001;
    }

    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public static SCSResponseCode getByCode(int c) throws UnknownResponseCodeException {
        SCSResponseCode res = RESPONSE_CODE_BY_CODE.get(c);
        if (res == null) {
            throw new UnknownResponseCodeException("GeniAMResponseCode " + c + " does not exists");
        }
        return res;
    }

    public String toString() {
        return "GeniAMResponseCode{code=" + this.code + ", description='" + this.description + "'}";
    }

    static {
        RESPONSE_CODE_BY_CODE = Arrays.stream(SCSResponseCode.values()).collect(Collectors.toMap(SCSResponseCode::getCode, Function.identity()));
    }
}

