/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.ssh_key_info;

import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.PuTTYFilesKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.SshFilesKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.putty.PpkHelper;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.putty.PuTTYPrivateKeyFile;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.util.library.JFedUtils;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import be.iminds.ilabt.jfed.util.tmp_file_helpers.PermanentFile;
import be.iminds.ilabt.jfed.util.tmp_file_helpers.TmpContentFile;
import be.iminds.ilabt.jfed.util.tmp_file_helpers.TmpFile;
import java.io.File;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeniUserSshKeyInfo
implements SshFilesKeyInfo,
PuTTYFilesKeyInfo {
    private static final Logger LOG = LoggerFactory.getLogger(GeniUserSshKeyInfo.class);
    @Nonnull
    protected final GeniUser geniUser;

    GeniUserSshKeyInfo(@Nonnull GeniUser geniUser) {
        this.geniUser = geniUser;
    }

    @Override
    public boolean canReturnLockedPrivateKeyFile() {
        return true;
    }

    @Override
    public TmpFile getPrivateKeyFile() {
        if (this.geniUser.getPrivateKeyFile() != null) {
            return new PermanentFile(this.geniUser.getPrivateKeyFile());
        }
        LOG.debug("geniUser has no privateKeyFile. geniUser class: " + this.geniUser.getClass().getName());
        return this.getUnencryptedPrivateKeyFile();
    }

    @Override
    public TmpFile getUnencryptedPrivateKeyFile() {
        File tmpDir = new File(JFedUtils.getUserDataDirectoryFile(), "tmp");
        if (!tmpDir.exists()) {
            tmpDir.mkdir();
        }
        String pemKey = new String(KeyUtil.privateKeyToAnyPem((PrivateKey)this.geniUser.getPrivateKey()));
        return new TmpContentFile("sshKeyUsrUE", ".pem", pemKey, true);
    }

    public boolean hasUnencryptedPrivateKey() {
        return true;
    }

    public boolean isLocked() {
        return false;
    }

    public boolean unlock(char[] password) {
        throw new IllegalStateException("Cannot unlock GeniUserSshKeyInfo, as this is always unlocked!");
    }

    @Nonnull
    public PublicKey getPublicKey() {
        return this.geniUser.getPublicKey();
    }

    public PrivateKey getPrivateKey() {
        return this.geniUser.getPrivateKey();
    }

    @Nonnull
    public GeniUser getGeniUser() {
        return this.geniUser;
    }

    @Override
    public boolean canReturnLockedPuttyKeyFile() {
        return true;
    }

    @Override
    public TmpFile getPuttyKeyFile() {
        String ppkContent = PpkHelper.getUserEncryptedPPK(this.geniUser);
        if (ppkContent != null) {
            assert (ppkContent.contains("aes256-cbc"));
            TmpContentFile lockedPuttyFile = new TmpContentFile("sshKeyUsrE", ".ppk", ppkContent);
            LOG.debug("UserSshKeyInfo is using encrypted PPK");
            return lockedPuttyFile;
        }
        LOG.debug("UserSshKeyInfo falling back to unencrypted PPK");
        return this.getUnlockedPuttyKeyFile();
    }

    @Override
    public TmpFile getUnlockedPuttyKeyFile() {
        File tmpDir = new File(JFedUtils.getUserDataDirectoryFile(), "tmp");
        if (!tmpDir.exists()) {
            tmpDir.mkdir();
        }
        String ppkContent = PuTTYPrivateKeyFile.createContent("jFed-tmp-ppk", (RSAPublicKey)this.geniUser.getPublicKey(), (RSAPrivateCrtKey)this.geniUser.getPrivateKey(), null);
        return new TmpContentFile("sskKeyUsrE", ".ppk", ppkContent);
    }

    @Nullable
    public String getComment() {
        return this.geniUser.getUserUrn().getEncodedResourceName() + "@" + this.geniUser.getUserUrn().getEncodedTopLevelAuthority();
    }
}

