/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.ssh_key_info.putty;

import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.putty.PuTTYPrivateKeyFile;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PpkHelper {
    private static final Logger LOG = LoggerFactory.getLogger(PpkHelper.class);
    private static final Map<String, String> userUrnToEncryptedPPK = new HashMap<String, String>();

    public static void makePpkIfNeeded(GeniUser user, String pass) {
        if (pass == null) {
            LOG.debug("No pass, so not storing encrypted PPK for user " + user.getUserUrnString());
            return;
        }
        try {
            if (!userUrnToEncryptedPPK.containsKey(user.getUserUrnString())) {
                String comment = "PPK-generated-from-PEM-by-jFed";
                RSAPublicKey publicKey = (RSAPublicKey)user.getPublicKey();
                RSAPrivateCrtKey privateKey = (RSAPrivateCrtKey)user.getPrivateKey();
                String ppkContent = PuTTYPrivateKeyFile.createContent(comment, publicKey, privateKey, pass);
                assert (ppkContent.contains("aes256-cbc"));
                userUrnToEncryptedPPK.put(user.getUserUrnString(), ppkContent);
                LOG.debug("Now storing encrypted PPK for user " + user.getUserUrnString());
            }
        }
        catch (Exception e) {
            LOG.error("Error in makePpkIfNeeded. Can safely be ignored. message: " + e.getMessage(), (Throwable)e);
        }
    }

    public static String getUserEncryptedPPK(GeniUser user) {
        return userUrnToEncryptedPPK.get(user.getUserUrnString());
    }
}

