/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.testbed_info;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.util.library.JFedTrustStore;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ServerTrustInfo
implements JFedTrustStore.TrustInfo {
    private final Server server;
    public static JFedTrustStore.TrustInfo emptyTrustInfo = new JFedTrustStore.TrustInfo(){

        @Nullable
        public String getCertificateChain() {
            return null;
        }

        @Nullable
        public String getAllowedCertificateAlias() {
            return null;
        }
    };

    public ServerTrustInfo(Server server) {
        this.server = server;
    }

    @Nullable
    public String getCertificateChain() {
        return this.server.getCertificateChain();
    }

    @Nullable
    public String getAllowedCertificateAlias() {
        return this.server.getAllowedCertificateAlias();
    }

    @Nonnull
    public static JFedTrustStore.TrustInfo convert(@Nullable Server server) {
        if (server == null) {
            return emptyTrustInfo;
        }
        return new ServerTrustInfo(server);
    }

    @Nonnull
    public static Collection<JFedTrustStore.TrustInfo> convert(@Nullable Collection<Server> servers) {
        if (servers == null) {
            return Collections.emptyList();
        }
        return servers.stream().map(ServerTrustInfo::new).collect(Collectors.toList());
    }

    @Nonnull
    public static Collection<JFedTrustStore.TrustInfo> convert(@Nullable TestbedInfoSource testbedInfoSource) {
        if (testbedInfoSource == null) {
            return Collections.emptyList();
        }
        return ServerTrustInfo.convert(testbedInfoSource.getServers());
    }
}

