/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.user;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserFactory;
import be.iminds.ilabt.jfed.lowlevel.user.UserLoginInfo;
import be.iminds.ilabt.jfed.lowlevel.userloginmodel.InvalidLoginException;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import com.google.common.base.Objects;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUserLoginInfo
implements UserLoginInfo {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractUserLoginInfo.class);
    private final boolean userAndAuthorityProvidedSeperately;
    @Nullable
    protected final String keyCertContent;
    protected final boolean unlocked;
    protected final List<X509Certificate> certificateChain;
    @Nullable
    protected final GeniUrn userUrn;
    @Nullable
    protected final Date expirationDate;
    @Nullable
    protected final Server userAuthorityServer;
    protected final GeniUserFactory geniUserFactory;
    protected String error = null;

    protected AbstractUserLoginInfo(@Nullable String keyCertContent, @Nullable GeniUrn userUrn, @Nullable Server userAuthorityServer, GeniUserFactory geniUserFactory) {
        this.userAndAuthorityProvidedSeperately = true;
        this.keyCertContent = keyCertContent;
        this.userUrn = userUrn;
        this.geniUserFactory = geniUserFactory;
        this.userAuthorityServer = userAuthorityServer;
        if (keyCertContent != null) {
            this.unlocked = !KeyUtil.isPemPrivateKeyEncrypted((String)keyCertContent);
            this.certificateChain = KeyUtil.pemToX509CertificateChain((String)keyCertContent);
            if (this.certificateChain == null) {
                this.addError("Could not parse certificate chain");
            }
            this.expirationDate = AbstractUserLoginInfo.getEarliestExpire(this.certificateChain);
        } else {
            this.unlocked = false;
            this.certificateChain = null;
            this.expirationDate = null;
        }
    }

    protected AbstractUserLoginInfo(@Nullable String keyCertContent, GeniUserFactory geniUserFactory, AuthorityFinder authorityFinder) {
        this.userAndAuthorityProvidedSeperately = false;
        this.keyCertContent = keyCertContent;
        this.geniUserFactory = geniUserFactory;
        if (keyCertContent != null) {
            this.unlocked = !KeyUtil.isPemPrivateKeyEncrypted((String)keyCertContent);
            this.certificateChain = KeyUtil.pemToX509CertificateChain((String)keyCertContent);
            if (this.certificateChain == null) {
                this.addError("Could not parse certificate chain");
            }
            this.expirationDate = AbstractUserLoginInfo.getEarliestExpire(this.certificateChain);
            GeniUrn userUrn = null;
            if (this.certificateChain != null) {
                try {
                    userUrn = GeniUserFactory.deriveUserUrnFromCertificateChain(this.certificateChain);
                }
                catch (CertificateParsingException e) {
                    LOG.error("Could not parse certificate chain. Will not extract user urn and expiration date", (Throwable)e);
                    this.addError("Could not parse certificate chain for user URN");
                }
            }
            this.userUrn = userUrn;
            this.userAuthorityServer = userUrn != null ? authorityFinder.findByAnyUrn(userUrn, AuthorityFinder.Purpose.FIND_USERAUTH) : null;
        } else {
            this.unlocked = false;
            this.certificateChain = null;
            this.userUrn = null;
            this.expirationDate = null;
            this.userAuthorityServer = null;
        }
    }

    private static Date getEarliestExpire(List<X509Certificate> certs) {
        if (certs == null) {
            return null;
        }
        Date res = null;
        for (X509Certificate cert : certs) {
            Date expire = cert.getNotAfter();
            if (res != null && !res.after(expire)) continue;
            res = expire;
        }
        return res;
    }

    @Override
    public boolean isUserAndAuthorityProvidedSeperately() {
        return this.userAndAuthorityProvidedSeperately;
    }

    @Override
    public boolean isValid() {
        return this.certificateChain != null && this.userUrn != null && this.expirationDate != null;
    }

    @Override
    public boolean isUnlocked() {
        return this.unlocked;
    }

    @Override
    @Nullable
    public GeniUrn getUserUrn() {
        return this.userUrn;
    }

    @Override
    @Nullable
    public List<X509Certificate> getCertificateChain() {
        return this.certificateChain;
    }

    @Override
    @Nullable
    public Date getExpirationDate() {
        return this.expirationDate;
    }

    @Override
    public GeniUser login(@Nullable char[] password) throws InvalidLoginException {
        if (this.keyCertContent == null) {
            throw new InvalidLoginException("Cannot login user with empty keyCertContent");
        }
        return this.geniUserFactory.createGeniUser(this.keyCertContent, password, null, null);
    }

    @Override
    @Nullable
    public Server getUserAuthorityServer() {
        return this.userAuthorityServer;
    }

    @Override
    public String getCertificateContent() {
        return this.keyCertContent;
    }

    @Override
    @Nullable
    public String getError() {
        return this.error;
    }

    protected void addError(String newError) {
        this.error = this.error != null ? this.error + "\n" + newError : newError;
    }

    protected boolean equalInfo(UserLoginInfo o) {
        if (!Objects.equal((Object)this.keyCertContent, (Object)o.getCertificateContent())) {
            return false;
        }
        if (!Objects.equal((Object)this.userUrn, (Object)o.getUserUrn())) {
            return false;
        }
        return Objects.equal((Object)this.userAuthorityServer, (Object)o.getUserAuthorityServer());
    }
}

