/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.user;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.io.File;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface GeniUser {
    @Nonnull
    public PrivateKey getPrivateKey();

    @Nonnull
    public PublicKey getPublicKey();

    @Nonnull
    public List<X509Certificate> getClientCertificateChain();

    @Nullable
    public Server getUserAuthorityServer();

    @Nullable
    public Integer getUserAuthorityServerId();

    @Nonnull
    public String getUserUrnString();

    @Nonnull
    public GeniUrn getUserUrn();

    @Nullable
    public File getPrivateKeyFile();

    @Nullable
    public File getCertificateFile();

    @Nullable
    default public String getCertEmail() {
        List<X509Certificate> certs = this.getClientCertificateChain();
        if (certs == null || certs.size() == 0) {
            return null;
        }
        X509Certificate cert = this.getClientCertificateChain().get(0);
        try {
            for (List<?> list : cert.getSubjectAlternativeNames()) {
                if (!Objects.equals(list.get(0), 1)) continue;
                return list.get(1).toString();
            }
            return null;
        }
        catch (CertificateParsingException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    default public Date getCertExpire() {
        List<X509Certificate> certs = this.getClientCertificateChain();
        if (certs == null || certs.size() == 0) {
            return null;
        }
        Date earliest = null;
        for (X509Certificate cert : certs) {
            Date expire = cert.getNotAfter();
            if (earliest != null && !earliest.after(expire)) continue;
            earliest = expire;
        }
        return earliest;
    }
}

