/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.user;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.user.AbstractUserLoginInfo;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserFactory;
import be.iminds.ilabt.jfed.lowlevel.user.UserLoginInfo;
import be.iminds.ilabt.jfed.lowlevel.userloginmodel.InvalidLoginException;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import java.io.File;
import java.io.IOException;
import java.util.Objects;

public class KeyCertFileUserLoginInfo
extends AbstractUserLoginInfo {
    private final File keyCertFile;

    KeyCertFileUserLoginInfo(File keyCertFile, GeniUserFactory geniUserFactory, AuthorityFinder authorityFinder) throws IOException {
        super(keyCertFile != null ? IOUtils.fileToString((File)keyCertFile) : null, geniUserFactory, authorityFinder);
        this.keyCertFile = keyCertFile;
        this.checkForErrors();
    }

    public KeyCertFileUserLoginInfo(File keyCertFile, GeniUrn userUrn, Server userAuthority, GeniUserFactory geniUserFactory) throws IOException {
        super(keyCertFile != null ? IOUtils.fileToString((File)keyCertFile) : null, userUrn, userAuthority, geniUserFactory);
        this.keyCertFile = keyCertFile;
        this.checkForErrors();
    }

    private void checkForErrors() {
        if (this.keyCertFile != null && this.keyCertContent == null) {
            this.addError("Could not read key-certificate-pair from file");
        }
    }

    @Override
    public GeniUser login(char[] password) throws InvalidLoginException {
        return this.geniUserFactory.createGeniUser(this.keyCertFile, password);
    }

    @Override
    public String getUserLoginTypeName() {
        return "Login Certificate File";
    }

    @Override
    public boolean equals(UserLoginInfo o) {
        if (!(o instanceof KeyCertFileUserLoginInfo)) {
            return false;
        }
        if (!Objects.equals(this.keyCertFile, ((KeyCertFileUserLoginInfo)o).keyCertFile)) {
            return false;
        }
        return super.equalInfo(o);
    }

    public File getFile() {
        return this.keyCertFile;
    }
}

