/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ssh_terminal_tool.known_hosts;

import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class OpenSshKnownHostsFile {
    private static final Logger LOG = LoggerFactory.getLogger(OpenSshKnownHostsFile.class);
    private final File knownHostsFile;

    public OpenSshKnownHostsFile(File knownHostsFile) {
        this.knownHostsFile = knownHostsFile;
    }

    @Inject
    public OpenSshKnownHostsFile() {
        File userHomeDir = new File(System.getProperty("user.home"));
        File userSshDir = new File(userHomeDir, ".ssh");
        this.knownHostsFile = new File(userSshDir, "known_hosts");
    }

    public void addKnownHost(String hostname, PublicKey publicKey) {
        if (!(publicKey instanceof RSAPublicKey)) {
            LOG.warn("publicKey must be RSAPublicKey: aborting adding host key");
            return;
        }
        RSAPublicKey rsaPubKey = (RSAPublicKey)publicKey;
        String knownHostFormatPublicKey = KeyUtil.rsaPublicKeyToOpenSshAuthorizedKeysFormatData((RSAPublicKey)rsaPubKey);
        this.addKnownHost(hostname, knownHostFormatPublicKey);
    }

    public void addKnownHost(String hostname, String origKnownHostFormatPublicKey) {
        String knownHostFormatPublicKey = origKnownHostFormatPublicKey.trim().replaceAll("[ \n\t]+", " ");
        String[] knownHostFormatPublicKeyParts = knownHostFormatPublicKey.split(" ");
        if (knownHostFormatPublicKeyParts.length != 1) {
            if (knownHostFormatPublicKeyParts.length == 3 || knownHostFormatPublicKeyParts.length == 4) {
                knownHostFormatPublicKey = knownHostFormatPublicKeyParts[2];
                if (!Objects.equals(knownHostFormatPublicKeyParts[1], "ssh-rsa")) {
                    throw new RuntimeException("Unknown format of known host key (" + knownHostFormatPublicKeyParts.length + " parts, part 2 should be ssh-rsa but is " + knownHostFormatPublicKeyParts[1] + "): \"" + knownHostFormatPublicKey + "\"");
                }
            } else {
                throw new RuntimeException("Unknown format of known host key (" + knownHostFormatPublicKeyParts.length + " parts): \"" + knownHostFormatPublicKey + "\"");
            }
        }
        LOG.debug("addKnownHost called for " + hostname + " -> " + knownHostFormatPublicKey);
        if (!this.knownHostsFile.exists()) {
            LOG.warn("No ~/.ssh/known_hosts file found: aborting adding host key");
            return;
        }
        try {
            if (this.knowsHost(hostname, knownHostFormatPublicKey)) {
                LOG.warn("Host key is already added: aborting adding host key");
                return;
            }
            String knownHostsLine = hostname + " ssh-rsa " + knownHostFormatPublicKey;
            LOG.debug("addKnownHost is adding a known hosts line: " + knownHostsLine);
            String knownHostsContent = IOUtils.fileToString((File)this.knownHostsFile);
            boolean endsWithNewline = knownHostsContent.endsWith("\n");
            PrintWriter pw = new PrintWriter(new FileWriter(this.knownHostsFile, true));
            pw.println((endsWithNewline ? "" : "\n") + knownHostsLine);
            pw.close();
        }
        catch (IOException e) {
            LOG.warn("Failed to add to known_hosts: " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean knowsHost(String hostname, PublicKey publicKey) throws IOException {
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new RuntimeException("Only RSAPublicKey supported for now");
        }
        RSAPublicKey rsaPubKey = (RSAPublicKey)publicKey;
        String knownHostFormatPublicKey = KeyUtil.rsaPublicKeyToOpenSshAuthorizedKeysFormatData((RSAPublicKey)rsaPubKey);
        return this.knowsHost(hostname, knownHostFormatPublicKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean knowsHost(String hostname, String knownHostFormatPublicKey) throws IOException {
        String[] knownHostFormatPublicKeyParts = knownHostFormatPublicKey.split(" ");
        if (knownHostFormatPublicKeyParts.length != 1) {
            if (knownHostFormatPublicKeyParts.length == 3 || knownHostFormatPublicKeyParts.length == 4) {
                knownHostFormatPublicKey = knownHostFormatPublicKeyParts[2];
                if (!Objects.equals(knownHostFormatPublicKeyParts[1], "ssh-rsa")) {
                    throw new RuntimeException("Unknown format of known host key (" + knownHostFormatPublicKeyParts.length + " parts, part 2 should be ssh-rsa but is " + knownHostFormatPublicKeyParts[1] + "): \"" + knownHostFormatPublicKey + "\"");
                }
            } else {
                throw new RuntimeException("Unknown format of known host key (" + knownHostFormatPublicKeyParts.length + " parts): \"" + knownHostFormatPublicKey + "\"");
            }
        }
        try {
            String sshKeyGenRes = OpenSshKnownHostsFile.myCommandHelper(true, "ssh-keygen", "-F", hostname, "-f", this.knownHostsFile.getPath());
            if (sshKeyGenRes != null) {
                return sshKeyGenRes.contains(knownHostFormatPublicKey);
            }
        }
        catch (Exception e) {
            LOG.warn("Error while calling ssh-keygen: " + e.getMessage(), (Throwable)e);
        }
        LOG.warn("Using flawed callback to determine if host is in known_hosts");
        try (BufferedReader br = null;){
            br = new BufferedReader(new FileReader(this.knownHostsFile));
            String line = br.readLine();
            while (line != null) {
                if (line.contains(knownHostFormatPublicKey) && line.contains(hostname)) {
                    boolean bl = true;
                    return bl;
                }
                line = br.readLine();
            }
        }
        return false;
    }

    private static String myCommandHelper(boolean mayFail, String ... command) {
        LOG.debug("Starting command: " + Arrays.asList(command));
        ProcessBuilder pb = new ProcessBuilder(command);
        pb = pb.redirectErrorStream(true);
        try {
            String line;
            Process p = pb.start();
            p.getOutputStream().close();
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            StringBuilder res = new StringBuilder();
            while ((line = input.readLine()) != null) {
                res.append(line);
            }
            input.close();
            try {
                p.waitFor();
            }
            catch (InterruptedException e) {
                LOG.warn("SshAgentHelper.myCommandHelper thread interrupted while waiting for terminal to stop", (Throwable)e);
            }
            if (p.exitValue() != 0) {
                if (mayFail) {
                    LOG.info("SshAgentHelper command \"" + command[0] + "\" returned non zero exit value: " + p.exitValue() + " output: " + res.toString());
                    return null;
                }
                throw new RuntimeException("SshAgentHelper command \"" + command[0] + "\" returned non zero exit value: " + p.exitValue() + " output: " + res.toString());
            }
            return res.toString();
        }
        catch (IOException e) {
            LOG.error("Error executing command: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

