/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.util.tmp_file_helpers;

import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.library.JFedUtils;
import be.iminds.ilabt.jfed.util.tmp_file_helpers.TmpFile;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TmpContentFile
implements TmpFile {
    private static final Logger LOG = LoggerFactory.getLogger(TmpContentFile.class);
    private static final AtomicLong globalFileNr = new AtomicLong(System.currentTimeMillis());
    private static final String fixedRandom;
    private String content;
    private final File dir;
    private final File file;
    private final boolean assureUserOnlyPermissions;

    public TmpContentFile(String name, String ext, String content) {
        this(name, ext, content, false);
    }

    public TmpContentFile(String name, String ext, String content, boolean assureUserOnlyPermissions) {
        this.assureUserOnlyPermissions = assureUserOnlyPermissions;
        this.content = content;
        this.dir = new File(JFedUtils.getUserDataDirectory() + File.separator + "tmp");
        long currentFileNr = globalFileNr.getAndIncrement();
        this.file = new File(this.dir, name + fixedRandom + "-" + currentFileNr + (String)(ext.startsWith(".") ? ext : "." + ext));
    }

    @Override
    public void store() {
        this.dir.mkdirs();
        IOUtils.stringToFile((File)this.file, (String)this.content);
        if (this.assureUserOnlyPermissions) {
            try {
                IOUtils.assureUserOnlyPerms((File)this.file, (boolean)true, (boolean)false, (boolean)false);
            }
            catch (IOException e) {
                LOG.warn("Could not change file permissions to user only", (Throwable)e);
            }
        }
        this.file.deleteOnExit();
        LOG.debug("stored file \"" + this.getFilename() + "\" exists=" + this.file.exists());
    }

    @Override
    public void delete() {
        LOG.debug("deleting file \"" + this.getFilename() + "\" exists=" + this.file.exists());
        try {
            this.file.delete();
        }
        catch (Exception e) {
            LOG.error("Error deleting TmpContentFile \"" + this.getFilename() + "\": " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public File getDir() {
        assert (Objects.equals(this.dir.getPath(), this.file.getParent()));
        return this.dir;
    }

    @Override
    public String getFilename() {
        return this.file.getPath();
    }

    public String getContent() {
        return this.content;
    }

    static {
        String pName = ManagementFactory.getRuntimeMXBean().getName();
        Random rand = new Random(System.currentTimeMillis() + (long)pName.hashCode());
        fixedRandom = "" + rand.nextLong();
    }
}

