/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassRefTypeSignature;
import io.github.classgraph.HierarchicalTypeSignature;
import io.github.classgraph.ScanResult;
import io.github.classgraph.TypeParameter;
import io.github.classgraph.utils.Parser;
import io.github.classgraph.utils.TypeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class ClassTypeSignature
extends HierarchicalTypeSignature {
    private final ClassInfo classInfo;
    final List<TypeParameter> typeParameters;
    private final ClassRefTypeSignature superclassSignature;
    private final List<ClassRefTypeSignature> superinterfaceSignatures;

    private ClassTypeSignature(ClassInfo classInfo, List<TypeParameter> typeParameters, ClassRefTypeSignature superclassSignature, List<ClassRefTypeSignature> superinterfaceSignatures) {
        this.classInfo = classInfo;
        this.typeParameters = typeParameters;
        this.superclassSignature = superclassSignature;
        this.superinterfaceSignatures = superinterfaceSignatures;
    }

    public List<TypeParameter> getTypeParameters() {
        return this.typeParameters;
    }

    public ClassRefTypeSignature getSuperclassSignature() {
        return this.superclassSignature;
    }

    public List<ClassRefTypeSignature> getSuperinterfaceSignatures() {
        return this.superinterfaceSignatures;
    }

    static ClassTypeSignature parse(String typeDescriptor, ClassInfo classInfo) throws Parser.ParseException {
        List<ClassRefTypeSignature> superinterfaceSignatures;
        Parser parser = new Parser(typeDescriptor);
        String definingClassNameNull = null;
        List<TypeParameter> typeParameters = TypeParameter.parseList(parser, definingClassNameNull);
        ClassRefTypeSignature superclassSignature = ClassRefTypeSignature.parse(parser, definingClassNameNull);
        if (parser.hasMore()) {
            superinterfaceSignatures = new ArrayList();
            while (parser.hasMore()) {
                ClassRefTypeSignature superinterfaceSignature = ClassRefTypeSignature.parse(parser, definingClassNameNull);
                if (superinterfaceSignature == null) {
                    throw new Parser.ParseException(parser, "Could not parse superinterface signature");
                }
                superinterfaceSignatures.add(superinterfaceSignature);
            }
        } else {
            superinterfaceSignatures = Collections.emptyList();
        }
        if (parser.hasMore()) {
            throw new Parser.ParseException(parser, "Extra characters at end of type descriptor");
        }
        ClassTypeSignature classSignature = new ClassTypeSignature(classInfo, typeParameters, superclassSignature, superinterfaceSignatures);
        return classSignature;
    }

    @Override
    protected String getClassName() {
        return this.classInfo != null ? this.classInfo.getName() : null;
    }

    @Override
    protected ClassInfo getClassInfo() {
        return this.classInfo;
    }

    @Override
    void setScanResult(ScanResult scanResult) {
        super.setScanResult(scanResult);
        if (this.typeParameters != null) {
            for (TypeParameter typeParameter : this.typeParameters) {
                typeParameter.setScanResult(scanResult);
            }
        }
        if (this.superclassSignature != null) {
            this.superclassSignature.setScanResult(scanResult);
        }
        if (this.superinterfaceSignatures != null) {
            for (ClassRefTypeSignature classRefTypeSignature : this.superinterfaceSignatures) {
                classRefTypeSignature.setScanResult(scanResult);
            }
        }
    }

    @Override
    void getClassNamesFromTypeDescriptors(Set<String> classNameListOut) {
        for (TypeParameter typeParameter : this.typeParameters) {
            typeParameter.getClassNamesFromTypeDescriptors(classNameListOut);
        }
        if (this.superclassSignature != null) {
            this.superclassSignature.getClassNamesFromTypeDescriptors(classNameListOut);
        }
        for (ClassRefTypeSignature typeSignature : this.superinterfaceSignatures) {
            typeSignature.getClassNamesFromTypeDescriptors(classNameListOut);
        }
    }

    public int hashCode() {
        return this.typeParameters.hashCode() + this.superclassSignature.hashCode() * 7 + this.superinterfaceSignatures.hashCode() * 15;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ClassTypeSignature)) {
            return false;
        }
        ClassTypeSignature o = (ClassTypeSignature)obj;
        return o.typeParameters.equals(this.typeParameters) && o.superclassSignature.equals(this.superclassSignature) && o.superinterfaceSignatures.equals(this.superinterfaceSignatures);
    }

    String toString(String className, int modifiers, boolean isAnnotation, boolean isInterface) {
        String superSig;
        int i;
        StringBuilder buf = new StringBuilder();
        if (modifiers != 0) {
            TypeUtils.modifiersToString(modifiers, false, buf);
        }
        if (!this.typeParameters.isEmpty()) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append('<');
            for (i = 0; i < this.typeParameters.size(); ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(this.typeParameters.get(i).toString());
            }
            buf.append('>');
        }
        if (buf.length() > 0) {
            buf.append(' ');
        }
        buf.append(isAnnotation ? "@interface" : (isInterface ? "interface" : ((modifiers & 0x4000) != 0 ? "enum" : "class")));
        if (className != null) {
            buf.append(' ');
            buf.append(className);
        }
        if (this.superclassSignature != null && !(superSig = this.superclassSignature.toString()).equals("java.lang.Object")) {
            buf.append(" extends ");
            buf.append(superSig);
        }
        if (!this.superinterfaceSignatures.isEmpty()) {
            buf.append(" implements");
            for (i = 0; i < this.superinterfaceSignatures.size(); ++i) {
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(' ');
                buf.append(this.superinterfaceSignatures.get(i).toString());
            }
        }
        return buf.toString();
    }

    public String toString() {
        return this.toString(this.classInfo.getName(), this.classInfo.getModifiers(), this.classInfo.isAnnotation(), this.classInfo.isInterface());
    }
}

