/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.ClasspathElement;
import io.github.classgraph.Resource;
import io.github.classgraph.ScanSpec;
import io.github.classgraph.utils.ClasspathOrModulePathEntry;
import io.github.classgraph.utils.FileUtils;
import io.github.classgraph.utils.InputStreamOrByteBufferAdapter;
import io.github.classgraph.utils.LogNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

class ClasspathElementDir
extends ClasspathElement {
    private File dir;

    ClasspathElementDir(ClasspathOrModulePathEntry classpathEltPath, ScanSpec scanSpec, boolean scanFiles, LogNode log) {
        super(classpathEltPath, scanSpec, scanFiles);
        if (scanFiles) {
            try {
                this.dir = classpathEltPath.getFile(log);
            }
            catch (IOException e) {
                if (log != null) {
                    log.log("Exception while trying to canonicalize path " + classpathEltPath.getResolvedPath(), e);
                }
                this.skipClasspathElement = true;
                return;
            }
            this.fileMatches = new ArrayList();
            this.classfileMatches = new ArrayList();
            this.fileToLastModified = new HashMap();
        }
    }

    private Resource newClasspathResource(final File classpathEltFile, final String pathRelativeToClasspathElt, final File classpathResourceFile) {
        return new Resource(){
            private RandomAccessFile randomAccessFile;
            private FileChannel fileChannel;

            @Override
            public String getPath() {
                return pathRelativeToClasspathElt;
            }

            @Override
            public String getPathRelativeToClasspathElement() {
                return pathRelativeToClasspathElt;
            }

            @Override
            public URL getURL() {
                try {
                    return new File(classpathEltFile, pathRelativeToClasspathElt).toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException("Could not form URL for dir: " + classpathEltFile + " ; path: " + pathRelativeToClasspathElt);
                }
            }

            @Override
            public ByteBuffer read() throws IOException {
                if (ClasspathElementDir.this.skipClasspathElement) {
                    throw new IOException("Parent directory could not be opened");
                }
                if (this.byteBuffer != null) {
                    throw new IllegalArgumentException("Resource is already open -- cannot open it again without first calling close()");
                }
                try {
                    this.randomAccessFile = new RandomAccessFile(classpathResourceFile, "r");
                    this.fileChannel = this.randomAccessFile.getChannel();
                    MappedByteBuffer buffer = this.fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, this.fileChannel.size());
                    buffer.load();
                    this.byteBuffer = buffer;
                    this.length = this.byteBuffer.remaining();
                    return this.byteBuffer;
                }
                catch (Exception e) {
                    this.close();
                    throw new IOException("Could not open " + this, e);
                }
            }

            @Override
            InputStreamOrByteBufferAdapter openOrRead() throws IOException {
                return InputStreamOrByteBufferAdapter.create(this.read());
            }

            @Override
            public InputStream open() throws IOException {
                this.read();
                return this.byteBufferToInputStream();
            }

            @Override
            public byte[] load() throws IOException {
                try {
                    this.read();
                    byte[] byteArray = this.byteBufferToByteArray();
                    this.length = byteArray.length;
                    byte[] byArray = byteArray;
                    return byArray;
                }
                finally {
                    this.close();
                }
            }

            @Override
            public void close() {
                if (this.inputStream != null) {
                    try {
                        this.inputStream.close();
                        this.inputStream = null;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (this.byteBuffer != null) {
                    this.byteBuffer = null;
                }
                if (this.fileChannel != null) {
                    try {
                        this.fileChannel.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.fileChannel = null;
                }
                if (this.randomAccessFile != null) {
                    try {
                        this.randomAccessFile.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.randomAccessFile = null;
                }
            }

            @Override
            protected String toStringImpl() {
                return "[dir " + classpathEltFile + "]/" + pathRelativeToClasspathElt;
            }
        };
    }

    private void scanDirRecursively(File classpathElt, File dir, int ignorePrefixLen, boolean prevInWhitelistedPath, HashSet<String> scannedCanonicalPaths, LogNode log) {
        File[] filesInDir;
        String dirRelativePath;
        String canonicalPath;
        boolean inWhitelistedPath = prevInWhitelistedPath;
        try {
            canonicalPath = dir.getCanonicalPath();
            if (!scannedCanonicalPaths.add(canonicalPath)) {
                if (log != null) {
                    log.log("Reached symlink cycle, stopping recursion: " + dir);
                }
                return;
            }
        }
        catch (IOException | SecurityException e) {
            if (log != null) {
                log.log("Could not canonicalize path: " + dir, e);
            }
            return;
        }
        String dirPath = dir.getPath();
        String string = dirRelativePath = ignorePrefixLen > dirPath.length() ? "/" : dirPath.substring(ignorePrefixLen).replace(File.separatorChar, '/') + "/";
        if (this.nestedClasspathRootPrefixes != null && this.nestedClasspathRootPrefixes.contains(dirRelativePath)) {
            if (log != null) {
                log.log("Reached nested classpath root, stopping recursion to avoid duplicate scanning: " + dirRelativePath);
            }
            return;
        }
        ScanSpec.ScanSpecPathMatch matchStatus = this.scanSpec.dirWhitelistMatchStatus(dirRelativePath);
        if (matchStatus == ScanSpec.ScanSpecPathMatch.NOT_WITHIN_WHITELISTED_PATH || matchStatus == ScanSpec.ScanSpecPathMatch.HAS_BLACKLISTED_PATH_PREFIX) {
            if (log != null) {
                log.log("Reached non-whitelisted (or blacklisted) directory: " + dirRelativePath);
            }
            return;
        }
        if (matchStatus == ScanSpec.ScanSpecPathMatch.AT_WHITELISTED_PATH || matchStatus == ScanSpec.ScanSpecPathMatch.HAS_WHITELISTED_PATH_PREFIX) {
            inWhitelistedPath = true;
        }
        if ((filesInDir = dir.listFiles()) == null) {
            if (log != null) {
                log.log("Invalid directory " + dir);
            }
            return;
        }
        LogNode dirLog = log == null ? null : log.log(canonicalPath, "Scanning subdirectory path: " + dirRelativePath + (dir.getPath().equals(canonicalPath) ? "" : " ; canonical path: " + canonicalPath));
        for (File fileInDir : filesInDir) {
            String fileInDirRelativePath;
            if (fileInDir.isDirectory()) {
                if (!inWhitelistedPath && matchStatus != ScanSpec.ScanSpecPathMatch.ANCESTOR_OF_WHITELISTED_PATH) continue;
                this.scanDirRecursively(classpathElt, fileInDir, ignorePrefixLen, inWhitelistedPath, scannedCanonicalPaths, dirLog);
                if (dirLog == null) continue;
                dirLog.addElapsedTime();
                continue;
            }
            if (!fileInDir.isFile()) continue;
            String string2 = fileInDirRelativePath = dirRelativePath.isEmpty() || "/".equals(dirRelativePath) ? fileInDir.getName() : dirRelativePath + fileInDir.getName();
            if (!inWhitelistedPath && (matchStatus != ScanSpec.ScanSpecPathMatch.AT_WHITELISTED_CLASS_PACKAGE || !this.scanSpec.isSpecificallyWhitelistedClass(fileInDirRelativePath))) continue;
            if (dirLog != null) {
                dirLog.log(fileInDirRelativePath, "Found whitelisted file: " + fileInDirRelativePath);
            }
            this.fileToLastModified.put(fileInDir, fileInDir.lastModified());
            if (this.scanSpec.enableClassInfo && FileUtils.isClassfile(fileInDirRelativePath)) {
                this.classfileMatches.add(this.newClasspathResource(classpathElt, fileInDirRelativePath, fileInDir));
            }
            this.fileMatches.add(this.newClasspathResource(classpathElt, fileInDirRelativePath, fileInDir));
        }
        if (matchStatus == ScanSpec.ScanSpecPathMatch.HAS_WHITELISTED_PATH_PREFIX || matchStatus == ScanSpec.ScanSpecPathMatch.ANCESTOR_OF_WHITELISTED_PATH) {
            this.fileToLastModified.put(dir, dir.lastModified());
        }
    }

    @Override
    void scanPaths(LogNode log) {
        String path;
        String canonicalPath = path = this.classpathEltPath.getResolvedPath();
        try {
            canonicalPath = this.classpathEltPath.getCanonicalPath(log);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        LogNode logNode = log == null ? null : log.log(canonicalPath, "Scanning directory classpath entry " + this.classpathEltPath + (path.equals(canonicalPath) ? "" : " ; canonical path: " + canonicalPath));
        HashSet<String> scannedCanonicalPaths = new HashSet<String>();
        this.scanDirRecursively(this.dir, this.dir, this.dir.getPath().length() + 1, false, scannedCanonicalPaths, logNode);
        if (logNode != null) {
            logNode.addElapsedTime();
        }
    }

    @Override
    void close() {
    }
}

