/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi.args;

import io.dropwizard.jdbi.args.OffsetDateTimeArgument;
import java.time.OffsetDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Optional;
import java.util.TimeZone;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;
import org.skife.jdbi.v2.tweak.ArgumentFactory;

public class GuavaOptionalOffsetTimeArgumentFactory
implements ArgumentFactory<com.google.common.base.Optional<OffsetDateTime>> {
    private final Optional<Calendar> calendar;

    public GuavaOptionalOffsetTimeArgumentFactory() {
        this.calendar = Optional.empty();
    }

    public GuavaOptionalOffsetTimeArgumentFactory(Optional<TimeZone> timeZone) {
        this.calendar = timeZone.map(GregorianCalendar::new);
    }

    public boolean accepts(Class<?> expectedType, Object value, StatementContext ctx) {
        if (value instanceof com.google.common.base.Optional) {
            com.google.common.base.Optional optionalValue = (com.google.common.base.Optional)value;
            return optionalValue.isPresent() && optionalValue.get() instanceof OffsetDateTime;
        }
        return false;
    }

    public Argument build(Class<?> expectedType, com.google.common.base.Optional<OffsetDateTime> value, StatementContext ctx) {
        return new OffsetDateTimeArgument((OffsetDateTime)value.get(), this.calendar);
    }
}

