/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi.args;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Optional;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;

public class JodaDateTimeArgument
implements Argument {
    @Nullable
    private final DateTime value;
    private final Optional<Calendar> calendar;

    JodaDateTimeArgument(@Nullable DateTime value, Optional<Calendar> calendar) {
        this.value = value;
        this.calendar = calendar;
    }

    public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
        if (this.value != null) {
            if (this.calendar.isPresent()) {
                Calendar calendarClone = (Calendar)this.calendar.get().clone();
                statement.setTimestamp(position, new Timestamp(this.value.getMillis()), calendarClone);
            } else {
                statement.setTimestamp(position, new Timestamp(this.value.getMillis()));
            }
        } else {
            statement.setNull(position, 93);
        }
    }
}

