/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.util.common;

import be.iminds.ilabt.jfed.util.common.OSDetector;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.Contract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtils {
    private static final Logger LOG = LoggerFactory.getLogger(IOUtils.class);
    public static final int READ_TIMEOUT = 60000;

    @Nonnull
    public static String askCommandLineInput(@Nonnull String question) {
        return IOUtils.askCommandLineInput(question, System.in);
    }

    @Nonnull
    public static String askCommandLineInput(@Nonnull String question, @Nonnull InputStream in) {
        Scanner input = new Scanner(in);
        System.out.print(question + ": ");
        return input.nextLine();
    }

    @Nonnull
    public static char[] askCommandLinePassword(@Nonnull String question) {
        return IOUtils.askCommandLinePassword(question, System.in);
    }

    @Nonnull
    public static char[] askCommandLinePassword(@Nonnull String question, @Nonnull InputStream in) {
        Console cons = System.console();
        cons = System.console();
        if (cons != null) {
            char[] passwd = cons.readPassword("%s: ", question);
            return passwd;
        }
        Scanner input = new Scanner(in);
        System.out.print("*** everything you type might be shown *** " + question + ": ");
        return input.nextLine().toCharArray();
    }

    @Nonnull
    public static String fileToString(@Nonnull String filename) throws IOException {
        return IOUtils.fileToString(new File(filename));
    }

    @Nonnull
    public static String fileToString(@Nonnull File file) throws IOException {
        StringBuilder res = new StringBuilder();
        try (FileReader fr = new FileReader(file);){
            char[] buffer = new char[4096];
            int read = fr.read(buffer);
            while (read != -1) {
                res.append(buffer, 0, read);
                read = fr.read(buffer);
            }
        }
        return res.toString();
    }

    @Nullable
    @Contract(value="null -> null")
    public static String fileToStringOrNull(@Nullable File file) {
        if (file == null || !file.isFile() || !file.exists()) {
            return null;
        }
        try {
            StringBuilder res = new StringBuilder();
            try (FileReader fr = new FileReader(file);){
                char[] buffer = new char[4096];
                int read = fr.read(buffer);
                while (read != -1) {
                    res.append(buffer, 0, read);
                    read = fr.read(buffer);
                }
            }
            return res.toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Nonnull
    public static String resourceToString(@Nonnull String resourceName, @Nonnull Class classInResourceRoot) throws IOException {
        assert (resourceName != null);
        assert (classInResourceRoot != null);
        StringBuilder res = new StringBuilder();
        InputStream resourceInputStream = classInResourceRoot.getResourceAsStream(resourceName);
        if (resourceInputStream == null) {
            throw new IOException("No resource named \"" + resourceName + "\" was found");
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(resourceInputStream));){
            String line = br.readLine();
            while (line != null) {
                res.append(line);
                res.append('\n');
                line = br.readLine();
            }
        }
        return res.toString();
    }

    @Nonnull
    public static byte[] fileToByteArray(@Nonnull File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        return IOUtils.streamToByteArray(is);
    }

    @Nonnull
    public static byte[] streamToByteArray(@Nonnull InputStream is) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            int i;
            byte[] b = new byte[1024];
            while ((i = is.read(b)) != -1) {
                baos.write(b, 0, i);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    public static void byteArrayToFile(@Nonnull File file, @Nonnull byte[] b) throws IOException {
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));){
            os.write(b);
        }
    }

    @Nonnull
    public static String streamToString(@Nonnull InputStream is, @Nonnull Charset encoding) throws IOException {
        return IOUtils.streamToString(is, encoding.name());
    }

    @Nonnull
    public static String streamToString(@Nonnull InputStream is, @Nonnull String encoding) throws IOException {
        assert (is != null);
        int BUFFER_SIZE = 2048;
        char[] buffer = new char[BUFFER_SIZE];
        StringBuilder out = new StringBuilder();
        try (InputStreamReader in = new InputStreamReader(is, encoding);){
            int rsz;
            while ((rsz = ((Reader)in).read(buffer, 0, buffer.length)) >= 0) {
                out.append(buffer, 0, rsz);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unexpected unsupported encoding \"" + encoding + "\"", e);
        }
        return out.toString();
    }

    @Nonnull
    public static String urlToString(@Nonnull URL url, @Nonnull Charset charset) throws IOException {
        URLConnection urlConn = url.openConnection();
        urlConn.setReadTimeout(60000);
        return IOUtils.streamToString(urlConn.getInputStream(), charset.toString());
    }

    @Nonnull
    public static byte[] urlToByteArray(@Nonnull URL url) throws IOException {
        URLConnection urlConn = url.openConnection();
        urlConn.setReadTimeout(60000);
        return IOUtils.streamToByteArray(urlConn.getInputStream());
    }

    public static void urlToFile(@Nonnull URL url, @Nonnull File file) throws IOException {
        URLConnection urlConn = url.openConnection();
        urlConn.setReadTimeout(60000);
        Files.copy(urlConn.getInputStream(), file.toPath(), new CopyOption[0]);
    }

    @Nonnull
    public static File urlToTmpFile(@Nonnull URL url) throws IOException {
        final Path tmpDir = Files.createTempDirectory(null, new FileAttribute[0]);
        final File tmpFile = new File(tmpDir.toFile(), url.getFile());
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    Files.delete(tmpFile.toPath());
                    Files.delete(tmpDir);
                }
                catch (IOException e) {
                    System.err.println("Failed to delete temp files on shutdown. Will be ignored.");
                }
            }
        });
        URLConnection urlConn = url.openConnection();
        urlConn.setReadTimeout(60000);
        Files.copy(urlConn.getInputStream(), tmpFile.toPath(), new CopyOption[0]);
        return tmpFile;
    }

    public static void streamToFile(@Nonnull InputStream is, @Nonnull File outFile) {
        Path destination = outFile.toPath();
        try {
            Files.copy(is, destination, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading inputstream '" + is + "' or writing to file \"" + outFile.getName() + "\": " + e.getMessage(), e);
        }
    }

    @Nonnull
    public static String currentStackToStacktraceString() {
        try {
            throw new RuntimeException();
        }
        catch (RuntimeException ex) {
            RuntimeException e = ex;
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            pw.close();
            String stacktrace = sw.getBuffer().toString();
            return stacktrace;
        }
    }

    @Nonnull
    public static String exceptionToStacktraceString(@Nonnull Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        pw.close();
        String stacktrace = sw.getBuffer().toString();
        return stacktrace;
    }

    @Nonnull
    public static String exceptionToShortDescription(@Nonnull Throwable e) {
        String localClassName = null;
        String methodName = null;
        int lineNr = -1;
        for (StackTraceElement ste : e.getStackTrace()) {
            if (ste.getClassName() == null || !ste.getClassName().contains("be.iminds.ilabt.")) continue;
            localClassName = ste.getClassName();
            methodName = ste.getMethodName();
            lineNr = ste.getLineNumber();
            break;
        }
        Object res = e.getClass().getSimpleName();
        if (localClassName != null) {
            res = (String)res + " in " + localClassName.replaceAll(".*\\.", "");
            if (methodName != null) {
                res = (String)res + "." + methodName + "()";
            }
            if (lineNr > 0) {
                res = (String)res + " @ line " + lineNr;
            }
        } else {
            res = (String)res + " " + e.getMessage();
        }
        return res;
    }

    @Nonnull
    public static String threadToStacktraceString(@Nonnull Thread thread) {
        StackTraceElement[] stackTraceElements = thread.getStackTrace();
        Object res = "";
        for (StackTraceElement e : stackTraceElements) {
            res = (String)res + e + "\n";
        }
        return res;
    }

    public static void stringToFile(@Nonnull String filename, @Nonnull String text) {
        IOUtils.stringToFile(new File(filename), text);
    }

    public static void stringToFile(@Nonnull File file, @Nonnull String text) {
        try {
            IOUtils.stringToFileWithEx(file, text);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing '" + file + "': " + e.getMessage(), e);
        }
    }

    public static void stringToFileWithEx(@Nonnull File file, @Nonnull String text) throws IOException {
        try (FileWriter fw = new FileWriter(file);){
            fw.write(text);
        }
    }

    public static boolean checkUserOnlyPerms(@Nonnull File file, boolean userRead, boolean userWrite, boolean userExecute) throws IOException {
        if (OSDetector.os == OSDetector.OS.UNIX || OSDetector.os == OSDetector.OS.MAC) {
            Set<PosixFilePermission> perms = Files.getPosixFilePermissions(file.toPath(), new LinkOption[0]);
            if (!IOUtils.checkNoPermsForGroupAndOther(file)) {
                return false;
            }
            if (userRead && !perms.contains((Object)PosixFilePermission.OWNER_READ)) {
                return false;
            }
            if (userWrite && !perms.contains((Object)PosixFilePermission.OWNER_WRITE)) {
                return false;
            }
            if (userExecute && !perms.contains((Object)PosixFilePermission.OWNER_EXECUTE)) {
                return false;
            }
        }
        return true;
    }

    public static boolean checkNoPermsForGroupAndOther(@Nonnull File file) throws IOException {
        if (OSDetector.os == OSDetector.OS.UNIX || OSDetector.os == OSDetector.OS.MAC) {
            Set<PosixFilePermission> perms = Files.getPosixFilePermissions(file.toPath(), new LinkOption[0]);
            if (perms.contains((Object)PosixFilePermission.GROUP_READ)) {
                return false;
            }
            if (perms.contains((Object)PosixFilePermission.GROUP_WRITE)) {
                return false;
            }
            if (perms.contains((Object)PosixFilePermission.GROUP_EXECUTE)) {
                return false;
            }
            if (perms.contains((Object)PosixFilePermission.OTHERS_READ)) {
                return false;
            }
            if (perms.contains((Object)PosixFilePermission.OTHERS_WRITE)) {
                return false;
            }
            if (perms.contains((Object)PosixFilePermission.OTHERS_EXECUTE)) {
                return false;
            }
        }
        return true;
    }

    public static void assureUserOnlyPerms(@Nonnull File file, boolean userRead, boolean userWrite, boolean userExecute) throws IOException {
        if (OSDetector.os == OSDetector.OS.UNIX || OSDetector.os == OSDetector.OS.MAC) {
            boolean needToChange = false;
            Set<PosixFilePermission> perms = Files.getPosixFilePermissions(file.toPath(), new LinkOption[0]);
            if (perms.contains((Object)PosixFilePermission.GROUP_READ)) {
                needToChange = true;
            }
            if (perms.contains((Object)PosixFilePermission.GROUP_WRITE)) {
                needToChange = true;
            }
            if (perms.contains((Object)PosixFilePermission.GROUP_EXECUTE)) {
                needToChange = true;
            }
            if (perms.contains((Object)PosixFilePermission.OTHERS_READ)) {
                needToChange = true;
            }
            if (perms.contains((Object)PosixFilePermission.OTHERS_WRITE)) {
                needToChange = true;
            }
            if (perms.contains((Object)PosixFilePermission.OTHERS_EXECUTE)) {
                needToChange = true;
            }
            if (perms.contains((Object)PosixFilePermission.OWNER_READ) != userRead) {
                needToChange = true;
            }
            if (perms.contains((Object)PosixFilePermission.OWNER_WRITE) != userWrite) {
                needToChange = true;
            }
            if (perms.contains((Object)PosixFilePermission.OWNER_EXECUTE) != userExecute) {
                needToChange = true;
            }
            if (needToChange) {
                IOUtils.setUserOnlyPerms(file, userRead, userWrite, userExecute);
            }
        }
    }

    public static void setUserOnlyPerms(@Nonnull String file, boolean userRead, boolean userWrite, boolean userExecute) throws IOException {
        IOUtils.setUserOnlyPerms(new File(file), userRead, userWrite, userExecute);
    }

    public static void setUserOnlyPerms(@Nonnull File file, boolean userRead, boolean userWrite, boolean userExecute) throws IOException {
        if (OSDetector.os == OSDetector.OS.UNIX || OSDetector.os == OSDetector.OS.MAC) {
            HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
            if (userRead) {
                perms.add(PosixFilePermission.OWNER_READ);
            }
            if (userWrite) {
                perms.add(PosixFilePermission.OWNER_WRITE);
            }
            if (userExecute) {
                perms.add(PosixFilePermission.OWNER_EXECUTE);
            }
            Files.setPosixFilePermissions(file.toPath(), perms);
        }
    }

    public static void setAllowAllRead(@Nonnull File file, boolean userWrite, boolean userExecute) throws IOException {
        if (OSDetector.os == OSDetector.OS.UNIX || OSDetector.os == OSDetector.OS.MAC) {
            HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
            perms.add(PosixFilePermission.OWNER_READ);
            perms.add(PosixFilePermission.GROUP_READ);
            perms.add(PosixFilePermission.OTHERS_READ);
            if (userWrite) {
                perms.add(PosixFilePermission.OWNER_WRITE);
            }
            if (userExecute) {
                perms.add(PosixFilePermission.OWNER_EXECUTE);
            }
            Files.setPosixFilePermissions(file.toPath(), perms);
        }
    }

    public static void deleteDirAtExit(final File dirToDelete) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    Files.walkFileTree(dirToDelete.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            try {
                                Files.delete(file);
                            }
                            catch (IOException e) {
                                System.err.println("Failed to delete file '" + file + "' in temp dir on shutdown. Will be ignored.");
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                            try {
                                Files.delete(dir);
                            }
                            catch (IOException e) {
                                System.err.println("Failed to delete dir '" + dir + "' in temp dir on shutdown. Will be ignored.");
                            }
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (IOException e) {
                    System.err.println("Failed to delete temp dir '" + dirToDelete.getPath() + "' on shutdown. Will be ignored.");
                }
            }
        });
    }

    @Nonnull
    public static PathParts splitUnixPath(@Nonnull String remoteUnixPath) {
        String ext;
        String fileBase;
        String filename;
        String dir;
        int dirSlashIndex = remoteUnixPath.lastIndexOf(47);
        if (dirSlashIndex >= 0) {
            dir = remoteUnixPath.substring(0, dirSlashIndex + 1);
            filename = remoteUnixPath.substring(dirSlashIndex + 1);
        } else {
            dir = "";
            filename = remoteUnixPath;
        }
        int extDotIndex = filename.lastIndexOf(46);
        if (extDotIndex > 0) {
            fileBase = filename.substring(0, extDotIndex);
            ext = filename.substring(extDotIndex + 1);
        } else {
            fileBase = filename;
            ext = "";
        }
        PathParts res = new PathParts(dir, fileBase, ext);
        assert (res.getFullPath().equals(remoteUnixPath)) : "Could not reconstruct: " + res.getFullPath() + " != " + remoteUnixPath;
        return res;
    }

    @Nonnull
    public static String getUnixBasename(@Nonnull String fullPath) {
        if (fullPath.length() > 1 && fullPath.endsWith("/")) {
            fullPath = fullPath.substring(0, fullPath.length() - 1);
        }
        int separatorLocation = fullPath.lastIndexOf(47);
        return fullPath.substring(separatorLocation + 1);
    }

    @Nonnull
    public static String getUnixPathOnly(@Nonnull String fullPath) {
        int separatorLocation = fullPath.lastIndexOf(47);
        if (separatorLocation < 0) {
            return fullPath;
        }
        return fullPath.substring(0, separatorLocation + 1);
    }

    public static int getTermWidth(int fallback) {
        try {
            ProcessBuilder pb = new ProcessBuilder("tput", "cols");
            pb.redirectInput(ProcessBuilder.Redirect.INHERIT);
            pb.redirectError(ProcessBuilder.Redirect.INHERIT);
            Process p = pb.start();
            String res = IOUtils.streamToString(p.getInputStream(), StandardCharsets.UTF_8);
            p.waitFor();
            int r = Integer.parseInt(res.trim());
            if (r < 30 || r > 600) {
                return fallback;
            }
            return r;
        }
        catch (Exception e) {
            LOG.debug("Failed to get terminal width (this is ignored)", (Throwable)e);
            return fallback;
        }
    }

    public static class PathParts {
        @Nonnull
        public final String dir;
        @Nonnull
        public final String fileBase;
        @Nonnull
        public final String ext;

        public PathParts(@Nonnull String dir, @Nonnull String fileBase, @Nonnull String ext) {
            this.dir = dir;
            this.fileBase = fileBase;
            this.ext = ext;
        }

        @Nonnull
        public String getFullExt() {
            if (this.ext.isEmpty()) {
                return "";
            }
            return "." + this.ext;
        }

        @Nonnull
        public String getFullPath() {
            if (this.ext.isEmpty()) {
                return this.dir + this.fileBase;
            }
            return this.dir + this.fileBase + "." + this.ext;
        }

        @Nonnull
        public String getBasenameAndExt() {
            if (this.ext.isEmpty()) {
                return this.fileBase;
            }
            return this.fileBase + "." + this.ext;
        }
    }
}

