/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.util.common;

import be.iminds.ilabt.jfed.util.common.TextUtil;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.InvalidParameterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class Slf4jHelper {
    private static final Logger LOG = LoggerFactory.getLogger(Slf4jHelper.class);

    private Slf4jHelper() {
        throw new RuntimeException("This is static only class");
    }

    public static Logger createPrintStreamLogger(PrintStream printStream, Level level) {
        return new PrintStreamLogger(printStream, level);
    }

    public static Logger createPrintWriterLogger(PrintWriter printWriter, Level level) {
        return new PrintWriterLogger(printWriter, level);
    }

    public static Logger createMultiplexLogger(Logger ... loggers) {
        return new MultiplexLogger(loggers);
    }

    private static class PrintStreamLogger
    extends AbstractSlf4JLoggerImpl {
        private final PrintStream out;

        public PrintStreamLogger(PrintStream out) {
            this(out, Level.INFO);
        }

        public PrintStreamLogger(PrintStream out, Level level) {
            super(level);
            this.out = out;
        }

        public String getName() {
            return "Test Output Logger";
        }

        @Override
        protected void handle(Level msgLevel, String message, Throwable t) {
            if (!this.level.includes(msgLevel)) {
                return;
            }
            if (t != null) {
                message = (String)message + "\n" + TextUtil.exceptionToString(t);
            }
            this.out.println(this.getName() + " - " + msgLevel + " - " + (String)message);
        }
    }

    public static enum Level {
        TRACE(0),
        DEBUG(1),
        INFO(2),
        WARN(3),
        ERROR(4);

        private final int level;

        private Level(int level) {
            this.level = level;
        }

        public int getLevel() {
            return this.level;
        }

        public boolean includes(Level level) {
            return this.getLevel() <= level.getLevel();
        }
    }

    private static class PrintWriterLogger
    extends AbstractSlf4JLoggerImpl {
        private final PrintWriter out;

        public PrintWriterLogger(PrintWriter out) {
            this(out, Level.INFO);
        }

        public PrintWriterLogger(PrintWriter out, Level level) {
            super(level);
            this.out = out;
        }

        public String getName() {
            return "Test Output Logger";
        }

        @Override
        protected void handle(Level msgLevel, String message, Throwable t) {
            if (!this.level.includes(msgLevel)) {
                return;
            }
            if (t != null) {
                message = (String)message + "\n" + TextUtil.exceptionToString(t);
            }
            this.out.println(this.getName() + " - " + msgLevel + " - " + (String)message);
        }
    }

    private static class MultiplexLogger
    implements Logger {
        private final Logger[] loggers;

        private MultiplexLogger(Logger[] loggers) {
            this.loggers = loggers;
        }

        public String getName() {
            return "MultiplexLogger";
        }

        public boolean isTraceEnabled() {
            for (Logger l : this.loggers) {
                if (!l.isTraceEnabled()) continue;
                return true;
            }
            return false;
        }

        public boolean isTraceEnabled(Marker marker) {
            for (Logger l : this.loggers) {
                if (!l.isTraceEnabled(marker)) continue;
                return true;
            }
            return false;
        }

        public boolean isDebugEnabled() {
            for (Logger l : this.loggers) {
                if (!l.isDebugEnabled()) continue;
                return true;
            }
            return false;
        }

        public boolean isDebugEnabled(Marker marker) {
            for (Logger l : this.loggers) {
                if (!l.isDebugEnabled(marker)) continue;
                return true;
            }
            return false;
        }

        public boolean isInfoEnabled() {
            for (Logger l : this.loggers) {
                if (!l.isInfoEnabled()) continue;
                return true;
            }
            return false;
        }

        public boolean isInfoEnabled(Marker marker) {
            for (Logger l : this.loggers) {
                if (!l.isInfoEnabled(marker)) continue;
                return true;
            }
            return false;
        }

        public boolean isWarnEnabled() {
            for (Logger l : this.loggers) {
                if (!l.isWarnEnabled()) continue;
                return true;
            }
            return false;
        }

        public boolean isWarnEnabled(Marker marker) {
            for (Logger l : this.loggers) {
                if (!l.isWarnEnabled(marker)) continue;
                return true;
            }
            return false;
        }

        public boolean isErrorEnabled() {
            for (Logger l : this.loggers) {
                if (!l.isErrorEnabled()) continue;
                return true;
            }
            return false;
        }

        public boolean isErrorEnabled(Marker marker) {
            for (Logger l : this.loggers) {
                if (!l.isErrorEnabled(marker)) continue;
                return true;
            }
            return false;
        }

        public void trace(String s) {
            for (Logger l : this.loggers) {
                l.trace(s);
            }
        }

        public void trace(String s, Object o) {
            for (Logger l : this.loggers) {
                l.trace(s, o);
            }
        }

        public void trace(String s, Object o, Object o1) {
            for (Logger l : this.loggers) {
                l.trace(s, o, o1);
            }
        }

        public void trace(String s, Object ... objects) {
            for (Logger l : this.loggers) {
                l.trace(s, objects);
            }
        }

        public void trace(String s, Throwable t) {
            for (Logger l : this.loggers) {
                l.trace(s, t);
            }
        }

        public void trace(Marker m, String s) {
            for (Logger l : this.loggers) {
                l.trace(m, s);
            }
        }

        public void trace(Marker m, String s, Object o) {
            for (Logger l : this.loggers) {
                l.trace(m, s, o);
            }
        }

        public void trace(Marker m, String s, Object o, Object o1) {
            for (Logger l : this.loggers) {
                l.trace(m, s, o, o1);
            }
        }

        public void trace(Marker m, String s, Object ... objects) {
            for (Logger l : this.loggers) {
                l.trace(m, s, objects);
            }
        }

        public void trace(Marker m, String s, Throwable t) {
            for (Logger l : this.loggers) {
                l.trace(m, s, t);
            }
        }

        public void debug(String s) {
            for (Logger l : this.loggers) {
                l.debug(s);
            }
        }

        public void debug(String s, Object o) {
            for (Logger l : this.loggers) {
                l.debug(s, o);
            }
        }

        public void debug(String s, Object o, Object o1) {
            for (Logger l : this.loggers) {
                l.debug(s, o, o1);
            }
        }

        public void debug(String s, Object ... objects) {
            for (Logger l : this.loggers) {
                l.debug(s, objects);
            }
        }

        public void debug(String s, Throwable t) {
            for (Logger l : this.loggers) {
                l.debug(s, t);
            }
        }

        public void debug(Marker m, String s) {
            for (Logger l : this.loggers) {
                l.debug(m, s);
            }
        }

        public void debug(Marker m, String s, Object o) {
            for (Logger l : this.loggers) {
                l.debug(m, s, o);
            }
        }

        public void debug(Marker m, String s, Object o, Object o1) {
            for (Logger l : this.loggers) {
                l.debug(m, s, o, o1);
            }
        }

        public void debug(Marker m, String s, Object ... objects) {
            for (Logger l : this.loggers) {
                l.debug(m, s, objects);
            }
        }

        public void debug(Marker m, String s, Throwable t) {
            for (Logger l : this.loggers) {
                l.debug(m, s, t);
            }
        }

        public void info(String s) {
            for (Logger l : this.loggers) {
                l.info(s);
            }
        }

        public void info(String s, Object o) {
            for (Logger l : this.loggers) {
                l.info(s, o);
            }
        }

        public void info(String s, Object o, Object o1) {
            for (Logger l : this.loggers) {
                l.info(s, o, o1);
            }
        }

        public void info(String s, Object ... objects) {
            for (Logger l : this.loggers) {
                l.info(s, objects);
            }
        }

        public void info(String s, Throwable t) {
            for (Logger l : this.loggers) {
                l.info(s, t);
            }
        }

        public void info(Marker m, String s) {
            for (Logger l : this.loggers) {
                l.info(m, s);
            }
        }

        public void info(Marker m, String s, Object o) {
            for (Logger l : this.loggers) {
                l.info(m, s, o);
            }
        }

        public void info(Marker m, String s, Object o, Object o1) {
            for (Logger l : this.loggers) {
                l.info(m, s, o, o1);
            }
        }

        public void info(Marker m, String s, Object ... objects) {
            for (Logger l : this.loggers) {
                l.info(m, s, objects);
            }
        }

        public void info(Marker m, String s, Throwable t) {
            for (Logger l : this.loggers) {
                l.info(m, s, t);
            }
        }

        public void warn(String s) {
            for (Logger l : this.loggers) {
                l.warn(s);
            }
        }

        public void warn(String s, Object o) {
            for (Logger l : this.loggers) {
                l.warn(s, o);
            }
        }

        public void warn(String s, Object o, Object o1) {
            for (Logger l : this.loggers) {
                l.warn(s, o, o1);
            }
        }

        public void warn(String s, Object ... objects) {
            for (Logger l : this.loggers) {
                l.warn(s, objects);
            }
        }

        public void warn(String s, Throwable t) {
            for (Logger l : this.loggers) {
                l.warn(s, t);
            }
        }

        public void warn(Marker m, String s) {
            for (Logger l : this.loggers) {
                l.warn(m, s);
            }
        }

        public void warn(Marker m, String s, Object o) {
            for (Logger l : this.loggers) {
                l.warn(m, s, o);
            }
        }

        public void warn(Marker m, String s, Object o, Object o1) {
            for (Logger l : this.loggers) {
                l.warn(m, s, o, o1);
            }
        }

        public void warn(Marker m, String s, Object ... objects) {
            for (Logger l : this.loggers) {
                l.warn(m, s, objects);
            }
        }

        public void warn(Marker m, String s, Throwable t) {
            for (Logger l : this.loggers) {
                l.warn(m, s, t);
            }
        }

        public void error(String s) {
            for (Logger l : this.loggers) {
                l.error(s);
            }
        }

        public void error(String s, Object o) {
            for (Logger l : this.loggers) {
                l.error(s, o);
            }
        }

        public void error(String s, Object o, Object o1) {
            for (Logger l : this.loggers) {
                l.error(s, o, o1);
            }
        }

        public void error(String s, Object ... objects) {
            for (Logger l : this.loggers) {
                l.error(s, objects);
            }
        }

        public void error(String s, Throwable t) {
            for (Logger l : this.loggers) {
                l.error(s, t);
            }
        }

        public void error(Marker m, String s) {
            for (Logger l : this.loggers) {
                l.error(m, s);
            }
        }

        public void error(Marker m, String s, Object o) {
            for (Logger l : this.loggers) {
                l.error(m, s, o);
            }
        }

        public void error(Marker m, String s, Object o, Object o1) {
            for (Logger l : this.loggers) {
                l.error(m, s, o, o1);
            }
        }

        public void error(Marker m, String s, Object ... objects) {
            for (Logger l : this.loggers) {
                l.error(m, s, objects);
            }
        }

        public void error(Marker m, String s, Throwable t) {
            for (Logger l : this.loggers) {
                l.error(m, s, t);
            }
        }
    }

    public static abstract class AbstractSlf4JLoggerImpl
    implements Logger {
        protected final Level level;
        private boolean handledExceptionInLogging = false;

        public AbstractSlf4JLoggerImpl(Level level) {
            if (level == null) {
                throw new InvalidParameterException("Logger level may not be null");
            }
            this.level = level;
        }

        protected abstract void handle(Level var1, String var2, Throwable var3);

        public boolean isTraceEnabled() {
            return this.level.includes(Level.TRACE);
        }

        public boolean isTraceEnabled(Marker marker) {
            return this.level.includes(Level.TRACE);
        }

        public boolean isDebugEnabled() {
            return this.level.includes(Level.DEBUG);
        }

        public boolean isDebugEnabled(Marker marker) {
            return this.level.includes(Level.DEBUG);
        }

        public boolean isInfoEnabled() {
            return this.level.includes(Level.INFO);
        }

        public boolean isInfoEnabled(Marker marker) {
            return this.level.includes(Level.INFO);
        }

        public boolean isWarnEnabled() {
            return this.level.includes(Level.WARN);
        }

        public boolean isWarnEnabled(Marker marker) {
            return this.level.includes(Level.WARN);
        }

        public boolean isErrorEnabled() {
            return this.level.includes(Level.ERROR);
        }

        public boolean isErrorEnabled(Marker marker) {
            return this.level.includes(Level.ERROR);
        }

        private void callHandle(Level level, String message, Throwable t) {
            block2: {
                try {
                    this.handle(level, message, t);
                }
                catch (Exception e) {
                    if (this.handledExceptionInLogging) break block2;
                    LOG.error("Warning: Exception in " + this.getClass() + ".handle(). Logging will possibly stop working. (NOTE: this error is reported only once.)", (Throwable)e);
                    this.handledExceptionInLogging = true;
                }
            }
        }

        public void trace(String s) {
            this.callHandle(Level.TRACE, s, null);
        }

        public void trace(String s, Object o) {
            this.callHandle(Level.TRACE, String.format(s, o), null);
        }

        public void trace(String s, Object o, Object o1) {
            this.callHandle(Level.TRACE, String.format(s, o, o1), null);
        }

        public void trace(String s, Object ... objects) {
            this.callHandle(Level.TRACE, String.format(s, objects), null);
        }

        public void trace(String s, Throwable t) {
            this.callHandle(Level.TRACE, s, t);
        }

        public void trace(Marker m, String s) {
            this.callHandle(Level.TRACE, s, null);
        }

        public void trace(Marker m, String s, Object o) {
            this.callHandle(Level.TRACE, String.format(s, o), null);
        }

        public void trace(Marker m, String s, Object o, Object o1) {
            this.callHandle(Level.TRACE, String.format(s, o, o1), null);
        }

        public void trace(Marker m, String s, Object ... objects) {
            this.callHandle(Level.TRACE, String.format(s, objects), null);
        }

        public void trace(Marker m, String s, Throwable throwable) {
            this.callHandle(Level.TRACE, s + "\n" + TextUtil.exceptionToString(throwable), null);
        }

        public void debug(String s) {
            this.callHandle(Level.DEBUG, s, null);
        }

        public void debug(String s, Object o) {
            this.callHandle(Level.DEBUG, String.format(s, o), null);
        }

        public void debug(String s, Object o, Object o1) {
            this.callHandle(Level.DEBUG, String.format(s, o, o1), null);
        }

        public void debug(String s, Object ... objects) {
            this.callHandle(Level.DEBUG, String.format(s, objects), null);
        }

        public void debug(String s, Throwable t) {
            this.callHandle(Level.DEBUG, s, t);
        }

        public void debug(Marker m, String s) {
            this.callHandle(Level.DEBUG, s, null);
        }

        public void debug(Marker m, String s, Object o) {
            this.callHandle(Level.DEBUG, String.format(s, o), null);
        }

        public void debug(Marker m, String s, Object o, Object o1) {
            this.callHandle(Level.DEBUG, String.format(s, o, o1), null);
        }

        public void debug(Marker m, String s, Object ... objects) {
            this.callHandle(Level.DEBUG, String.format(s, objects), null);
        }

        public void debug(Marker m, String s, Throwable throwable) {
            this.callHandle(Level.DEBUG, s + "\n" + TextUtil.exceptionToString(throwable), null);
        }

        public void info(String s) {
            this.callHandle(Level.INFO, s, null);
        }

        public void info(String s, Object o) {
            this.callHandle(Level.INFO, String.format(s, o), null);
        }

        public void info(String s, Object o, Object o1) {
            this.callHandle(Level.INFO, String.format(s, o, o1), null);
        }

        public void info(String s, Object ... objects) {
            this.callHandle(Level.INFO, String.format(s, objects), null);
        }

        public void info(String s, Throwable t) {
            this.callHandle(Level.INFO, s, t);
        }

        public void info(Marker m, String s) {
            this.callHandle(Level.INFO, s, null);
        }

        public void info(Marker m, String s, Object o) {
            this.callHandle(Level.INFO, String.format(s, o), null);
        }

        public void info(Marker m, String s, Object o, Object o1) {
            this.callHandle(Level.INFO, String.format(s, o, o1), null);
        }

        public void info(Marker m, String s, Object ... objects) {
            this.callHandle(Level.INFO, String.format(s, objects), null);
        }

        public void info(Marker m, String s, Throwable throwable) {
            this.callHandle(Level.INFO, s + "\n" + TextUtil.exceptionToString(throwable), null);
        }

        public void warn(String s) {
            this.callHandle(Level.WARN, s, null);
        }

        public void warn(String s, Object o) {
            this.callHandle(Level.WARN, String.format(s, o), null);
        }

        public void warn(String s, Object o, Object o1) {
            this.callHandle(Level.WARN, String.format(s, o, o1), null);
        }

        public void warn(String s, Object ... objects) {
            this.callHandle(Level.WARN, String.format(s, objects), null);
        }

        public void warn(String s, Throwable t) {
            this.callHandle(Level.WARN, s, t);
        }

        public void warn(Marker m, String s) {
            this.callHandle(Level.WARN, s, null);
        }

        public void warn(Marker m, String s, Object o) {
            this.callHandle(Level.WARN, String.format(s, o), null);
        }

        public void warn(Marker m, String s, Object o, Object o1) {
            this.callHandle(Level.WARN, String.format(s, o, o1), null);
        }

        public void warn(Marker m, String s, Object ... objects) {
            this.callHandle(Level.WARN, String.format(s, objects), null);
        }

        public void warn(Marker m, String s, Throwable throwable) {
            this.callHandle(Level.WARN, s + "\n" + TextUtil.exceptionToString(throwable), null);
        }

        public void error(String s) {
            this.callHandle(Level.ERROR, s, null);
        }

        public void error(String s, Object o) {
            this.callHandle(Level.ERROR, String.format(s, o), null);
        }

        public void error(String s, Object o, Object o1) {
            this.callHandle(Level.ERROR, String.format(s, o, o1), null);
        }

        public void error(String s, Object ... objects) {
            this.callHandle(Level.ERROR, String.format(s, objects), null);
        }

        public void error(String s, Throwable t) {
            this.callHandle(Level.ERROR, s, t);
        }

        public void error(Marker m, String s) {
            this.callHandle(Level.ERROR, s, null);
        }

        public void error(Marker m, String s, Object o) {
            this.callHandle(Level.ERROR, String.format(s, o), null);
        }

        public void error(Marker m, String s, Object o, Object o1) {
            this.callHandle(Level.ERROR, String.format(s, o, o1), null);
        }

        public void error(Marker m, String s, Object ... objects) {
            this.callHandle(Level.ERROR, String.format(s, objects), null);
        }

        public void error(Marker m, String s, Throwable throwable) {
            this.callHandle(Level.ERROR, s + "\n" + TextUtil.exceptionToString(throwable), null);
        }
    }
}

