/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import net.oauth.client.ExcerptInputStream;
import net.oauth.client.URLConnectionResponse;
import net.oauth.http.HttpClient;
import net.oauth.http.HttpMessage;
import net.oauth.http.HttpResponseMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLConnectionClient
implements HttpClient {
    private static final String EOL = "\r\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public HttpResponseMessage execute(HttpMessage request, Map<String, Object> parameters) throws IOException {
        void var9_14;
        String key;
        String httpMethod = request.method;
        List<Map.Entry<String, String>> addHeaders = request.headers;
        URL url = request.url;
        URLConnection connection = url.openConnection();
        connection.setDoInput(true);
        if (connection instanceof HttpURLConnection) {
            HttpURLConnection http = (HttpURLConnection)connection;
            http.setRequestMethod(httpMethod);
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                String string = entry.getKey();
                String value = entry.getValue().toString();
                if ("followRedirects".equals(string)) {
                    http.setInstanceFollowRedirects(Boolean.parseBoolean(value));
                    continue;
                }
                if ("connectTimeout".equals(string)) {
                    http.setConnectTimeout(Integer.parseInt(value));
                    continue;
                }
                if (!"readTimeout".equals(string)) continue;
                http.setReadTimeout(Integer.parseInt(value));
            }
        }
        StringBuilder headers = new StringBuilder(httpMethod);
        headers.append(" ").append(url.getPath());
        String query = url.getQuery();
        if (query != null && query.length() > 0) {
            headers.append("?").append(query);
        }
        headers.append(EOL);
        for (Map.Entry<String, List<String>> entry : connection.getRequestProperties().entrySet()) {
            key = entry.getKey();
            for (String value : entry.getValue()) {
                headers.append(key).append(": ").append(value).append(EOL);
            }
        }
        String contentLength = null;
        for (Map.Entry entry : addHeaders) {
            key = (String)entry.getKey();
            if ("Content-Length".equalsIgnoreCase(key) && connection instanceof HttpURLConnection) {
                contentLength = (String)entry.getValue();
            } else {
                connection.setRequestProperty(key, (String)entry.getValue());
            }
            headers.append(key).append(": ").append((String)entry.getValue()).append(EOL);
        }
        Object var9_12 = null;
        InputStream inputStream = request.getBody();
        if (inputStream != null) {
            try {
                if (contentLength != null) {
                    ((HttpURLConnection)connection).setFixedLengthStreamingMode(Integer.parseInt(contentLength));
                }
                connection.setDoOutput(true);
                OutputStream output = connection.getOutputStream();
                try {
                    int n;
                    ExcerptInputStream ex = new ExcerptInputStream(inputStream);
                    byte[] b = new byte[1024];
                    while (0 < (n = ex.read(b))) {
                        output.write(b, 0, n);
                    }
                    byte[] byArray = ex.getExcerpt();
                }
                finally {
                    output.close();
                }
            }
            finally {
                inputStream.close();
            }
        }
        return new URLConnectionResponse(request, headers.toString(), (byte[])var9_14, connection);
    }
}

