-- this file is no longer used
FAIL;

--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

SET search_path = public, pg_catalog;

--
-- Name: resultstatus; Type: TYPE; Schema: public; Owner: tester
--

CREATE TYPE resultstatus AS ENUM (
    'SUCCESS',
    'FAILURE',
    'WARNING',
    'CANCELLED'
);

CREATE TYPE taskstate AS ENUM (
    'CREATED',
    'RUNNING',
    'EXPIRED',
    'FINISHED',
    'CANCELLING',
    'CANCELLED'
);


ALTER TYPE resultstatus OWNER TO tester;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: admin; Type: TABLE; Schema: public; Owner: tester; Tablespace: 
--

CREATE TABLE admin (
    use_alt_emails boolean DEFAULT false,
    disable_emails boolean DEFAULT false,
    disable_prod_tests boolean DEFAULT false,
    active_config boolean DEFAULT true NOT NULL,
    CONSTRAINT single_row CHECK ((active_config = true))
);


ALTER TABLE admin OWNER TO tester;

--
-- Name: TABLE admin; Type: COMMENT; Schema: public; Owner: tester
--

COMMENT ON TABLE admin IS 'administation options';


--
-- Name: COLUMN admin.use_alt_emails; Type: COMMENT; Schema: public; Owner: tester
--

COMMENT ON COLUMN admin.use_alt_emails IS 'Use the alternative email address list or not';


--
-- Name: COLUMN admin.disable_emails; Type: COMMENT; Schema: public; Owner: tester
--

COMMENT ON COLUMN admin.disable_emails IS 'Disable all sending of emails';


--
-- Name: COLUMN admin.disable_prod_tests; Type: COMMENT; Schema: public; Owner: tester
--

COMMENT ON COLUMN admin.disable_prod_tests IS 'Disable all production tests (typically because the self test fails)';


--
-- Name: COLUMN admin.active_config; Type: COMMENT; Schema: public; Owner: tester
--

COMMENT ON COLUMN admin.active_config IS 'Column used to force this table to have a single row';


--
-- Name: frequency; Type: TABLE; Schema: public; Owner: tester; Tablespace: 
--

CREATE TABLE frequency (
    id integer NOT NULL,
    cron character varying(30) NOT NULL,
    description character varying
);


ALTER TABLE frequency OWNER TO tester;

--
-- Name: TABLE frequency; Type: COMMENT; Schema: public; Owner: tester
--

COMMENT ON TABLE frequency IS 'Frequencies at which to run tests. By being in a seperate table, groups of frequency can be easily changed,';


--
-- Name: COLUMN frequency.cron; Type: COMMENT; Schema: public; Owner: tester
--

COMMENT ON COLUMN frequency.cron IS 'cron like string';


--
-- Name: frequency_id_seq; Type: SEQUENCE; Schema: public; Owner: tester
--

CREATE SEQUENCE frequency_id_seq
    START WITH 10
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE frequency_id_seq OWNER TO tester;

--
-- Name: frequency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: tester
--

ALTER SEQUENCE frequency_id_seq OWNED BY frequency.id;


--
-- Name: parameter_definition; Type: TABLE; Schema: public; Owner: tester; Tablespace: 
--

CREATE TABLE parameter_definition (
    testdefinition_id character varying NOT NULL,
    key text NOT NULL,
    type text NOT NULL,
    description text,
    default_value text
);


ALTER TABLE parameter_definition OWNER TO tester;

--
-- Name: COLUMN parameter_definition.default_value; Type: COMMENT; Schema: public; Owner: tester
--

COMMENT ON COLUMN parameter_definition.default_value IS 'default value, in case the instance does not specify this parameter';


--
-- Name: parameter_instance; Type: TABLE; Schema: public; Owner: tester; Tablespace: 
--

CREATE TABLE parameter_instance (
    testinstance_id integer NOT NULL,
    key text NOT NULL,
    value text NOT NULL
);


ALTER TABLE parameter_instance OWNER TO tester;

--
-- Name: parameter_instance_with_definition; Type: VIEW; Schema: public; Owner: tester
--

CREATE VIEW parameter_instance_with_definition AS
 SELECT pi.testinstance_id,
    pi.key,
    pi.value,
    pd.testdefinition_id,
    pd.type,
    pd.description,
    pd.default_value
   FROM (parameter_instance pi
     LEFT JOIN parameter_definition pd ON ((pi.key = pd.key)));


ALTER TABLE parameter_instance_with_definition OWNER TO tester;

--
-- Name: result; Type: TABLE; Schema: public; Owner: tester; Tablespace: 
--

CREATE TABLE result (
    id integer NOT NULL,
    testinstance_id integer NOT NULL,
    log_file character varying,
    created timestamp with time zone DEFAULT now(),
    log_url character varying,
    summary resultstatus,
    expire timestamp with time zone,
    prev_result_id integer
);


ALTER TABLE result OWNER TO tester;

ALTER TABLE ONLY result
    ADD CONSTRAINT results_pkey PRIMARY KEY (id);

--
-- Name: COLUMN result.expire; Type: COMMENT; Schema: public; Owner: tester
--

COMMENT ON COLUMN result.expire IS 'time at which this result stops representing the current state';


--
-- Name: result_resultid_seq; Type: SEQUENCE; Schema: public; Owner: tester
--

CREATE SEQUENCE result_resultid_seq
    START WITH 10
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE result_resultid_seq OWNER TO tester;

--
-- Name: result_resultid_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: tester
--

ALTER SEQUENCE result_resultid_seq OWNED BY result.id;


--
-- Name: result_with_testbed; Type: TABLE; Schema: public; Owner: tester; Tablespace: 
--

CREATE TABLE result_with_testbed (
    id integer,
    log_file character varying,
    created timestamp with time zone,
    log_url character varying,
    summary resultstatus,
    expire timestamp with time zone,
    testbed_id text,
    testbed_categories character varying[],
    prev_result_id integer
);

ALTER TABLE ONLY result_with_testbed REPLICA IDENTITY NOTHING;


ALTER TABLE result_with_testbed OWNER TO tester;

--
-- Name: return_definition; Type: TABLE; Schema: public; Owner: tester; Tablespace: 
--

CREATE TABLE return_definition (
    testdefinition_id character varying NOT NULL,
    name text NOT NULL,
    type text NOT NULL,
    description text,
    index integer
);


ALTER TABLE return_definition OWNER TO tester;

--
-- Name: subresult; Type: TABLE; Schema: public; Owner: tester; Tablespace: 
--

CREATE TABLE subresult (
    result_id integer NOT NULL,
    key text NOT NULL,
    value text NOT NULL
);


ALTER TABLE subresult OWNER TO tester;

--
-- Name: task; Type: TABLE; Schema: public; Owner: tester; Tablespace: 
--

CREATE TABLE task (
    id integer NOT NULL,
    testinstance_id integer NOT NULL,
    start timestamp with time zone DEFAULT now() NOT NULL,
    deadline timestamp with time zone NOT NULL,
    stop timestamp with time zone NULL,
    log text,
    result_id integer,
    run_info text,
    state taskstate NOT NULL
);

ALTER TABLE task OWNER TO tester;

ALTER TABLE ONLY task
    ADD CONSTRAINT task_pkey PRIMARY KEY (id);

--
-- Name: TABLE task; Type: COMMENT; Schema: public; Owner: tester
--

COMMENT ON TABLE task IS 'each task represents a single currently running test execution';


--
-- Name: task_id_seq; Type: SEQUENCE; Schema: public; Owner: tester
--

CREATE SEQUENCE task_id_seq
    START WITH 10
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE task_id_seq OWNER TO tester;

--
-- Name: task_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: tester
--

ALTER SEQUENCE task_id_seq OWNED BY task.id;


--
-- Name: testbed_category; Type: TABLE; Schema: public; Owner: tester; Tablespace: 
--

CREATE TABLE testbed_category (
    id integer NOT NULL,
    name character varying NOT NULL
);


ALTER TABLE testbed_category OWNER TO tester;

--
-- Name: TABLE testbed_category; Type: COMMENT; Schema: public; Owner: tester
--

COMMENT ON TABLE testbed_category IS 'Category names for testbed';


--
-- Name: testbed_category_id_seq; Type: SEQUENCE; Schema: public; Owner: tester
--

CREATE SEQUENCE testbed_category_id_seq
    START WITH 10
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE testbed_category_id_seq OWNER TO tester;

--
-- Name: testbed_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: tester
--

ALTER SEQUENCE testbed_category_id_seq OWNED BY testbed_category.id;


--
-- Name: testbed_category_mapping; Type: TABLE; Schema: public; Owner: tester; Tablespace: 
--

CREATE TABLE testbed_category_mapping (
    testbed_id character varying(20) NOT NULL,
    category_id smallint NOT NULL
);


ALTER TABLE testbed_category_mapping OWNER TO tester;

--
-- Name: TABLE testbed_category_mapping; Type: COMMENT; Schema: public; Owner: tester
--

COMMENT ON TABLE testbed_category_mapping IS 'mapping between testbed and the categories they belong to';


--
-- Name: testbed; Type: TABLE; Schema: public; Owner: tester; Tablespace: 
--

CREATE TABLE testbed (
    id character varying(20) NOT NULL,
    iface_url character varying,
    urn character varying,
    info_url character varying,
    long_name character varying,
    help_url character varying,
    ping_host character varying(100),
    otrs_name character varying(30),
    description text,
    geni_id character varying(20),
    geni_href character varying,
    organisation_id character varying,
    allow_links boolean DEFAULT false NOT NULL,
    color character varying(30),
    logo character varying(200),
    nodes_location_visualisation_coordinates_url character varying,
    nodes_location_visualisation_image_url character varying,
    proxy_id integer
);


ALTER TABLE testbed OWNER TO tester;

--
-- Name: COLUMN testbed.otrs_name; Type: COMMENT; Schema: public; Owner: tester
--

COMMENT ON COLUMN testbed.otrs_name IS 'Name in the OTRS mails';


--
-- Name: COLUMN testbed.description; Type: COMMENT; Schema: public; Owner: tester
--

COMMENT ON COLUMN testbed.description IS 'textual description of this testbed';


--
-- Name: COLUMN testbed.geni_id; Type: COMMENT; Schema: public; Owner: tester
--

COMMENT ON COLUMN testbed.geni_id IS 'id/name for geni operational monitoring';


--
-- Name: COLUMN testbed.geni_href; Type: COMMENT; Schema: public; Owner: tester
--

COMMENT ON COLUMN testbed.geni_href IS 'url of testbed in geni operational monitoring';


CREATE TABLE organisation (
    id character varying(30) NOT NULL,
    name character varying(256) NOT NULL,
    logo_url character varying,
    site_url character varying,
    coordinates character varying
);


ALTER TABLE organisation OWNER TO tester;

ALTER TABLE ONLY organisation
    ADD CONSTRAINT organisation_pkey PRIMARY KEY (id);

    

CREATE TABLE server (
    id integer NOT NULL,
    testbed_id character varying(20),
    name character varying(256),
    allowed_certificate_alias character varying(100),
    certificate_chain character varying,
    base_url character varying,
    coordinates character varying,
    server_type character varying,
    urn_tld character varying,
    flags character varying[],
    scs integer[],
    user_auth integer[],
    default_scs integer,
    default_user_auth integer
);


ALTER TABLE server OWNER TO tester;

ALTER TABLE ONLY server
    ADD CONSTRAINT server_pkey PRIMARY KEY (id);

CREATE SEQUENCE server_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;
ALTER TABLE server_id_seq OWNER TO tester;
ALTER SEQUENCE server_id_seq OWNED BY server.id;
ALTER TABLE ONLY server ALTER COLUMN id SET DEFAULT nextval('server_id_seq'::regclass);



CREATE TABLE service (
    id integer NOT NULL,
    server_id integer NOT NULL,
    api character varying(50),
    api_version character varying(10),
    urn character varying,
    url character varying
);

ALTER TABLE service OWNER TO tester;

ALTER TABLE ONLY service
    ADD CONSTRAINT service_pkey PRIMARY KEY (id);

CREATE SEQUENCE service_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;
ALTER TABLE service_id_seq OWNER TO tester;
ALTER SEQUENCE service_id_seq OWNED BY service.id;
ALTER TABLE ONLY service ALTER COLUMN id SET DEFAULT nextval('service_id_seq'::regclass);



CREATE TABLE proxy (
    id integer NOT NULL,
    name character varying(255),
    type character varying(20),
    hostname character varying,
    port_range character varying,
    host_key character varying
);

ALTER TABLE proxy OWNER TO tester;

ALTER TABLE ONLY proxy
    ADD CONSTRAINT proxy_pkey PRIMARY KEY (id);

CREATE SEQUENCE proxy_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;
ALTER TABLE proxy_id_seq OWNER TO tester;
ALTER SEQUENCE proxy_id_seq OWNED BY proxy.id;
ALTER TABLE ONLY proxy ALTER COLUMN id SET DEFAULT nextval('proxy_id_seq'::regclass);










---
---
---


CREATE TABLE serverglimpse (
    server_id integer,

    advertisement_info jsonb,
    health_info jsonb
);
ALTER TABLE serverglimpse OWNER TO tester;
ALTER TABLE ONLY serverglimpse
    ADD CONSTRAINT serverglimpse_server_id_fkey FOREIGN KEY (server_id) REFERENCES server(id);
ALTER TABLE ONLY serverglimpse
    ADD CONSTRAINT serverglimpse_server_id_unique UNIQUE (server_id);




CREATE TABLE log (
    id integer NOT NULL,
    name text,
    task_id integer,
    result_id integer,
    start timestamp with time zone DEFAULT now() NOT NULL,
    stop timestamp with time zone,
    live boolean DEFAULT false NOT NULL,
    complete boolean DEFAULT false NOT NULL,
    media_type text DEFAULT 'binary' NOT NULL,
    content bytea DEFAULT '' NOT NULL
);
ALTER TABLE log OWNER TO tester;
ALTER TABLE ONLY log
    ADD CONSTRAINT log_pkey PRIMARY KEY (id);
ALTER TABLE ONLY log
    ADD CONSTRAINT log_task_id_fkey FOREIGN KEY (task_id) REFERENCES task(id) ON DELETE SET NULL;
ALTER TABLE ONLY log
    ADD CONSTRAINT log_result_id_fkey FOREIGN KEY (result_id) REFERENCES result(id) ON DELETE SET NULL;

CREATE SEQUENCE log_id_seq
    START WITH 3
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;
ALTER TABLE log_id_seq OWNER TO tester;
ALTER SEQUENCE log_id_seq OWNED BY log.id;
ALTER TABLE ONLY log ALTER COLUMN id SET DEFAULT nextval('log_id_seq'::regclass);



CREATE TABLE configset (
    id character varying(30) NOT NULL,

    bindable_servers_id integer[],
    hide_servers_id integer[],

    flags jsonb,
    gts jsonb,
    triggered_messages jsonb
);
ALTER TABLE configset OWNER TO tester;
ALTER TABLE ONLY configset
    ADD CONSTRAINT configset_pkey PRIMARY KEY (id);



CREATE TABLE resourceclass (
    id character varying(50) NOT NULL,

    image_url character varying,
    image_id character varying,
    hrn character varying,
    visible_in_toolbox boolean DEFAULT true NOT NULL,
    draggable_from_toolbox boolean DEFAULT true NOT NULL,
    parent_id character varying(50),
    instantiate_as_id character varying(50),
    default_resource_id integer[],
--    resource_ids integer[],  --replaced by resourceclass_resource_map

    configset_id character varying[]
);
ALTER TABLE resourceclass OWNER TO tester;
ALTER TABLE ONLY resourceclass
    ADD CONSTRAINT resourceclass_pkey PRIMARY KEY (id);

--- ----- NOT supported -----
--- ALTER TABLE ONLY resourceclass
---    ADD CONSTRAINT resourceclass_configset_id_fkey FOREIGN KEY (configset_id) REFERENCES configset(id);



CREATE TABLE resource (
    id integer NOT NULL,
    
    server_id integer,
--- resource_class_id character varying(50) NOT NULL,  --- replaced by many-to-many (resourceclass_resource_map)
    rspec_element_name character varying,

    layer3 boolean DEFAULT true NOT NULL,
    require_fixed_node_assignment boolean DEFAULT false NOT NULL,
    require_disk_image boolean DEFAULT false NOT NULL,
    require_hardware_type boolean DEFAULT false NOT NULL,

    allow_fixed_node_assignment boolean DEFAULT true NOT NULL,
    allow_disk_image boolean DEFAULT true NOT NULL,
    allow_hardware_type boolean DEFAULT false NOT NULL,

    exclusive boolean DEFAULT true NOT NULL,
    allow_modify_exclusive boolean DEFAULT false NOT NULL,

    sliver_type character varying,
    hardware_type character varying,
    disk_image character varying,
    component_urn character varying

---    , configset_id character varying[]  --- replaced by many-to-many (resourceclass_resource_map)
);
ALTER TABLE resource OWNER TO tester;
ALTER TABLE ONLY resource
    ADD CONSTRAINT resource_pkey PRIMARY KEY (id);

CREATE SEQUENCE resource_id_seq
    START WITH 10
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;
ALTER TABLE resource_id_seq OWNER TO tester;
ALTER SEQUENCE resource_id_seq OWNED BY resource.id;
ALTER TABLE ONLY resource ALTER COLUMN id SET DEFAULT nextval('resource_id_seq'::regclass);


CREATE TABLE resourceclass_resource_map (
    resourceclass_id character varying(50) NOT NULL,
    resource_id integer NOT NULL,
    configset_id character varying
);
ALTER TABLE resourceclass_resource_map OWNER TO tester;

ALTER TABLE ONLY resourceclass_resource_map
    ADD CONSTRAINT resourceclass_resource_map_resource_id_fkey FOREIGN KEY (resource_id) REFERENCES resource(id);
ALTER TABLE ONLY resourceclass_resource_map
    ADD CONSTRAINT resourceclass_resource_map_resourceclass_id_fkey FOREIGN KEY (resourceclass_id) REFERENCES resourceclass(id);
ALTER TABLE ONLY resourceclass_resource_map
    ADD CONSTRAINT resourceclass_resource_map_configset_id_fkey FOREIGN KEY (configset_id) REFERENCES configset(id);

CREATE INDEX resourceclass_resource_map_resourceclass_id_fkey_index ON resourceclass_resource_map USING btree (resourceclass_id);

ALTER TABLE ONLY resourceclass_resource_map
    ADD CONSTRAINT unique_resourceclass_resource_map UNIQUE (resourceclass_id, resource_id, configset_id);
--- not sure if I want this  (= each resource is in only 1 resourceclass per configset)
--- ALTER TABLE ONLY resourceclass_resource_map
---    ADD CONSTRAINT unique_resource_confiset_id_in_resourceclass_resource_map UNIQUE (resource_id, configset_id);




CREATE TABLE userurn_configset_map (
    urn_tla character varying,
    configset_id character varying
);
ALTER TABLE userurn_configset_map OWNER TO tester;
ALTER TABLE ONLY userurn_configset_map
    ADD CONSTRAINT userurn_configset_map_pkey PRIMARY KEY (urn_tla);

ALTER TABLE ONLY userurn_configset_map
    ADD CONSTRAINT userurn_configset_map_configset_id_fkey FOREIGN KEY (configset_id) REFERENCES configset(id);



--
-- Name: testdefinition; Type: TABLE; Schema: public; Owner: tester; Tablespace: 
--

CREATE TABLE testdefinition (
    id character varying NOT NULL,
    test_type character varying NOT NULL,
    geni_datastore_metric character varying,
    geni_datastore_description character varying,
    geni_datastore_units character varying,
    max_test_duration_ms integer DEFAULT 300000 NOT NULL
);


ALTER TABLE testdefinition OWNER TO tester;

--
-- Name: COLUMN testdefinition.max_test_duration_ms; Type: COMMENT; Schema: public; Owner: tester
--

COMMENT ON COLUMN testdefinition.max_test_duration_ms IS 'Maximum duration of a test in ms. After this duration, the test will be aborted and considered as failed.';


--
-- Name: testinstance; Type: TABLE; Schema: public; Owner: tester; Tablespace: 
--

CREATE TABLE testinstance (
    id integer NOT NULL,
    name character varying,
    testdefinition_id character varying NOT NULL,
    enabled boolean DEFAULT true NOT NULL,
    frequency_id integer,
    next_run timestamp with time zone,
    last_run timestamp with time zone,
    last_result_id bigint,
    allow_restart boolean DEFAULT false NOT NULL,
    test_version_name character varying(20) DEFAULT 'prod'::character varying,
    last_result_id_excluding_cancelled bigint,
    test_statistics jsonb,
    last_result_date timestamp with time zone,
    last_result_excluding_cancelled_date timestamp with time zone
);


ALTER TABLE testinstance OWNER TO tester;

--
-- Name: COLUMN testinstance.last_result_id; Type: COMMENT; Schema: public; Owner: tester
--

COMMENT ON COLUMN testinstance.last_result_id IS 'last result id. This is used to speed up queries. Not very nice, but it works.';


--
-- Name: COLUMN testinstance.allow_restart; Type: COMMENT; Schema: public; Owner: tester
--

COMMENT ON COLUMN testinstance.allow_restart IS 'Allow restart from globally accessible site';


--
-- Name: COLUMN testinstance.test_version_name; Type: COMMENT; Schema: public; Owner: tester
--

COMMENT ON COLUMN testinstance.test_version_name IS 'Name of the fedmon-origins version that needs to run this test. Typically ''test'' or ''prod''.';


--
-- Name: COLUMN testinstance.last_result_id_excluding_cancelled; Type: COMMENT; Schema: public; Owner: tester
--

COMMENT ON COLUMN testinstance.last_result_id_excluding_cancelled IS 'last result id. This one excludes cancelled tests. This is used to speed up queries. Not very nice, but it works.';


--
-- Name: testinstance_id_seq; Type: SEQUENCE; Schema: public; Owner: tester
--

CREATE SEQUENCE testinstance_id_seq
    START WITH 20
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE testinstance_id_seq OWNER TO tester;

--
-- Name: testinstance_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: tester
--

ALTER SEQUENCE testinstance_id_seq OWNED BY testinstance.id;


--
-- Name: testinstance_with_testbed; Type: TABLE; Schema: public; Owner: tester; Tablespace: 
--

CREATE TABLE testinstance_with_testbed (
    id integer,
    name character varying,
    testdefinition_id character varying,
    enabled boolean,
    frequency_id integer,
    next_run timestamp with time zone,
    last_run timestamp with time zone,
    testbed_id text,
    testbed_categories character varying[],
    last_result_id bigint,
    allow_restart boolean,
    test_version_name character varying(20),
    testbed_geni_id character varying(20),
    testbed_geni_href character varying,
    last_result_id_excluding_cancelled bigint,
    testbed_urn character varying,
    test_statistics jsonb,
    last_result_date timestamp with time zone,
    last_result_excluding_cancelled_date timestamp with time zone
);

ALTER TABLE ONLY testinstance_with_testbed REPLICA IDENTITY NOTHING;


ALTER TABLE testinstance_with_testbed OWNER TO tester;



--
-- Name: testinstance_with_testbed_nocat; Type: TABLE; Schema: public; Owner: tester; Tablespace:
--

CREATE TABLE testinstance_with_testbed_nocat (
    id integer,
    name character varying,
    testdefinition_id character varying,
    enabled boolean,
    frequency_id integer,
    next_run timestamp with time zone,
    last_run timestamp with time zone,
    testbed_id text,
    last_result_id bigint,
    allow_restart boolean,
    test_version_name character varying(20),
    testbed_geni_id character varying(20),
    testbed_geni_href character varying,
    last_result_id_excluding_cancelled bigint,
    testbed_urn character varying,
    test_statistics jsonb,
    last_result_date timestamp with time zone,
    last_result_excluding_cancelled_date timestamp with time zone
);

ALTER TABLE ONLY testinstance_with_testbed_nocat REPLICA IDENTITY NOTHING;


ALTER TABLE testinstance_with_testbed_nocat OWNER TO tester;
--
-- Name: sfa_user; Type: TABLE; Schema: public; Owner: tester; Tablespace:
--

CREATE TABLE sfa_user (
    id character varying NOT NULL,
    password_filename character varying,
    pem_key_and_cert_filename character varying,
    user_authority_urn character varying
);


ALTER TABLE sfa_user OWNER TO tester;

--
-- Name: id; Type: DEFAULT; Schema: public; Owner: tester
--

ALTER TABLE ONLY frequency ALTER COLUMN id SET DEFAULT nextval('frequency_id_seq'::regclass);


--
-- Name: result_id; Type: DEFAULT; Schema: public; Owner: tester
--

ALTER TABLE ONLY result ALTER COLUMN id SET DEFAULT nextval('result_resultid_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: tester
--

ALTER TABLE ONLY task ALTER COLUMN id SET DEFAULT nextval('task_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: tester
--

ALTER TABLE ONLY testbed_category ALTER COLUMN id SET DEFAULT nextval('testbed_category_id_seq'::regclass);


--
-- Name: testinstance_id; Type: DEFAULT; Schema: public; Owner: tester
--

ALTER TABLE ONLY testinstance ALTER COLUMN id SET DEFAULT nextval('testinstance_id_seq'::regclass);


--
-- Name: admin_pkey; Type: CONSTRAINT; Schema: public; Owner: tester; Tablespace:
--

ALTER TABLE ONLY admin
    ADD CONSTRAINT admin_pkey PRIMARY KEY (active_config);


--
-- Name: frequency_pkey; Type: CONSTRAINT; Schema: public; Owner: tester; Tablespace:
--

ALTER TABLE ONLY frequency
    ADD CONSTRAINT frequency_pkey PRIMARY KEY (id);


--
-- Name: parameter_definition_pkey; Type: CONSTRAINT; Schema: public; Owner: tester; Tablespace:
--

ALTER TABLE ONLY parameter_definition
    ADD CONSTRAINT parameter_definition_pkey PRIMARY KEY (testdefinition_id, key);


--
-- Name: results_pkey; Type: CONSTRAINT; Schema: public; Owner: tester; Tablespace:
--


--
-- Name: subresult_pkey; Type: CONSTRAINT; Schema: public; Owner: tester; Tablespace:
--

ALTER TABLE ONLY subresult
    ADD CONSTRAINT subresult_pkey PRIMARY KEY (result_id, key);


--
-- Name: task_pkey; Type: CONSTRAINT; Schema: public; Owner: tester; Tablespace:
--


--
-- Name: testbed_categories_name_key; Type: CONSTRAINT; Schema: public; Owner: tester; Tablespace:
--

ALTER TABLE ONLY testbed_category
    ADD CONSTRAINT testbed_categories_name_key UNIQUE (name);


--
-- Name: testbed_categories_pkey; Type: CONSTRAINT; Schema: public; Owner: tester; Tablespace:
--

ALTER TABLE ONLY testbed_category
    ADD CONSTRAINT testbed_categories_pkey PRIMARY KEY (id);


--
-- Name: testbed_pkey; Type: CONSTRAINT; Schema: public; Owner: tester; Tablespace:
--

ALTER TABLE ONLY testbed
    ADD CONSTRAINT testbed_pkey PRIMARY KEY (id);


--
-- Name: testdefinition_pkey; Type: CONSTRAINT; Schema: public; Owner: tester; Tablespace:
--

ALTER TABLE ONLY testdefinition
    ADD CONSTRAINT testdefinition_pkey PRIMARY KEY (id);


--
-- Name: testinstance_pkey; Type: CONSTRAINT; Schema: public; Owner: tester; Tablespace:
--

ALTER TABLE ONLY testinstance
    ADD CONSTRAINT testinstance_pkey PRIMARY KEY (id);


--
-- Name: testinstance_name_key; Type: CONSTRAINT; Schema: public; Owner: tester; Tablespace:
--

ALTER TABLE ONLY testinstance
    ADD CONSTRAINT testinstance_name_key UNIQUE (name);


--
-- Name: unique_key_tiid_paramname; Type: CONSTRAINT; Schema: public; Owner: tester; Tablespace:
--

ALTER TABLE ONLY parameter_instance
    ADD CONSTRAINT unique_key_tiid_paramname UNIQUE (testinstance_id, key);


--
-- Name: sfa_user_pkey; Type: CONSTRAINT; Schema: public; Owner: tester; Tablespace:
--

ALTER TABLE ONLY sfa_user
    ADD CONSTRAINT sfa_user_pkey PRIMARY KEY (id);


--
-- Name: category_index; Type: INDEX; Schema: public; Owner: tester; Tablespace: 
--

CREATE INDEX category_index ON testbed_category_mapping USING btree (category_id);


--
-- Name: deadline_index; Type: INDEX; Schema: public; Owner: tester; Tablespace: 
--

CREATE INDEX task_deadline_index ON task USING btree (deadline);
CREATE INDEX task_stop_index ON task USING btree (stop);


--
-- Name: results_testinstance_id_timestamp_desc; Type: INDEX; Schema: public; Owner: tester; Tablespace: 
--

CREATE INDEX results_testinstance_id_timestamp_desc ON result USING btree (testinstance_id, created DESC);


--
-- Name: results_timestamp_desc; Type: INDEX; Schema: public; Owner: tester; Tablespace: 
--

CREATE INDEX results_timestamp_desc ON result USING btree (created DESC);


--
-- Name: testbed_id_index; Type: INDEX; Schema: public; Owner: tester; Tablespace: 
--

CREATE INDEX testbed_id_index ON testbed_category_mapping USING hash (testbed_id);


--
-- Name: testinstance_fkey_index; Type: INDEX; Schema: public; Owner: tester; Tablespace: 
--

CREATE INDEX test_instance_fkey_index ON task USING btree (testinstance_id);


--
-- Name: _RETURN; Type: RULE; Schema: public; Owner: tester
--

CREATE RULE "_RETURN" AS
    ON SELECT TO testinstance_with_testbed DO INSTEAD  SELECT t.id,
    t.name,
    t.testdefinition_id,
    t.enabled,
    t.frequency_id,
    t.next_run,
    t.last_run,
    pi.value AS testbed_id,
    array_agg(tc.name) AS testbed_categories,
    t.last_result_id,
    t.allow_restart,
    t.test_version_name,
    tb.geni_id AS testbed_geni_id,
    tb.geni_href AS testbed_geni_href,
    t.last_result_id_excluding_cancelled,
    tb.urn AS testbed_urn,
    t.test_statistics,
    t.last_result_date,
    t.last_result_excluding_cancelled_date
   FROM ((((testinstance t
     LEFT JOIN parameter_instance pi ON (((pi.testinstance_id = t.id) AND (pi.key = 'testbed'::text))))
     LEFT JOIN testbed tb ON ((pi.value = (tb.id)::text)))
     LEFT JOIN testbed_category_mapping tbc ON ((pi.value = (tbc.testbed_id)::text)))
     LEFT JOIN testbed_category tc ON ((tbc.category_id = tc.id)))
  GROUP BY t.id, pi.value, tb.id;

CREATE RULE "_RETURN" AS
    ON SELECT TO testinstance_with_testbed_nocat DO INSTEAD  SELECT t.id,
    t.name,
    t.testdefinition_id,
    t.enabled,
    t.frequency_id,
    t.next_run,
    t.last_run,
    pi.value AS testbed_id,
    t.last_result_id,
    t.allow_restart,
    t.test_version_name,
    tb.geni_id AS testbed_geni_id,
    tb.geni_href AS testbed_geni_href,
    t.last_result_id_excluding_cancelled,
    tb.urn AS testbed_urn,
    t.test_statistics,
    t.last_result_date,
    t.last_result_excluding_cancelled_date
   FROM ((testinstance t
     LEFT JOIN parameter_instance pi ON (((pi.testinstance_id = t.id) AND (pi.key = 'testbed'::text))))
     LEFT JOIN testbed tb ON ((pi.value = (tb.id)::text)));

--
-- Name: _RETURN; Type: RULE; Schema: public; Owner: tester
--

CREATE RULE "_RETURN" AS
    ON SELECT TO result_with_testbed DO INSTEAD  SELECT r.id,
    r.log_file,
    r.created,
    r.log_url,
    r.summary,
    r.expire,
    p.value AS testbed_id,
    array_agg(tc.name) AS testbed_categories,
    r.prev_result_id
   FROM (((result r
     LEFT JOIN parameter_instance p USING (testinstance_id))
     LEFT JOIN testbed_category_mapping tbc ON ((p.value = (tbc.testbed_id)::text)))
     LEFT JOIN testbed_category tc ON ((tbc.category_id = tc.id)))
  WHERE (p.key = 'testbed'::text)
  GROUP BY r.id, p.value;


--
-- Name: frequency_id; Type: FK CONSTRAINT; Schema: public; Owner: tester
--

ALTER TABLE ONLY testinstance
    ADD CONSTRAINT frequency_id FOREIGN KEY (frequency_id) REFERENCES frequency(id) ON DELETE SET NULL;


--
-- Name: parameter_definition_testdefinition_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: tester
--

ALTER TABLE ONLY parameter_definition
    ADD CONSTRAINT parameter_definition_testdefinition_id_fkey FOREIGN KEY (testdefinition_id) REFERENCES testdefinition(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: results_testinstance_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: tester
--

ALTER TABLE ONLY result
    ADD CONSTRAINT results_testinstance_id_fkey FOREIGN KEY (testinstance_id) REFERENCES testinstance(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: subresult_resultid_fkey; Type: FK CONSTRAINT; Schema: public; Owner: tester
--

ALTER TABLE ONLY subresult
    ADD CONSTRAINT subresult_resultid_fkey FOREIGN KEY (result_id) REFERENCES result(id) ON DELETE CASCADE;


--
-- Name: task_testinstance_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: tester
--

ALTER TABLE ONLY task
    ADD CONSTRAINT task_testinstance_id_fkey FOREIGN KEY (testinstance_id) REFERENCES testinstance(id) ON DELETE CASCADE;


ALTER TABLE ONLY testbed
    ADD CONSTRAINT testbed_organisation_id_fkey FOREIGN KEY (organisation_id) REFERENCES organisation(id) ON DELETE SET NULL;

--
-- Name: testbed_category_mapping_category_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: tester
--

ALTER TABLE ONLY testbed_category_mapping
    ADD CONSTRAINT testbed_category_mapping_category_id_fkey FOREIGN KEY (category_id) REFERENCES testbed_category(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: testbed_category_mapping_testbed_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: tester
--

ALTER TABLE ONLY testbed_category_mapping
    ADD CONSTRAINT testbed_category_mapping_testbed_id_fkey FOREIGN KEY (testbed_id) REFERENCES testbed(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: testinstance_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: tester
--

ALTER TABLE ONLY parameter_instance
    ADD CONSTRAINT testinstance_id_foreign FOREIGN KEY (testinstance_id) REFERENCES testinstance(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: testinstance_last_result_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: tester
--

ALTER TABLE ONLY testinstance
    ADD CONSTRAINT testinstance_last_result_id_fkey FOREIGN KEY (last_result_id) REFERENCES result(id) ON DELETE SET NULL;


--
-- Name: testinstance_testdefinition_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: tester
--

ALTER TABLE ONLY testinstance
    ADD CONSTRAINT testinstance_testdefinition_id_fkey FOREIGN KEY (testdefinition_id) REFERENCES testdefinition(id);



CREATE VIEW testbed_with_categories AS
 SELECT t.id,
    t.iface_url,
    t.urn,
    t.info_url,
    t.long_name,
    t.help_url,
    t.ping_host,
    t.otrs_name,
    t.description,
    t.geni_id,
    t.geni_href,
    array_agg(tc.name) AS categories,
    array_agg(tc.id) AS category_ids,
    t.organisation_id,
    allow_links,
    color,
    logo,
    nodes_location_visualisation_coordinates_url,
    nodes_location_visualisation_image_url,
    t.proxy_id
   FROM ((testbed t
     LEFT JOIN testbed_category_mapping tbc ON (((t.id)::text = (tbc.testbed_id)::text)))
     LEFT JOIN testbed_category tc ON ((tbc.category_id = tc.id)))
  GROUP BY t.id
  ORDER BY t.id;

ALTER TABLE testbed_with_categories OWNER TO tester;

