-- noinspection SqlNoDataSourceInspectionForFile

INSERT INTO frequency VALUES (1, '17 4 * * 0', 'Each saturday night at 04:17');
INSERT INTO frequency VALUES (2, '*/5 * * * *', 'Each 5 minutes');
INSERT INTO frequency VALUES (3, '3 3 31 2 0', 'Never (sun 31 feb at 3:03)');

INSERT INTO admin (use_alt_emails,disable_emails,disable_prod_tests,disable_all_tests,maintenance_message,active_config)
VALUES (false, false, false, false, 'blah', true);

INSERT INTO sfa_user VALUES ('tester-a', 'tester', 'urn:publicid:IDN+a.example.com+authority+cm', 'blah blih bloh', false);
INSERT INTO sfa_user VALUES ('fail-b', 'fail', 'urn:publicid:IDN+b.example.com+authority+cm', 'blah2 blih2 bloh2', true);

INSERT INTO organisation VALUES ('iminds', 'iMinds',
                                 'http://www.iminds.be/~/media/iminds/images/general/logo_iminds.ashx',
                                 'http://ilabt.iminds.be',
                                 'BE;51.05;3.733333;Ghent University - iMinds, Gaston Crommenlaan 8 (Bus 201), B-9050 Gent, Belgium',
                                 '{ "one@example.com", "two@example.com" }');
INSERT INTO organisation VALUES ('testorg', 'Test Organisation', NULL, NULL, NULL, NULL);

INSERT INTO testbed VALUES ('A',
  'http://www.example.com/a', 'urn:publicid:IDN+a.example.com+authority+cm',
  'http://www.example.com/doc/', 'Fake Testbed 1: A', 'http://www.example.com/help.html',
  'www.a.example.com', 'OTRS A', 'Description of A', 'ex-a', 'https://example.com/info/aggregate/ex-a',
                            'iminds', true, 'red', 'logoA', 'yy', 'xx',
                            NULL, --proxy_id
                            99,  --default_server_id
                            '{ "tech1@example.com", "tech2@example.com" }', --technical_contact_emails
                            '{ "prim1@example.com", "prim2@example.com" }', --primary_contact_emails
                            '{ "gdpr1@example.com", "gdpr2@example.com" }', --gdpr_contact_emails
                            '{ "urn:publicid:IDN+a.example.com+user+mra", "urn:publicid:IDN+a.example.com+user+admin" }', --testbed_admin_urns
                            '{ "emulab", "gcf", "openstack" }', --software
                            'This is the primary fake test Testbed', --notes
                            $${
                                "@type": "F4FFederationStatus",

                                "serverAdded": true,
                                "resourceAdded": true,
                                "testsAdded": true,
                                "basicTestsPassedOnce": true,
                                "loginTestPassedOnce": true,
                                "dbInfoComplete": true,
                                "internalMonitoringAdded": true,

                                "ipOK": true,
                                "dnsOK": true,
                                "urnOK": true,
                                "certificateOK": true,
                                "sshOK": true,
                                "getVersionInfoOK": true,

                                "summary": "Fully federated",
                                "summaryChangeDate": "2018-01-01T17:00:00Z",

                                "notes": "Notes on Federation details"
                              }$$::jsonb, --f4fFederationStatus
                              $${
                                  "@type": "GDPRInfo",
                                  "grpdUrl": "http://example.com/gdpr",
                                  "acceptPeriodInDays": 300,
                                  "acceptSubject": "SLICE",
                                  "version": "2"
                                }$$
);
INSERT INTO testbed VALUES (
  'B', 'https://www.example.com/b', 'urn:publicid:IDN+b.example.com+authority+cm', 'http://www.example.com/doc/',
       'Fake Testbed 2: B', 'http://www.example.com/gelp.html', 'www.b.example.com', 'OTRS B', NULL,
       'ex-b', 'https://example.com/info/aggregate/ex-b', 'testorg', false, 'blue', 'logoB', NULL, NULL,
  NULL, --proxy_id
  100,  --default_server_id
  '{ "three@example.com", "four@example.com" }'
);
INSERT INTO testbed VALUES (
  'C', 'http://www.example.com:8080/c', 'urn:publicid:IDN+c.example.com:cc+authority+cm', NULL,
       'Fake Testbed 3: C', 'http://www.example.com/helpc.html', '10.216.69.137', NULL, NULL, NULL, NULL,
  'iminds', false, NULL, NULL, NULL, NULL,
  NULL, --proxy_id
  101,  --default_server_id,
  NULL
);

INSERT INTO testbed_category VALUES (0, 'oneAndTwo');
INSERT INTO testbed_category VALUES (1, 'one', FALSE);
INSERT INTO testbed_category VALUES (3, 'none', TRUE);

INSERT INTO testbed_category_mapping VALUES ('A', 0);
INSERT INTO testbed_category_mapping VALUES ('A', 1);
INSERT INTO testbed_category_mapping VALUES ('B', 0);

INSERT INTO server VALUES (99, 'A',
                               'Server A', 'aliasA', 'X509 CERTIFICATE PLACEHOLDER',
                               'http://www.example.com/', 'US;1.0;1.0;addressA',
                               'test', 'a.example.com',
                               '{ "featureStitching", "fedmonHasNodeAvailabilityDetails", "workaroundForceAmv2Describe" }',   --flags
                               '{ 101, 102 }',                             --scs
                           '{ 103 }',                                      --user_auth
                           101,                                            --default_scs
                           103,                                            --default_user_auth
                           'urn:publicid:IDN+a.example.com+authority+cm',  --default_urn
                           104                                             --default_am
);
INSERT INTO server VALUES (100, 'B',
                                'Server B', 'aliasB', 'X509 CERTIFICATE PLACEHOLDER 2',
                                'https://www.example.com/', 'BE;2.0;2.0;',
                                'test', 'b.example.com',
                                '{ "featurePoaShareLan", "workaroundRemoveAbacCredential", "excludeInConnectivityTest" }', --flags
                                '{ 101 }',                                   --scs
                           '{ 103 }',                                        --user_auth
                           101,                                              --default_scs
                           103,                                              --default_user_auth
                           'urn:publicid:IDN+b.example.com+authority+cm',     --default_urn
                           201                                                --default_am
);

INSERT INTO server VALUES (101, 'C',
                                'Server C', 'aliasC', 'X509 CERTIFICATE PLACEHOLDER 3',
                                NULL, NULL,
                                NULL, NULL,
                                NULL, --flags
                                NULL,                                         --scs
                           NULL,                                              --user_auth
                           NULL,                                              --default_scs
                           NULL,                                              --default_user_auth
                           'urn:publicid:IDN+c.example.com:cc+authority+cm',  --default_urn
                           NULL                                               --default_am
);

INSERT INTO service VALUES (101, 99,  'SCS',          '1', 'urn:publicid:IDN+a.example.com+authority+scs', 'http://www.example.com/scs/1/');
INSERT INTO service VALUES (102, 99,  'SCS',          '1', 'urn:publicid:IDN+a.example.com+authority+scs', 'http://www.example.com/scs/2/');
INSERT INTO service VALUES (103, 99,  'ProtoGeni.SA', '2', 'urn:publicid:IDN+a.example.com+authority+sa',  'http://www.example.com/sa/2/');
INSERT INTO service VALUES (104, 99,  'Geni.AM',      '3', 'urn:publicid:IDN+a.example.com+authority+cm',  'http://www.example.com/am/3/');
INSERT INTO service VALUES (200, 100, 'Geni.AM',      '2', 'urn:publicid:IDN+b.example.com+authority+cm',  'https://www.example.com/b/am2/');
INSERT INTO service VALUES (201, 100, 'Geni.AM',      '3', 'urn:publicid:IDN+b.example.com+authority+cm',  'https://www.example.com/b/am3/');

INSERT INTO proxy VALUES (42, 'Test Proxy', 'SSH', 'example.com', '22,443,8022-8024', 'ssh-rsa blablabla=');

UPDATE testbed SET proxy_id=42 WHERE id='A';

-- TestDefinition
--
-- id
-- test_type
-- geni_datastore_metric
-- geni_datastore_description
-- geni_datastore_units
-- max_test_duration_ms
-- has_user_parameter
-- has_server_parameter
-- parameter_definition

INSERT INTO testdefinition VALUES ('ping', 'ping', NULL, NULL, NULL, 120000, false, true,
                                   $$[
                                     {
                                       "name": "user",
                                       "type": "user",
                                       "description": "The user providing the PEM login file containing the private key and certificate that are used for this test",
                                       "defaultValue": null,
                                       "nonNullValueRequired" : true
                                     },
                                     {
                                       "name": "warning_threshold_ms",
                                       "type": "long",
                                       "description": "Ping RTT (in ms) after which the ping test status is set to warning instead of success.",
                                       "defaultValue": 1000,
                                       "nonNullValueRequired" : true
                                     },
                                     {
                                       "name": "timeout_ms",
                                       "type": "long",
                                       "description": "Timeout (in ms) of the ping command. This is used to generate the ping command, and is not used when the command is overwritten.",
                                       "defaultValue": 5000,
                                       "nonNullValueRequired" : true
                                     },
                                     {
                                       "name": "override_command",
                                       "type": "string",
                                       "description": "If specified, this command will be used instead of an automatically constructed ping command. This command should only return one thing: a double representing the number of milliseconds RTT.",
                                       "defaultValue": null,
                                       "nonNullValueRequired" : false
                                     },
                                     { "name": "use_proxy",
                                       "type": "boolean",
                                       "description": "If set, the ping command will be changed so that it is run from the proxy at bastion.test.iminds.be (if override_command is used, this option is ignored, as the command created by this option is overwritten)",
                                       "defaultValue": "false",
                                       "nonNullValueRequired" : true
                                     },
                                     {
                                       "name": "list_test",
                                       "type": "list of string",
                                       "description": "a list of strings",
                                       "defaultValue": null,
                                       "nonNullValueRequired" : false
                                     }
                                   ]$$::jsonb);
INSERT INTO testdefinition VALUES ('anyGetVersion', 'anyGetVersion', 'is_available', 'Is aggregate manager responsive', 'boolean', 300000, true, true,
                                   $$[
                                     {
                                       "name": "context-file",
                                       "type": "file-content",
                                       "description": "Content of the context-file to use for this test. (Leave empty to use default)",
                                       "defaultValue": "username = <user.username>\npasswordFilename = <user.passwordfilename>\npemKeyAndCertFilename = <user.pemkeyandcertfilename>\nuserAuthorityUrn = <user.userauthorityurn>\ntestedAggregateManagerUrn = <testbed.urn>\nbe_less_strict = false\ndisable_compliance_tests = false\n\nam_version = <am_version>",
                                       "nonNullValueRequired" : true
                                     },
                                     {
                                       "name": "am_version",
                                       "type": "string",
                                       "description": "The aggregate manager version to use. Options: \"2\", \"3\" or \"auto\"",
                                       "defaultValue": "auto",
                                       "nonNullValueRequired" : true
                                     },
                                     {
                                       "name": "alternative_test_class",
                                       "type": "string",
                                       "description": "Alternative Automated Tester Test Class to use. (When not specified, TestAnyGetVersion is used)",
                                       "defaultValue": null,
                                       "nonNullValueRequired" : false
                                     },
                                     {
                                       "name": "email",
                                       "type": "TestEmailConfig",
                                       "description": "Configuration of \"if\", \"which\" and \"to who\" emails should be sent on test completion",
                                       "defaultValue": {
                                         "@type" : "TestEmailConfig",
                                         "addresses" : [ "test@example.com" ]
                                       },
                                       "nonNullValueRequired" : false
                                     }
                                   ]$$::jsonb);

-- TestInstance
--
--  id
--  name
--  testdefinition_id
--  enabled
--  frequency_id
--  next_run
--  last_run
--  test_version_name
--  allow_restart
--  user_parameter_value
--  server_parameter_value
--  parameter_values
--
--  last_result_id
--  last_result_id_excluding_cancelled
--  last_result_date
--  last_result_excluding_cancelled_date
--  test_statistics
--
--  selftest_immune
--
-- summation

INSERT INTO testinstance VALUES (9, 'pingA', 'ping', true, 1, '2015-11-30 13:10:00+01', '2015-11-30 13:00:00+01', 'prod', true,  NULL, NULL, DEFAULT ,
                                 NULL, NULL, NULL, NULL, NULL, false);
INSERT INTO testinstance VALUES (10, 'getVersionB', 'anyGetVersion', true, 2, '2015-11-30 12:59:00+01', '2015-11-30 12:50:00+01', 'test', true,  NULL, NULL, DEFAULT,
                                 NULL, NULL, NULL, NULL, '{ "metric" : "failure", "unit" : "times", "dayTotal" : 6.0, "weekTotal" : 2.0, "monthTotal" : 15.0 }'::jsonb, false,
                                 '{ "unit" : "times", "year" : {"success": 50.0, "warning": 0.0, "failure": 40.0, "total" : 100.0, "nonFailurePercent": 1.0, "successPercent": 99.0}, "week" : {"success": 5.0, "warning": 2.0, "failure": 4.0, "total" : 10.0, "nonFailurePercent": 0.0, "successPercent": 100.0}, "month" : {"success": 55.0, "warning": 1.0, "failure": 44.0, "total" : 110.0, "nonFailurePercent": 0.0, "successPercent": 110.0}, "day" : {"success": 0.0, "warning": 3.0, "failure": 10.0, "total" : 20.0, "nonFailurePercent": 5.0, "successPercent": 60.0} }'::jsonb);
INSERT INTO testinstance VALUES (11, 'pingB', 'ping', false, 1, '2015-11-30 12:59:00+01', '2015-11-30 11:00:00+01', 'test', false, NULL, NULL, DEFAULT,
                                 NULL, NULL, NULL, NULL, NULL, true);
INSERT INTO testinstance VALUES (12, 'getVersionA', 'anyGetVersion', true, 3, '2015-11-30 11:00:00+01', '2015-11-30 10:00:00+01', 'prod',  true, NULL, NULL, DEFAULT,
                                 NULL, NULL, NULL, NULL, NULL, false);
INSERT INTO testinstance VALUES (13, 'getVersionC', 'anyGetVersion', true, 3, '50000-01-01 00:00:00+00', NULL, 'prod', true, NULL, NULL, DEFAULT,
                                 NULL, NULL, NULL, NULL, NULL, false);
INSERT INTO testinstance VALUES (14, 'pingC', 'ping', true, 3, '50000-01-01 00:00:00+00', '2015-11-30 12:50:00+01', 'prod', true, NULL, NULL, DEFAULT,
                                 NULL, NULL, NULL, NULL, NULL, false);

INSERT INTO task VALUES (1, 9, '2015-11-30 13:00:00+01', '2015-11-30 13:05:00+01', NULL, '/test/test.log', NULL, 'test run info', 'CREATED');
INSERT INTO task VALUES (2, 10, '2015-11-30 13:00:00+01', '2015-11-30 13:05:00+01', NULL, '/test/test2.log', NULL, 'test run info', 'RUNNING');
INSERT INTO task VALUES (3, 10, '2015-11-30 12:55:00+01', '2015-11-30 12:59:00+01', '2015-11-30 12:57:00+01', '/test/test3.log', 2, 'test run info', 'FINISHED');
INSERT INTO task VALUES (4, 9, '2015-11-30 12:55:00+01', '2015-11-30 12:59:00+01', '2015-11-30 12:58:00+01', '/test/test4.log', NULL, 'test run info', 'CANCELLED');

-- Result
--
-- id
-- testinstance_id
-- log_file
-- created
-- log_url
-- summary
-- expire
-- prev_result_id
-- details

INSERT INTO result VALUES (1, 9, '/log/result/1', '2015-11-30 13:00:00+01', 'http://localhost/results/log/result/1', 'SUCCESS', '2015-11-30 13:20:00+01', NULL,
                           '{ "subres1" : "1", "subres2" : "2" }'::jsonb);
INSERT INTO result VALUES (2, 10, '/log/result/2', '2015-11-30 12:50:00+01', 'http://localhost/results/log/result/2', 'FAILURE', '2015-11-30 13:01:00+01', NULL,
                           $${
                             "subres1" : "1b",
                             "subresLong1" : 1,
                             "subresInt2" : 2,
                             "subresNest3" : { "SUB3" : 3 },
                             "subresNest4" : {
                               "SUB4a" : { "SUB4aSUB": "deep" },
                               "SUB4b" : [ 4, "four" ]
                             },
                             "subresList5" : [ 5, "five" ]
                           }$$::jsonb);
INSERT INTO result VALUES (3, 11, '/log/result/3', '2015-11-30 12:50:00+01', 'http://localhost/results/log/result/3', 'WARNING', '2015-11-30 13:01:00+01', NULL,
                           '{ "subres1" : "1d", "subres2" : "2d" }'::jsonb);
INSERT INTO result VALUES (4, 11, '/log/result/4', '2015-11-30 13:00:00+01', 'http://localhost/results/log/result/4', 'CANCELLED', '2015-11-30 13:20:00+01', 3,
                           '{ "cancelled" : true }'::jsonb);
INSERT INTO result VALUES (5, 12, '/log/result/5', '2015-11-28 13:00:00+01', 'http://localhost/results/log/result/5', 'FAILURE', '2015-11-29 13:20:00+01', NULL, '{}' :: JSONB);
INSERT INTO result VALUES (6, 12, '/log/result/6', '2015-11-29 13:00:00+01', 'http://localhost/results/log/result/6', 'WARNING', '2015-11-30 13:20:00+01', 5, '{}' :: JSONB);
INSERT INTO result VALUES (7, 12, '/log/result/7', '2015-11-30 13:00:00+01', 'http://localhost/results/log/result/7', 'SUCCESS', '2015-12-01 13:20:00+01', 6, DEFAULT);

UPDATE testinstance SET last_result_id=1,last_result_id_excluding_cancelled=1,
  last_result_date='2015-11-30 13:00:00+01',last_result_excluding_cancelled_date='2015-11-30 13:00:00+01',
  server_parameter_value=99, user_parameter_value='tester-a',
  parameter_values='{ "use_proxy" : "true" }'::jsonb
WHERE id=9;

UPDATE testinstance SET last_result_id=2,last_result_id_excluding_cancelled=2,
  last_result_date='2015-11-30 12:50:00+01',last_result_excluding_cancelled_date='2015-11-30 12:50:00+01',
  server_parameter_value=100, user_parameter_value=NULL,
  parameter_values=$${
    "am_version" : "2",
    "email" : {
      "@type" : "TestEmailConfig",
      "addresses" : [ "test@example.com", "test2@example.com" ],
      "altAddresses" : [ "alt@example.com" ],
      "limits" : {
        "maxPerDay": 1,
        "maxPerHour": 2
      },
      "triggers" : [
        {
          "requiredStatus": "FAILURE",
          "onlyForFirst" : false,
          "negation" : false,
          "subject": "Another Failure",
          "body": "bad"
        },
        {
          "requiredStatus": "FAILURE",
          "onlyForFirst" : true,
          "negation" : false,
          "repeatCron" : "0 9 * * 1",
          "subject": "A First Failure",
          "body": "first bad"
        },
        {
          "requiredStatus": "WARNING",
          "onlyForFirst" : true,
          "negation" : false,
          "subject": "Possible Problem",
          "body": "warning\nwarning\nwarning\n"
        },
        {
          "requiredStatus": "SUCCESS",
          "onlyForFirst" : true,
          "negation" : false,
          "subject": "All OK again",
          "body": "good"
        },
        {
          "requiredStatus": "FAILURE",
          "onlyForFirst" : true,
          "negation" : true,
          "subject": "Not failing anymore",
          "body": "first non bad"
        }
      ]
    },
    "list_test" : [ "blah", "blih", "bloh" ]
  }$$::jsonb
WHERE id=10;

UPDATE testinstance SET last_result_id=4,last_result_id_excluding_cancelled=3,
  last_result_date='2015-11-30 13:00:00+01',last_result_excluding_cancelled_date='2015-11-30 12:50:00+01',
  server_parameter_value=100, user_parameter_value=NULL
WHERE id=11;

UPDATE testinstance SET last_result_id=7,last_result_id_excluding_cancelled=7,
  last_result_date='2015-11-30 13:00:00+01',last_result_excluding_cancelled_date='2015-11-30 13:00:00+01',
  server_parameter_value=99, user_parameter_value=NULL
WHERE id=12;

UPDATE testinstance SET server_parameter_value=101, user_parameter_value='tester-a',
  parameter_values=$${ "am_version" : "3", "alternative_test_class" : "Test", "context-file" : "test context file content" }$$::jsonb
WHERE id=13;

UPDATE testinstance SET server_parameter_value=101
WHERE id=14;

INSERT INTO configset VALUES ('testA', '{ 99, 100 }', '{ 100 }', '{ "message" : "test", "switch": true }'::jsonb, $${
  "locations": ["AMS", "LJU", "PRG"],
  "externalDomains": [
    {
      "id": "ams-ep1",
      "location": "AMS",
      "port": "ep1",
      "name": "iMinds #1",
      "description": "from AMS via GN/BRU, BELnet"
    }
  ],
  "gtsToFed4FIREVlans": [{
    "id": "vlan1175",
    "gtsExternalDomain": "ams-ep1",
    "urn": "urn:publicid:IDN+gts1175-edge.ilabt.iminds.be+authority+cm"
  }]
}$$::jsonb,
                              $$[ {
                                "id" : 1,
                                "guiTrigger" : "LOGIN",
                                "title" : "Test Message",
                                "text" : "This is a test message. You can ignore it.",
                                "type" : "INFO",
                                "frequency" : "ALWAYS",
                                "enableDoNotShowAgainButton" : true
                              }
                              ]$$::jsonb,
                              'Test Flag A description',
                              $$[
                              {
                              "id" : 1,
                              "@type" : "LoginSite",
                              "imageId" : "fed4fire",
                              "buttonText" : "test button",
                              "url" : "https://fed4fire.eu/",
                              "urlType" : "GET_PEM"
                              }
                              ]$$::jsonb);
INSERT INTO configset VALUES ('testB', NULL, NULL, '{ "message" : "test2", "switch": false }'::jsonb, NULL, NULL);
INSERT INTO configset VALUES ('testC', '{ 100 }', '{ 99 }', NULL, NULL, NULL);

INSERT INTO resource (id, server_id, rspec_element_name, layer3,
                    require_fixed_node_assignment, require_hardware_type, require_disk_image,
                    allow_fixed_node_assignment, allow_hardware_type, allow_disk_image,
                    "exclusive", allow_modify_exclusive,
                    sliver_type, hardware_type, disk_image, component_urn, allowed_sliver_types,
                    allow_links, allow_stitched_links, default_link_type, allowed_link_types,
                    auto_filter_fixed_nodes_by_hardware_type, auto_filter_fixed_nodes_by_sliver_type,
                    filter_fixed_nodes_by_hardware_type,
                    filter_fixed_nodes_by_sliver_type,
                    link_info, overwrite_server_name, allow_site_selection) VALUES (0, 99, 'node', true,
                                       true, true, false,
                                       true, true, false,
                                       true, false,
                                       'raw-pc', 'hardwareType', 'diskImage', 'componentId', '{ "raw-pc" }',
                                       true, false, 'gre', '{ "gre", "lan" }',
                                       true, true,
                                       '{ "pc1", "pc2" }', '{ "raw-pc" }',
                             $$[ {
                               "filter" : {
                                 "matchSameResource" : true,
                                 "matchAnySameServer" : false,
                                 "matchAnyInterServer" : false,
                                 "matchResourceId" : [ 5, 6 ],
                                 "maxNodeCount" : 2
                               },
                               "rules" : {
                                 "allowLink" : true,
                                 "allowNoLinkType" : false,
                                 "defaultLinkType" : "mylink"
                               }
                             }, {
                               "filter" : {
                                 "matchSameResource" : false,
                                 "matchAnySameServer" : true,
                                 "matchAnyInterServer" : false,
                                 "matchServerId" : [ 7, 8 ]
                               },
                               "rules" : {
                                 "allowLink" : false,
                                 "allowNoLinkType" : true
                               }
                             }
                               ]$$::jsonb, 'Overwritten server name', false);
INSERT INTO resource (id, server_id, rspec_element_name, layer3,
                    require_fixed_node_assignment, require_hardware_type, require_disk_image,
                    allow_fixed_node_assignment, allow_hardware_type, allow_disk_image,
                    "exclusive", allow_modify_exclusive,
                    sliver_type, hardware_type, disk_image, component_urn, allowed_sliver_types,
                    allow_links, allow_stitched_links, default_link_type, allowed_link_types,
                    auto_filter_fixed_nodes_by_hardware_type, auto_filter_fixed_nodes_by_sliver_type,
                    filter_fixed_nodes_by_hardware_type,
                    filter_fixed_nodes_by_sliver_type,
                    link_info, overwrite_server_name, allow_site_selection) VALUES (1, 100, 'node', true,
                                       false, false, false,
                                       true, true, true,
                                       true, false,
                                       'raw-pc', 'hardwareType2', 'diskImage2', 'componentId2', '{ "raw-pc" }',
                                       DEFAULT , DEFAULT, DEFAULT, DEFAULT,
                                       false, false,
                                       '{ "pcX" }', '{ "cooked-pc", "baked-pc" }',
                                       $$[{
                                         "filter" : {
                                           "matchSameResource" : false,
                                           "matchAnySameServer" : false,
                                           "matchAnyInterServer" : true,
                                           "matchCategory" : [ "cat1" ]
                                         },
                                         "rules" : {
                                           "allowLink" : false,
                                           "allowNoLinkType" : false,
                                           "allowedLinkTypes" : [ "mylink1", "mylink2" ]
                                         }
                                       }
                                         ]$$::jsonb, NULL, true);
INSERT INTO resource (id, server_id, rspec_element_name, layer3,
                    require_fixed_node_assignment, require_hardware_type, require_disk_image,
                    allow_fixed_node_assignment, allow_hardware_type, allow_disk_image,
                    "exclusive", allow_modify_exclusive,
                    sliver_type, hardware_type, disk_image, component_urn, allowed_sliver_types,
                    allow_links, allow_stitched_links, default_link_type, allowed_link_types,
                    auto_filter_fixed_nodes_by_hardware_type, auto_filter_fixed_nodes_by_sliver_type,
                    filter_fixed_nodes_by_hardware_type,
                    filter_fixed_nodes_by_sliver_type,
                    link_info) VALUES (2, 100, 'node', false,
                                       false, false, false,
                                       true, true, true,
                                       true, false,
                                       'raw-pc', 'hardwareType3', 'diskImage3', 'componentId3', '{ "raw-pc" }',
                                       DEFAULT, DEFAULT, DEFAULT, DEFAULT,
                                       NULL, NULL,
                                       NULL, NULL,
                                       $$[ {
                                         "filter" : {
                                           "matchSameResource" : false,
                                           "matchAnySameServer" : false,
                                           "matchAnyInterServer" : false,
                                           "matchFederation" : [ "fed1", "fed2" ]
                                         },
                                         "rules" : {
                                           "allowLink" : false,
                                           "allowNoLinkType" : false
                                         }
                                       }
                                         ]$$::jsonb);
INSERT INTO resource (id, server_id, rspec_element_name, layer3,
                    require_fixed_node_assignment, require_hardware_type, require_disk_image,
                    allow_fixed_node_assignment, allow_hardware_type, allow_disk_image,
                    "exclusive", allow_modify_exclusive,
                    sliver_type, hardware_type, disk_image, component_urn, allowed_sliver_types,
                    allow_links, allow_stitched_links, default_link_type, allowed_link_types,
                    auto_filter_fixed_nodes_by_hardware_type, auto_filter_fixed_nodes_by_sliver_type,
                    filter_fixed_nodes_by_hardware_type,
                    filter_fixed_nodes_by_sliver_type,
                    link_info) VALUES (3, 99, 'node', false,
                                       false, false, true,
                                       false, false, true,
                                       false, true,
                                       'xen-vm', NULL, NULL, NULL, '{ "xen-vm", "default-vm" }',
                                       DEFAULT, DEFAULT, DEFAULT, DEFAULT,
                                       NULL, NULL,
                                       NULL, NULL,
                                       NULL);

-- (id,image_url,image_id,
-- hrn,visible_in_toolbox,draggable_from_toolbox,
-- parent_id,instantiate_as_id,default_resource_id,
-- configset_id,weight)
INSERT INTO resourceclass VALUES ('any-pc', NULL, NULL,
                                            'PC', false, false,
                                            NULL, NULL, NULL,
                                            NULL, NULL);
INSERT INTO resourceclass VALUES ('raw-pc', 'http://jfed.iminds.be/raw-pc.png', 'raw-pc',
                                            'Bare Metal PC', true, true,
                                            'any-pc', NULL, '{ 0, 1 }',
                                            '{ "testA" }', 5);
INSERT INTO resourceclass VALUES ('xen-vm', NULL, NULL,
                                            'Xen VM', true, true,
                                            'any-pc', NULL, '{ 3 }',
                                            '{ "testA", "testB" }', 10);
UPDATE resourceclass SET instantiate_as_id='raw-pc' WHERE id = 'any-pc';

INSERT INTO resourceclass_resource_map VALUES ('raw-pc', 0, 'testA');
INSERT INTO resourceclass_resource_map VALUES ('raw-pc', 1, 'testA');
INSERT INTO resourceclass_resource_map VALUES ('xen-vm', 3, 'testA');
INSERT INTO resourceclass_resource_map VALUES ('xen-vm', 3, 'testB');

INSERT INTO userurn_configset_map VALUES('example.com', 'testA');
INSERT INTO userurn_configset_map VALUES('2.example.com', 'testB');
INSERT INTO userurn_configset_map VALUES('3.example.com', 'testC', 'user[0-2].*ok');


-- "availableComponentIds" : [ "urn:publicid:IDN+a.example.com+node+available1", "urn:publicid:IDN+a.example.com+node+available2" ],
--    "unavailableComponentIds" : [ "urn:publicid:IDN+a.example.com+node+used" ],

INSERT INTO serverglimpse VALUES(99, $${
  "componentDetails" : [
    { "id" : "urn:publicid:IDN+a.example.com+node+available1", "hw" : [ "hw1" ], "available" : true },
    { "id" : "urn:publicid:IDN+a.example.com+node+available2", "hw" : [ ], "available" : true },
    { "id" : "urn:publicid:IDN+a.example.com+node+used",       "hw" : [ "hw1", "hw2" ], "available" : false }
  ],
  "componentManagerIds" : [ "urn:publicid:IDN+a.example.com+authority+cm" ],
  "counts": {
    "anyAvailable": 2,
    "anyTotal": 20,
    "rawPCsAvailable": 2,
    "rawPCsTotal": 20,
    "VMsAvailable": 1,
    "VMsTotal": 100,
    "Ipv4sAvailable": 509,
    "Ipv4sTotal": 510,
    "OpenflowsAvailable": 0,
    "OpenflowsTotal": 0
  },
  "hwCounts" : {
    "pcgen1Available": 2,
    "pcgen1Total":  4
  },
  "diskImages": [{
    "description": "desc5",
    "name": "urn:publicid:IDN+a.example.com+image+img5",
    "os": "os5",
    "sliverTypes": ["shared-vm"],
    "url": "http://a.example.com/image/5",
    "version": "ver5"
  }, {
    "description": "desc2",
    "name": "urn:publicid:IDN+a.example.com+image+img2",
    "os": "os2",
    "sliverTypes": ["raw-pc", "raw-pc2", "raw-pc3"],
    "url": "http://a.example.com/image/2",
    "version": "ver2"
  }],
  "result": "http://localhost:9000/result/1",
  "rspec": "http://example.com/rspecs/99/advertisement.rspec",
  "sliverTypeInfo": [{
    "defaultDiskImage": "urn:publicid:IDN+a.example.com+image+img5",
    "hardwareTypes": ["vmB"],
    "sliverType": "shared-vm"
  }, {
    "defaultDiskImage": "urn:publicid:IDN+a.example.com+image+img2",
    "hardwareTypes": ["pcA", "pcB"],
    "sliverType": "raw-pc"
  }, {
    "hardwareTypes": ["ipv4"]
  }],
  "timestamp": "2015-11-30T12:00:00Z"
}$$::jsonb, $${
  "health" : 100,
  "healthExplanation" : "test1",
  "healthExplanationFull" : "Just a 1st test.",
  "result" : "http://localhost:9000/result/2",
  "status" : "SUCCESS",
  "timestamp" : "2015-11-30T12:00:01Z"
}$$::jsonb, NULL, NULL);


--  "availableComponentIds" : [ "urn:publicid:IDN+b.example.com+node+available" ],
--  "unavailableComponentIds" : [ "urn:publicid:IDN+b.example.com+node+used1", "urn:publicid:IDN+b.example.com+node+used2" ],

-- json contains availableComponentIds and unavailableComponentIds, to check if everything is backward compatible
INSERT INTO serverglimpse VALUES(100, $${
  "availableComponentIds" : [ "urn:publicid:IDN+b.example.com+node+available" ],
  "unavailableComponentIds" : [ "urn:publicid:IDN+b.example.com+node+used1", "urn:publicid:IDN+b.example.com+node+used2" ],
  "componentDetails" : [
    { "id" : "urn:publicid:IDN+b.example.com+node+available", "hw" : [ "hw1b", "hw2b" ], "available" : true },
    { "id" : "urn:publicid:IDN+b.example.com+node+used1", "hw" : [ "hw3b" ], "available" : false },
    { "id" : "urn:publicid:IDN+b.example.com+node+used2", "available" : false }
  ],
  "componentManagerIds" : [ "urn:publicid:IDN+b.example.com+authority+cm" ],
  "diskImages": [{
    "description": "desc1",
    "name": "urn:publicid:IDN+b.example.com+image+img1",
    "os": "os1",
    "sliverTypes": ["raw-pcEXTRA"],
    "url": "http://b.example.com/image/1",
    "version": "ver1"
  }],
  "result": {
    "@type": "Result",
    "id": 3
  },
  "rspec": "http://example.com/rspecs/100/advertisement.rspec",
  "sliverTypeInfo": [{
    "defaultDiskImage": "urn:publicid:IDN+b.example.com+image+img1",
    "hardwareTypes": ["pc"],
    "flavors": ["banana", "vanilla"],
    "sliverType": "raw-pc"
  }],
  "timestamp": "2015-11-30T12:00:10Z"
}$$::jsonb, $${
  "health" : 0,
  "healthExplanation" : "test2",
  "healthExplanationFull" : "Just a 2nd test.",
  "result" : {
    "@type": "Result",
    "id": 4
  },
  "status" : "FAILURE",
  "timestamp" : "2015-11-30T12:00:11Z"
}$$::jsonb, 10, $$[ {
  "reported" : "2030-02-18T11:00:00Z",
  "start" : "2030-02-20T12:00:11Z",
  "end" : "2030-02-20T13:15:30Z",
  "message" : "Test Maintenance message",
  "planned" : true
}, {
  "start" : "2030-02-21T12:00:11Z",
  "end" : "2030-02-21T13:15:30Z",
  "message" : "Second test Maintenance message"
} ]$$::jsonb);


INSERT INTO log VALUES(0, 'example.txt', 1, 1, '2015-11-30T12:01:00Z', '2015-11-30T12:10:00Z', true, true,
                       'TEXT',
                       E'This is the test content of log 1\012One more line.\012'::bytea);

INSERT INTO log VALUES(1, 'data.json', NULL, NULL, '2015-11-30T12:11:00Z', NULL, false, false, 'JSON', '');

INSERT INTO log VALUES(2, 'log.bin', NULL, NULL, '2015-11-30T12:18:00Z', NULL, false, false, DEFAULT, E'\\000\\002\\004\\006\\010');


INSERT INTO graph (id,
                   graph_definition_id, sub_type, period_pretty,
                   description, period_in_seconds,
                   test_instance_id, test_definition_id,
                   graph_start_time, graph_end_time,  expire,
                   image_data)
VALUES('test-t-1day',
  'test', 't', '1day',
  'Test Day Graph', 24*60*60,
  9, 'ping',
  '2015-11-30T12:00:00Z', '2015-12-01T12:00:00Z', '2015-12-01T13:00:00Z',
       E'\\000\\001\\002');

INSERT INTO graph (id,
                   graph_definition_id, sub_type, period_pretty,
                   description, period_in_seconds,
                   test_instance_id, test_definition_id,
                   graph_start_time, graph_end_time,  expire,
                   image_data)
VALUES('test2-1hour',
  'test2', NULL, '1hour',
  NULL, NULL,
  NULL, NULL,
  NULL, NULL, NULL,
       NULL);

INSERT INTO federation VALUES (
  'fed1',
  'Federation 1',
  'This is Federation 1',
  'Notes for fed1',
  '{ "http://example.com/fed1" }',
  NULL --parent_federation_id
);

INSERT INTO federation VALUES (
  'fed2',
  'Federation 2',
  NULL,
  NULL,
  NULL,
  NULL --parent_federation_id
);

INSERT INTO federation VALUES (
  'subfed1a',
  'Federation 1a',
  'This is Federation 1a',
  'Notes for fed1a',
  '{ "http://example.com/fed1", "http://example.com/fed1a" }',
  'fed1' --parent_federation_id
);

INSERT INTO testbed_federation_mapping VALUES('A', 'fed1');
INSERT INTO testbed_federation_mapping VALUES('A', 'subfed1a');
INSERT INTO testbed_federation_mapping VALUES('B', 'fed1');
INSERT INTO testbed_federation_mapping VALUES('C', 'fed2');

-- since we ignored sequence, make sure we can still make new rows
ALTER SEQUENCE frequency_id_seq        RESTART WITH 200;
ALTER SEQUENCE log_id_seq              RESTART WITH 200;
ALTER SEQUENCE proxy_id_seq            RESTART WITH 200;
ALTER SEQUENCE resource_id_seq         RESTART WITH 200;
ALTER SEQUENCE result_id_seq           RESTART WITH 200;
ALTER SEQUENCE server_id_seq           RESTART WITH 200;
ALTER SEQUENCE service_id_seq          RESTART WITH 2000;
ALTER SEQUENCE task_id_seq             RESTART WITH 200;
ALTER SEQUENCE testbed_category_id_seq RESTART WITH 200;
ALTER SEQUENCE testinstance_id_seq     RESTART WITH 200;
