/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.bugreport.resource;

import be.iminds.ilabt.jfed.bugreport.model.BugReport;
import be.iminds.ilabt.jfed.bugreport.model.test.BugReportTestCollection;
import be.iminds.ilabt.jfed.bugreport.service.JFedBugReportWebApiApplication;
import be.iminds.ilabt.jfed.bugreport.service.JFedBugReportWebApiConfiguration;
import be.iminds.ilabt.jfed.bugreport.test.BugReportCallTestCollection;
import be.iminds.ilabt.jfed.bugreport.test.JFedBugReportTestPostgresDB;
import be.iminds.ilabt.jfed.call_log_output.SerializableApiCallDetails;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.net.URI;
import java.util.List;
import javax.ws.rs.core.GenericType;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.client.JerseyWebTarget;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class BugReportIntegrationTest {
    @ClassRule
    public static final DropwizardAppRule<JFedBugReportWebApiConfiguration> RULE = new DropwizardAppRule(JFedBugReportWebApiApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    protected static BugReportTestCollection bugReportTestCollection;
    protected static BugReportCallTestCollection bugReportCallTestCollection;
    protected JerseyClient client;

    @BeforeClass
    public static void setUp() throws Exception {
        BugReportIntegrationTest.setUp(RULE);
    }

    public static void setUp(DropwizardAppRule<JFedBugReportWebApiConfiguration> RULE) throws Exception {
        assert (RULE != null);
        JFedBugReportTestPostgresDB testPostgresDB = new JFedBugReportTestPostgresDB(RULE);
        testPostgresDB.recreateDB();
        testPostgresDB.close();
        bugReportTestCollection = new BugReportTestCollection();
        bugReportCallTestCollection = new BugReportCallTestCollection();
    }

    @AfterClass
    public static void tearDown() throws Exception {
    }

    @Before
    public void beforeMethod() throws Exception {
        this.client = new JerseyClientBuilder().build();
        assert (this.client != null);
    }

    public BugReport testLookupBugReport(BugReport expected, int id) throws Exception {
        BugReport actual = this.doLookupBugReport(id);
        this.checkLookupBugReport(expected, actual);
        return actual;
    }

    public BugReport doLookupBugReport(int id) throws Exception {
        assert (this.client != null);
        JerseyWebTarget query = this.client.target(String.format("http://localhost:%d/bugreport/" + id, RULE.getLocalPort()));
        BugReport actual = (BugReport)query.request().get(BugReport.class);
        System.out.println("Got result BugReport: " + actual);
        return actual;
    }

    public void checkLookupBugReport(BugReport expected, BugReport actual) {
        bugReportTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)actual, (JsonLdObjectWithId)expected, true);
    }

    @Test
    public void lookupBugReport0() throws Exception {
        BugReport expected = (BugReport)bugReportTestCollection.getByIndex(0);
        BugReport actual = this.testLookupBugReport(expected, (Integer)expected.getId());
        MatcherAssert.assertThat((Object)actual.getApiCallDetailIds(), (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat((Object)actual.getApiCallDetailUris(), (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat((Object)actual.getApiCallDetailUris(), (Matcher)Matchers.contains((Object[])new URI[]{new URI("http://localhost:9000/bugreport/0/call/11"), new URI("http://localhost:9000/bugreport/0/call/12"), new URI("http://localhost:9000/bugreport/0/call/13")}));
    }

    @Test
    public void lookupBugReport1() throws Exception {
        BugReport expected = (BugReport)bugReportTestCollection.getByIndex(1);
        BugReport actual = this.testLookupBugReport(expected, (Integer)expected.getId());
        MatcherAssert.assertThat((Object)actual.getApiCallDetailIds(), (Matcher)Matchers.hasSize((int)0));
        MatcherAssert.assertThat((Object)actual.getApiCallDetailUris(), (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void lookupBugReport2() throws Exception {
        BugReport expected = (BugReport)bugReportTestCollection.getByIndex(2);
        BugReport actual = this.testLookupBugReport(expected, (Integer)expected.getId());
        MatcherAssert.assertThat((Object)actual.getApiCallDetailIds(), (Matcher)Matchers.hasSize((int)0));
        MatcherAssert.assertThat((Object)actual.getApiCallDetailUris(), (Matcher)Matchers.hasSize((int)0));
    }

    public SerializableApiCallDetails testLookupCall(SerializableApiCallDetails expected, int bugReportId, int callId) throws Exception {
        SerializableApiCallDetails actual = this.doLookupCall(bugReportId, callId);
        this.checkLookupCall(expected, actual);
        return actual;
    }

    public SerializableApiCallDetails doLookupCall(int bugReportId, int callId) throws Exception {
        assert (this.client != null);
        JerseyWebTarget query = this.client.target(String.format("http://localhost:%d/bugreport/" + bugReportId + "/call/" + callId, RULE.getLocalPort()));
        SerializableApiCallDetails actual = (SerializableApiCallDetails)query.request().accept(new String[]{"application/json"}).get(SerializableApiCallDetails.class);
        System.out.println("Got result SerializableApiCallDetails: " + actual);
        return actual;
    }

    public void checkLookupCall(SerializableApiCallDetails expected, SerializableApiCallDetails actual) {
        bugReportCallTestCollection.assertSame(actual, expected);
    }

    public String doLookupCallAsHtml(int bugReportId, int callId) throws Exception {
        assert (this.client != null);
        JerseyWebTarget query = this.client.target(String.format("http://localhost:%d/bugreport/" + bugReportId + "/call/" + callId, RULE.getLocalPort()));
        String actual = (String)query.request().accept(new String[]{"text/html"}).get(String.class);
        return actual;
    }

    public List<SerializableApiCallDetails> doLookupAllCallsMinimal(int bugReportId) throws Exception {
        assert (this.client != null);
        JerseyWebTarget query = this.client.target(String.format("http://localhost:%d/bugreport/" + bugReportId + "/call", RULE.getLocalPort()));
        List actual = (List)query.request().get((GenericType)new GenericType<List<SerializableApiCallDetails>>(){});
        System.out.println("Got result SerializableApiCallDetails: " + actual);
        return actual;
    }

    @Test
    public void lookupCall0() throws Exception {
        SerializableApiCallDetails expected = bugReportCallTestCollection.getByIndex(0);
        this.testLookupCall(expected, 0, expected.getId());
    }

    @Test
    public void lookupCallAsHtml0() throws Exception {
        SerializableApiCallDetails expected = bugReportCallTestCollection.getByIndex(0);
        String html = this.doLookupCallAsHtml(0, expected.getId());
        System.out.print("Got call as HTML: " + html);
        MatcherAssert.assertThat((Object)html, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)html, (Matcher)Matchers.containsString((String)"<html"));
    }

    @Test
    public void lookupCall1() throws Exception {
        SerializableApiCallDetails expected = bugReportCallTestCollection.getByIndex(1);
        this.testLookupCall(expected, 0, expected.getId());
    }

    @Test
    public void lookupCall2() throws Exception {
        SerializableApiCallDetails expected = bugReportCallTestCollection.getByIndex(2);
        this.testLookupCall(expected, 0, expected.getId());
    }

    @Test
    public void lookupAllCallsMinimal() throws Exception {
        List<SerializableApiCallDetails> actual = this.doLookupAllCallsMinimal(0);
        MatcherAssert.assertThat(actual, (Matcher)Matchers.hasSize((int)3));
        for (int i = 0; i < 3; ++i) {
            SerializableApiCallDetails expectedCall = bugReportCallTestCollection.getByIndex(i);
            SerializableApiCallDetails actualCall = actual.get(i);
            MatcherAssert.assertThat((Object)actualCall.getId(), (Matcher)Matchers.is((Object)expectedCall.getId()));
            MatcherAssert.assertThat((Object)actualCall.getAuthorityUrn(), (Matcher)Matchers.is((Object)expectedCall.getAuthorityUrn()));
            MatcherAssert.assertThat((Object)actualCall.getAuthorityName(), (Matcher)Matchers.is((Object)expectedCall.getAuthorityName()));
            MatcherAssert.assertThat((Object)actualCall.getApiName(), (Matcher)Matchers.is((Object)expectedCall.getApiName()));
            MatcherAssert.assertThat((Object)actualCall.getGeniMethodName(), (Matcher)Matchers.is((Object)expectedCall.getGeniMethodName()));
            MatcherAssert.assertThat((String)("wrong stoptime for call " + i), (Object)actualCall.getStopTime(), (Matcher)Matchers.is((Object)expectedCall.getStopTime()));
            MatcherAssert.assertThat((String)("wrong starttime for call " + i), (Object)actualCall.getStartTime(), (Matcher)Matchers.is((Object)expectedCall.getStartTime()));
        }
    }
}

