/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.bugreport.dao;

import be.iminds.ilabt.jfed.bugreport.model.BugReport;
import be.iminds.ilabt.jfed.bugreport.model.BugReportBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.base.dao.DaoCommon;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.jackson.Jackson;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class BugReportMapper
implements ResultSetMapper<BugReport> {
    private static final ObjectMapper MAPPER = Jackson.newObjectMapper();

    public BugReport map(int index, ResultSet r, StatementContext ctx) throws SQLException {
        BugReportBuilder bugReport;
        if (BugReportMapper.hasColumn(r, "content_json_text")) {
            BugReport base;
            String json = r.getString("content_json_text");
            try {
                base = (BugReport)MAPPER.readValue(json, BugReport.class);
            }
            catch (JsonProcessingException e) {
                throw new WebApplicationException("Error converting BugReport from JSON in DB", (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
            }
            catch (IOException e) {
                throw new WebApplicationException("IOException converting BugReport from JSON in DB", (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
            }
            bugReport = new BugReportBuilder(base);
        } else {
            bugReport = new BugReportBuilder();
        }
        if (BugReportMapper.hasColumn(r, "bugreport$call_ids")) {
            List callIds = DaoCommon.rowIntegerArray((ResultSet)r, (String)"bugreport$call_ids");
            bugReport.setApiCallDetailIds(callIds);
        }
        bugReport = ((BugReportBuilder)bugReport.setId((Object)r.getInt("id"))).setCommitTime(r.getTimestamp("commit_time").toInstant()).setReporterUrn(r.getString("reporter_urn")).setMail(r.getString("email"));
        return bugReport.create();
    }

    public static boolean hasColumn(ResultSet rs, String columnName) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columns = rsmd.getColumnCount();
        for (int x = 1; x <= columns; ++x) {
            if (!columnName.equals(rsmd.getColumnName(x))) continue;
            return true;
        }
        return false;
    }

    static {
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
    }
}

