/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.bugreport.jira;

import be.iminds.ilabt.jfed.bugreport.jira.BasicAuthJiraCallClient;
import be.iminds.ilabt.jfed.bugreport.jira.JiraCallClient;
import be.iminds.ilabt.jfed.bugreport.jira.OAuthJiraCallClient;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.oauth.OAuthAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraClient {
    private static final Logger LOG = LoggerFactory.getLogger(JiraException.class);
    private final JiraCallClient jiraCallClient;
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private Map createMetaData = null;
    private Map serviceDeskList = null;
    private Map<String, Map> customersByServiceDeskId = new HashMap<String, Map>();
    private Map<String, Map> requestTypeDataByServiceDeskId = new HashMap<String, Map>();
    static String RESERVED_CHARS_JQL = "+-&|!(){}[]^~*?\\:";

    private static void debugDumpReply(String msg, Object jsonReply) {
        try {
            LOG.debug(msg + ": {}", (Object)MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(jsonReply));
        }
        catch (JsonProcessingException e) {
            LOG.debug(msg + " (ignoring json write error): {}", jsonReply);
        }
    }

    public JiraClient(@Nonnull String jiraBaseUrl, @Nonnull OAuthAccessor oAuthAccessor) {
        assert (oAuthAccessor.accessToken != null);
        this.jiraCallClient = new OAuthJiraCallClient(jiraBaseUrl, oAuthAccessor);
    }

    public JiraClient(@Nonnull String jiraBaseUrl, @Nonnull String username, @Nonnull String password) {
        this.jiraCallClient = new BasicAuthJiraCallClient(jiraBaseUrl, username, password);
    }

    private static String jqlQuote(String orig) {
        Object res = "";
        for (int i = 0; i < orig.length(); ++i) {
            char c = orig.charAt(i);
            if (RESERVED_CHARS_JQL.indexOf(c) != -1) {
                res = (String)res + "\\\\";
                res = (String)res + c;
                continue;
            }
            res = (String)res + c;
        }
        return res;
    }

    @Nonnull
    public List<String> getIssueKeysMatchingSummarySearch(@Nonnull String project, @Nonnull List<String> textsToMatch, boolean onlyNonDuplicate) throws JiraException {
        assert (!textsToMatch.isEmpty());
        Object jql = "";
        for (String textToMatch : textsToMatch) {
            if (!((String)jql).isEmpty()) {
                jql = (String)jql + " AND ";
            }
            jql = (String)jql + "text ~ \"" + JiraClient.jqlQuote(textToMatch) + "\"";
        }
        if (onlyNonDuplicate) {
            jql = (String)jql + " AND (resolution != Duplicate OR resolution IS EMPTY)";
        }
        jql = (String)jql + " AND project = " + project;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("jql", (String)jql);
        params.put("fields", "key,summary,description");
        LOG.debug("getIssueKeysMatchingSummarySearch jql=" + (String)jql);
        Map queryResultMap = this.jiraCallClient.get("/rest/api/2/search", params);
        ArrayList<String> res = new ArrayList<String>();
        if (queryResultMap.get("issues") != null && queryResultMap.get("issues") instanceof List) {
            List issues = (List)queryResultMap.get("issues");
            for (Object issue : issues) {
                if (issue == null || !(issue instanceof Map)) {
                    throw new JiraException("Unexpected result format issue=" + issue);
                }
                Map issueMap = (Map)issue;
                if (issueMap.get("key") != null && issueMap.get("key") instanceof String) {
                    String key = (String)issueMap.get("key");
                    res.add(key);
                    continue;
                }
                throw new JiraException("Unexpected result format key=" + issueMap.get("key") + " in issue=" + issue);
            }
        } else {
            throw new JiraException("Unexpected result format: issues=" + queryResultMap.get("issues"));
        }
        return res;
    }

    @Nonnull
    public String getIssueDescription(@Nonnull String issueKey) throws JiraException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fields", "key,summary,description");
        Map resultIssueMap = this.jiraCallClient.get("/rest/api/2/issue/" + issueKey, params);
        ArrayList res = new ArrayList();
        if (resultIssueMap.get("fields") != null && resultIssueMap.get("fields") instanceof Map) {
            Map fields = (Map)resultIssueMap.get("fields");
            Object description = fields.get("description");
            if (description == null || !(description instanceof String)) {
                throw new JiraException("Unexpected result format description=" + description);
            }
            return (String)description;
        }
        throw new JiraException("Unexpected result format: fields=" + resultIssueMap.get("fields"));
    }

    public void addComment(@Nonnull String issueKey, @Nonnull String comment) throws JiraException {
        String requestContent;
        Map<String, String> createRequestMap = Collections.singletonMap("body", comment);
        try {
            requestContent = MAPPER.writeValueAsString(createRequestMap);
        }
        catch (JsonProcessingException e) {
            throw new JiraException("Failed to create request", e);
        }
        Map response = this.jiraCallClient.post("/rest/api/2/issue/" + issueKey + "/comment", "application/json", requestContent);
    }

    @Nonnull
    public Map getCreateMetaData() throws JiraException {
        if (this.createMetaData == null) {
            this.createMetaData = this.jiraCallClient.get("/rest/api/2/issue/createmeta", Collections.emptyMap());
            if (this.createMetaData == null) {
                throw new JiraException("Error fetching /rest/api/2/issue/createmeta: no content in reply");
            }
            if (!this.createMetaData.containsKey("projects")) {
                throw new JiraException("Error fetching /rest/api/2/issue/createmeta: no projects in reply");
            }
            if (!(this.createMetaData.get("projects") instanceof List)) {
                throw new JiraException("Error fetching /rest/api/2/issue/createmeta: no projects List in reply " + this.createMetaData.get("projects").getClass().getName());
            }
            List projects = (List)this.createMetaData.get("projects");
            if (projects.isEmpty()) {
                throw new JiraException("Error fetching /rest/api/2/issue/createmeta: empty projects List in reply");
            }
            for (Object proj : projects) {
                if (!(proj instanceof Map)) {
                    throw new JiraException("Error fetching /rest/api/2/issue/createmeta: projects has non object item " + proj.getClass().getName());
                }
                Map projMap = (Map)proj;
                if (!projMap.containsKey("id")) {
                    throw new JiraException("Error fetching /rest/api/2/issue/createmeta: project has no id");
                }
                if (!projMap.containsKey("key")) {
                    throw new JiraException("Error fetching /rest/api/2/issue/createmeta: project has no key");
                }
                if (projMap.containsKey("issuetypes")) continue;
                throw new JiraException("Error fetching /rest/api/2/issue/createmeta: project has no issuetypes");
            }
            LOG.info("Got createMetaData: {}", (Object)this.createMetaData);
        }
        return this.createMetaData;
    }

    @Nonnull
    public Map getServiceDeskList() throws JiraException {
        String urlPrefix = "rest/servicedeskapi/servicedesk";
        if (this.serviceDeskList == null) {
            this.serviceDeskList = this.jiraCallClient.get(urlPrefix, Collections.emptyMap());
            JiraClient.debugDumpReply("serviceDeskList res", this.serviceDeskList);
            if (this.serviceDeskList == null) {
                throw new JiraException("Error fetching " + urlPrefix + ": no content in reply");
            }
            if (!this.serviceDeskList.containsKey("values")) {
                throw new JiraException("Error fetching " + urlPrefix + ": no values in reply");
            }
            if (!(this.serviceDeskList.get("values") instanceof List)) {
                throw new JiraException("Error fetching " + urlPrefix + ": no values List in reply " + this.serviceDeskList.get("values").getClass().getName());
            }
            List values = (List)this.serviceDeskList.get("values");
            if (values.isEmpty()) {
                throw new JiraException("Error fetching " + urlPrefix + ": empty values List in reply");
            }
            for (Object sd : values) {
                if (!(sd instanceof Map)) {
                    throw new JiraException("Error fetching " + urlPrefix + ": values has non object item " + sd.getClass().getName());
                }
                Map sdMap = (Map)sd;
                if (!sdMap.containsKey("id")) {
                    throw new JiraException("Error fetching " + urlPrefix + ": service desk has no id");
                }
                if (!sdMap.containsKey("projectId")) {
                    throw new JiraException("Error fetching " + urlPrefix + ": service desk has no projectId");
                }
                if (sdMap.containsKey("projectKey")) continue;
                throw new JiraException("Error fetching " + urlPrefix + ": service desk has no key");
            }
            LOG.info("Got serviceDeskList: {}", (Object)this.serviceDeskList);
        }
        return this.serviceDeskList;
    }

    @Nonnull
    @Deprecated
    public Map getCustomerList(@Nonnull String serviceDeskId, boolean forceReload) throws JiraException {
        String urlPrefix = "rest/servicedeskapi/servicedesk/" + serviceDeskId + "/customer";
        Map res = this.customersByServiceDeskId.get(serviceDeskId);
        if (res == null) {
            res = this.jiraCallClient.get(urlPrefix, Collections.emptyMap());
            if (res == null) {
                throw new JiraException("Error fetching " + urlPrefix + ": no content in reply");
            }
            if (!res.containsKey("values")) {
                throw new JiraException("Error fetching " + urlPrefix + ": no values in reply");
            }
            if (!(res.get("values") instanceof List)) {
                throw new JiraException("Error fetching " + urlPrefix + ": no values List in reply " + res.get("values").getClass().getName());
            }
            List values = (List)res.get("values");
            if (values.isEmpty()) {
                throw new JiraException("Error fetching " + urlPrefix + ": empty values List in reply");
            }
            for (Object sd : values) {
                if (!(sd instanceof Map)) {
                    throw new JiraException("Error fetching " + urlPrefix + ": values has non object item " + sd.getClass().getName());
                }
                Map sdMap = (Map)sd;
                if (!sdMap.containsKey("accountId")) {
                    throw new JiraException("Error fetching " + urlPrefix + ": service desk has no id");
                }
                if (sdMap.containsKey("emailAddress")) continue;
                throw new JiraException("Error fetching " + urlPrefix + ": service desk has no key");
            }
            LOG.info("Got customers for {}: {}", (Object)serviceDeskId, (Object)res);
            this.customersByServiceDeskId.put(serviceDeskId, res);
        }
        return res;
    }

    @Nonnull
    public String getCustomerIdByEmail(@Nonnull String serviceDeskKey, @Nonnull String email) throws JiraException {
        String urlPrefix = "rest/servicedesk/1/pages/people/customers/pagination/" + serviceDeskKey + "/search?query=" + email + "&page=1";
        Map res = this.jiraCallClient.get(urlPrefix, Collections.emptyMap());
        JiraClient.debugDumpReply("getCustomerIdByEmail res", res);
        if (res == null) {
            throw new JiraException("Error fetching " + urlPrefix + ": no content in reply");
        }
        if (!res.containsKey("results")) {
            throw new JiraException("Error fetching " + urlPrefix + ": no results in reply");
        }
        if (!(res.get("results") instanceof List)) {
            throw new JiraException("Error fetching " + urlPrefix + ": no results List in reply " + res.get("values").getClass().getName());
        }
        List values = (List)res.get("results");
        if (values.isEmpty()) {
            return null;
        }
        for (Object sd : values) {
            if (!(sd instanceof Map)) {
                throw new JiraException("Error fetching " + urlPrefix + ": results has non object item " + sd.getClass().getName());
            }
            Map sdMap = (Map)sd;
            if (!sdMap.containsKey("identifier")) {
                throw new JiraException("Error fetching " + urlPrefix + ": customer has no identifier");
            }
            if (!sdMap.containsKey("email")) {
                throw new JiraException("Error fetching " + urlPrefix + ": customer has no email");
            }
            if (!sdMap.containsKey("displayName")) {
                throw new JiraException("Error fetching " + urlPrefix + ": customer has no displayName");
            }
            String curEmail = (String)sdMap.get("email");
            String curDisplayName = (String)sdMap.get("displayName");
            String curId = (String)sdMap.get("identifier");
            if (!curEmail.equalsIgnoreCase(email)) continue;
            return curId;
        }
        return null;
    }

    @Nonnull
    public Map getRequestTypeDataByServiceDeskId(@Nonnull String serviceDeskId) throws JiraException {
        Map res = this.requestTypeDataByServiceDeskId.get(serviceDeskId);
        if (res == null) {
            String urlPrefix = "rest/servicedeskapi/servicedesk/" + serviceDeskId + "/requesttype";
            res = this.jiraCallClient.get(urlPrefix, Collections.emptyMap());
            JiraClient.debugDumpReply("getRequestTypeDataByServiceDeskId res", res);
            if (res == null) {
                throw new JiraException("Error fetching " + urlPrefix + ": no content in reply");
            }
            if (!res.containsKey("values")) {
                throw new JiraException("Error fetching " + urlPrefix + ": no values in reply");
            }
            if (!(res.get("values") instanceof List)) {
                throw new JiraException("Error fetching " + urlPrefix + ": no values List in reply " + res.get("values").getClass().getName());
            }
            List values = (List)res.get("values");
            if (values.isEmpty()) {
                throw new JiraException("Error fetching " + urlPrefix + ": empty values List in reply");
            }
            for (Object sd : values) {
                if (!(sd instanceof Map)) {
                    throw new JiraException("Error fetching " + urlPrefix + ": values has non object item " + sd.getClass().getName());
                }
                Map sdMap = (Map)sd;
                if (!sdMap.containsKey("id")) {
                    throw new JiraException("Error fetching " + urlPrefix + ": service desk has no id");
                }
                if (sdMap.containsKey("name")) continue;
                throw new JiraException("Error fetching " + urlPrefix + ": service desk has no key");
            }
            LOG.info("Got request types for {}: {}", (Object)serviceDeskId, (Object)res);
            this.requestTypeDataByServiceDeskId.put(serviceDeskId, res);
        }
        return res;
    }

    @Nonnull
    public String getProjectIdByKey(String projectKey) throws JiraException {
        Map createMetaData = this.getCreateMetaData();
        List projects = (List)createMetaData.get("projects");
        for (Object projObj : projects) {
            Map project = (Map)projObj;
            String curProjectId = (String)project.get("id");
            String curProjectKey = (String)project.get("key");
            if (!Objects.equals(curProjectKey, projectKey)) continue;
            return curProjectId;
        }
        throw new IllegalArgumentException("Project \"" + projectKey + "\" does not exist.");
    }

    @Nonnull
    String getServiceDeskIdByKey(@Nonnull String serviceDeskKey) throws JiraException {
        Map serviceDeskList = this.getServiceDeskList();
        JiraClient.debugDumpReply("serviceDeskList res2", serviceDeskList);
        List serviceDesks = (List)serviceDeskList.get("values");
        for (Object sdObj : serviceDesks) {
            Map serviceDesk = (Map)sdObj;
            String curId = (String)serviceDesk.get("id");
            String curKey = (String)serviceDesk.get("projectKey");
            if (!Objects.equals(curKey, serviceDeskKey)) continue;
            assert (curId != null);
            return curId;
        }
        LOG.error("Did not find serviceDesk {} in {}", (Object)serviceDeskKey, (Object)serviceDeskList);
        throw new IllegalArgumentException("Service Desk \"" + serviceDeskKey + "\" does not exist.");
    }

    String createCustomer(@Nonnull String serviceDeskId, @Nonnull String email, @Nullable String custumerDisplayName) throws JiraException {
        String requestContent;
        HashMap<String, String> createRequestMap = new HashMap<String, String>();
        createRequestMap.put("fullName", custumerDisplayName == null ? email : custumerDisplayName);
        createRequestMap.put("email", email);
        try {
            requestContent = MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(createRequestMap);
        }
        catch (JsonProcessingException e) {
            throw new JiraException("Failed to create customer", e);
        }
        Map response = this.jiraCallClient.post("rest/servicedeskapi/customer", "application/json", requestContent);
        JiraClient.debugDumpReply("createCustomer response", response);
        String customerId = (String)response.get("key");
        this.customersByServiceDeskId.clear();
        LOG.info("Created customer {} with id={}", (Object)email, (Object)customerId);
        return customerId;
    }

    @Nonnull
    String getOrCreateCustomerAccountId(@Nonnull String serviceDeskId, @Nonnull String custumerEmail, @Nullable String custumerDisplayName) throws JiraException {
        String existingCostumerId = this.getCustomerIdByEmail(serviceDeskId, custumerEmail);
        LOG.info("Did not find customer {} in {} -> will create it", (Object)custumerEmail, (Object)serviceDeskId);
        return this.createCustomer(serviceDeskId, custumerEmail, custumerDisplayName);
    }

    @Nonnull
    String getIssueTypeIdByName(String projectKey, String issueTypeName) throws JiraException {
        Map createMetaData = this.getCreateMetaData();
        List projects = (List)createMetaData.get("projects");
        for (Object projObj : projects) {
            Map project = (Map)projObj;
            String curProjectKey = (String)project.get("key");
            if (!curProjectKey.equals(curProjectKey)) continue;
            List issueTypes = (List)project.get("issuetypes");
            for (Map issueType : issueTypes) {
                String curIssueId = (String)issueType.get("id");
                String curIssueName = (String)issueType.get("name");
                if (!curIssueName.equals(issueTypeName)) continue;
                return curIssueId;
            }
        }
        throw new IllegalArgumentException("issueTypeName \"" + issueTypeName + "\" does not exist in project \"" + projectKey + "\".");
    }

    @Nonnull
    String getRequestTypeIdByName(String serviceDeskId, String requestTypeName) throws JiraException {
        Map reqTypeData = this.getRequestTypeDataByServiceDeskId(serviceDeskId);
        List values = (List)reqTypeData.get("values");
        for (Object reqTypeObj : values) {
            Map reqType = (Map)reqTypeObj;
            String curName = (String)reqType.get("name");
            if (!requestTypeName.equals(curName)) continue;
            return (String)reqType.get("id");
        }
        LOG.error("Did not find requestType {} for serviceDesk {} in {}", new Object[]{requestTypeName, serviceDeskId, reqTypeData});
        throw new IllegalArgumentException("requestType \"" + requestTypeName + "\" does not exist in service desk \"" + serviceDeskId + "\".");
    }

    @Nonnull
    public String createIssue(@Nonnull String projectKey, @Nonnull String summary, @Nonnull String description, @Nullable String issueTypeName, @Nullable List<String> labels, @Nullable List<String> component, @Nullable String assignee, @Nullable String affectsVersion, @Nullable List<String> relatesTo) throws JiraException {
        String requestContent;
        String projectId = this.getProjectIdByKey(projectKey);
        String issueTypeId = this.getIssueTypeIdByName(projectKey, issueTypeName);
        HashMap createRequestMap = new HashMap();
        HashMap<String, Object> fieldsMap = new HashMap<String, Object>();
        createRequestMap.put("fields", fieldsMap);
        fieldsMap.put("project", Collections.singletonMap("id", projectId));
        fieldsMap.put("summary", summary);
        fieldsMap.put("description", description);
        if (issueTypeName != null) {
            fieldsMap.put("issuetype", Collections.singletonMap("id", issueTypeId));
        }
        if (assignee != null) {
            fieldsMap.put("assignee", Collections.singletonMap("name", assignee));
        }
        if (labels != null && !labels.isEmpty()) {
            fieldsMap.put("labels", labels);
        }
        if (affectsVersion != null) {
            fieldsMap.put("versions", Collections.singletonList(Collections.singletonMap("name", affectsVersion)));
        }
        if (component != null && !component.isEmpty()) {
            fieldsMap.put("components", component.stream().map(compName -> Collections.singletonMap("name", compName)).collect(Collectors.toList()));
        }
        try {
            requestContent = MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(createRequestMap);
        }
        catch (JsonProcessingException e) {
            throw new JiraException("Failed to create request", e);
        }
        Map response = this.jiraCallClient.post("/rest/api/2/issue/", "application/json", requestContent);
        String issueKey = (String)response.get("key");
        LOG.debug("Created issue " + issueKey);
        if (relatesTo != null && !relatesTo.isEmpty()) {
            for (String relatedIssueKey : relatesTo) {
                String linkRequestContent;
                HashMap<String, Map<String, String>> linkMap = new HashMap<String, Map<String, String>>();
                linkMap.put("type", Collections.singletonMap("name", "Relates"));
                linkMap.put("inwardIssue", Collections.singletonMap("key", issueKey));
                linkMap.put("outwardIssue", Collections.singletonMap("key", relatedIssueKey));
                try {
                    linkRequestContent = MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(linkMap);
                }
                catch (JsonProcessingException e) {
                    throw new JiraException("Failed to create request", e);
                }
                Map map = this.jiraCallClient.post("/rest/api/2/issueLink/", "application/json", linkRequestContent);
            }
        }
        return issueKey;
    }

    @Nonnull
    public String createRequest(@Nonnull String serviceDeskKey, @Nonnull String summary, @Nonnull String description, @Nullable String requestTypeName, @Nonnull List<String> requestParticipants, @Nullable String raiseOnBehalfOfEmail, @Nullable String raiseOnBehalfOfDisplayName, @Nullable String assignee) throws JiraException {
        String serviceDeskId = this.getServiceDeskIdByKey(serviceDeskKey);
        String requestTypeId = requestTypeName == null ? null : this.getRequestTypeIdByName(serviceDeskId, requestTypeName);
        return this.createRequest(serviceDeskKey, summary, description, Integer.parseInt(requestTypeId), requestParticipants, raiseOnBehalfOfEmail, raiseOnBehalfOfDisplayName, assignee);
    }

    @Nonnull
    public String createRequest(@Nonnull String serviceDeskKey, @Nonnull String summary, @Nonnull String description, int requestTypeId, @Nonnull List<String> requestParticipants, @Nullable String raiseOnBehalfOfEmail, @Nullable String raiseOnBehalfOfDisplayName, @Nullable String assignee) throws JiraException {
        String requestContent;
        String serviceDeskId = this.getServiceDeskIdByKey(serviceDeskKey);
        assert (serviceDeskId != null);
        HashMap<String, Object> createRequestMap = new HashMap<String, Object>();
        createRequestMap.put("serviceDeskId", serviceDeskId);
        ArrayList<String> requestParticipantsAccountIds = new ArrayList<String>();
        for (String p : requestParticipants) {
            requestParticipantsAccountIds.add(p);
        }
        createRequestMap.put("requestParticipants", requestParticipantsAccountIds);
        String raiseOnBehalfOfAccountId = raiseOnBehalfOfEmail;
        if (raiseOnBehalfOfAccountId != null) {
            createRequestMap.put("raiseOnBehalfOf", raiseOnBehalfOfAccountId);
        }
        HashMap<String, String> requestFieldValues = new HashMap<String, String>();
        createRequestMap.put("requestFieldValues", requestFieldValues);
        requestFieldValues.put("summary", summary);
        requestFieldValues.put("description", description);
        createRequestMap.put("requestTypeId", "" + requestTypeId);
        try {
            requestContent = MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(createRequestMap);
        }
        catch (JsonProcessingException e) {
            throw new JiraException("Failed to create request", e);
        }
        Map response = this.jiraCallClient.post("/rest/servicedeskapi/request", "application/json", requestContent);
        String requestKey = (String)response.get("issueKey");
        LOG.debug("Created request " + requestKey);
        return requestKey;
    }

    public static class JiraException
    extends Exception {
        public JiraException() {
        }

        public JiraException(String message) {
            super(message);
        }

        public JiraException(String message, Throwable cause) {
            super(message, cause);
        }

        public JiraException(Throwable cause) {
            super(cause);
        }

        public JiraException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
            super(message, cause, enableSuppression, writableStackTrace);
        }
    }
}

