/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.bugreport.jira;

import be.iminds.ilabt.jfed.bugreport.jira.JiraCallClient;
import be.iminds.ilabt.jfed.bugreport.jira.JiraClient;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.ParameterStyle;
import net.oauth.client.OAuthClient;
import net.oauth.client.OAuthResponseMessage;
import net.oauth.client.httpclient4.HttpClient4;
import net.oauth.http.HttpClient;

public class OAuthJiraCallClient
implements JiraCallClient {
    @Nonnull
    private final OAuthAccessor oAuthAccessor;
    @Nonnull
    private final String jiraBaseUrl;
    @Nonnull
    private final OAuthClient oAuthClient;
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public OAuthJiraCallClient(@Nonnull String jiraBaseUrl, @Nonnull OAuthAccessor oAuthAccessor) {
        assert (oAuthAccessor.accessToken != null);
        this.oAuthAccessor = oAuthAccessor;
        this.jiraBaseUrl = jiraBaseUrl;
        this.oAuthClient = new OAuthClient((HttpClient)new HttpClient4());
    }

    @Override
    @Nonnull
    public Map get(@Nonnull String path, @Nonnull Map<String, String> parameters) throws JiraClient.JiraException {
        try {
            String url = this.jiraBaseUrl + (this.jiraBaseUrl.endsWith("/") ? "" : "/") + path;
            OAuthMessage response = this.oAuthClient.invoke(this.oAuthAccessor, url, parameters.entrySet());
            return (Map)MAPPER.readValue(response.getBodyAsStream(), Map.class);
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new JiraClient.JiraException("Internal bug: Problem constructing URL", e);
        }
        catch (IOException | OAuthException e) {
            throw new JiraClient.JiraException("Error querying jira", e);
        }
    }

    @Override
    @Nullable
    public Map post(@Nonnull String path, @Nullable String contentType, @Nullable String content) throws JiraClient.JiraException {
        try {
            OAuthResponseMessage oAuthResponseMessage;
            String url = this.jiraBaseUrl + (this.jiraBaseUrl.endsWith("/") ? "" : "/") + path;
            ByteArrayInputStream body = content == null ? null : new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
            OAuthMessage request = this.oAuthAccessor.newRequestMessage("POST", url, Collections.emptyList(), (InputStream)body);
            OAuthMessage response = this.oAuthClient.invoke(request, ParameterStyle.AUTHORIZATION_HEADER);
            assert (request instanceof OAuthResponseMessage);
            if (request instanceof OAuthResponseMessage && (oAuthResponseMessage = (OAuthResponseMessage)response).getHttpResponse().getStatusCode() == 201) {
                return null;
            }
            return (Map)MAPPER.readValue(response.getBodyAsStream(), Map.class);
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new JiraClient.JiraException("Internal bug: Problem constructing URL", e);
        }
        catch (IOException | OAuthException e) {
            throw new JiraClient.JiraException("Error querying jira", e);
        }
    }
}

