/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.bugreport.resource;

import be.iminds.ilabt.jfed.bugreport.dao.OAuthAccessToken;
import be.iminds.ilabt.jfed.bugreport.dao.OAuthAccessTokenBuilder;
import be.iminds.ilabt.jfed.bugreport.dao.OAuthDao;
import be.iminds.ilabt.jfed.bugreport.jira.JiraClient;
import be.iminds.ilabt.jfed.bugreport.service.JFedBugReportWebApiConfigurationIface;
import be.iminds.ilabt.jfed.fedmon.webapi.base.AbstractWebApiConfigurationIface;
import be.iminds.ilabt.jfed.fedmon.webapi.service.util.EmailSender;
import be.iminds.ilabt.jfed.util.common.TextUtil;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import javax.ws.rs.core.UriInfo;
import net.oauth.OAuth;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.OAuthServiceProvider;
import net.oauth.client.OAuthClient;
import net.oauth.client.httpclient4.HttpClient4;
import net.oauth.http.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/oauth")
@Produces(value={"application/json"})
public class OAuthResource {
    private static final Logger LOG = LoggerFactory.getLogger(OAuthResource.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    protected static final String SERVLET_BASE_URL = "/plugins/servlet";
    private final String jiraBaseUrl;
    private final String consumerKey;
    private final String publicKey;
    private final String publicKeyPem;
    private final String publicKeyPem2;
    private final String publicKeyOpenSsh;
    private final RSAPrivateKey privateKey;
    private final String callback;
    private final JiraClientMethod jiraClientMethod;
    private final String jiraClientUsername;
    private final String jiraClientPassword;
    @Context
    UriInfo uriInfo;
    @NotNull
    private final JFedBugReportWebApiConfigurationIface bugReportConfiguration;
    @NotNull
    private final AbstractWebApiConfigurationIface webApiConfiguration;
    @NotNull
    private final EmailSender emailSender;
    @NotNull
    private final OAuthDao oAuthDao;
    private List<TokenSecretVerifierHolder> requestTokens = new ArrayList<TokenSecretVerifierHolder>();
    private List<OAuthAccessToken> accessTokens = new ArrayList<OAuthAccessToken>();
    private OAuthAccessor accessor;

    public OAuthResource(@NotNull JFedBugReportWebApiConfigurationIface bugReportConfiguration, @NotNull AbstractWebApiConfigurationIface webApiConfiguration, @NotNull EmailSender emailSender, @NotNull OAuthDao oAuthDao) {
        this.bugReportConfiguration = bugReportConfiguration;
        this.webApiConfiguration = webApiConfiguration;
        this.emailSender = emailSender;
        this.oAuthDao = oAuthDao;
        this.jiraClientMethod = bugReportConfiguration.getJiraClientMethod() == null ? JiraClientMethod.NONE : JiraClientMethod.find(bugReportConfiguration.getJiraClientMethod());
        this.jiraClientUsername = bugReportConfiguration.getJiraClientUsername();
        this.jiraClientPassword = bugReportConfiguration.getJiraClientPassword();
        switch (this.jiraClientMethod) {
            case BASICAUTH: {
                if (this.jiraClientPassword == null) {
                    throw new IllegalArgumentException("Configuration uses " + this.jiraClientMethod + " so requires jiraClientPassword");
                }
            }
            case OAUTH: {
                if (this.jiraClientUsername != null) break;
                throw new IllegalArgumentException("Configuration uses " + this.jiraClientMethod + " so requires jiraClientUsername");
            }
            case NONE: {
                break;
            }
            default: {
                throw new IllegalArgumentException("jiraClientMethod " + this.jiraClientMethod + " is not supported");
            }
        }
        LOG.info("Jira Client method is: " + this.jiraClientMethod);
        this.callback = bugReportConfiguration.getOAuthConsumerCallbackUrl();
        LOG.info("OAUTH: Using oauth callback URL: \"" + this.callback + "\"");
        this.jiraBaseUrl = bugReportConfiguration.getJiraBaseUrl() == null ? "https://ibcn-jira.intec.ugent.be" : bugReportConfiguration.getJiraBaseUrl();
        LOG.info("OAUTH: jiraBaseUrl: \"" + this.jiraBaseUrl + "\"");
        this.consumerKey = bugReportConfiguration.getOAuthConsumerKey() == null ? "jfed-bugreport-api" : bugReportConfiguration.getOAuthConsumerKey();
        LOG.info("OAUTH: consumerKey: \"" + this.consumerKey + "\"");
        String privKey = bugReportConfiguration.getPrivateOAuthConsumerPemKey();
        if (privKey == null || privKey.trim().isEmpty()) {
            throw new IllegalStateException("Bug report configuration contains no privateOAuthConsumerPemKey");
        }
        if (privKey.contains("-----BEGIN RSA PRIVATE KEY") && ((privKey = OAuthResource.findPemMessage(privKey, "RSA PRIVATE KEY")) == null || privKey.trim().isEmpty())) {
            throw new IllegalStateException("Bug report configuration contained no correct PEM RSA PRIVATE KEY message");
        }
        if (privKey.contains("-----BEGIN PRIVATE KEY") && ((privKey = OAuthResource.findPemMessage(privKey, "PRIVATE KEY")) == null || privKey.trim().isEmpty())) {
            throw new IllegalStateException("Bug report configuration contained no correct PEM PRIVATE KEY message");
        }
        if (privKey.contains("\n")) {
            privKey.replaceAll("\\n", "").trim();
            if (privKey.isEmpty()) {
                throw new IllegalStateException("Bug report configuration contained incorrect private key");
            }
        }
        try {
            this.privateKey = KeyUtil.pemToRsaPrivateKey((String)bugReportConfiguration.getPrivateOAuthConsumerPemKey(), null);
        }
        catch (KeyUtil.PEMDecodingException e) {
            throw new IllegalStateException("Bug report configuration contained private key that could not be processed by jFed KeyUtil");
        }
        if (this.privateKey == null) {
            throw new IllegalStateException("Bug report configuration contained private key that could not be processed by jFed KeyUtil");
        }
        RSAPublicKey pubKey = KeyUtil.rsaPrivateKeyToRsaPublicKey((RSAPrivateKey)this.privateKey);
        if (pubKey == null) {
            throw new IllegalStateException("Bug report configuration contained private key that could not be used to find the public key");
        }
        this.publicKey = new String(KeyUtil.getPublicKeyCharsPKCS1Base64((RSAPublicKey)pubKey));
        String pemMid = TextUtil.wrap((String)this.publicKey, (int)64);
        this.publicKeyPem = "-----BEGIN RSA PUBLIC KEY-----\n" + pemMid + "\n-----END RSA PUBLIC KEY-----\n";
        String pem2Mid = TextUtil.wrap((String)("MIICIjANBgkqhkiG9w0BAQEFAAOCAg8A" + this.publicKey), (int)64);
        this.publicKeyPem2 = "-----BEGIN PUBLIC KEY-----\n" + pem2Mid + "\n-----END PUBLIC KEY-----\n";
        this.publicKeyOpenSsh = KeyUtil.publicKeyToOpenSshAuthorizedKeysFormat((PublicKey)pubKey);
    }

    public static String findPemMessage(String pemContent, String messageName) {
        String start;
        int startPos = (pemContent = pemContent.trim().replaceAll("\r\n", "\n")).indexOf(start = "-----BEGIN " + messageName + "-----");
        if (startPos != -1) {
            int decodedContent = (pemContent = pemContent.substring(startPos + start.length())).indexOf("-----END " + messageName + "-----");
            if (decodedContent < 0) {
                return null;
            }
            return pemContent.substring(0, decodedContent);
        }
        return null;
    }

    @GET
    @Path(value="servicePubKey")
    @Produces(value={"text/plain"})
    @Timed
    public String showPublicKey(@Context HttpServletRequest request) {
        return this.publicKey;
    }

    @GET
    @Path(value="servicePubKey/pem")
    @Produces(value={"text/plain"})
    @Timed
    public String showPublicKeyPem(@Context HttpServletRequest request) {
        return this.publicKeyPem;
    }

    @GET
    @Path(value="servicePubKey/pem2")
    @Produces(value={"text/plain"})
    @Timed
    public String showPublicKeyPem2(@Context HttpServletRequest request) {
        return this.publicKeyPem2;
    }

    @GET
    @Path(value="servicePubKey/openssh")
    @Produces(value={"text/plain"})
    @Timed
    public String showPublicKeyOpenSsh(@Context HttpServletRequest request) {
        return this.publicKeyOpenSsh;
    }

    @GET
    @Path(value="jira/authorize")
    @Produces(value={"text/html"})
    @Timed
    public Response jiraRedirectRequestToken(@Context HttpServletRequest request) {
        TokenSecretVerifierHolder requestToken = this.getRequestToken();
        LOG.info("OAUTH: Got request token: " + requestToken);
        this.requestTokens.add(requestToken);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)this.getAuthorizeUrl()).queryParam("oauth_token", new Object[]{requestToken.token}).queryParam("oauth_callback", new Object[]{this.callback});
        try {
            return Response.temporaryRedirect((URI)uriBuilder.build(new Object[0])).build();
        }
        catch (IllegalArgumentException | UriBuilderException e) {
            throw new WebApplicationException("Failed to create URL to redirect to", e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="jira/callback")
    @Produces(value={"text/html"})
    @Timed
    public String jiraRequestTokenCallback(@Context HttpServletRequest request, @QueryParam(value="oauth_token") String oauthRequestToken, @QueryParam(value="oauth_verifier") String oauthVerifier) {
        LOG.info("OAUTH: jira called callback for request token " + oauthRequestToken + "  with verifier " + oauthVerifier);
        TokenSecretVerifierHolder tokenSecretVerifierHolder = null;
        for (TokenSecretVerifierHolder cur : this.requestTokens) {
            if (!cur.token.equals(oauthRequestToken)) continue;
            tokenSecretVerifierHolder = cur;
            break;
        }
        if (tokenSecretVerifierHolder == null) {
            throw new WebApplicationException("No matching request token is known: " + oauthRequestToken, Response.Status.BAD_REQUEST);
        }
        LOG.info("OAUTH: jira called callback with known request token");
        tokenSecretVerifierHolder.verifier = oauthVerifier;
        String accessToken = this.swapRequestTokenForAccessToken(tokenSecretVerifierHolder.token, tokenSecretVerifierHolder.secret, tokenSecretVerifierHolder.verifier);
        LOG.info("OAUTH: got access token " + accessToken);
        LOG.info("OAUTH: will test access token by fetching loggedInUsername");
        String loggedInUsername = this.getUsernameFromAccessToken(accessToken);
        LOG.info("OAUTH: got username \"" + loggedInUsername + "\". Will store in DB.");
        OAuthAccessToken oAuthAccessToken = new OAuthAccessTokenBuilder().setUsername(loggedInUsername).setServiceProviderBaseUrl(this.jiraBaseUrl).setAccessToken(accessToken).create();
        this.accessTokens.add(oAuthAccessToken);
        this.oAuthDao.insert(oAuthAccessToken);
        LOG.info("OAUTH: Will reply user.");
        String htmlReply = "<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <title>Authorization Completed</title>\n  </head>\n  <body>\n    <p>OAuth Access Token for " + oAuthAccessToken.getServiceProviderBaseUrl() + " successfull stored for user " + oAuthAccessToken.getUsername() + "</p>\n  </body>\n</html>";
        return htmlReply;
    }

    @Nonnull
    public String getUsernameFromAccessToken(@Nonnull String oauthAccessToken) {
        OAuthAccessor accessor = this.getAccessor();
        OAuthClient client = new OAuthClient((HttpClient)new HttpClient4());
        accessor.accessToken = oauthAccessToken;
        try {
            OAuthMessage response = client.invoke(accessor, this.jiraBaseUrl + "/rest/auth/1/session", Collections.emptySet());
            LOG.debug("OAUTH: got reply to 'get logged in user' call ");
            Map userMap = (Map)MAPPER.readValue(response.getBodyAsStream(), Map.class);
            if (userMap.get("username") != null && userMap.get("username") instanceof String && !((String)userMap.get("username")).isEmpty()) {
                String username = (String)userMap.get("username");
                LOG.debug("OAUTH: Found username: \"" + username + "\"");
                return username;
            }
            LOG.debug("OAUTH: Did NOT find username: " + userMap);
            throw new RuntimeException("OAUTH: Could not find username of logged in user");
        }
        catch (IOException | URISyntaxException | OAuthException e) {
            LOG.error("OAUTH: Exception in 'get logged in user' call", e);
            throw new RuntimeException("OAUTH: Exception in 'get logged in user' call", e);
        }
    }

    public TokenSecretVerifierHolder getRequestToken() {
        try {
            OAuthAccessor accessor = this.getAccessor();
            OAuthClient oAuthClient = new OAuthClient((HttpClient)new HttpClient4());
            ImmutableList callBack = this.callback == null || "".equals(this.callback) ? Collections.emptyList() : ImmutableList.of((Object)new OAuth.Parameter("oauth_callback", this.callback));
            OAuthMessage message = oAuthClient.getRequestTokenResponse(accessor, "POST", callBack);
            TokenSecretVerifierHolder tokenSecretVerifier = new TokenSecretVerifierHolder();
            tokenSecretVerifier.token = accessor.requestToken;
            tokenSecretVerifier.secret = accessor.tokenSecret;
            tokenSecretVerifier.verifier = message.getParameter("oauth_verifier");
            return tokenSecretVerifier;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to obtain request token", e);
        }
    }

    public String swapRequestTokenForAccessToken(String requestToken, String tokenSecret, String oauthVerifier) {
        try {
            OAuthAccessor accessor = this.getAccessor();
            OAuthClient client = new OAuthClient((HttpClient)new HttpClient4());
            accessor.requestToken = requestToken;
            accessor.tokenSecret = tokenSecret;
            OAuthMessage message = client.getAccessToken(accessor, "POST", (Collection)ImmutableList.of((Object)new OAuth.Parameter("oauth_verifier", oauthVerifier)));
            return message.getToken();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to swap request token with access token", e);
        }
    }

    public String makeAuthenticatedRequest(String url, String accessToken) {
        try {
            OAuthAccessor accessor = this.getAccessor();
            OAuthClient client = new OAuthClient((HttpClient)new HttpClient4());
            accessor.accessToken = accessToken;
            OAuthMessage response = client.invoke(accessor, url, Collections.emptySet());
            return response.readBodyAsString();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to make an authenticated request.", e);
        }
    }

    @Nonnull
    private String getAccessToken(String username) {
        OAuthAccessToken oAuthAccessToken = this.oAuthDao.get(username, this.bugReportConfiguration.getJiraBaseUrl());
        if (oAuthAccessToken == null) {
            throw new IllegalStateException("No access token known for user \"" + username + "\"");
        }
        return oAuthAccessToken.getAccessToken();
    }

    @Nullable
    public JiraClient getJiraClient() {
        try {
            switch (this.jiraClientMethod) {
                case BASICAUTH: {
                    return new JiraClient(this.bugReportConfiguration.getJiraBaseUrl(), this.jiraClientUsername, this.jiraClientPassword);
                }
                case OAUTH: {
                    OAuthAccessor accessor = this.getAccessor();
                    accessor.accessToken = this.getAccessToken(this.jiraClientUsername);
                    return new JiraClient(this.bugReportConfiguration.getJiraBaseUrl(), accessor);
                }
                case NONE: {
                    return null;
                }
            }
            throw new IllegalArgumentException("jiraClientMethod " + this.jiraClientMethod + " is not supported");
        }
        catch (Exception e) {
            LOG.error("Something went wrong creating the jira client. Falling back to null.", (Throwable)e);
            return null;
        }
    }

    private final OAuthAccessor getAccessor() {
        if (this.accessor == null) {
            OAuthServiceProvider serviceProvider = new OAuthServiceProvider(this.getRequestTokenUrl(), this.getAuthorizeUrl(), this.getAccessTokenUrl());
            OAuthConsumer consumer = new OAuthConsumer(this.callback, this.consumerKey, null, serviceProvider);
            consumer.setProperty("RSA-SHA1.PrivateKey", (Object)this.privateKey);
            consumer.setProperty("oauth_signature_method", (Object)"RSA-SHA1");
            this.accessor = new OAuthAccessor(consumer);
        }
        return this.accessor;
    }

    private String getAccessTokenUrl() {
        return this.jiraBaseUrl + "/plugins/servlet/oauth/access-token";
    }

    private String getRequestTokenUrl() {
        return this.jiraBaseUrl + "/plugins/servlet/oauth/request-token";
    }

    public String getAuthorizeUrlForToken(String token) {
        return this.getAuthorizeUrl() + "?oauth_token=" + token;
    }

    private String getAuthorizeUrl() {
        return this.jiraBaseUrl + "/plugins/servlet/oauth/authorize";
    }

    private static enum JiraClientMethod {
        OAUTH,
        BASICAUTH,
        NONE;


        public static JiraClientMethod find(String m) throws IllegalArgumentException {
            m = m.toUpperCase().trim().replaceAll(" ", "");
            return JiraClientMethod.valueOf(m);
        }
    }

    public static class TokenSecretVerifierHolder {
        public String token;
        public String verifier;
        public String secret;

        public String toString() {
            return "TokenSecretVerifierHolder{token='" + this.token + "', verifier='" + this.verifier + "', secret='" + this.secret + "'}";
        }
    }
}

