/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.bugreport.service;

import be.iminds.ilabt.jfed.bugreport.model.BugReport;
import be.iminds.ilabt.jfed.bugreport.service.JFedBugReportAccess;
import be.iminds.ilabt.jfed.bugreport.service.JFedBugReportWebApiConfigurationIface;
import be.iminds.ilabt.jfed.fedmon.webapi.base.AbstractWebApiConfiguration;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class JFedBugReportWebApiConfiguration
extends AbstractWebApiConfiguration<JFedBugReportAccess>
implements JFedBugReportWebApiConfigurationIface {
    private static final Logger LOG = LoggerFactory.getLogger(JFedBugReportWebApiConfiguration.class);
    private String rawBugReportFrom;
    private List<String> rawBugReportJiraAddresses;
    private List<String> rawBugReportTos;
    private List<String> rawBugReportPublicTos;
    private String privateOAuthConsumerPemKey;
    private String oAuthConsumerCallbackUrl;
    private String oAuthConsumerKey;
    private String jiraBaseUrl;
    private InternetAddress bugReportFrom;
    private List<InternetAddress> bugReportJiraAddresses;
    private List<InternetAddress> bugReportTos;
    private List<InternetAddress> bugReportPublicTos;
    private String jiraClientMethod;
    private String jiraClientUsername;
    private String jiraClientPassword;

    public JFedBugReportWebApiConfiguration() {
        super(JFedBugReportAccess.class, (AbstractWebApiConfiguration.BaseAccessEnumFactory)new AbstractWebApiConfiguration.BaseAccessEnumFactory<JFedBugReportAccess>(){

            public JFedBugReportAccess getRead() {
                return JFedBugReportAccess.READ;
            }

            public JFedBugReportAccess getAdmin() {
                return JFedBugReportAccess.ADMIN;
            }
        });
    }

    protected JsonLdObjectsMetaData createJsonLdObjectsMetaData() {
        return JsonLdObjectsMetaData.getInstance((String)BugReport.class.getPackage().getName());
    }

    @Override
    @JsonProperty(value="bugReportFromAddress")
    public String getRawBugReportFrom() {
        return this.rawBugReportFrom;
    }

    @Override
    @JsonProperty(value="bugReportToAddresses")
    public List<String> getRawBugReportTos() {
        return this.rawBugReportTos == null ? Collections.emptyList() : this.rawBugReportTos;
    }

    @Override
    @JsonProperty(value="bugReportJiraAddresses")
    public List<String> getRawBugReportJiraAddresses() {
        return this.rawBugReportJiraAddresses;
    }

    @Override
    @JsonProperty(value="bugReportPublicToAddresses")
    public List<String> getRawBugReportPublicTos() {
        return this.rawBugReportPublicTos == null ? Collections.emptyList() : this.rawBugReportPublicTos;
    }

    @Override
    @JsonProperty(value="privateOAuthConsumerPemKey")
    public String getPrivateOAuthConsumerPemKey() {
        return this.privateOAuthConsumerPemKey;
    }

    @Override
    @JsonProperty(value="oAuthConsumerCallbackUrl")
    public String getOAuthConsumerCallbackUrl() {
        return this.oAuthConsumerCallbackUrl;
    }

    @Override
    @JsonProperty(value="oAuthConsumerKey")
    public String getOAuthConsumerKey() {
        return this.oAuthConsumerKey;
    }

    @Override
    @JsonProperty(value="jiraBaseUrl")
    public String getJiraBaseUrl() {
        return this.jiraBaseUrl;
    }

    @Override
    public String getJiraClientMethod() {
        return this.jiraClientMethod;
    }

    @Override
    public String getJiraClientUsername() {
        return this.jiraClientUsername;
    }

    @Override
    public String getJiraClientPassword() {
        return this.jiraClientPassword;
    }

    public void setJiraClientMethod(String jiraClientMethod) {
        this.jiraClientMethod = jiraClientMethod;
    }

    public void setJiraClientUsername(String jiraClientUsername) {
        this.jiraClientUsername = jiraClientUsername;
    }

    public void setJiraClientPassword(String jiraClientPassword) {
        this.jiraClientPassword = jiraClientPassword;
    }

    public void setRawBugReportFrom(String rawBugReportFrom) throws AddressException {
        this.rawBugReportFrom = rawBugReportFrom;
        this.bugReportFrom = JFedBugReportWebApiConfiguration.convertInternetAddress(rawBugReportFrom);
    }

    public void setRawBugReportJiraAddresses(List<String> rawBugReportJiraAddresses) throws AddressException {
        this.rawBugReportJiraAddresses = rawBugReportJiraAddresses;
        this.bugReportJiraAddresses = JFedBugReportWebApiConfiguration.convertInternetAddressList(this.rawBugReportJiraAddresses);
    }

    public void setRawBugReportTos(List<String> rawBugReportTos) throws AddressException {
        this.rawBugReportTos = rawBugReportTos == null ? Collections.emptyList() : rawBugReportTos;
        this.bugReportTos = JFedBugReportWebApiConfiguration.convertInternetAddressList(this.rawBugReportTos);
    }

    public void setRawBugReportPublicTos(List<String> rawBugReportPublicTos) throws AddressException {
        this.rawBugReportPublicTos = rawBugReportPublicTos == null ? Collections.emptyList() : rawBugReportPublicTos;
        this.bugReportPublicTos = JFedBugReportWebApiConfiguration.convertInternetAddressList(this.rawBugReportPublicTos);
    }

    public void setPrivateOAuthConsumerPemKey(String privateOAuthConsumerPemKey) {
        this.privateOAuthConsumerPemKey = privateOAuthConsumerPemKey;
    }

    @JsonProperty(value="oAuthConsumerCallbackUrl")
    public void setOAuthConsumerCallbackUrl(String oAuthConsumerCallbackUrl) {
        this.oAuthConsumerCallbackUrl = oAuthConsumerCallbackUrl;
    }

    @JsonProperty(value="oAuthConsumerKey")
    public void setOAuthConsumerKey(String oAuthConsumerKey) {
        this.oAuthConsumerKey = oAuthConsumerKey;
    }

    public void setJiraBaseUrl(String jiraBaseUrl) {
        this.jiraBaseUrl = jiraBaseUrl;
    }

    @Override
    @JsonIgnore
    public InternetAddress getBugReportFrom() {
        return this.bugReportFrom;
    }

    @Override
    @JsonIgnore
    public List<InternetAddress> getBugReportTos() {
        return this.bugReportTos;
    }

    @Override
    @JsonIgnore
    public List<InternetAddress> getBugReportJiraAddresses() {
        return this.bugReportJiraAddresses;
    }

    @Override
    @JsonIgnore
    public List<InternetAddress> getBugReportPublicTos() {
        return this.bugReportPublicTos;
    }

    private static InternetAddress convertInternetAddress(@Nullable String address) throws AddressException {
        if (address == null) {
            return null;
        }
        return new InternetAddress(address);
    }

    private static List<InternetAddress> convertInternetAddressList(@Nonnull List<String> addresses) throws AddressException {
        ArrayList<InternetAddress> res = new ArrayList<InternetAddress>(addresses.size());
        for (String adminAddress : addresses) {
            res.add(new InternetAddress(adminAddress));
        }
        return res;
    }
}

