/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.api.AbstractArrayAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.ComparatorFactory;
import org.assertj.core.data.Index;
import org.assertj.core.data.Offset;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.FloatArrays;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractFloatArrayAssert<SELF extends AbstractFloatArrayAssert<SELF>>
extends AbstractArrayAssert<SELF, float[], Float> {
    @VisibleForTesting
    protected FloatArrays arrays = FloatArrays.instance();
    private final ComparatorFactory floatComparator = ComparatorFactory.INSTANCE;

    public AbstractFloatArrayAssert(float[] actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public void isNullOrEmpty() {
        this.arrays.assertNullOrEmpty(this.info, (float[])this.actual);
    }

    @Override
    public void isEmpty() {
        this.arrays.assertEmpty(this.info, (float[])this.actual);
    }

    @Override
    public SELF isNotEmpty() {
        this.arrays.assertNotEmpty(this.info, (float[])this.actual);
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    @Override
    public SELF hasSize(int expected) {
        this.arrays.assertHasSize(this.info, (float[])this.actual, expected);
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    @Override
    public SELF hasSameSizeAs(Iterable<?> other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, (float[])this.actual, other);
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    public SELF contains(float ... values) {
        this.arrays.assertContains(this.info, (float[])this.actual, values);
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    public SELF contains(float[] values, Offset<Float> precision) {
        this.usingComparatorWithPrecision((Float)precision.value);
        return this.contains(values);
    }

    public SELF containsOnly(float ... values) {
        this.arrays.assertContainsOnly(this.info, (float[])this.actual, values);
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    public SELF containsOnly(float[] values, Offset<Float> precision) {
        this.usingComparatorWithPrecision((Float)precision.value);
        return this.containsOnly(values);
    }

    public SELF containsOnlyOnce(float ... values) {
        this.arrays.assertContainsOnlyOnce(this.info, (float[])this.actual, values);
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    public SELF containsOnlyOnce(float[] values, Offset<Float> precision) {
        this.usingComparatorWithPrecision((Float)precision.value);
        return this.containsOnlyOnce(values);
    }

    public SELF containsSequence(float ... sequence) {
        this.arrays.assertContainsSequence(this.info, (float[])this.actual, sequence);
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    public SELF containsSequence(float[] sequence, Offset<Float> precision) {
        this.usingComparatorWithPrecision((Float)precision.value);
        return this.containsSequence(sequence);
    }

    public SELF containsSubsequence(float ... subsequence) {
        this.arrays.assertContainsSubsequence(this.info, (float[])this.actual, subsequence);
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    public SELF containsSubsequence(float[] subsequence, Offset<Float> precision) {
        this.usingComparatorWithPrecision((Float)precision.value);
        return this.containsSubsequence(subsequence);
    }

    public SELF contains(float value, Index index) {
        this.arrays.assertContains(this.info, (float[])this.actual, value, index);
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    public SELF contains(float value, Index index, Offset<Float> precision) {
        this.usingComparatorWithPrecision((Float)precision.value);
        return this.contains(value, index);
    }

    public SELF doesNotContain(float ... values) {
        this.arrays.assertDoesNotContain(this.info, (float[])this.actual, values);
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    public SELF doesNotContain(float[] values, Offset<Float> precision) {
        this.usingComparatorWithPrecision((Float)precision.value);
        this.arrays.assertDoesNotContain(this.info, (float[])this.actual, values);
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    public SELF doesNotContain(float value, Index index) {
        this.arrays.assertDoesNotContain(this.info, (float[])this.actual, value, index);
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    public SELF doesNotContain(float value, Index index, Offset<Float> precision) {
        this.usingComparatorWithPrecision((Float)precision.value);
        return this.doesNotContain(value, index);
    }

    public SELF doesNotHaveDuplicates() {
        this.arrays.assertDoesNotHaveDuplicates(this.info, (float[])this.actual);
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    public SELF doesNotHaveDuplicates(Offset<Float> precision) {
        this.usingComparatorWithPrecision((Float)precision.value);
        return this.doesNotHaveDuplicates();
    }

    public SELF startsWith(float ... sequence) {
        this.arrays.assertStartsWith(this.info, (float[])this.actual, sequence);
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    public SELF startsWith(float[] values, Offset<Float> precision) {
        this.usingComparatorWithPrecision((Float)precision.value);
        return this.startsWith(values);
    }

    public SELF endsWith(float ... sequence) {
        this.arrays.assertEndsWith(this.info, (float[])this.actual, sequence);
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    public SELF endsWith(float[] values, Offset<Float> precision) {
        this.usingComparatorWithPrecision((Float)precision.value);
        return this.endsWith(values);
    }

    @Override
    public SELF isSorted() {
        this.arrays.assertIsSorted(this.info, (float[])this.actual);
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    @Override
    public SELF isSortedAccordingTo(Comparator<? super Float> comparator) {
        this.arrays.assertIsSortedAccordingToComparator(this.info, (float[])this.actual, comparator);
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    @Override
    @CheckReturnValue
    public SELF usingElementComparator(Comparator<? super Float> customComparator) {
        this.arrays = new FloatArrays(new ComparatorBasedComparisonStrategy(customComparator));
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    @Override
    @CheckReturnValue
    public SELF usingDefaultElementComparator() {
        this.arrays = FloatArrays.instance();
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    public SELF containsExactly(float ... values) {
        this.arrays.assertContainsExactly(this.info, (float[])this.actual, values);
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    public SELF containsExactly(float[] values, Offset<Float> precision) {
        this.usingComparatorWithPrecision((Float)precision.value);
        return this.containsExactly(values);
    }

    public SELF containsExactlyInAnyOrder(float ... values) {
        this.arrays.assertContainsExactlyInAnyOrder(this.info, (float[])this.actual, values);
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    @CheckReturnValue
    public SELF usingComparatorWithPrecision(Float precision) {
        return (SELF)this.usingElementComparator(this.floatComparator.floatComparatorWithPrecision(precision.floatValue()));
    }

    public SELF containsAnyOf(float ... values) {
        this.arrays.assertContainsAnyOf(this.info, (float[])this.actual, values);
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }
}

