/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.assertj.core.api.AbstractIterableAssert;
import org.assertj.core.api.AbstractMapAssert;
import org.assertj.core.api.ErrorCollector;
import org.assertj.core.api.IterableSizeAssert;
import org.assertj.core.api.MapSizeAssert;
import org.assertj.core.api.ProxifyMethodChangingTheObjectUnderTest;
import org.assertj.core.internal.bytebuddy.ByteBuddy;
import org.assertj.core.internal.bytebuddy.TypeCache;
import org.assertj.core.internal.bytebuddy.implementation.MethodDelegation;
import org.assertj.core.internal.bytebuddy.matcher.ElementMatcher;
import org.assertj.core.internal.bytebuddy.matcher.ElementMatchers;

class SoftProxies {
    private final ErrorCollector collector = new ErrorCollector();
    private final TypeCache<TypeCache.SimpleKey> cache = new TypeCache.WithInlineExpunction<TypeCache.SimpleKey>(TypeCache.Sort.SOFT);

    SoftProxies() {
    }

    void collectError(Throwable error) {
        this.collector.addError(error);
    }

    List<Throwable> errorsCollected() {
        return this.collector.errors();
    }

    <V, T> V create(Class<V> assertClass, Class<T> actualClass, T actual) {
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            TypeCache.SimpleKey key = new TypeCache.SimpleKey(assertClass, new Class[0]);
            Class<?> proxyClass = this.cache.findOrInsert(classLoader, key, () -> this.createProxy(assertClass, this.collector));
            Constructor<?> constructor = proxyClass.getConstructor(actualClass);
            return (V)constructor.newInstance(actual);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    Object createIterableSizeAssertProxy(IterableSizeAssert<?> iterableSizeAssert) {
        Class<?> proxyClass = this.createProxy(IterableSizeAssert.class, this.collector);
        try {
            Constructor<?> constructor = proxyClass.getConstructor(AbstractIterableAssert.class, Integer.class);
            return constructor.newInstance(iterableSizeAssert.returnToIterable(), iterableSizeAssert.actual);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private <V> Class<?> createProxy(Class<V> assertClass, ErrorCollector collector) {
        ElementMatcher.Junction specialMethods = ElementMatchers.named("extracting").or(ElementMatchers.named("filteredOn")).or(ElementMatchers.named("filteredOnNull")).or(ElementMatchers.named("map")).or(ElementMatchers.named("asString")).or(ElementMatchers.named("asList")).or(ElementMatchers.named("size")).or(ElementMatchers.named("toAssert")).or(ElementMatchers.named("flatMap")).or(ElementMatchers.named("extractingResultOf")).or(ElementMatchers.named("flatExtracting"));
        return new ByteBuddy().subclass(assertClass).method(specialMethods).intercept(MethodDelegation.to(new ProxifyMethodChangingTheObjectUnderTest(this))).method(ElementMatchers.any().and(ElementMatchers.not(specialMethods))).intercept(MethodDelegation.to(collector)).make().load(assertClass.getClassLoader()).getLoaded();
    }

    public boolean wasSuccess() {
        return this.collector.wasSuccess();
    }

    public Object createMapSizeAssertProxy(MapSizeAssert<?, ?> mapSizeAssert) {
        Class<?> proxyClass = this.createProxy(MapSizeAssert.class, this.collector);
        try {
            Constructor<?> constructor = proxyClass.getConstructor(AbstractMapAssert.class, Integer.class);
            return constructor.newInstance(mapSizeAssert.returnToMap(), mapSizeAssert.actual);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

