/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal.bytebuddy.dynamic.scaffold;

import org.assertj.core.internal.bytebuddy.description.field.FieldDescription;
import org.assertj.core.internal.bytebuddy.description.field.FieldList;
import org.assertj.core.internal.bytebuddy.description.type.TypeDefinition;
import org.assertj.core.internal.bytebuddy.description.type.TypeDescription;
import org.assertj.core.internal.bytebuddy.matcher.ElementMatcher;
import org.assertj.core.internal.bytebuddy.matcher.ElementMatchers;

public interface FieldLocator {
    public Resolution locate(String var1);

    public Resolution locate(String var1, TypeDescription var2);

    public static class ForTopLevelType
    extends AbstractBase {
        protected ForTopLevelType(TypeDescription typeDescription) {
            super(typeDescription);
        }

        @Override
        protected FieldList<?> locate(ElementMatcher<? super FieldDescription> matcher) {
            return (FieldList)this.accessingType.getDeclaredFields().filter(matcher);
        }

        public static enum Factory implements org.assertj.core.internal.bytebuddy.dynamic.scaffold.FieldLocator$Factory
        {
            INSTANCE;


            @Override
            public FieldLocator make(TypeDescription typeDescription) {
                return new ForTopLevelType(typeDescription);
            }
        }
    }

    public static class ForClassHierarchy
    extends AbstractBase {
        private final TypeDescription typeDescription;

        public ForClassHierarchy(TypeDescription typeDescription) {
            this(typeDescription, typeDescription);
        }

        public ForClassHierarchy(TypeDescription typeDescription, TypeDescription accessingType) {
            super(accessingType);
            this.typeDescription = typeDescription;
        }

        @Override
        protected FieldList<?> locate(ElementMatcher<? super FieldDescription> matcher) {
            for (TypeDefinition typeDefinition : this.typeDescription) {
                FieldList candidates = (FieldList)typeDefinition.getDeclaredFields().filter(matcher);
                if (candidates.isEmpty()) continue;
                return candidates;
            }
            return new FieldList.Empty();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForClassHierarchy)) {
                return false;
            }
            ForClassHierarchy other = (ForClassHierarchy)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            TypeDescription this$typeDescription = this.typeDescription;
            TypeDescription other$typeDescription = other.typeDescription;
            return !(this$typeDescription == null ? other$typeDescription != null : !this$typeDescription.equals(other$typeDescription));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ForClassHierarchy;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + super.hashCode();
            TypeDescription $typeDescription = this.typeDescription;
            result = result * 59 + ($typeDescription == null ? 43 : $typeDescription.hashCode());
            return result;
        }

        public static enum Factory implements org.assertj.core.internal.bytebuddy.dynamic.scaffold.FieldLocator$Factory
        {
            INSTANCE;


            @Override
            public FieldLocator make(TypeDescription typeDescription) {
                return new ForClassHierarchy(typeDescription);
            }
        }
    }

    public static class ForExactType
    extends AbstractBase {
        private final TypeDescription typeDescription;

        public ForExactType(TypeDescription typeDescription) {
            this(typeDescription, typeDescription);
        }

        public ForExactType(TypeDescription typeDescription, TypeDescription accessingType) {
            super(accessingType);
            this.typeDescription = typeDescription;
        }

        @Override
        protected FieldList<?> locate(ElementMatcher<? super FieldDescription> matcher) {
            return (FieldList)this.typeDescription.getDeclaredFields().filter(matcher);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForExactType)) {
                return false;
            }
            ForExactType other = (ForExactType)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            TypeDescription this$typeDescription = this.typeDescription;
            TypeDescription other$typeDescription = other.typeDescription;
            return !(this$typeDescription == null ? other$typeDescription != null : !this$typeDescription.equals(other$typeDescription));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ForExactType;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + super.hashCode();
            TypeDescription $typeDescription = this.typeDescription;
            result = result * 59 + ($typeDescription == null ? 43 : $typeDescription.hashCode());
            return result;
        }

        public static class Factory
        implements org.assertj.core.internal.bytebuddy.dynamic.scaffold.FieldLocator$Factory {
            private final TypeDescription typeDescription;

            public Factory(TypeDescription typeDescription) {
                this.typeDescription = typeDescription;
            }

            @Override
            public FieldLocator make(TypeDescription typeDescription) {
                return new ForExactType(this.typeDescription, typeDescription);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Factory)) {
                    return false;
                }
                Factory other = (Factory)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                TypeDescription this$typeDescription = this.typeDescription;
                TypeDescription other$typeDescription = other.typeDescription;
                return !(this$typeDescription == null ? other$typeDescription != null : !this$typeDescription.equals(other$typeDescription));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Factory;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                TypeDescription $typeDescription = this.typeDescription;
                result = result * 59 + ($typeDescription == null ? 43 : $typeDescription.hashCode());
                return result;
            }
        }
    }

    public static abstract class AbstractBase
    implements FieldLocator {
        protected final TypeDescription accessingType;

        protected AbstractBase(TypeDescription accessingType) {
            this.accessingType = accessingType;
        }

        @Override
        public Resolution locate(String name) {
            FieldList<?> candidates = this.locate(ElementMatchers.named(name).and(ElementMatchers.isVisibleTo(this.accessingType)));
            return candidates.size() == 1 ? new Resolution.Simple((FieldDescription)candidates.getOnly()) : Resolution.Illegal.INSTANCE;
        }

        @Override
        public Resolution locate(String name, TypeDescription type) {
            FieldList<?> candidates = this.locate(ElementMatchers.named(name).and(ElementMatchers.fieldType(type)).and(ElementMatchers.isVisibleTo(this.accessingType)));
            return candidates.size() == 1 ? new Resolution.Simple((FieldDescription)candidates.getOnly()) : Resolution.Illegal.INSTANCE;
        }

        protected abstract FieldList<?> locate(ElementMatcher<? super FieldDescription> var1);

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AbstractBase)) {
                return false;
            }
            AbstractBase other = (AbstractBase)o;
            if (!other.canEqual(this)) {
                return false;
            }
            TypeDescription this$accessingType = this.accessingType;
            TypeDescription other$accessingType = other.accessingType;
            return !(this$accessingType == null ? other$accessingType != null : !this$accessingType.equals(other$accessingType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AbstractBase;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TypeDescription $accessingType = this.accessingType;
            result = result * 59 + ($accessingType == null ? 43 : $accessingType.hashCode());
            return result;
        }
    }

    public static enum NoOp implements FieldLocator,
    Factory
    {
        INSTANCE;


        @Override
        public FieldLocator make(TypeDescription typeDescription) {
            return this;
        }

        @Override
        public Resolution locate(String name) {
            return Resolution.Illegal.INSTANCE;
        }

        @Override
        public Resolution locate(String name, TypeDescription type) {
            return Resolution.Illegal.INSTANCE;
        }
    }

    public static interface Factory {
        public FieldLocator make(TypeDescription var1);
    }

    public static interface Resolution {
        public boolean isResolved();

        public FieldDescription getField();

        public static class Simple
        implements Resolution {
            private final FieldDescription fieldDescription;

            protected Simple(FieldDescription fieldDescription) {
                this.fieldDescription = fieldDescription;
            }

            @Override
            public boolean isResolved() {
                return true;
            }

            @Override
            public FieldDescription getField() {
                return this.fieldDescription;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Simple)) {
                    return false;
                }
                Simple other = (Simple)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                FieldDescription this$fieldDescription = this.fieldDescription;
                FieldDescription other$fieldDescription = other.fieldDescription;
                return !(this$fieldDescription == null ? other$fieldDescription != null : !this$fieldDescription.equals(other$fieldDescription));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Simple;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                FieldDescription $fieldDescription = this.fieldDescription;
                result = result * 59 + ($fieldDescription == null ? 43 : $fieldDescription.hashCode());
                return result;
            }
        }

        public static enum Illegal implements Resolution
        {
            INSTANCE;


            @Override
            public boolean isResolved() {
                return false;
            }

            @Override
            public FieldDescription getField() {
                throw new IllegalStateException("Could not locate field");
            }
        }
    }
}

