/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Preconditions;

public final class IterableUtil {
    public static boolean isNullOrEmpty(Iterable<?> iterable) {
        if (iterable == null) {
            return true;
        }
        if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
            return true;
        }
        return !iterable.iterator().hasNext();
    }

    public static int sizeOf(Iterable<?> iterable) {
        Preconditions.checkNotNull(iterable, "Iterable must not be null");
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size();
        }
        int size = 0;
        Iterator<?> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            ++size;
            iterator.next();
        }
        return size;
    }

    public static <T> List<T> nonNullElementsIn(Iterable<? extends T> i) {
        if (IterableUtil.isNullOrEmpty(i)) {
            return Collections.emptyList();
        }
        ArrayList<T> nonNull = new ArrayList<T>();
        for (T element : i) {
            if (element == null) continue;
            nonNull.add(element);
        }
        return nonNull;
    }

    public static <T> T[] toArray(Iterable<? extends T> iterable) {
        if (iterable == null) {
            return null;
        }
        return Lists.newArrayList(iterable).toArray();
    }

    public static <T> T[] toArray(Iterable<? extends T> iterable, Class<T> type) {
        if (iterable == null) {
            return null;
        }
        Collection<T> collection = IterableUtil.toCollection(iterable);
        T[] array = IterableUtil.newArray(type, collection.size());
        return collection.toArray(array);
    }

    public static <T> Collection<T> toCollection(Iterable<T> iterable) {
        return iterable instanceof Collection ? (ArrayList<T>)iterable : Lists.newArrayList(iterable);
    }

    @SafeVarargs
    public static <T> Iterable<T> iterable(T ... elements) {
        if (elements == null) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        Collections.addAll(list, elements);
        return list;
    }

    @SafeVarargs
    public static <T> Iterator<T> iterator(T ... elements) {
        if (elements == null) {
            return null;
        }
        return IterableUtil.iterable(elements).iterator();
    }

    private static <T> T[] newArray(Class<T> type, int length) {
        return (Object[])Array.newInstance(type, length);
    }

    private IterableUtil() {
    }
}

