/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.call_log_output;

import be.iminds.ilabt.jfed.call_log_output.LogOutput;
import be.iminds.ilabt.jfed.call_log_output.SerializableApiCallDetails;
import be.iminds.ilabt.jfed.lowlevel.stitching.StitchingData;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import be.iminds.ilabt.jfed.util.library.DataConversionUtils;
import be.iminds.ilabt.jfed.util.library.XmlUtil;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.rendersnake.HtmlAttributesFactory;
import org.rendersnake.HtmlCanvas;
import org.rendersnake.internal.CharactersWriteable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class HtmlLogOutput
extends LogOutput {
    private final String reportTitle;
    private static final Pattern HAS_COMPRESSED_PATTERN = Pattern.compile("\"?geni_compressed\"?\\s*:\\s*\"?true");
    public static final String MACHINE_LOGLINE_PREFIX = "RAW_INFO";

    protected HtmlLogOutput(String reportTitle) {
        this.reportTitle = reportTitle;
    }

    public String getReportTitle() {
        return this.reportTitle;
    }

    public static String getEmbeddedImageCss(String cssClassName, String resourcename, int x, int y) throws IOException {
        int len;
        InputStream is = HtmlLogOutput.class.getResourceAsStream(resourcename);
        assert (is != null) : "Failed to get InputStream for resource \"" + resourcename + "\"";
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = is.read(buffer)) != -1) {
            bout.write(buffer, 0, len);
        }
        bout.close();
        String base64 = DataConversionUtils.encodeBase64((byte[])bout.toByteArray());
        return "div.image-" + cssClassName + " {\n  width:" + x + "px;\n  height:" + y + "px;\n  margin: 3px 10px 3px 10px;\n  float: left;\n  background-image:url(data:image/png;base64," + base64 + "); \n}";
    }

    public static void writeImage(HtmlCanvas html, LogOutput.TestResultState state) throws IOException {
        String stateCssClassName = HtmlLogOutput.stateClass(state);
        html.div((CharactersWriteable)HtmlAttributesFactory.class_((String)("image-" + stateCssClassName)));
        html._div();
    }

    public static String stateClass(LogOutput.TestResultState state) {
        switch (state) {
            case SKIPPED: {
                return "skip";
            }
            case SUCCESS: {
                return "success";
            }
            case WARN: {
                return "warn";
            }
            case FAILED: {
                return "fail";
            }
        }
        return "fail";
    }

    public static void addKeyValue(HtmlCanvas html, String clazz, String key, String value) throws IOException {
        html.tr();
        html.td((CharactersWriteable)HtmlAttributesFactory.class_((String)"key"));
        html.span().content(key + ": ", true);
        html._td();
        html.td((CharactersWriteable)HtmlAttributesFactory.class_((String)"value"));
        html.span((CharactersWriteable)HtmlAttributesFactory.class_((String)clazz)).content(value, true);
        html._td();
        html._tr();
    }

    public static void addCollapsable(HtmlCanvas html, String clazz, String shortText, String fullContent) throws IOException {
        if (fullContent == null) {
            HtmlLogOutput.addKeyValue(html, clazz, shortText, "");
        } else {
            int newLineCount = 0;
            for (int i = 0; i < fullContent.length(); ++i) {
                if (fullContent.charAt(i) != '\n') continue;
                ++newLineCount;
            }
            if (fullContent.length() > 150 || newLineCount > 1) {
                String id = clazz + Math.random();
                html.tr();
                html.td((CharactersWriteable)HtmlAttributesFactory.class_((String)"key"));
                html.span().content(shortText + ": ", true);
                html._td();
                html.td((CharactersWriteable)HtmlAttributesFactory.class_((String)"value"));
                html.a((CharactersWriteable)HtmlAttributesFactory.class_((String)"reveal").onClick("switchVisibility('" + id + "')").title("Hide/Show " + shortText)).content("Hide/Show", true);
                html.div((CharactersWriteable)HtmlAttributesFactory.style((String)"display:none;").class_(clazz + "-big").id(id)).content(fullContent, true);
                html._td();
                html._tr();
            } else {
                HtmlLogOutput.addKeyValue(html, clazz, shortText, fullContent);
            }
        }
    }

    public static void addClassVisibleToggle(HtmlCanvas html, String className, String text) throws IOException {
        html.div();
        html.span().content(text + ": ", true);
        html.a((CharactersWriteable)HtmlAttributesFactory.class_((String)"reveal").onClick("switchClassVisibility('" + className + "')").title("Hide/Show " + text)).content("Hide/Show", true);
        html._div();
    }

    public void toHtmlFile(File file) {
        this.toHtmlFile(file, false);
    }

    public abstract void htmlContent(HtmlCanvas var1) throws IOException;

    public String toHtmlString(boolean showSecurityRisks) {
        return this.toHtmlString(showSecurityRisks, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toHtmlString(boolean showSecurityRisks, boolean addPolyFills) {
        StringWriter writer = null;
        try {
            writer = new StringWriter();
            this.toHtml(writer, showSecurityRisks, addPolyFills);
            String string = writer.getBuffer().toString();
            return string;
        }
        catch (IOException e) {
            LOG.error("IOException writing to string", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    LOG.error("IOException trying to close StringWriter", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toHtmlFile(File file, boolean showSecurityRisks) {
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            this.toHtml(writer, showSecurityRisks);
        }
        catch (IOException e) {
            LOG.error("IOException writing to file \"" + file.getPath() + "\"", (Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    LOG.error("IOException trying to close file \"" + file.getPath() + "\"", (Throwable)e);
                }
            }
        }
    }

    public void toHtml(Writer writer, boolean showSecurityRisks) throws IOException {
        this.toHtml(writer, showSecurityRisks, false);
    }

    public static void writeStart(@Nonnull HtmlCanvas html, boolean addPolyFills, String reportTitle) throws IOException {
        String failCss = "";
        String okCss = "";
        String skipCss = "";
        String warnCss = "";
        try {
            failCss = HtmlLogOutput.getEmbeddedImageCss("fail", "error15x15.png", 15, 15);
            okCss = HtmlLogOutput.getEmbeddedImageCss("success", "ok15x15.png", 15, 15);
            skipCss = HtmlLogOutput.getEmbeddedImageCss("skip", "skip15x15.png", 15, 15);
            warnCss = HtmlLogOutput.getEmbeddedImageCss("warn", "warning15x15.png", 15, 15);
        }
        catch (IOException e) {
            LOG.error("Error while loading generated html css or png. This will be ignored.", (Throwable)e);
        }
        html.html().head().title().content(reportTitle).meta((CharactersWriteable)HtmlAttributesFactory.name((String)"description").add("content", "description", false)).macros().stylesheet("result.css");
        InputStream cssis = HtmlLogOutput.class.getResourceAsStream("result.css");
        Object cssContent = IOUtils.streamToString((InputStream)cssis, (String)"UTF-8");
        cssContent = (String)cssContent + failCss + "\n";
        cssContent = (String)cssContent + okCss + "\n";
        cssContent = (String)cssContent + skipCss + "\n";
        cssContent = (String)cssContent + warnCss + "\n";
        html.style((CharactersWriteable)HtmlAttributesFactory.media((String)"screen").type("text/css")).content((String)cssContent, false);
        InputStream jsis = HtmlLogOutput.class.getResourceAsStream("result.js");
        String jsContent = IOUtils.streamToString((InputStream)jsis, (String)"UTF-8");
        html.script((CharactersWriteable)HtmlAttributesFactory.language((String)"JavaScript1.3")).content(jsContent, false);
        jsis = HtmlLogOutput.class.getResourceAsStream("vkbeautify.0.99.00.beta.js");
        jsContent = IOUtils.streamToString((InputStream)jsis, (String)"UTF-8");
        html.script((CharactersWriteable)HtmlAttributesFactory.language((String)"JavaScript1.3")).content(jsContent, false);
        jsis = HtmlLogOutput.class.getResourceAsStream("base64js.min.js");
        jsContent = IOUtils.streamToString((InputStream)jsis, (String)"UTF-8");
        html.script((CharactersWriteable)HtmlAttributesFactory.language((String)"JavaScript1.3")).content(jsContent, false);
        jsis = HtmlLogOutput.class.getResourceAsStream("inflate.min.js");
        jsContent = IOUtils.streamToString((InputStream)jsis, (String)"UTF-8");
        html.script((CharactersWriteable)HtmlAttributesFactory.language((String)"JavaScript1.3")).content(jsContent, false);
        if (addPolyFills) {
            jsis = HtmlLogOutput.class.getResourceAsStream("encoding-indexes.js");
            jsContent = IOUtils.streamToString((InputStream)jsis, (String)"UTF-8");
            html.script((CharactersWriteable)HtmlAttributesFactory.language((String)"JavaScript1.3")).content(jsContent, false);
            jsis = HtmlLogOutput.class.getResourceAsStream("encoding.js");
            jsContent = IOUtils.streamToString((InputStream)jsis, (String)"UTF-8");
            html.script((CharactersWriteable)HtmlAttributesFactory.language((String)"JavaScript1.3")).content(jsContent, false);
        }
        html._head().body();
    }

    public static void writeEnd(@Nonnull HtmlCanvas html) throws IOException {
        html._body()._html();
    }

    public void toHtml(Writer writer, boolean showSecurityRisks, boolean addPolyFills) throws IOException {
        disableRemoveSecurityRisks = showSecurityRisks;
        HtmlCanvas html = new HtmlCanvas(writer);
        HtmlLogOutput.writeStart(html, addPolyFills, this.reportTitle);
        this.htmlContent(html);
        HtmlLogOutput.writeEnd(html);
        writer.flush();
        disableRemoveSecurityRisks = false;
    }

    public static void writeOverviewItem(@Nonnull HtmlCanvas html, int index, LogOutput.TestResultState state, String name) throws IOException {
        html.div((CharactersWriteable)HtmlAttributesFactory.class_((String)"methodoverview-full"));
        HtmlLogOutput.writeImage(html, state);
        html.span((CharactersWriteable)HtmlAttributesFactory.class_((String)("methodoverview-methodname " + HtmlLogOutput.stateClass(state) + "header"))).span().a((CharactersWriteable)HtmlAttributesFactory.href((String)("#test" + index))).content(name, true)._span()._span();
        html._div();
    }

    public static void writeCall(HtmlCanvas html, int index, int apiCallCount, SerializableApiCallDetails details) throws IOException {
        String id = "api-call-" + index + "-" + apiCallCount;
        html.div();
        html.span().content("Api Call " + apiCallCount + ": ", true);
        html.a((CharactersWriteable)HtmlAttributesFactory.class_((String)"reveal").onClick("switchVisibility('" + id + "')").title("Hide/Show Api Call")).content("Hide/Show", true);
        html.span().content(" (" + details.getGeniMethodName() + " @ " + details.getAuthorityUrn() + ")");
        html._div();
        html.div((CharactersWriteable)HtmlAttributesFactory.style((String)"display:none;").class_("api-call").id(id));
        html.table((CharactersWriteable)HtmlAttributesFactory.style((String)"width:100%; table-layout: fixed;"));
        HtmlLogOutput.addKeyValue(html, "value-nondata", "API Name", details.getApiName());
        if (details.getAuthorityName() != null || details.getAuthorityUrn() != null) {
            HtmlLogOutput.addKeyValue(html, "value-nondata", "Authority HRN", details.getAuthorityName());
            HtmlLogOutput.addKeyValue(html, "value-data", "Authority URN", details.getAuthorityUrn());
        }
        if (details.getStartTime() != null) {
            HtmlLogOutput.addKeyValue(html, "value-data", "Start Time", HtmlLogOutput.dateToString(details.getStartTime()));
        }
        if (details.getStopTime() != null) {
            HtmlLogOutput.addKeyValue(html, "value-data", "Stop Time", HtmlLogOutput.dateToString(details.getStopTime()));
        }
        HtmlLogOutput.addKeyValue(html, "value-data", "API Method Name", details.getGeniMethodName());
        HtmlLogOutput.addKeyValue(html, "value-data", "Java Method Name", details.getGeniMethodName());
        HtmlLogOutput.addKeyValue(html, "value-data", "Server URL", details.getCallServerUrl());
        if (!Objects.equals(details.getBaseServerUrl(), details.getCallServerUrl())) {
            HtmlLogOutput.addKeyValue(html, "value-data", "Base Server URL", details.getBaseServerUrl());
        }
        if (details.getConnectionSslAuthUserUrn() != null) {
            HtmlLogOutput.addKeyValue(html, "value-data", "Connection User URN", details.getConnectionSslAuthUserUrn());
        }
        if (details.getProxyInfo() != null) {
            HtmlLogOutput.addKeyValue(html, "value-data", "Proxy", details.getProxyInfo().toString());
        }
        if (details.getConnectionSslAuthUserCertificates() != null) {
            HtmlLogOutput.addCollapsable(html, "value-data", "Connection User certificates", HtmlLogOutput.removeSecurityRisks(details.getConnectionSslAuthUserCertificates()));
        }
        if (details.getProxyInfo() != null) {
            HtmlLogOutput.addCollapsable(html, "value-data", "Connection Proxy Settings", HtmlLogOutput.removeSecurityRisks(details.getProxyInfo().toString()));
        }
        String baseId = "c" + index + "-" + apiCallCount;
        boolean hasRequestHttpRspec = HtmlLogOutput.isJsonStringRspec(details.getHttpRequest());
        boolean hasRequestGeniRspec = HtmlLogOutput.hasRspec(details.getXmlRpcRequestJsonObject(), true, false);
        boolean hasRequestRSpec = hasRequestHttpRspec || hasRequestGeniRspec;
        String idShowHtmlReqButton = "showHtmlReqButton" + baseId;
        String idShowXmlReqButton = "showXmlReqButton" + baseId;
        String idShowRspecReqButton = "showRSpecReqButton" + baseId;
        String idShowHtmlReqButtonPretty = "showHtmlReqButtonPretty" + baseId;
        String idShowRspecReqButtonPretty = "showRSpecReqButtonPretty" + baseId;
        String idShowHtmlReqText = "showHtmlReqText" + baseId;
        String idShowXmlReqText = "showXmlReqText" + baseId;
        String idShowRSpecReqText = "showRSpecReqText" + baseId;
        String idShowHtmlReqTextPretty = "showHtmlReqTextPretty" + baseId;
        String idShowRSpecReqTextPretty = "showRSpecReqTextPretty" + baseId;
        String idShowNoReqText = "showNoReqText" + baseId;
        String[] allRequestButtons = new String[]{idShowHtmlReqButton, idShowXmlReqButton, idShowRspecReqButton, idShowHtmlReqButtonPretty, idShowRspecReqButtonPretty};
        String[] allRequestText = new String[]{idShowHtmlReqText, idShowXmlReqText, idShowRSpecReqText, idShowHtmlReqTextPretty, idShowRSpecReqTextPretty};
        html.tr();
        html.td((CharactersWriteable)HtmlAttributesFactory.class_((String)"key"));
        html.table((CharactersWriteable)HtmlAttributesFactory.class_((String)"format-table"));
        html.tr();
        html.td((CharactersWriteable)HtmlAttributesFactory.class_((String)"format-table-key").title("Content of the HTTP Request")).content("HTTP");
        html.td((CharactersWriteable)HtmlAttributesFactory.class_((String)"format-table-raw"));
        html.div((CharactersWriteable)HtmlAttributesFactory.class_((String)"reveal").id(idShowHtmlReqButton).onClick(HtmlLogOutput.generateToggleButtonCode(idShowHtmlReqButton, allRequestButtons) + HtmlLogOutput.generateRevealCode(idShowHtmlReqText, idShowNoReqText, allRequestText))).content("raw", true);
        html._td();
        html.td((CharactersWriteable)HtmlAttributesFactory.class_((String)"format-table-formatted"));
        html.div((CharactersWriteable)HtmlAttributesFactory.class_((String)"reveal").id(idShowHtmlReqButtonPretty).onClick(HtmlLogOutput.generateToggleButtonCode(idShowHtmlReqButtonPretty, allRequestButtons) + HtmlLogOutput.generateRevealCode(idShowHtmlReqTextPretty, idShowNoReqText, allRequestText) + "formatXmlDiv('" + idShowHtmlReqText + "','" + idShowHtmlReqTextPretty + "');")).content("pretty", true);
        html._td();
        html._tr();
        html.tr();
        html.td((CharactersWriteable)HtmlAttributesFactory.class_((String)"format-table-key").title("List of XML-RPC Request Parameters, encoded as JSON for easier reading")).content("XML-RPC");
        html.td((CharactersWriteable)HtmlAttributesFactory.class_((String)"format-table-raw"));
        html.div((CharactersWriteable)HtmlAttributesFactory.class_((String)"reveal").id(idShowXmlReqButton).onClick(HtmlLogOutput.generateToggleButtonCode(idShowXmlReqButton, allRequestButtons) + HtmlLogOutput.generateRevealCode(idShowXmlReqText, idShowNoReqText, allRequestText))).content("raw", true);
        html._td();
        html.td((CharactersWriteable)HtmlAttributesFactory.class_((String)"format-table-formatted"));
        html._td();
        html._tr();
        if (hasRequestRSpec) {
            String showRspecFormattedCode;
            String showRspecRawCode;
            String rspecSourceId = hasRequestGeniRspec ? idShowXmlReqText : idShowHtmlReqText;
            if (hasRequestGeniRspec) {
                showRspecRawCode = "getEmbeddedRspecDiv('" + rspecSourceId + "', '" + idShowRSpecReqText + "');\n";
                showRspecFormattedCode = "formatEmbeddedRspecDiv('" + rspecSourceId + "', '" + idShowRSpecReqTextPretty + "');\n";
            } else {
                showRspecRawCode = "copyDiv('" + rspecSourceId + "', '" + idShowRSpecReqText + "');\n";
                showRspecFormattedCode = "formatXmlDiv('" + rspecSourceId + "', '" + idShowRSpecReqTextPretty + "');\n";
            }
            html.tr();
            html.td((CharactersWriteable)HtmlAttributesFactory.class_((String)"format-table-key").title("An RSpec detected somewhere in the Request.")).content("RSpec");
            html.td((CharactersWriteable)HtmlAttributesFactory.class_((String)"format-table-raw"));
            html.div((CharactersWriteable)HtmlAttributesFactory.class_((String)"reveal").id(idShowRspecReqButton).onClick(HtmlLogOutput.generateToggleButtonCode(idShowRspecReqButton, allRequestButtons) + HtmlLogOutput.generateRevealCode(idShowRSpecReqText, idShowNoReqText, allRequestText) + showRspecRawCode)).content("raw", true);
            html._td();
            html.td((CharactersWriteable)HtmlAttributesFactory.class_((String)"format-table-formatted"));
            html.div((CharactersWriteable)HtmlAttributesFactory.class_((String)"reveal").id(idShowRspecReqButtonPretty).onClick(HtmlLogOutput.generateToggleButtonCode(idShowRspecReqButtonPretty, allRequestButtons) + HtmlLogOutput.generateRevealCode(idShowRSpecReqTextPretty, idShowNoReqText, allRequestText) + showRspecFormattedCode)).content("pretty", true);
            html._td();
            html._tr();
        }
        html._table();
        html.div((CharactersWriteable)HtmlAttributesFactory.class_((String)"format-header")).content("Request: ", true);
        html._td();
        html.td((CharactersWriteable)HtmlAttributesFactory.class_((String)"value"));
        html.div((CharactersWriteable)HtmlAttributesFactory.class_((String)"value-data-big initially-hidden").id(idShowHtmlReqText)).content(HtmlLogOutput.removeSecurityRisks(details.getHttpRequest()), true);
        html.div((CharactersWriteable)HtmlAttributesFactory.class_((String)"value-data-big initially-hidden").id(idShowHtmlReqTextPretty)).content("loading...", true);
        html.div((CharactersWriteable)HtmlAttributesFactory.class_((String)"value-data-big initially-hidden").id(idShowXmlReqText)).content(HtmlLogOutput.removeSecurityRisks(details.getXmlRpcRequestJsonString()), true);
        if (hasRequestRSpec) {
            html.div((CharactersWriteable)HtmlAttributesFactory.class_((String)"value-data-big initially-hidden").id(idShowRSpecReqText)).content("loading...", true);
            html.div((CharactersWriteable)HtmlAttributesFactory.class_((String)"value-data-big initially-hidden").id(idShowRSpecReqTextPretty)).content("loading...", true);
        }
        html.div((CharactersWriteable)HtmlAttributesFactory.class_((String)"small-help").id(idShowNoReqText)).content("(click a format to show the data)", true);
        html._td();
        html._tr();
        String idShowHtmlReplyButton = "showHtmlReplyButton" + baseId;
        String idShowXmlReplyButton = "showXmlReplyButton" + baseId;
        String idShowGeniValReplyButton = "showGeniValReplyButton" + baseId;
        String idShowRSpecReplyButton = "showRSpecReplyButton" + baseId;
        String idShowHtmlReplyButtonFormatted = "showHtmlReplyButtonFormatted" + baseId;
        String idShowGeniValReplyButtonFormatted = "showGeniValReplyButtonFormatted" + baseId;
        String idShowRSpecReplyButtonFormatted = "showRSpecReplyButtonFormatted" + baseId;
        String idShowHtmlReplyText = "showHtmlReplyText" + baseId;
        String idShowXmlReplyText = "showXmlReplyText" + baseId;
        String idShowGeniValReplyText = "showGeniValReplyText" + baseId;
        String idShowGeniValReplyTextDetail = "showGeniValReplyTextDetail" + baseId;
        String idShowRSpecReplyText = "showRSpecReplyText" + baseId;
        String idShowHtmlReplyTextFormatted = "showHtmlReplyTextFormatted" + baseId;
        String idShowGeniValReplyTextFormatted = "showGeniValReplyTextFormatted" + baseId;
        String idShowRSpecReplyTextFormatted = "showRSpecReplyTextFormatted" + baseId;
        String idShowNoReplyText = "showNoReplyText" + baseId;
        String[] allReplyButtons = new String[]{idShowHtmlReplyButton, idShowXmlReplyButton, idShowGeniValReplyButton, idShowRSpecReplyButton, idShowHtmlReplyButtonFormatted, idShowGeniValReplyButtonFormatted, idShowRSpecReplyButtonFormatted};
        String[] allReplyText = new String[]{idShowHtmlReplyText, idShowXmlReplyText, idShowGeniValReplyText, idShowRSpecReplyText, idShowHtmlReplyTextFormatted, idShowGeniValReplyTextFormatted, idShowRSpecReplyTextFormatted};
        boolean hasGeniVal = details.getGeniResponseCode() != null;
        Object xmlRpcResponseJsonObject = details.getXmlRpcResponseJsonObject();
        Object xmlRpcResponseJsonObjectValue = xmlRpcResponseJsonObject instanceof Map && ((Map)xmlRpcResponseJsonObject).containsKey("value") ? ((Map)xmlRpcResponseJsonObject).get("value") : xmlRpcResponseJsonObject;
        boolean hasReplyHttpRspec = HtmlLogOutput.isRSpec(details.getHttpResponse());
        boolean hasReplyGeniRSpec = HtmlLogOutput.isRSpec(xmlRpcResponseJsonObjectValue);
        boolean hasReplyCompressedRSpec = HtmlLogOutput.isCompressedRSpec(xmlRpcResponseJsonObjectValue);
        boolean hasReplyRSpec = hasReplyCompressedRSpec || hasReplyHttpRspec || hasReplyGeniRSpec;
        boolean hasEmbeddedReplyGeniRSpec = !hasReplyRSpec && HtmlLogOutput.hasRspec(xmlRpcResponseJsonObjectValue, true, false);
        boolean hasEmbeddedReplyGeniCompressedRSpec = !hasReplyRSpec && HtmlLogOutput.hasRspec(xmlRpcResponseJsonObjectValue, false, true);
        boolean hasEmbeddedReplyRSpec = hasEmbeddedReplyGeniRSpec || hasEmbeddedReplyGeniCompressedRSpec;
        boolean hasFormattableGeniVal = hasGeniVal && HtmlLogOutput.isXml(details.getXmlRpcGeniResponseValue()) && !hasReplyCompressedRSpec;
        LOG.debug("call={} hasRspec={} hasCompressedRSpec={} hasGeniRSpec={} hasHttpRspec={} hasFormattableGeniVal={} resp.len={} hasComp={}", new Object[]{details.getGeniMethodName(), hasReplyRSpec, hasReplyCompressedRSpec, hasReplyGeniRSpec, hasReplyHttpRspec, hasFormattableGeniVal, details.getXmlRpcGeniResponseValue() != null ? "" + details.getXmlRpcGeniResponseValue().length() : "null", HtmlLogOutput.hasCompressedReply(details.getXmlRpcRequestJsonString())});
        html.tr();
        html.td((CharactersWriteable)HtmlAttributesFactory.class_((String)"key"));
        html.table((CharactersWriteable)HtmlAttributesFactory.class_((String)"format-table"));
        html.tr();
        html.td((CharactersWriteable)HtmlAttributesFactory.class_((String)"format-table-key").title("Content of the HTTP Reply")).content("HTTP");
        html.td((CharactersWriteable)HtmlAttributesFactory.class_((String)"format-table-raw"));
        html.div((CharactersWriteable)HtmlAttributesFactory.class_((String)"reveal").id(idShowHtmlReplyButton).onClick(HtmlLogOutput.generateToggleButtonCode(idShowHtmlReplyButton, allReplyButtons) + HtmlLogOutput.generateRevealCode(idShowHtmlReplyText, idShowNoReplyText, allReplyText))).content("raw", true);
        html._td();
        html.td((CharactersWriteable)HtmlAttributesFactory.class_((String)"format-table-formatted"));
        html.div((CharactersWriteable)HtmlAttributesFactory.class_((String)"reveal").id(idShowHtmlReplyButtonFormatted).onClick(HtmlLogOutput.generateToggleButtonCode(idShowHtmlReplyButtonFormatted, allReplyButtons) + HtmlLogOutput.generateRevealCode(idShowHtmlReplyTextFormatted, idShowNoReplyText, allReplyText) + "formatXmlDiv('" + idShowHtmlReplyText + "','" + idShowHtmlReplyTextFormatted + "');")).content("pretty", true);
        html._td();
        html._tr();
        html.tr();
        html.td((CharactersWriteable)HtmlAttributesFactory.class_((String)"format-table-key").title("The XML-RPC reply, encoded as JSON for easier reading")).content("XML-RPC");
        html.td((CharactersWriteable)HtmlAttributesFactory.class_((String)"format-table-raw"));
        html.div((CharactersWriteable)HtmlAttributesFactory.class_((String)"reveal").id(idShowXmlReplyButton).onClick(HtmlLogOutput.generateToggleButtonCode(idShowXmlReplyButton, allReplyButtons) + HtmlLogOutput.generateRevealCode(idShowXmlReplyText, idShowNoReplyText, allReplyText))).content("raw", true);
        html._td();
        html.td((CharactersWriteable)HtmlAttributesFactory.class_((String)"format-table-formatted"));
        html._td();
        html._tr();
        if (hasGeniVal) {
            html.tr();
            html.td((CharactersWriteable)HtmlAttributesFactory.class_((String)"format-table-key").title("In the Geni SFA API's, all replies are a single object containing 'code', 'output' and 'value' fields. These are shown seperately here. If the Geni value contains XML, \"pretty\" will format and ident that XML.")).content("Geni Value");
            html.td((CharactersWriteable)HtmlAttributesFactory.class_((String)"format-table-raw"));
            html.div((CharactersWriteable)HtmlAttributesFactory.class_((String)"reveal").id(idShowGeniValReplyButton).onClick(HtmlLogOutput.generateToggleButtonCode(idShowGeniValReplyButton, allReplyButtons) + HtmlLogOutput.generateRevealCode(idShowGeniValReplyText, idShowNoReplyText, allReplyText))).content("raw", true);
            html._td();
            html.td((CharactersWriteable)HtmlAttributesFactory.class_((String)"format-table-formatted"));
            if (hasFormattableGeniVal) {
                html.div((CharactersWriteable)HtmlAttributesFactory.class_((String)"reveal").id(idShowGeniValReplyButtonFormatted).onClick(HtmlLogOutput.generateToggleButtonCode(idShowGeniValReplyButtonFormatted, allReplyButtons) + HtmlLogOutput.generateRevealCode(idShowGeniValReplyTextFormatted, idShowNoReplyText, allReplyText) + "formatXmlDiv('" + idShowGeniValReplyTextDetail + "','" + idShowGeniValReplyTextFormatted + "');\n")).content("pretty", true);
            }
            html._td();
            html._tr();
        }
        if (hasReplyRSpec || hasEmbeddedReplyRSpec) {
            Object showRspecFormattedCode;
            Object showRspecRawCode;
            String rspecSourceId = hasReplyCompressedRSpec || hasReplyGeniRSpec || hasEmbeddedReplyRSpec ? idShowGeniValReplyTextDetail : idShowHtmlReplyText;
            if (hasReplyCompressedRSpec) {
                showRspecRawCode = "decompressedDiv('" + rspecSourceId + "', '" + idShowRSpecReplyText + "');\n";
                showRspecFormattedCode = "formatCompressedXmlDiv('" + rspecSourceId + "', '" + idShowRSpecReplyTextFormatted + "');\n";
            } else if (hasReplyGeniRSpec) {
                showRspecRawCode = "getEmbeddedRspecDiv('" + rspecSourceId + "', '" + idShowRSpecReplyText + "');\n";
                showRspecFormattedCode = "formatEmbeddedRspecDiv('" + rspecSourceId + "', '" + idShowRSpecReplyTextFormatted + "');\n";
            } else if (hasReplyHttpRspec) {
                showRspecRawCode = "copyDiv('" + rspecSourceId + "', '" + idShowRSpecReplyText + "');\n";
                showRspecFormattedCode = "formatXmlDiv('" + rspecSourceId + "', '" + idShowRSpecReplyTextFormatted + "');\n";
            } else if (hasEmbeddedReplyGeniRSpec) {
                showRspecRawCode = "getEmbeddedRspecDiv('" + rspecSourceId + "', '" + idShowRSpecReplyText + "');\n";
                showRspecFormattedCode = "formatEmbeddedRspecDiv('" + rspecSourceId + "', '" + idShowRSpecReplyTextFormatted + "');\n";
            } else if (hasEmbeddedReplyGeniCompressedRSpec) {
                showRspecRawCode = "decompressedDiv('" + rspecSourceId + "', '" + idShowRSpecReplyText + "');\n";
                showRspecFormattedCode = "formatCompressedXmlDiv('" + rspecSourceId + "', '" + idShowRSpecReplyTextFormatted + "');\n";
            } else {
                assert (false) : "unsupported case";
                showRspecRawCode = "error();";
                showRspecFormattedCode = "error();";
            }
            html.tr();
            html.td((CharactersWriteable)HtmlAttributesFactory.class_((String)"format-table-key").title("An RSpec found in the reply. If needed, base64 decoding and zlib inflation will be used to make the RSpec readable.")).content("RSpec");
            html.td((CharactersWriteable)HtmlAttributesFactory.class_((String)"format-table-raw"));
            html.div((CharactersWriteable)HtmlAttributesFactory.class_((String)"reveal").id(idShowRSpecReplyButton).onClick(HtmlLogOutput.generateToggleButtonCode(idShowRSpecReplyButton, allReplyButtons) + HtmlLogOutput.generateRevealCode(idShowRSpecReplyText, idShowNoReplyText, allReplyText) + (String)showRspecRawCode)).content("raw", true);
            html._td();
            html.td((CharactersWriteable)HtmlAttributesFactory.class_((String)"format-table-formatted"));
            html.div((CharactersWriteable)HtmlAttributesFactory.class_((String)"reveal").id(idShowRSpecReplyButtonFormatted).onClick(HtmlLogOutput.generateToggleButtonCode(idShowRSpecReplyButtonFormatted, allReplyButtons) + HtmlLogOutput.generateRevealCode(idShowRSpecReplyTextFormatted, idShowNoReplyText, allReplyText) + (String)showRspecFormattedCode)).content("pretty", true);
            html._td();
            html._tr();
        }
        html._table();
        html.div((CharactersWriteable)HtmlAttributesFactory.class_((String)"format-header")).content("Reply: ", true);
        html._td();
        html.td((CharactersWriteable)HtmlAttributesFactory.class_((String)"value"));
        html.div((CharactersWriteable)HtmlAttributesFactory.class_((String)"value-data-big initially-hidden").id(idShowHtmlReplyText)).content(HtmlLogOutput.removeSecurityRisks(details.getHttpResponse()), true);
        html.div((CharactersWriteable)HtmlAttributesFactory.class_((String)"value-data-big initially-hidden").id(idShowHtmlReplyTextFormatted)).content("loading...", true);
        html.div((CharactersWriteable)HtmlAttributesFactory.class_((String)"value-data-big initially-hidden").id(idShowXmlReplyText)).content(HtmlLogOutput.removeSecurityRisks(details.getXmlRpcResponseJsonString()), true);
        if (hasGeniVal) {
            html.div((CharactersWriteable)HtmlAttributesFactory.class_((String)"value-data-big initially-hidden").id(idShowGeniValReplyTextFormatted)).content("loading...", true);
            html.div((CharactersWriteable)HtmlAttributesFactory.class_((String)"initially-hidden").id(idShowGeniValReplyText)).div().span((CharactersWriteable)HtmlAttributesFactory.class_((String)"geni-header-key")).content("code: ").span((CharactersWriteable)HtmlAttributesFactory.class_((String)"value-data")).content("" + details.getGeniResponseCode(), false).span().content("&nbsp;", false).span((CharactersWriteable)HtmlAttributesFactory.class_((String)"value-data")).content(details.getGeniResponseCodeDescription(), true)._div().div().span((CharactersWriteable)HtmlAttributesFactory.class_((String)"geni-header-key")).content("output: ").div((CharactersWriteable)HtmlAttributesFactory.class_((String)"value-data-big")).content(details.getGeniResponseOutput(), true)._div().div().span((CharactersWriteable)HtmlAttributesFactory.class_((String)"geni-header-key")).content("value: ").div((CharactersWriteable)HtmlAttributesFactory.class_((String)"value-data-big").id(idShowGeniValReplyTextDetail)).content(HtmlLogOutput.removeSecurityRisks(details.getXmlRpcGeniResponseValue()), true)._div()._div();
        }
        if (hasReplyRSpec || hasEmbeddedReplyRSpec) {
            html.div((CharactersWriteable)HtmlAttributesFactory.class_((String)"value-data-big initially-hidden").id(idShowRSpecReplyText)).content("loading...", true);
            html.div((CharactersWriteable)HtmlAttributesFactory.class_((String)"value-data-big initially-hidden").id(idShowRSpecReplyTextFormatted)).content("loading...", true);
        }
        html.div((CharactersWriteable)HtmlAttributesFactory.class_((String)"small-help").id(idShowNoReplyText)).content("(click a format to show the data)", true);
        html._td();
        html._tr();
        String stitchingOverview = HtmlLogOutput.makeStitchingOverview(details);
        if (stitchingOverview != null) {
            HtmlLogOutput.addCollapsable(html, "value-data", "Stitching Overview", stitchingOverview);
        }
        if (details.getExceptionString() != null) {
            HtmlLogOutput.addCollapsable(html, "value-data", "Exception", details.getExceptionString());
        }
        html._table();
        html._div();
    }

    public static void writeGroup(HtmlCanvas html, int index, LogOutput.TestResultState state, String name, String description, long durationMs, Date start, Date stop, Throwable exception, List<SerializableApiCallDetails> calls, List<LogOutput.LogEntry> logEntries) throws IOException {
        HtmlLogOutput.writeGroupStart(html, index, state, name, description, durationMs, start, stop, exception, calls, logEntries, Padding.topBottom(5), false);
        HtmlLogOutput.writeGroupEnd(html);
    }

    public static void writeEmbeddedGroup(HtmlCanvas html, int index, LogOutput.TestResultState state, String name, String description, long durationMs, Date start, Date stop, Throwable exception, List<SerializableApiCallDetails> calls, List<LogOutput.LogEntry> logEntries) throws IOException {
        HtmlLogOutput.writeGroupStart(html, index, state, name, description, durationMs, start, stop, exception, calls, logEntries, new Padding(5, 10), true);
        HtmlLogOutput.writeGroupEnd(html);
    }

    public static void writeGroup(HtmlCanvas html, int index, LogOutput.TestResultState state, String name, String description, long durationMs, Date start, Date stop, String exceptionStackTrace, List<SerializableApiCallDetails> calls, List<LogOutput.LogEntry> logEntries) throws IOException {
        HtmlLogOutput.writeGroupStart(html, index, state, name, description, durationMs, start, stop, exceptionStackTrace, calls, logEntries, Padding.topBottom(5), false);
        HtmlLogOutput.writeGroupEnd(html);
    }

    public static void writeGroupStart(HtmlCanvas html, int index, LogOutput.TestResultState state, String name, String description, long durationMs, Date start, Date stop, Throwable exception, List<SerializableApiCallDetails> calls, List<LogOutput.LogEntry> logEntries, @Nonnull Padding padding, boolean collapsible) throws IOException {
        String exceptionStackTrace;
        if (exception != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            exception.printStackTrace(pw);
            pw.close();
            exceptionStackTrace = HtmlLogOutput.removeSecurityRisks(sw.getBuffer().toString());
        } else {
            exceptionStackTrace = null;
        }
        HtmlLogOutput.writeGroupStart(html, index, state, name, description, durationMs, start, stop, exceptionStackTrace, calls, logEntries, padding, collapsible);
    }

    public static void writeGroupStart(HtmlCanvas html, int index, LogOutput.TestResultState state, String name, String description, long durationMs, Date start, Date stop, String exceptionStackTrace, List<SerializableApiCallDetails> calls, List<LogOutput.LogEntry> logEntries, @Nonnull Padding padding, boolean collapsible) throws IOException {
        String hideableId = "methoddetail-body-" + index;
        String hiddenMsgId = "methoddetail-body-hidden-" + index;
        String initiallyHiddenClass = collapsible ? " initially-hidden" : "";
        String hideButtonId = "methoddetail-body-" + index + "-toggle-button";
        html.div((CharactersWriteable)HtmlAttributesFactory.style((String)("padding: " + padding.top + "px " + padding.right + "px " + padding.bottom + "px " + padding.left + "px;")));
        html.div((CharactersWriteable)HtmlAttributesFactory.class_((String)("methoddetail-header " + HtmlLogOutput.stateClass(state) + "header")));
        HtmlLogOutput.writeImage(html, state);
        html.span().a((CharactersWriteable)HtmlAttributesFactory.id((String)("test" + index))).content(name)._span();
        if (collapsible) {
            html.div((CharactersWriteable)HtmlAttributesFactory.class_((String)"reveal reveal-right reveal-margin").id(hideButtonId).onClick(HtmlLogOutput.generateToggleButtonCode(hideButtonId, new String[0]) + HtmlLogOutput.generateRevealCode(hideableId, hiddenMsgId, new String[0]))).content("Hide/Show", true);
        }
        html._div();
        if (collapsible) {
            html.div((CharactersWriteable)HtmlAttributesFactory.class_((String)("methoddetail " + HtmlLogOutput.stateClass(state) + "body small-help")).id(hiddenMsgId)).content("(content collapsed)", true);
        }
        html.div((CharactersWriteable)HtmlAttributesFactory.class_((String)("methoddetail " + HtmlLogOutput.stateClass(state) + "body" + initiallyHiddenClass)).id(hideableId));
        html.div((CharactersWriteable)HtmlAttributesFactory.class_((String)"state")).content(state.toString());
        if (description != null) {
            html.div((CharactersWriteable)HtmlAttributesFactory.class_((String)"description")).content(description);
        }
        html.div((CharactersWriteable)HtmlAttributesFactory.class_((String)"times"));
        if (durationMs != 0L) {
            html.span((CharactersWriteable)HtmlAttributesFactory.class_((String)"timeheader")).content("duration ");
            html.span((CharactersWriteable)HtmlAttributesFactory.class_((String)"value-nondata")).content((double)durationMs / 1000.0 + "s");
        }
        if (start != null) {
            html.span((CharactersWriteable)HtmlAttributesFactory.class_((String)"timeheader")).content(" from ");
            html.span((CharactersWriteable)HtmlAttributesFactory.class_((String)"value-nondata")).content(HtmlLogOutput.dateToString(start));
        }
        if (stop != null) {
            html.span((CharactersWriteable)HtmlAttributesFactory.class_((String)"timeheader")).content(" to ");
            html.span((CharactersWriteable)HtmlAttributesFactory.class_((String)"value-nondata")).content(HtmlLogOutput.dateToString(stop));
        }
        html._div();
        if (exceptionStackTrace != null) {
            HtmlLogOutput.addCollapsable(html, "value-data", "Exception Stacktrace", exceptionStackTrace);
        }
        int apiCallCount = 1;
        if (calls != null) {
            for (SerializableApiCallDetails details : calls) {
                HtmlLogOutput.writeCall(html, index, apiCallCount++, details);
            }
        }
        int logLineCount = 1;
        if (logEntries != null) {
            for (LogOutput.LogEntry logline : logEntries) {
                String type = logline.type.name();
                if (logline.text.startsWith(MACHINE_LOGLINE_PREFIX)) {
                    type = LogOutput.LogLineType.DEBUG.name();
                }
                String logText = HtmlLogOutput.removeSecurityRisks(logline.text);
                String id = "logline-" + index + "-" + logLineCount;
                String className = "logline-" + type;
                String headerClassName = className + "-header";
                if (logline.getExceptionStackTrace() == null) {
                    html = HtmlLogOutput.addParagraphs(html.div((CharactersWriteable)(logline.isFormatAsCode() ? HtmlAttributesFactory.class_((String)(className + " format-as-code")).id(id) : HtmlAttributesFactory.class_((String)className).id(id))).span((CharactersWriteable)HtmlAttributesFactory.class_((String)headerClassName)).content(type + ": ", true), logText)._div();
                } else {
                    html = HtmlLogOutput.addParagraphs(html.div((CharactersWriteable)(logline.isFormatAsCode() ? HtmlAttributesFactory.class_((String)(className + " format-as-code")).id(id) : HtmlAttributesFactory.class_((String)className).id(id))).span((CharactersWriteable)HtmlAttributesFactory.class_((String)headerClassName)).content(type + ": ", true).div(), logText)._div();
                    String stacktrace = HtmlLogOutput.removeSecurityRisks(logline.getExceptionStackTrace());
                    html.div((CharactersWriteable)HtmlAttributesFactory.class_((String)"logline-exception"));
                    HtmlLogOutput.addCollapsable(html, "value-data", "Exception Stacktrace", stacktrace);
                    html._div()._div();
                }
                ++logLineCount;
            }
        }
    }

    public static void writeGroupEnd(HtmlCanvas html) throws IOException {
        html._div();
        html._div();
    }

    private static boolean isXml(String text) {
        return text != null && XmlUtil.isXmlLikeQuickTest((String)text.trim());
    }

    public static boolean hasCompressedReply(String requestJsonString) {
        if (requestJsonString == null) {
            return false;
        }
        return HAS_COMPRESSED_PATTERN.matcher(requestJsonString).find();
    }

    private static String generateToggleButtonCode(String thisToggleButtonId, String ... allToggleButtonIds) {
        HashSet<String> otherIds = new HashSet<String>(Arrays.asList(allToggleButtonIds));
        otherIds.remove(thisToggleButtonId);
        String res = "var newVisible = switchRevealClassActive('" + thisToggleButtonId + "');\n";
        for (String otherId : otherIds) {
            res = res + "setRevealClassActive('" + otherId + "', false);\n";
        }
        return res;
    }

    public static String generateRevealCode(String toggledTextId, String noReplyTextId, String ... allTextIds) {
        HashSet<String> otherIds = new HashSet<String>(Arrays.asList(allTextIds));
        otherIds.remove(toggledTextId);
        otherIds.remove(noReplyTextId);
        String res = "setVisibility('" + toggledTextId + "', newVisible);\nsetVisibility('" + noReplyTextId + "', !newVisible);\nif (newVisible) {\n";
        for (String otherId : otherIds) {
            res = res + "    setVisibility('" + otherId + "', false);\n";
        }
        res = res + "\n}\n";
        return res;
    }

    public static HtmlCanvas addParagraphs(HtmlCanvas html, String lines) {
        HtmlCanvas res = html;
        try {
            res = res.span();
            BufferedReader br = new BufferedReader(new StringReader(lines));
            String line = br.readLine();
            if (line != null) {
                res = res.write(line);
                line = br.readLine();
                while (line != null) {
                    res = res.div().content(line, true);
                    line = br.readLine();
                }
            }
            res = res._span();
        }
        catch (IOException e) {
            LOG.error("Did not expect an exception here", (Throwable)e);
        }
        return res;
    }

    public static String dateToString(long ms) {
        return HtmlLogOutput.dateToString(new Date(ms));
    }

    public static String dateToString(Date d) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS X");
        String iso8601LocalTZ = sdf.format(d);
        String rfc3339ZTZ = RFC3339Util.dateToRFC3339String((Date)d, (boolean)true, (boolean)true, (boolean)true);
        return iso8601LocalTZ + "(" + rfc3339ZTZ + ")";
    }

    public static String makeStitchingOverview(String rspec) {
        if (rspec == null) {
            return null;
        }
        Element stitchingElement = StitchingData.extractStitchingElementFromRspec((String)rspec);
        if (stitchingElement == null) {
            return null;
        }
        List<Element> pathEls = HtmlLogOutput.quickDomChildrenHelper(stitchingElement, "path");
        if (pathEls == null || pathEls.isEmpty()) {
            return null;
        }
        Object res = "";
        for (Element pathEl : pathEls) {
            String pathId = pathEl.getAttribute("id");
            assert (pathId != null) : "<stitching> has <path> element without id attribute: " + pathEl;
            res = (String)res + "  - path \"";
            res = (String)res + pathId;
            res = (String)res + "\"\n";
            NodeList hopList = pathEl.getElementsByTagName("hop");
            for (int i = 0; i < hopList.getLength(); ++i) {
                Node hopNode = hopList.item(i);
                assert (hopNode != null);
                assert (hopNode.getNodeType() == 1);
                Element hopElement = (Element)hopNode;
                String hopId = hopElement.getAttribute("id");
                res = (String)res + "    - hop id=\"" + hopId + "\"\n";
                List<Element> linkEls = HtmlLogOutput.quickDomChildrenHelper(hopElement, "link");
                for (Element linkEl : linkEls) {
                    String linkIdUrn = linkEl.getAttribute("id");
                    res = (String)res + "      - link \"";
                    res = (String)res + linkIdUrn;
                    res = (String)res + "\"\n";
                    Element scDescriptorEl = HtmlLogOutput.quickDomChildHelper(linkEl, "switchingCapabilityDescriptor");
                    Element scSpecificInfoEl = HtmlLogOutput.quickDomChildHelper(scDescriptorEl, "switchingCapabilitySpecificInfo");
                    Element scSpecificInfo_L2scEl = HtmlLogOutput.quickDomChildHelper(scSpecificInfoEl, "switchingCapabilitySpecificInfo_L2sc");
                    Element vlanRangeAvailabilityEl = HtmlLogOutput.quickDomChildHelper(scSpecificInfo_L2scEl, "vlanRangeAvailability");
                    Element suggestedVLANRangeEl = HtmlLogOutput.quickDomChildHelper(scSpecificInfo_L2scEl, "suggestedVLANRange");
                    String vlanRangeAvailability = vlanRangeAvailabilityEl.getTextContent();
                    String suggestedVLANRange = suggestedVLANRangeEl.getTextContent();
                    res = (String)res + "        vlanRangeAvailability=\"";
                    res = (String)res + vlanRangeAvailability;
                    res = (String)res + "\"\n";
                    res = (String)res + "        suggestedVLANRange   =\"";
                    res = (String)res + suggestedVLANRange;
                    res = (String)res + "\"\n";
                }
            }
        }
        return res;
    }

    private static List<Element> quickDomChildrenHelper(Element e, String tagName) {
        NodeList resList = e.getElementsByTagName(tagName);
        ArrayList<Element> resElements = new ArrayList<Element>();
        for (int i = 0; i < resList.getLength(); ++i) {
            Node resNode = resList.item(i);
            assert (resNode != null);
            assert (resNode.getNodeType() == 1);
            Element resElement = (Element)resNode;
            resElements.add(resElement);
        }
        return resElements;
    }

    private static Element quickDomChildHelper(Element e, String tagName) {
        NodeList resList = e.getElementsByTagName(tagName);
        assert (resList.getLength() == 1);
        Node resNode = resList.item(0);
        assert (resNode != null);
        assert (resNode.getNodeType() == 1);
        return (Element)resNode;
    }

    private static boolean isJsonStringRspec(String jsonString) {
        if (jsonString == null) {
            return false;
        }
        if (!(jsonString = jsonString.trim()).startsWith("\"") && !jsonString.endsWith("\"")) {
            return false;
        }
        return HtmlLogOutput.isRSpec(jsonString.substring(0, jsonString.length() - 1));
    }

    private static boolean isRSpec(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof String)) {
            return false;
        }
        return HtmlLogOutput.isRSpec((String)obj);
    }

    private static boolean isRSpec(@Nullable String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        String head = text;
        if (text.length() > 100) {
            head = text.substring(0, 100);
        }
        return head.contains("<rspec");
    }

    private static boolean isCompressedRSpec(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof String)) {
            return false;
        }
        return HtmlLogOutput.isCompressedRSpec((String)obj);
    }

    private static boolean isCompressedRSpec(@Nullable String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        try {
            String decodedValue = DataConversionUtils.decompressFromBase64((String)text);
            return HtmlLogOutput.isRSpec(decodedValue);
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static boolean hasRspec(@Nullable Object base, boolean matchNonCompressed, boolean matchCompressed) {
        if (base == null) {
            return false;
        }
        LinkedList<Object> objectsToCheck = new LinkedList<Object>();
        objectsToCheck.add(base);
        while (!objectsToCheck.isEmpty()) {
            Object o = objectsToCheck.removeLast();
            if (o instanceof Map) {
                Object[] h = (Map)o;
                Set entrySet = h.entrySet();
                for (Map.Entry e : entrySet) {
                    objectsToCheck.add(e.getValue());
                }
                continue;
            }
            if (o instanceof List) {
                for (Object val : (List)o) {
                    objectsToCheck.add(val);
                }
                continue;
            }
            if (o instanceof Object[]) {
                for (Object val : (Object[])o) {
                    objectsToCheck.add(val);
                }
                continue;
            }
            if (o instanceof String) {
                String value = (String)o;
                if (matchNonCompressed && HtmlLogOutput.isRSpec(value)) {
                    return true;
                }
                if (!matchCompressed || !HtmlLogOutput.isCompressedRSpec(value)) continue;
                return true;
            }
            if (o instanceof Number || o instanceof Boolean) continue;
            LOG.debug("Object is of type: " + o.getClass().getName());
        }
        return false;
    }

    private static List<String> extractRspecsFromJson(Object jsonRootObject) {
        if (jsonRootObject == null) {
            return Collections.emptyList();
        }
        ArrayList<String> res = new ArrayList<String>();
        LinkedList<Object> objectsToProcess = new LinkedList<Object>();
        objectsToProcess.add(jsonRootObject);
        while (!objectsToProcess.isEmpty()) {
            String s;
            Object jsonObject = objectsToProcess.pollFirst();
            if (jsonObject == null) continue;
            if (jsonObject instanceof String && HtmlLogOutput.isRSpec(s = (String)jsonObject)) {
                res.add(s);
            }
            if (jsonObject instanceof List) {
                List v = (List)jsonObject;
                objectsToProcess.addAll(v);
            }
            if (!(jsonObject instanceof Map)) continue;
            Map ht = (Map)jsonObject;
            objectsToProcess.addAll(ht.values());
        }
        return res;
    }

    public static String makeStitchingOverview(SerializableApiCallDetails callDetails) {
        if (callDetails != null) {
            Object stitchingOverviewText = "";
            int infoCount = 0;
            try {
                List<String> rspecsInReply;
                List<String> rspecsInRequest = HtmlLogOutput.extractRspecsFromJson(callDetails.getXmlRpcRequestJsonObject());
                if (!rspecsInRequest.isEmpty()) {
                    Object requestRspecText = "Stitching info in request RSpec:\n";
                    int count = 0;
                    for (String rspec : rspecsInRequest) {
                        String rspecOverview;
                        if (count > 0) {
                            requestRspecText = (String)requestRspecText + "\n!!! There is an additional Rspec in the request:\n";
                        }
                        if ((rspecOverview = HtmlLogOutput.makeStitchingOverview(rspec)) == null) continue;
                        requestRspecText = (String)requestRspecText + rspecOverview;
                        ++count;
                        ++infoCount;
                    }
                    if (count > 0) {
                        stitchingOverviewText = (String)stitchingOverviewText + (String)requestRspecText + "\n\n";
                    }
                }
                if (!(rspecsInReply = HtmlLogOutput.extractRspecsFromJson(callDetails.getXmlRpcResponseJsonObject())).isEmpty()) {
                    Object replyRspecText = "Stitching info in reply RSpec:\n";
                    int count = 0;
                    for (String rspec : rspecsInReply) {
                        String rspecOverview;
                        if (count > 0) {
                            replyRspecText = (String)replyRspecText + "\n!!! There is an additional Rspec in the reply:\n";
                        }
                        if ((rspecOverview = HtmlLogOutput.makeStitchingOverview(rspec)) == null) continue;
                        replyRspecText = (String)replyRspecText + rspecOverview;
                        ++count;
                        ++infoCount;
                    }
                    if (count > 0) {
                        stitchingOverviewText = (String)stitchingOverviewText + (String)replyRspecText + "\n\n";
                    }
                }
                if (Objects.equals(callDetails.getGeniResponseCodeIsSuccess(), Boolean.FALSE) && (callDetails.getGeniResponseOutput().toLowerCase().contains("vlan") || callDetails.getGeniResponseOutput().toLowerCase().contains("any"))) {
                    stitchingOverviewText = (String)stitchingOverviewText + "Error reply with output \"" + callDetails.getGeniResponseOutput() + "\"\n\n";
                    ++infoCount;
                }
            }
            catch (AssertionError t) {
                LOG.error("AssertionError while processing stitching data: " + ((Throwable)((Object)t)).getMessage(), (Throwable)((Object)t));
                stitchingOverviewText = (String)stitchingOverviewText + "\n\nException while processing stitching data: ";
                stitchingOverviewText = (String)stitchingOverviewText + ((Throwable)((Object)t)).getMessage();
                ++infoCount;
            }
            catch (Exception t) {
                LOG.error("Exception while processing stitching data: " + t.getMessage(), (Throwable)t);
                stitchingOverviewText = (String)stitchingOverviewText + "\n\nException while processing stitching data: ";
                stitchingOverviewText = (String)stitchingOverviewText + t.getMessage();
                ++infoCount;
            }
            if (infoCount > 0) {
                return stitchingOverviewText;
            }
            return null;
        }
        return null;
    }

    public static class Padding {
        public final int top;
        public final int right;
        public final int bottom;
        public final int left;

        public Padding(int top, int right, int bottom, int left) {
            this.top = top;
            this.right = right;
            this.bottom = bottom;
            this.left = left;
        }

        public Padding(int topBottom, int leftRight) {
            this(topBottom, leftRight, topBottom, leftRight);
        }

        public Padding() {
            this(0, 0, 0, 0);
        }

        public static Padding zero() {
            return new Padding(0, 0, 0, 0);
        }

        public static Padding topBottom(int topBottom) {
            return new Padding(topBottom, 0, topBottom, 0);
        }

        public static Padding leftRight(int leftRight) {
            return new Padding(0, leftRight, 0, leftRight);
        }
    }
}

