/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.call_log_output;

import be.iminds.ilabt.jfed.util.common.IOUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogOutput {
    protected static final Logger LOG = LoggerFactory.getLogger(LogOutput.class);
    protected static boolean disableRemoveSecurityRisks = false;

    public static List<SecurityRiskDescription> getAllSecurityRiskDescriptions() {
        ArrayList<SecurityRiskDescription> res = new ArrayList<SecurityRiskDescription>();
        res.add(new SecurityRiskDescription("-----BEGIN RSA PRIVATE KEY-----", "-----END RSA PRIVATE KEY-----"));
        res.add(new SecurityRiskDescription("-----BEGIN PRIVATE KEY-----", "-----END PRIVATE KEY-----"));
        return res;
    }

    public void copyToFile(URL in, File fileOut) throws IOException {
        int len;
        assert (in != null);
        assert (fileOut != null);
        FileOutputStream out = new FileOutputStream(fileOut);
        InputStream is = in.openStream();
        byte[] buffer = new byte[1024];
        while ((len = is.read(buffer)) != -1) {
            ((OutputStream)out).write(buffer, 0, len);
        }
        ((OutputStream)out).close();
    }

    public static String removeSecurityRisks(String text) {
        if (disableRemoveSecurityRisks) {
            return text;
        }
        if (text == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        List<SecurityRiskDescription> secRisks = LogOutput.getAllSecurityRiskDescriptions();
        while (text.length() > 0) {
            int firstStringIndex = -1;
            int secRiskIndex = -1;
            int i = 0;
            for (SecurityRiskDescription secRisk : secRisks) {
                int stringIndex = text.indexOf(secRisk.start);
                if (stringIndex >= 0 && (stringIndex < firstStringIndex || firstStringIndex == -1)) {
                    firstStringIndex = stringIndex;
                    secRiskIndex = i;
                }
                ++i;
            }
            if (secRiskIndex != -1) {
                SecurityRiskDescription secRisk;
                String safePart = text.substring(0, firstStringIndex);
                sb.append(safePart);
                text = text.substring(firstStringIndex);
                secRisk = secRisks.get(secRiskIndex);
                Pattern pattern = Pattern.compile(secRisk.end);
                Matcher matcher = pattern.matcher(text);
                if (matcher.find()) {
                    int endIndex = matcher.end();
                    String unsafe = text.substring(0, endIndex);
                    text = text.substring(endIndex);
                    sb.append("**** SECURITY: removed text that looked like a security risk. (").append(unsafe.length()).append(" characters) ****");
                    continue;
                }
                sb.append("**** SECURITY: removed text that looked like a security risk. WARNING: could not find end, so removed rest of text (").append(text.length()).append(" characters) ****");
                text = "";
                continue;
            }
            sb.append(text);
            text = "";
        }
        return sb.toString();
    }

    private static class SecurityRiskDescription {
        public final String start;
        public final String end;

        private SecurityRiskDescription(String start, String end) {
            this.start = start;
            this.end = end;
        }
    }

    @XmlRootElement(name="logentry")
    @XmlType(name="logentry")
    public static class LogEntry {
        LogLineType type;
        String text;
        long timeMs;
        String exception;
        boolean formatAsCode;

        public LogEntry() {
            this.type = null;
            this.text = null;
            this.exception = null;
            this.timeMs = -1L;
            this.formatAsCode = false;
        }

        public LogEntry(LogLineType type, String text, long timeMs) {
            this(type, text, timeMs, (Throwable)null, false);
        }

        public LogEntry(LogLineType type, String text, long timeMs, String exception, boolean formatAsCode) {
            assert (type != null);
            assert (text != null);
            this.type = type;
            this.text = text;
            this.timeMs = timeMs;
            this.exception = exception;
            this.formatAsCode = formatAsCode;
        }

        public LogEntry(LogLineType type, String text, long timeMs, Throwable exception, boolean formatAsCode) {
            assert (type != null);
            assert (text != null);
            this.type = type;
            this.text = text;
            this.timeMs = timeMs;
            this.exception = exception == null ? null : IOUtils.exceptionToStacktraceString((Throwable)exception);
            this.formatAsCode = formatAsCode;
        }

        public LogEntry(LogLineType type, String text) {
            this(type, text, System.currentTimeMillis(), (Throwable)null, false);
        }

        public LogEntry(LogLineType type, String text, Throwable exception) {
            this(type, text, System.currentTimeMillis(), exception, false);
        }

        public LogEntry(LogLineType type, String text, boolean formatAsCode) {
            this(type, text, System.currentTimeMillis(), (Throwable)null, formatAsCode);
        }

        public LogEntry(LogLineType type, String text, Throwable exception, boolean formatAsCode) {
            this(type, text, System.currentTimeMillis(), exception, formatAsCode);
        }

        @XmlElement(name="type")
        public LogLineType getType() {
            return this.type;
        }

        @XmlElement(name="text")
        public String getText() {
            return this.text;
        }

        @XmlElement(name="timeInMs")
        public long getTimeMs() {
            return this.timeMs;
        }

        @XmlElement(name="exception")
        public String getExceptionStackTrace() {
            return this.exception;
        }

        @XmlElement(name="formatAsCode")
        public boolean isFormatAsCode() {
            return this.formatAsCode;
        }

        public void setType(LogLineType type) {
            this.type = type;
        }

        public void setText(String text) {
            this.text = text;
        }

        public void setTimeMs(long timeMs) {
            this.timeMs = timeMs;
        }

        public void setException(String exception) {
            this.exception = exception;
        }

        public void setFormatAsCode(boolean formatAsCode) {
            this.formatAsCode = formatAsCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LogEntry)) {
                return false;
            }
            LogEntry logEntry = (LogEntry)o;
            if (this.timeMs != logEntry.timeMs) {
                return false;
            }
            if (this.exception != null ? !Objects.equals(this.exception, logEntry.exception) : logEntry.exception != null) {
                return false;
            }
            if (this.text != null ? !Objects.equals(this.text, logEntry.text) : logEntry.text != null) {
                return false;
            }
            return this.type == logEntry.type;
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
            result = 31 * result + (int)(this.timeMs ^ this.timeMs >>> 32);
            result = 31 * result + (this.exception != null ? this.exception.hashCode() : 0);
            return result;
        }
    }

    public static enum LogLineType {
        TRACE,
        DEBUG,
        NOTE,
        WARN,
        ERROR,
        FATAL_ERROR,
        EXCEPTION;

    }

    public static enum TestResultState {
        SUCCESS,
        WARN,
        SKIPPED,
        FAILED;

    }
}

