/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph.utils;

import io.github.classgraph.utils.FastPathResolver;
import io.github.classgraph.utils.FileUtils;
import io.github.classgraph.utils.LogNode;
import io.github.classgraph.utils.NestedJarHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JarfileMetadataReader {
    private final File jarFile;
    public boolean isSystemJar;
    public List<ZipEntry> zipEntries;
    public List<String> classPathEntriesToScan;
    private Set<String> packageRootRelativePaths;
    private List<String> libJarPaths;
    private static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    private final Object customClassLoaderLock;
    private ClassLoader customClassLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getCustomClassLoader(NestedJarHandler nestedJarHandler, LogNode log) {
        Object object = this.customClassLoaderLock;
        synchronized (object) {
            if (this.customClassLoader != null) {
                return this.customClassLoader;
            }
            if (this.packageRootRelativePaths == null && this.libJarPaths == null) {
                return null;
            }
            ArrayList<URL> urls = new ArrayList<URL>();
            for (String packageRootPath : this.packageRootRelativePaths) {
                try {
                    File extractedClasspathJarfileOrDir = packageRootPath.isEmpty() ? this.jarFile : nestedJarHandler.unzipToTempDir(this.jarFile, packageRootPath, log);
                    urls.add(extractedClasspathJarfileOrDir.toURI().toURL());
                }
                catch (IOException e) {
                    if (log == null) continue;
                    log.log("Cannot unzip package root " + packageRootPath + " in jarfile " + this.jarFile + " : " + e);
                }
            }
            if (this.libJarPaths != null) {
                for (String libJarPath : this.libJarPaths) {
                    File innermostJarFile;
                    block17: {
                        innermostJarFile = null;
                        try {
                            innermostJarFile = nestedJarHandler.getInnermostNestedJar(libJarPath, log).getKey();
                        }
                        catch (Exception e) {
                            if (log == null) break block17;
                            log.log("Cannot extract lib jar " + libJarPath + " : " + e);
                        }
                    }
                    if (innermostJarFile == null) continue;
                    try {
                        urls.add(innermostJarFile.toURI().toURL());
                    }
                    catch (MalformedURLException e) {
                        if (log == null) continue;
                        log.log("Cannot create URL from lib jar path " + innermostJarFile + " : " + e);
                    }
                }
            }
            if (!urls.isEmpty()) {
                if (log != null) {
                    LogNode subLog = log.log("Creating custom ClassLoader for jar " + this.jarFile + " with URLs:");
                    for (URL url : urls) {
                        subLog.log(url.toString());
                    }
                }
                this.customClassLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]));
            }
            return this.customClassLoader;
        }
    }

    private void addClassPathEntryToScan(String classPathEntryPath) {
        if (this.classPathEntriesToScan == null) {
            this.classPathEntriesToScan = new ArrayList<String>();
        }
        this.classPathEntriesToScan.add(classPathEntryPath);
    }

    private void addSpaceDelimitedClassPathToScan(String zipFilePath, String classPath) {
        for (String classpathEntry : classPath.split(" ")) {
            if (classpathEntry.isEmpty()) continue;
            this.addClassPathEntryToScan(zipFilePath == null ? classpathEntry : zipFilePath + "!" + classpathEntry);
        }
    }

    void addPackageRootPath(String packageRoot) {
        if (this.packageRootRelativePaths == null) {
            this.packageRootRelativePaths = new HashSet<String>();
        }
        this.packageRootRelativePaths.add(packageRoot);
    }

    private void addLibJarEntry(String libJarPath) {
        if (this.libJarPaths == null) {
            this.libJarPaths = new ArrayList<String>();
        }
        this.libJarPaths.add(libJarPath);
    }

    private String extractManifestField(String manifest, int classPathIdx) {
        int len = manifest.length();
        StringBuilder buf = new StringBuilder();
        int curr = classPathIdx;
        if (curr < len && manifest.charAt(curr) == ' ') {
            ++curr;
        }
        while (curr < len) {
            char c = manifest.charAt(curr);
            if (c == '\r' && (curr < len - 1 ? (int)manifest.charAt(curr + 1) : 10) == 10) {
                if ((curr < len - 2 ? (int)manifest.charAt(curr + 2) : 10) != 32) break;
                curr += 2;
            } else if (c == '\r') {
                if ((curr < len - 1 ? (int)manifest.charAt(curr + 1) : 10) != 32) break;
                ++curr;
            } else if (c == '\n') {
                if ((curr < len - 1 ? (int)manifest.charAt(curr + 1) : 10) != 32) break;
                ++curr;
            } else {
                buf.append(c);
            }
            ++curr;
        }
        return buf.toString().trim();
    }

    JarfileMetadataReader(File jarFile, LogNode log) {
        block28: {
            this.customClassLoaderLock = new Object();
            this.jarFile = jarFile;
            try (ZipFile zipFile = new ZipFile(jarFile);){
                int numEntries = zipFile.size();
                this.zipEntries = new ArrayList<ZipEntry>(numEntries);
                ArrayList<String> zipEntryPaths = new ArrayList<String>(numEntries);
                boolean hasBootInfClasses = false;
                boolean hasWebInfClasses = false;
                String jarFileName = FastPathResolver.resolve(jarFile.getPath());
                String springBootLibPrefix = "BOOT-INF/lib";
                String springBootClassesPrefix = "BOOT-INF/classes";
                Enumeration<? extends ZipEntry> iter = zipFile.entries();
                while (iter.hasMoreElements()) {
                    ZipEntry zipEntry = iter.nextElement();
                    if (zipEntry.isDirectory()) continue;
                    this.zipEntries.add(zipEntry);
                    String zipEntryPath = zipEntry.getName();
                    if (zipEntryPath.endsWith("/")) {
                        zipEntryPath = zipEntryPath.substring(0, zipEntryPath.length() - 1);
                    }
                    if (zipEntryPath.startsWith("/")) {
                        zipEntryPath = zipEntryPath.substring(1);
                    }
                    zipEntryPaths.add(zipEntryPath);
                    if (!zipEntryPath.equals(MANIFEST_PATH)) continue;
                    InputStream inputStream = zipFile.getInputStream(zipEntry);
                    Throwable throwable = null;
                    try {
                        int springBootLibIdx;
                        int springBootClassesIdx;
                        String manifest = FileUtils.readAllBytesAsString(inputStream, zipEntry.getSize(), log);
                        this.isSystemJar = manifest.indexOf("\nImplementation-Title: Java Runtime Environment") > 0 || manifest.indexOf("\nSpecification-Title: Java Platform API Specification") > 0;
                        int classPathIdx = manifest.indexOf("\nClass-Path:");
                        if (classPathIdx >= 0) {
                            this.addSpaceDelimitedClassPathToScan(null, this.extractManifestField(manifest, classPathIdx + 12));
                        }
                        if ((springBootClassesIdx = manifest.indexOf("\nSpring-Boot-Classes:")) >= 0) {
                            springBootClassesPrefix = this.extractManifestField(manifest, springBootClassesIdx + 21);
                            if (springBootClassesPrefix.startsWith("/")) {
                                springBootClassesPrefix = springBootClassesPrefix.substring(1);
                            }
                            if (!springBootClassesPrefix.endsWith("/")) {
                                springBootClassesPrefix = springBootClassesPrefix + '/';
                            }
                            if (springBootClassesPrefix.equals("/")) {
                                springBootClassesPrefix = "";
                            }
                        }
                        if ((springBootLibIdx = manifest.indexOf("\nSpring-Boot-Lib:")) < 0) continue;
                        springBootLibPrefix = this.extractManifestField(manifest, springBootLibIdx + 17);
                        if (springBootLibPrefix.startsWith("/")) {
                            springBootLibPrefix = springBootLibPrefix.substring(1);
                        }
                        if (!springBootLibPrefix.endsWith("/")) {
                            springBootLibPrefix = springBootLibPrefix + '/';
                        }
                        if (!springBootLibPrefix.equals("/")) continue;
                        springBootLibPrefix = "";
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inputStream == null) continue;
                        JarfileMetadataReader.$closeResource(throwable, inputStream);
                    }
                }
                for (int i = 0; i < zipEntryPaths.size(); ++i) {
                    String zipEntryPath = (String)zipEntryPaths.get(i);
                    if (!hasBootInfClasses && zipEntryPath.startsWith(springBootClassesPrefix)) {
                        if (log != null) {
                            log.log("Found Spring-Boot package root: " + springBootClassesPrefix);
                        }
                        hasBootInfClasses = true;
                        String springBootClasses = springBootClassesPrefix.endsWith("/") ? springBootClassesPrefix.substring(0, springBootClassesPrefix.length() - 1) : springBootClassesPrefix;
                        String classPathEntryPath = jarFileName + "!" + springBootClasses;
                        this.addClassPathEntryToScan(classPathEntryPath);
                        this.addPackageRootPath(springBootClasses);
                    }
                    if (!hasWebInfClasses && zipEntryPath.startsWith("WEB-INF/classes/")) {
                        if (log != null) {
                            log.log("Found WAR class root: " + zipEntryPath);
                        }
                        hasWebInfClasses = true;
                        this.addClassPathEntryToScan(jarFileName + "!WEB-INF/classes");
                        this.addPackageRootPath("WEB-INF/classes");
                    }
                    if (!zipEntryPath.startsWith(springBootLibPrefix) && !zipEntryPath.startsWith("WEB-INF/lib/") && !zipEntryPath.startsWith("WEB-INF/lib-provided/") && !zipEntryPath.startsWith("lib/") || !zipEntryPath.endsWith(".jar")) continue;
                    if (log != null) {
                        log.log("Found lib jar: " + zipEntryPath);
                    }
                    String libJarPath = jarFileName + "!" + zipEntryPath;
                    this.addClassPathEntryToScan(libJarPath);
                    this.addLibJarEntry(libJarPath);
                }
            }
            catch (IOException e) {
                this.zipEntries = Collections.emptyList();
                if (log == null) break block28;
                log.log("Exception while opening jarfile " + jarFile, e);
            }
        }
    }
}

