/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.rrd.base;

import be.iminds.ilabt.jfed.fedmon.rrd.base.RrdConfig;
import be.iminds.ilabt.jfed.fedmon.rrd.base.TestInstanceRrd;
import be.iminds.ilabt.jfed.fedmon.rrd.impl.AggregateStatusDowntimeRrd;
import be.iminds.ilabt.jfed.fedmon.rrd.impl.AggregateStatusUptimeRrd;
import be.iminds.ilabt.jfed.fedmon.rrd.impl.ListResourcesRrd;
import be.iminds.ilabt.jfed.fedmon.rrd.impl.NodeLoginRrd;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Frequency;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RrdManager {
    private static final Logger LOG = LoggerFactory.getLogger(RrdManager.class);
    protected final RrdConfig rrdConfig;
    private static Pattern longPattern = Pattern.compile("[0-9.]+");
    private static Pattern rrdTimePattern = Pattern.compile("([0-9.]+)([smhdwMy]?)");

    public RrdManager(RrdConfig rrdConfig) {
        this.rrdConfig = rrdConfig;
    }

    protected static File getBaseRrdDir(RrdConfig rrdConfig) {
        String dirStrO = rrdConfig.getRrdDbDir();
        if (dirStrO == null) {
            throw new RuntimeException("Configuration is missing RRD db dir property.");
        }
        File res = new File(dirStrO);
        if (!res.exists() || !res.isDirectory()) {
            throw new RuntimeException("Configuration specified RRD db dir, but this dir does not exist: \"" + dirStrO + "\"");
        }
        if (!res.canRead() || !res.canWrite()) {
            throw new RuntimeException("Configuration specified RRD db dir, but that dir is not read and writable: \"" + dirStrO + "\"");
        }
        return res;
    }

    public static long periodAndStepToExpireS(long stepS, long periodS) {
        if (stepS > 600L) {
            return stepS;
        }
        return 600L;
    }

    public static boolean isLong(String s) {
        return longPattern.matcher(s).matches();
    }

    public static long rrdTimeToS(String rrdTime) {
        double res;
        Matcher m = rrdTimePattern.matcher(rrdTime);
        if (!m.find()) {
            throw new RuntimeException("Invalid RRD time: \"" + rrdTime + "\"");
        }
        String nr = m.group(1);
        try {
            res = Double.parseDouble(nr);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Invalid RRD time: \"" + rrdTime + "\"", e);
        }
        if (m.groupCount() < 2 || m.group(2).isEmpty()) {
            return Math.round(res);
        }
        String t = m.group(2);
        assert (t.length() == 1);
        switch (t.charAt(0)) {
            case 's': {
                return Math.round(res);
            }
            case 'm': {
                return Math.round(res * 60.0);
            }
            case 'h': {
                return Math.round(res * 3600.0);
            }
            case 'd': {
                return Math.round(res * 86400.0);
            }
            case 'w': {
                return Math.round(res * 604800.0);
            }
            case 'M': {
                return Math.round(res * 2678400.0);
            }
            case 'y': {
                return Math.round(res * 3.16224E7);
            }
        }
        throw new RuntimeException("Invalid RRD time: \"" + rrdTime + "\"");
    }

    public static String makeTimePretty(long timeS) {
        if (timeS == 60L) {
            return "1m";
        }
        if (timeS == 3600L) {
            return "1h";
        }
        if (timeS == 86400L) {
            return "1day";
        }
        if (timeS == 604800L) {
            return "1week";
        }
        if (timeS == 2678400L) {
            return "1month";
        }
        if (timeS == 31622400L) {
            return "1year";
        }
        if (timeS == 63244800L) {
            return "2years";
        }
        if (timeS == 158112000L) {
            return "5years";
        }
        if (timeS == 316224000L) {
            return "10years";
        }
        if (timeS < 60L) {
            return timeS + "s";
        }
        if (timeS < 3600L) {
            return (double)timeS / 60.0 + "m";
        }
        if (timeS < 86400L) {
            return (double)timeS / 3600.0 + "h";
        }
        if (timeS < 2678400L) {
            return (double)timeS / 86400.0 + "days";
        }
        if (timeS < 31622400L) {
            return (double)timeS / 2678400.0 + "months";
        }
        return (double)timeS / 3.16224E7 + "years";
    }

    public static String makeTimePrettyForUser(long timeS) {
        if (timeS == 60L) {
            return "1m";
        }
        if (timeS == 3600L) {
            return "1h";
        }
        if (timeS == 86400L) {
            return "1day";
        }
        if (timeS == 604800L) {
            return "1week";
        }
        if (timeS == 2678400L) {
            return "1month";
        }
        if (timeS == 31622400L) {
            return "1year";
        }
        if (timeS < 60L) {
            return String.format("%.2fs", timeS);
        }
        if (timeS < 3600L) {
            return String.format("%.2fm", (double)timeS / 60.0);
        }
        if (timeS < 86400L) {
            return String.format("%.2fh", (double)timeS / 3600.0);
        }
        if (timeS < 2678400L) {
            return String.format("%.2fdays", (double)timeS / 86400.0);
        }
        if (timeS < 31622400L) {
            return String.format("%.2fmonths", (double)timeS / 2678400.0);
        }
        return String.format("%.2fyears", (double)timeS / 3.16224E7);
    }

    private File getAltRrdFile(TestInstance testInstance, TestDefinition testDefinition, boolean useTmpFile) {
        if (!useTmpFile) {
            return null;
        }
        try {
            return File.createTempFile("ti-" + testInstance.getId(), "rrd");
        }
        catch (IOException e) {
            LOG.error("Failed to create tmp file", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<TestInstanceRrd> get(TestInstance testInstance, Frequency testInstanceFrequency, TestDefinition testDefinition, boolean useTmpFile) {
        ArrayList<TestInstanceRrd> res = new ArrayList<TestInstanceRrd>();
        if (testDefinition.getType().trim().equalsIgnoreCase("aggregateTestbedStatus")) {
            res.add(new AggregateStatusUptimeRrd(testInstance, testInstanceFrequency, testDefinition, this.rrdConfig, this.getAltRrdFile(testInstance, testDefinition, useTmpFile)));
            res.add(new AggregateStatusDowntimeRrd(testInstance, testInstanceFrequency, testDefinition, this.rrdConfig, this.getAltRrdFile(testInstance, testDefinition, useTmpFile)));
        }
        if (testDefinition.getType().trim().equalsIgnoreCase("listResources")) {
            res.add(new ListResourcesRrd(testInstance, testInstanceFrequency, testDefinition, this.rrdConfig, this.getAltRrdFile(testInstance, testDefinition, useTmpFile)));
        }
        if (((String)testDefinition.getId()).trim().toLowerCase().contains("nodelogin") || ((String)testDefinition.getId()).trim().equalsIgnoreCase("repl_sum_nodelogin") || ((String)testDefinition.getId()).trim().toLowerCase().contains("stitch") || ((String)testDefinition.getId()).trim().toLowerCase().contains("genitut") || ((String)testDefinition.getId()).trim().toLowerCase().contains("multinodeping")) {
            res.add(new NodeLoginRrd(testInstance, testInstanceFrequency, testDefinition, this.rrdConfig, this.getAltRrdFile(testInstance, testDefinition, useTmpFile)));
        }
        return res;
    }

    public TestInstanceRrd get(TestInstance testInstance, Frequency testInstanceFrequency, TestDefinition testDefinition, String graphType) {
        List<TestInstanceRrd> all = this.get(testInstance, testInstanceFrequency, testDefinition, false);
        for (TestInstanceRrd t : all) {
            if (!t.getType().equals(graphType)) continue;
            return t;
        }
        return null;
    }

    public List<File> getAllRrdFiles() {
        File base = RrdManager.getBaseRrdDir(this.rrdConfig);
        File[] allRrd = base.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".rrd");
            }
        });
        return Arrays.asList(allRrd);
    }
}

